/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.alg;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.BadPaddingException;
import com.rsa.crypto.IllegalBlockSizeException;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.InvalidKeyException;
import com.rsa.crypto.Key;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.RSAPrivateKey;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.ncm.alg.AbstractAsymmCipher;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEAlgorithmIdentifier;
import com.rsa.crypto.ncm.ccme.CCMEAsymmetricKey;
import com.rsa.crypto.ncm.ccme.CCMECryptoContext;
import com.rsa.crypto.ncm.ccme.CCMECryptoObject;
import com.rsa.crypto.ncm.ccme.CCMEException;
import com.rsa.crypto.ncm.key.AbstractRSAKey;
import com.rsa.crypto.ncm.log.NativeCryptoObjectEvent;
import com.rsa.cryptoj.o.bz;
import java.util.Arrays;

public class RSACipher
extends AbstractAsymmCipher {
    private static final int m = 0;
    private int n = 0;
    a h;
    boolean i = false;
    int j = 0;
    byte[] k;
    int l;

    public RSACipher(b b2, String string) {
        super(b2, string);
        this.c();
        this.c = CCMEAlgorithmIdentifier.getAlgId(this.b);
        RSACipher.verifyAlgorithmIsSupported(this.cryptoModule.b(), this.c);
    }

    @Override
    public int getMaxInputLen() {
        this.b();
        if (this.n <= this.h.c) {
            return 0;
        }
        return this.n - this.h.c;
    }

    @Override
    public void init(int n2, Key key, AlgorithmParams algorithmParams, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        boolean bl2;
        Integer n3;
        this.a(n2);
        this.a(key);
        this.n = (((AbstractRSAKey)this.d).getN().getBitLength() + 7) / 8;
        this.j = 0;
        if (algorithmParams != null && algorithmParams instanceof AlgInputParams && (n3 = (Integer)((AlgInputParams)algorithmParams).get("blinding")) != null) {
            this.j = n3;
            if (this.j > 1) {
                this.j = 1;
            }
        }
        boolean bl3 = this.d instanceof RSAPrivateKey ? this.e : (bl2 = !this.e);
        if (!(this.d instanceof RSAPrivateKey) || !((RSAPrivateKey)((Object)this.d)).hasCRTInfo()) {
            this.j = 0;
        }
        this.a(secureRandom);
        try {
            if (!this.isHandleNull()) {
                this.freeObject();
            }
            this.createObject(this.cryptoModule.b(), this.cryptoModule.e(), this.c, this.e, this.j, this.d, bl2, this.g);
        }
        catch (CCMEException cCMEException) {
            if (cCMEException.getErrorCode() == 10009) {
                throw new InvalidKeyException("This functionality is not supported by the native module.");
            }
            throw cCMEException;
        }
        if (bz.a()) {
            bz.b().objectCreated(new NativeCryptoObjectEvent("Native", "Asymmetric Cipher", "RSA", this.getImplementationName()));
        }
        this.i = bl2;
        this.l = 0;
        this.f = true;
    }

    @Override
    public int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        this.b();
        return this.a(byArray, n2, n3, byArray2, n4, false);
    }

    @Override
    public int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException, IllegalBlockSizeException {
        this.b();
        return this.a(byArray, n2, n3, byArray2, n4, true);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws BadPaddingException, IllegalBlockSizeException {
        this.b();
        return this.a(null, 0, 0, byArray, n2, true);
    }

    @Override
    public void reInit(AlgorithmParams algorithmParams) {
        this.b();
        this.l = 0;
    }

    @Override
    public int getBlockSize() {
        this.b();
        return this.n;
    }

    @Override
    public int getOutputSize(int n2) {
        return this.f ? this.n : this.l + n2;
    }

    @Override
    public AlgorithmParams getAlgorithmParams() {
        return new com.rsa.crypto.ncm.alg.b(this.cryptoModule);
    }

    @Override
    public void clearSensitiveData() {
        super.clearSensitiveData();
        if (this.k != null) {
            Arrays.fill(this.k, (byte)0);
            this.k = null;
        }
        this.l = 0;
    }

    @Override
    protected void dupObject(CCMECryptoObject cCMECryptoObject) {
        super.dupObject(cCMECryptoObject);
        if (this.isSensitiveDataCleared()) {
            return;
        }
        RSACipher rSACipher = (RSACipher)cCMECryptoObject;
        if (this.f) {
            rSACipher.createObject(this.cryptoModule.b(), this.cryptoModule.e(), rSACipher.c, rSACipher.e, rSACipher.j, rSACipher.d, rSACipher.i, rSACipher.g);
        }
        if (this.k != null) {
            rSACipher.k = (byte[])this.k.clone();
        }
    }

    private void c() {
        String[] stringArray = this.a.split("/");
        if (stringArray.length == 1) {
            throw new NoSuchAlgorithmException("RSA requires a padding mode.");
        }
        if (stringArray.length == 2) {
            this.h = new a(stringArray[1], null);
        } else if (stringArray.length == 5 && "OAEP".equalsIgnoreCase(stringArray[1]) && "MGF1".equalsIgnoreCase(stringArray[3]) && stringArray[2].equalsIgnoreCase(stringArray[4])) {
            this.h = new a(stringArray[1], stringArray[2]);
        } else {
            throw new NoSuchAlgorithmException("Invalid RSA transformation string: " + this.a);
        }
        this.b = this.h.b;
    }

    private void a(Key key) {
        this.a();
        if (!(key instanceof AbstractRSAKey)) {
            throw new InvalidKeyException("Not a native RSA key.");
        }
        this.d = (CCMEAsymmetricKey)key.clone();
    }

    private int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl2) {
        int n5;
        int n6 = n5 = this.e ? this.getMaxInputLen() : this.getBlockSize();
        if (n3 > 0) {
            if (n3 + this.l > n5) {
                throw new IllegalBlockSizeException("Input data length exceeded max of " + n5);
            }
            if (this.l == 0 && (this.k == null || this.k.length < n5)) {
                this.k = new byte[n5];
            }
            System.arraycopy(byArray, n2, this.k, this.l, n3);
        }
        int n7 = 0;
        if (bl2 || (n3 += this.l) == n5 && (this.e || this.h.a.equalsIgnoreCase("NoPad"))) {
            n7 = this.a(this.k, n3, byArray2, n4);
            this.l = 0;
        } else {
            this.l = n3;
        }
        return n7;
    }

    private int a(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        if (n2 == 0) {
            return 0;
        }
        if (this.h.a.equalsIgnoreCase("NoPad") && n2 < this.n) {
            throw new IllegalBlockSizeException("An entire block must be provided when NoPad is used.");
        }
        try {
            n4 = this.doFinalNative(this.e, byArray, 0, n2, byArray2, n3);
        }
        catch (CCMEException cCMEException) {
            if (!(this.e || cCMEException.getErrorCode() != 10022 && cCMEException.getErrorCode() != 10001)) {
                throw new BadPaddingException("Invalid ciphertext.");
            }
            if (cCMEException.getErrorCode() == 10023) {
                throw new BadPaddingException("Invalid input data.");
            }
            throw cCMEException;
        }
        return n4;
    }

    private native void createObject(CCMECryptoContext var1, byte[] var2, int var3, boolean var4, int var5, CCMEAsymmetricKey var6, boolean var7, CCMECryptoObject var8);

    class a {
        final String a;
        final String b;
        final int c;

        a(String string, String string2) {
            this.a = string;
            if ("NoPad".equalsIgnoreCase(string)) {
                this.b = "RSA";
                this.c = 0;
            } else if ("PKCS1".equalsIgnoreCase(string)) {
                this.b = "RSA_PKCS1";
                this.c = 11;
            } else if ("PKCS1BlockSSLPad".equalsIgnoreCase(string)) {
                this.b = "RSA_PKCS1_SSL";
                this.c = 11;
            } else if ("OAEP".equalsIgnoreCase(string)) {
                int n2;
                if ("SHA1".equalsIgnoreCase(string2)) {
                    this.b = "RSA_PKCS1_OAEP";
                    n2 = 20;
                } else if ("SHA256".equalsIgnoreCase(string2)) {
                    this.b = "RSA_PKCS1_OAEP_SHA256";
                    n2 = 32;
                } else {
                    throw new NoSuchAlgorithmException("This functionality is not supported by the native module. RSA OAEP " + string2);
                }
                this.c = 2 * n2 + 2;
            } else {
                throw new NoSuchAlgorithmException("RSA Padding mode, " + string + ", is not supported.");
            }
        }
    }
}

