/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.ccme;

import com.rsa.crypto.CryptoException;
import com.rsa.crypto.ncm.ccme.CCMEException;
import com.rsa.crypto.ncm.ccme.CCMEHandle;
import com.rsa.crypto.ncm.ccme.CCMEProvider;
import com.rsa.cryptoj.o.bg;
import com.rsa.cryptoj.o.co;
import java.io.File;
import java.io.IOException;

public class CCMEFIPS140Provider
extends CCMEHandle
implements CCMEProvider {
    public static final String NATIVE_FIPS140_PATH_PROPERTY_NAME = "com.rsa.cryptoj.native.fips140.path";
    public static final String CCME_LD_LIBRARY_PATH_ENV_VAR = "R_SHLIB_LD_LIBRARY_PATH";
    private static final int ROLE_USER = 1;
    private static final int ROLE_OFFICER = 2;
    private File moduleConfigFile;

    public CCMEFIPS140Provider(bg bg2) {
        String string = co.u();
        if (string == null) {
            string = System.getenv(CCME_LD_LIBRARY_PATH_ENV_VAR);
        }
        try {
            int n2 = bg2 == null ? 1 : bg2.a();
            this.createCCMEFIPS140Provider(string, n2);
        }
        catch (CCMEException cCMEException) {
            if (cCMEException.getErrorCode() == 10014 || cCMEException.getErrorCode() == 10001) {
                throw new CryptoException("Unable to load FIPS provider");
            }
            throw cCMEException;
        }
    }

    @Override
    public void close() {
        if (!this.isHandleNull()) {
            this.freeProvider();
        }
    }

    public void setRole(int n2) {
        int n3 = n2 == 10 ? 2 : 1;
        this.setRoleNative(n3);
    }

    private void setRolesFile(File file) {
        if (!file.exists()) {
            throw new CryptoException("Module Config file doesn't exist.");
        }
        try {
            this.moduleConfigFile = file;
            this.setRolesFileNative(file.getCanonicalPath());
        }
        catch (CCMEException cCMEException) {
            throw new CryptoException("FIPS140 Role file: " + cCMEException.getMessage());
        }
        catch (IOException iOException) {
            throw new CryptoException("FIPS140 Role file: " + iOException.getMessage());
        }
    }

    public void authenticateRole(int n2, byte[] byArray, File file) {
        if (byArray == null) {
            throw new CryptoException("Bad PIN.");
        }
        if (file != null && this.moduleConfigFile == null) {
            this.setRolesFile(file);
        } else {
            if (file != null && !file.equals(this.moduleConfigFile)) {
                throw new CryptoException("Cannot change the module file.");
            }
            if (this.moduleConfigFile == null) {
                throw new CryptoException("Module Config File must be set.");
            }
        }
        int n3 = n2 == 10 ? 2 : 1;
        this.authenticateRoleNative(n3, byArray);
    }

    private native void authenticateRoleNative(int var1, byte[] var2);

    private native void createCCMEFIPS140Provider(String var1, int var2);

    private native void setRolesFileNative(String var1);

    private native void setRoleNative(int var1);

    private native void freeProvider();
}

