/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.key;

import com.rsa.crypto.BigNum;
import com.rsa.crypto.ECParams;
import com.rsa.crypto.ECPoint;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEPKeyContext;
import com.rsa.crypto.ncm.ccme.CCMEParameters;
import com.rsa.crypto.ncm.key.d;
import com.rsa.cryptoj.o.dd;
import com.rsa.cryptoj.o.dp;
import java.math.BigInteger;

public class ECParamsImpl
extends CCMEParameters
implements ECParams {
    private static final int f = 3;
    protected static final int a = 2;
    protected static final int b = 1;
    protected static final int c = 0;
    protected static final String d = "EC_PARAMETER_GENERATION";
    private int g;
    private String h;
    String e;
    private final byte[] i;
    private final String j;
    private final byte[] k;
    private final String l;
    private final int m;
    private int n = -1;
    private int[] o = null;
    private int p;
    private BigNum q;
    private BigNum r;
    private BigNum s;
    private BigNum t;
    private ECPoint u;
    private int v = -1;

    public ECParamsImpl(b b2, String string) {
        super(b2);
        this.h = string.toUpperCase();
        this.e = "NIST_" + this.h + "_WITH_ACCEL";
        this.g = this.h.startsWith("P") ? 0 : 1;
        this.createNamedCurveObject(b2.c(), b2.e(), this.e);
        this.n = Integer.parseInt(string.substring(1));
        this.i = null;
        this.j = null;
        this.m = 1;
        this.k = null;
        this.l = null;
        this.p = -1;
    }

    protected ECParamsImpl(b b2) {
        super(b2);
        this.g = -1;
        this.n = -1;
        this.m = 1;
        this.i = null;
        this.j = null;
        this.k = null;
        this.l = null;
        this.p = -1;
    }

    public ECParamsImpl(b b2, byte[] byArray) {
        super(b2);
        this.g = -1;
        this.n = -1;
        this.m = 1;
        this.i = null;
        this.j = null;
        this.k = null;
        this.l = null;
        this.p = -1;
        this.createObjectEncoded(b2.c(), b2.e(), byArray);
    }

    @Override
    public CCMEParameters recreateParams() {
        if (this.h != null) {
            this.createNamedCurveObject(this.cryptoModule.c(), this.cryptoModule.e(), this.e);
        } else if (this.cachedEncoding != null) {
            this.createObjectEncoded(this.cryptoModule.c(), this.cryptoModule.e(), this.cachedEncoding);
        }
        return this;
    }

    public ECParamsImpl(b b2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, int n2, byte[] byArray7, String string, int n3, byte[] byArray8, String string2) {
        super(b2);
        if (byArray == null || byArray2 == null || byArray3 == null || byArray5 == null || byArray6 == null) {
            throw new IllegalArgumentException("Invalid Parameters.");
        }
        this.n = new com.rsa.crypto.ncm.key.b(byArray).getBitLength();
        this.h = null;
        this.e = null;
        this.i = byArray4 == null ? null : (byte[])byArray4.clone();
        this.j = string;
        this.m = n3;
        this.k = byArray8 == null ? null : (byte[])byArray8.clone();
        this.l = string2;
        this.p = 0;
        byte[] byArray9 = dp.c(byArray5, 0, byArray5.length);
        byte[] byArray10 = dp.c(byArray6, 0, byArray6.length);
        int n4 = this.n;
        byte[] byArray11 = dp.b(byArray2, n4);
        byte[] byArray12 = dp.b(byArray3, n4);
        this.createPrimeObject(b2.c(), b2.e(), this.n, byArray, byArray11, byArray12, new d(byArray9, byArray10, this.n).getEncoded(), dd.a(n2), byArray7);
    }

    public ECParamsImpl(b b2, int n2, int[] nArray, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n3, byte[] byArray6, String string, int n4, byte[] byArray7, String string2) {
        super(b2);
        if (byArray == null || byArray2 == null || byArray4 == null || byArray5 == null) {
            throw new IllegalArgumentException("Invalid Parameters.");
        }
        this.h = null;
        this.e = null;
        this.g = 1;
        this.n = n2;
        this.o = nArray;
        this.i = byArray3 == null ? null : (byte[])byArray3.clone();
        this.j = string;
        this.m = n4;
        this.k = byArray7 == null ? null : (byte[])byArray7.clone();
        this.l = string2;
        boolean bl2 = this.o == null || this.o.length == 0;
        byte[] byArray8 = dp.c(byArray4, 0, byArray4.length);
        byte[] byArray9 = dp.c(byArray5, 0, byArray5.length);
        int n5 = (n2 + 7) / 8;
        byte[] byArray10 = dp.b(byArray, n5);
        byte[] byArray11 = dp.b(byArray2, n5);
        this.p = bl2 ? 1 : 2;
        byte[] byArray12 = bl2 ? dd.a(n2) : ECParamsImpl.a(n2, nArray);
        this.createBinaryObject(b2.c(), b2.e(), this.n, byArray12, bl2, byArray10, byArray11, new d(byArray8, byArray9, this.n).getEncoded(), dd.a(n3), byArray6);
    }

    @Override
    public synchronized BigNum getOrder() {
        if (this.q == null) {
            if (this.isHandleNull()) {
                return new com.rsa.crypto.ncm.key.b();
            }
            byte[] byArray = this.getOrderNative();
            if (byArray != null) {
                byArray = dp.c(byArray, 0, byArray.length);
            }
            this.q = byArray == null ? null : new com.rsa.crypto.ncm.key.b(byArray);
        }
        return this.q;
    }

    @Override
    public synchronized BigNum getA() {
        if (this.r == null) {
            if (this.isHandleNull()) {
                return new com.rsa.crypto.ncm.key.b();
            }
            byte[] byArray = this.getANative();
            if (byArray != null) {
                byArray = dp.c(byArray, 0, byArray.length);
            }
            this.r = byArray == null ? null : new com.rsa.crypto.ncm.key.b(byArray);
        }
        return this.r;
    }

    @Override
    public synchronized BigNum getB() {
        if (this.s == null) {
            if (this.isHandleNull()) {
                return new com.rsa.crypto.ncm.key.b();
            }
            byte[] byArray = this.getBNative();
            if (byArray != null) {
                byArray = dp.c(byArray, 0, byArray.length);
            }
            this.s = byArray == null ? null : new com.rsa.crypto.ncm.key.b(byArray);
        }
        return this.s;
    }

    @Override
    public byte[] getSeed() {
        return this.i;
    }

    @Override
    public synchronized int getCofactor() {
        if (this.v == -1) {
            if (this.isHandleNull()) {
                return 0;
            }
            byte[] byArray = this.getCofactorNative();
            if (byArray != null) {
                this.v = new BigInteger(1, byArray).intValue();
            }
        }
        return this.v;
    }

    @Override
    public synchronized BigNum getFieldPrime() {
        if (this.t == null) {
            if (this.getFieldType() != 0) {
                return null;
            }
            if (!this.isHandleNull()) {
                byte[] byArray = this.getFieldPrimeNative();
                if (byArray != null) {
                    byArray = dp.c(byArray, 0, byArray.length);
                    this.t = new com.rsa.crypto.ncm.key.b(byArray);
                }
            } else {
                return new com.rsa.crypto.ncm.key.b();
            }
        }
        return this.t;
    }

    @Override
    public synchronized int getFieldSize() {
        if (this.n == -1 && !this.isHandleNull()) {
            this.n = this.getNumBitsNative();
        }
        return this.n;
    }

    @Override
    public synchronized int[] getFieldMidTerms() {
        if (this.o != null) {
            return this.o;
        }
        if (this.isHandleNull() || this.g != 1 || this.p == 1) {
            return null;
        }
        this.a(this.getFieldMidTermsNative());
        return this.o;
    }

    @Override
    public synchronized ECPoint getBase() {
        if (this.u == null) {
            if (this.isHandleNull()) {
                return null;
            }
            byte[] byArray = this.getBaseNative();
            this.u = byArray == null ? null : new d(byArray);
        }
        return this.u;
    }

    @Override
    public synchronized int getFieldType() {
        if (this.g == -1 && !this.isHandleNull()) {
            this.p = this.getFieldTypeNative();
            this.g = this.p == 2 ? 1 : this.p;
        }
        return this.g;
    }

    @Override
    public String getDigest() {
        return this.j;
    }

    @Override
    public int getVersion() {
        return this.m;
    }

    @Override
    public String getCurveName() {
        return this.h;
    }

    @Override
    public byte[] getBaseSeed() {
        return this.k;
    }

    @Override
    public String getBaseDigest() {
        return this.l;
    }

    private static byte[] a(int n2, int[] nArray) {
        int n3;
        byte[] byArray = new byte[(n2 + 7) / 8];
        int n4 = n3 = byArray.length - 1;
        byArray[n4] = (byte)(byArray[n4] | 1);
        int n5 = n3 - n2 / 8;
        byArray[n5] = (byte)(byArray[n5] | 1 << n2 % 8);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n6 = n3 - nArray[i2] / 8;
            byArray[n6] = (byte)(byArray[n6] | 1 << nArray[i2] % 8);
        }
        return byArray;
    }

    private void a(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (!bigInteger.testBit(0)) {
            throw new IllegalArgumentException("The first bit of the reduction polynomial representation for a EC binary field is not set.");
        }
        if (!bigInteger.testBit(this.getFieldSize())) {
            throw new IllegalArgumentException("The degree bit of the reduction polynomial representation for a EC binary field is not set.");
        }
        int[] nArray = new int[3];
        int n2 = 0;
        for (int i2 = 1; i2 < bigInteger.bitLength() - 1; ++i2) {
            if (!bigInteger.testBit(i2)) continue;
            if (n2 == 3) {
                throw new IllegalArgumentException("The reduction polynomial representation for a EC binary field contains too many mid-terms.");
            }
            nArray[n2++] = i2;
        }
        if (n2 > 0) {
            this.o = new int[n2];
            System.arraycopy(nArray, 0, this.o, 0, n2);
        } else {
            this.o = null;
        }
    }

    private native void createNamedCurveObject(CCMEPKeyContext var1, byte[] var2, String var3);

    private native void createPrimeObject(CCMEPKeyContext var1, byte[] var2, int var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9);

    private native void createBinaryObject(CCMEPKeyContext var1, byte[] var2, int var3, byte[] var4, boolean var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9, byte[] var10);

    private native void createObjectEncoded(CCMEPKeyContext var1, byte[] var2, byte[] var3);

    private native byte[] getANative();

    private native byte[] getBNative();

    private native byte[] getBaseNative();

    private native byte[] getCofactorNative();

    private native byte[] getOrderNative();

    private native byte[] getFieldPrimeNative();

    private native byte[] getFieldMidTermsNative();

    private native int getFieldTypeNative();

    private native int getNumBitsNative();

    @Override
    public void cache() {
        this.getA();
        this.getB();
        this.getBase();
        this.getCofactor();
        this.getFieldSize();
        this.getFieldType();
        this.getOrder();
        if (this.g == 0) {
            this.getFieldPrime();
        } else {
            this.getFieldMidTerms();
        }
        if (!this.cryptoModule.a().isPKCS11Context()) {
            this.getBinaryEncoding();
        }
    }

    @Override
    public void a() {
        throw new UnsupportedOperationException();
    }
}

