/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.key;

import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.ECParams;
import com.rsa.crypto.KeyPair;
import com.rsa.crypto.PQGParams;
import com.rsa.crypto.PrivateKey;
import com.rsa.crypto.PublicKey;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEAsymmetricKey;
import com.rsa.crypto.ncm.ccme.CCMEPKeyContext;
import com.rsa.crypto.ncm.key.DHPrivateKeyImpl;
import com.rsa.crypto.ncm.key.DHPublicKeyImpl;
import com.rsa.crypto.ncm.key.DSAPrivateKeyImpl;
import com.rsa.crypto.ncm.key.DSAPublicKeyImpl;
import com.rsa.crypto.ncm.key.ECPrivateKeyImpl;
import com.rsa.crypto.ncm.key.ECPublicKeyImpl;
import com.rsa.crypto.ncm.key.RSAPrivateKeyImpl;
import com.rsa.crypto.ncm.key.RSAPublicKeyImpl;

public class KeyPairImpl
extends CCMEAsymmetricKey
implements KeyPair {
    protected PrivateKey a;
    protected PublicKey b;
    private final String c;

    private KeyPairImpl(b b2, String string) {
        super(b2);
        this.c = string;
    }

    protected KeyPairImpl(b b2, String string, AlgorithmParams algorithmParams) {
        super(b2);
        int n2;
        this.c = string;
        if (this.c.equals("EC")) {
            this.a = new ECPrivateKeyImpl(b2, (ECParams)algorithmParams);
            this.b = new ECPublicKeyImpl(b2, (ECParams)algorithmParams);
            n2 = 2;
        } else if (this.c.equals("RSA")) {
            this.a = new RSAPrivateKeyImpl(b2, false);
            this.b = new RSAPublicKeyImpl(b2);
            n2 = 4;
        } else if (this.c.equals("DH")) {
            this.a = new DHPrivateKeyImpl(b2, (PQGParams)algorithmParams);
            this.b = new DHPublicKeyImpl(b2, (PQGParams)algorithmParams);
            n2 = 1;
        } else if (this.c.equals("DSA")) {
            this.a = new DSAPrivateKeyImpl(b2, (PQGParams)algorithmParams);
            this.b = new DSAPublicKeyImpl(b2, (PQGParams)algorithmParams);
            n2 = 3;
        } else {
            throw new CryptoException("No Keypair type for " + string);
        }
        this.createObject(b2.c(), b2.e(), n2);
    }

    @Override
    public String getAlgorithm() {
        return this.c;
    }

    @Override
    public PrivateKey getPrivate() {
        return this.a;
    }

    @Override
    public PublicKey getPublic() {
        return this.b;
    }

    @Override
    public void clearSensitiveData() {
        if (this.a != null && !((CCMEAsymmetricKey)((Object)this.a)).isHandleNull()) {
            this.a.clearSensitiveData();
            this.b.clearSensitiveData();
        }
    }

    @Override
    public Object clone() {
        KeyPairImpl keyPairImpl = new KeyPairImpl(this.cryptoModule, this.c);
        keyPairImpl.a = (PrivateKey)this.a.clone();
        keyPairImpl.b = (PublicKey)this.b.clone();
        return keyPairImpl;
    }

    private native void createObject(CCMEPKeyContext var1, byte[] var2, int var3);

    @Override
    public void a() {
        throw new UnsupportedOperationException();
    }
}

