/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.crypto.ncm.mes;

import com.rsa.crypto.CryptoException;
import com.rsa.crypto.JCMCloneable;
import com.rsa.crypto.SensitiveData;
import com.rsa.crypto.ncm.b;
import com.rsa.crypto.ncm.ccme.CCMEHandle;
import com.rsa.crypto.ncm.ccme.CCMEPKCS11Provider;
import com.rsa.crypto.ncm.cert.c;
import java.nio.charset.Charset;

public abstract class MESCertificate
extends CCMEHandle
implements JCMCloneable,
SensitiveData,
c {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    protected final b cryptoModule;
    protected final boolean isPKCS11Object;

    protected MESCertificate(b b2) {
        this.cryptoModule = b2;
        this.isPKCS11Object = b2.a().isPKCS11Context();
    }

    public b getCryptoModule() {
        return this.cryptoModule;
    }

    @Override
    public synchronized Object clone() {
        MESCertificate mESCertificate = (MESCertificate)super.clone();
        if (!this.isHandleNull()) {
            this.dupObject(mESCertificate);
        }
        return mESCertificate;
    }

    @Override
    public synchronized void clearSensitiveData() {
        this.freeObject();
    }

    public synchronized boolean isSensitiveDataCleared() {
        return this.isHandleNull();
    }

    void freeObject() {
        if (!this.isHandleNull()) {
            this.freeObjectNative();
        }
    }

    @Override
    public synchronized native byte[] getCertID() throws CryptoException;

    @Override
    public synchronized native void setCertID(byte[] var1) throws CryptoException;

    @Override
    public String getCertLabel() throws CryptoException {
        byte[] byArray = this.getCertLabelNative();
        if (byArray == null || byArray.length == 1 && byArray[0] == 0) {
            return null;
        }
        return new String(byArray, UTF8_CHARSET);
    }

    protected static byte[] getBytes(String string) {
        return string.getBytes(UTF8_CHARSET);
    }

    private synchronized native byte[] getCertLabelNative() throws CryptoException;

    @Override
    public void setCertLabel(String string) throws CryptoException {
        this.setCertLabelNative(MESCertificate.getBytes(string));
    }

    private synchronized native void setCertLabelNative(byte[] var1) throws CryptoException;

    @Override
    public byte[] getManufacturerID() throws CryptoException {
        boolean bl2 = this.cryptoModule.a().isPKCS11Context();
        if (!bl2) {
            throw new CryptoException("Not a PKCS #11 cert");
        }
        return ((CCMEPKCS11Provider)this.cryptoModule.a().getProvider()).getManufacturerID();
    }

    @Override
    public synchronized native byte[] getEncoded();

    @Override
    public synchronized native void store();

    @Override
    public synchronized native void deleteCertFromDevice();

    protected void finalize() throws Throwable {
        try {
            this.freeObject();
        }
        finally {
            super.finalize();
        }
    }

    private native void freeObjectNative();

    protected native void dupObject(MESCertificate var1);
}

