/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.cryptoj.o;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.DomainParams;
import com.rsa.crypto.ECParams;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.ncm.ccme.CCMEException;
import com.rsa.cryptoj.o.bm;
import com.rsa.cryptoj.o.bo;
import com.rsa.cryptoj.o.bp;
import com.rsa.cryptoj.o.cb;
import com.rsa.cryptoj.o.dc;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Parameters;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;

public final class eq
extends JSAFE_Parameters {
    private static final String k = "Parameter verification failed.";
    private static final int l = 1;
    private static final int m = 2;
    private static final int n = 3;
    private static final String o = "EC";
    private static final int p = 255;
    private static final String q = "prime";
    private static final String r = "binary";
    private static final String s = "onb";
    private static final String t = "ECParameters";
    private static final String u = "ECParametersExtended";
    private static final String v = "ECParametersBER";
    private static final String w = "ECBaseGenInfo";
    private int x = 1;
    private byte[] y;
    private String z;

    eq(CryptoModule cryptoModule, int[] nArray) throws JSAFE_InvalidParameterException, JSAFE_UnimplementedException {
        super(cryptoModule, o);
        try {
            this.a(nArray);
        }
        catch (CCMEException cCMEException) {
            if (cCMEException.getErrorCode() == 10008) {
                throw new JSAFE_InvalidParameterException("Invalid EC parameter.");
            }
            throw cCMEException;
        }
        this.d = this.c.newAlgParamGenerator(this.b());
    }

    eq(CryptoModule cryptoModule, String string) throws JSAFE_InvalidParameterException, JSAFE_UnimplementedException {
        super(cryptoModule, o);
        this.d = this.c.newAlgParamGenerator(this.b());
    }

    eq(CryptoModule cryptoModule, DomainParams domainParams, String string) {
        super(cryptoModule, o);
        this.h = domainParams;
        this.d = this.c.newAlgParamGenerator(this.b());
    }

    @Override
    public void setParameterData(byte[][] byArray) throws JSAFE_InputException {
        this.a(9, byArray);
        this.b(byArray);
    }

    private void b(byte[][] byArray) throws JSAFE_InputException {
        try {
            this.h = bo.a(o, byArray, this.c.getKeyBuilder());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_InputException(invalidAlgorithmParameterException);
        }
    }

    private void a(int[] nArray) throws JSAFE_InvalidParameterException, JSAFE_UnimplementedException {
        if (nArray.length == 0) {
            return;
        }
        if (nArray.length != 2) {
            throw new JSAFE_InvalidParameterException("Incorrect number of parameters: expected two.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (nArray[0]) {
            case 0: {
                stringBuilder.append("P");
                break;
            }
            case 1: {
                stringBuilder.append("B");
                break;
            }
            case 2: {
                stringBuilder.append("K");
                break;
            }
            default: {
                throw new JSAFE_InvalidParameterException("Incorrect curve type.");
            }
        }
        stringBuilder.append(nArray[1]);
        try {
            this.h = this.c.getKeyBuilder().newECParams(stringBuilder.toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_InvalidParameterException("Invalid EC parameter.");
        }
    }

    @Override
    public void setParameterData(String string, byte[][] byArray) throws JSAFE_InputException, JSAFE_UnimplementedException {
        if (t.equals(string)) {
            this.setParameterData(byArray);
        } else if (v.equals(string)) {
            this.a(byArray);
        } else if (u.equals(string)) {
            this.a(12, byArray);
            this.b(byArray);
        } else if (w.equals(string)) {
            if (this.h == null) {
                throw new JSAFE_InputException("Format ECBaseGenInfo can only be used if parameter data is set.");
            }
            if (byArray.length != 2 || byArray[0] == null || byArray[0].length == 0 || byArray[1] == null || byArray[1].length == 0) {
                throw new JSAFE_InputException("Expected two ECBaseGenInfo parameters.");
            }
            this.y = dc.a(byArray[0]);
            this.z = bm.a(byArray[1], null);
        } else {
            throw new JSAFE_UnimplementedException("Unimplemented EC parameter format. ");
        }
    }

    @Override
    public byte[][] getParameterData() {
        if (this.h == null) {
            return new byte[0][];
        }
        return bo.a(o, this.h);
    }

    @Override
    public byte[][] getParameterData(String string) throws JSAFE_UnimplementedException {
        if (t.equals(string)) {
            return this.getParameterData();
        }
        if (u.equals(string)) {
            if (this.h == null) {
                return new byte[0][];
            }
            return bo.a(u, this.h);
        }
        if (v.equals(string)) {
            if (this.h == null) {
                return new byte[0][];
            }
            return new byte[][]{this.a()};
        }
        throw new JSAFE_UnimplementedException("Unsupported format: " + string);
    }

    @Override
    public void generate() throws JSAFE_InvalidUseException {
        if (this.x < 2) {
            throw new JSAFE_InvalidUseException("Object not initialized.");
        }
        if (this.x == 2) {
            try {
                this.h = (DomainParams)this.d.generate();
            }
            catch (CryptoException cryptoException) {
                throw new JSAFE_InvalidUseException(cryptoException.getMessage());
            }
        }
        if (this.x == 3) {
            try {
                boolean bl2 = this.d.verify();
                if (!bl2) {
                    throw new JSAFE_InvalidUseException(k);
                }
            }
            catch (CryptoException cryptoException) {
                throw new JSAFE_InvalidUseException(k);
            }
        }
    }

    @Override
    public void generateInit(int[] nArray, java.security.SecureRandom secureRandom) throws JSAFE_InvalidParameterException {
        if (this.j == null) {
            this.j = secureRandom;
        }
        AlgInputParams algInputParams = this.c.newAlgInputParams();
        if (nArray != null && nArray.length == 1) {
            this.b(nArray, algInputParams);
            return;
        }
        if (nArray == null || nArray.length == 0) {
            this.a(algInputParams);
            return;
        }
        this.a(nArray, algInputParams);
    }

    private void a(int[] nArray, AlgInputParams algInputParams) throws JSAFE_InvalidParameterException {
        String string;
        int n2 = nArray[0];
        int n3 = nArray[5];
        switch (nArray[1]) {
            case 0: {
                string = q;
                break;
            }
            case 1: {
                string = r;
                break;
            }
            case 2: {
                string = s;
                break;
            }
            default: {
                throw new JSAFE_InvalidParameterException("Parameter type not valid, expected 0, 1 or 2 for field type.");
            }
        }
        int n4 = nArray[3] != 0 ? nArray[3] : 255;
        int n5 = nArray[4];
        if (n5 == 0) {
            n5 = 255;
        }
        algInputParams.set("verifiablyRandomCurve", nArray[2] == 1 || nArray[2] == 2);
        algInputParams.set("verifiablyRandomPoint", nArray[2] == 2 || nArray[2] == 3);
        algInputParams.set("trialDivisionBound", n4);
        algInputParams.set("useTables", n3 == 1);
        algInputParams.set("curveType", string);
        if (n5 != 0) {
            algInputParams.set("maxCofactor", n5);
        }
        algInputParams.set("securityStrength", n2);
        try {
            cb.a(0, this.c, algInputParams);
            this.d.initGen(algInputParams, this.c());
            this.x = 2;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_InvalidParameterException(invalidAlgorithmParameterException);
        }
    }

    private void a(AlgInputParams algInputParams) throws JSAFE_InvalidParameterException {
        SecureRandom secureRandom = this.c();
        if (this.y == null) {
            this.y = new byte[(((ECParams)this.h).getFieldSize() + 7) / 8];
            secureRandom.nextBytes(this.y);
        }
        if (this.z == null) {
            this.z = bm.a((((ECParams)this.h).getFieldSize() + 7) / 8);
        }
        algInputParams.set("domainParams", this.h);
        algInputParams.set("seed", this.y);
        algInputParams.set("digest", this.z);
        try {
            this.d.initGen(algInputParams, secureRandom);
            this.x = 2;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_InvalidParameterException(invalidAlgorithmParameterException);
        }
    }

    private void b(int[] nArray, AlgInputParams algInputParams) throws JSAFE_InvalidParameterException {
        algInputParams.set("securityStrength", nArray[0]);
        algInputParams.set("domainParams", this.h);
        try {
            this.d.initVerify(algInputParams, this.c());
            this.x = 3;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_InvalidParameterException(invalidAlgorithmParameterException);
        }
    }

    @Override
    public void generateInit(int[] nArray, java.security.SecureRandom secureRandom, JSAFE_Session[] jSAFE_SessionArray) throws JSAFE_InvalidParameterException {
        this.generateInit((int[])nArray.clone(), secureRandom);
    }

    @Override
    public void generateReInit() throws JSAFE_InvalidUseException {
        if (this.x != 2) {
            throw new JSAFE_InvalidUseException("Cannot reinitialize, object not initialized.");
        }
    }

    @Override
    protected byte[] a() throws JSAFE_UnimplementedException {
        try {
            return bp.a((ECParams)this.h);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_UnimplementedException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    public String[] getSupportedSetFormats() {
        return new String[]{t, v, u};
    }

    @Override
    public String[] getSupportedGetFormats() {
        if (this.h == null) {
            return new String[0];
        }
        return new String[]{t, v, u};
    }

    @Override
    protected String b() {
        return o;
    }
}

