/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jcp;

import com.rsa.cryptoj.o.pm;
import com.rsa.cryptoj.o.pp;
import com.rsa.cryptoj.o.ps;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public final class SuiteBChecker {
    private SuiteBChecker() {
    }

    public static boolean isSuiteBCompliant(X509CRL x509CRL, PublicKey publicKey) {
        return ps.a(x509CRL) && ps.a(x509CRL, publicKey) && ps.b(x509CRL);
    }

    public static boolean isSuiteBCompliant(X509Certificate x509Certificate) throws CertPathValidatorException {
        try {
            return SuiteBChecker.isSuiteBCompliant(x509Certificate, x509Certificate.getPublicKey());
        }
        catch (SecurityException securityException) {
            throw new CertPathValidatorException(securityException.getMessage());
        }
    }

    public static boolean isSuiteBCompliant(X509Certificate x509Certificate, PublicKey publicKey) throws CertPathValidatorException {
        try {
            if (!(x509Certificate instanceof pp)) {
                x509Certificate = pm.a(ByteBuffer.wrap(x509Certificate.getEncoded()));
            }
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Unable to check certificate for SuiteB compliance.", exception);
        }
        pp pp2 = (pp)x509Certificate;
        try {
            return ps.c(pp2) && ps.a(pp2, publicKey) && ps.a(pp2) && ps.a(pp2.getPublicKey(), publicKey) && ps.b(pp2) && ps.a((X509Certificate)pp2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertPathValidatorException("Unsupported PublicKey object: must be instance of java.security.ECPublicKey", invalidKeyException);
        }
        catch (SecurityException securityException) {
            throw new CertPathValidatorException("Certificate does not contain a valid key", securityException);
        }
    }
}

