/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.crypto.CryptoException;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.DomainParams;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.Key;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.PublicKey;
import com.rsa.crypto.ncm.key.j;
import com.rsa.cryptoj.o.bj;
import com.rsa.cryptoj.o.bk;
import com.rsa.cryptoj.o.bl;
import com.rsa.cryptoj.o.ca;
import com.rsa.cryptoj.o.ce;
import com.rsa.cryptoj.o.cf;
import com.rsa.cryptoj.o.cj;
import com.rsa.cryptoj.o.cl;
import com.rsa.cryptoj.o.dc;
import com.rsa.cryptoj.o.dn;
import com.rsa.cryptoj.o.do;
import com.rsa.cryptoj.o.dp;
import com.rsa.cryptoj.o.dt;
import com.rsa.cryptoj.o.ej;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.a;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.zip.CRC32;

public abstract class JSAFE_PublicKey
extends JSAFE_Object
implements JSAFE_Key {
    private static final long serialVersionUID = -3275111075367779522L;
    protected static final String a = "Unsupported format: ";
    private static final int m = 1;
    protected PublicKey b;
    protected CryptoModule c;
    protected String d;
    protected byte[] h;
    protected String i;
    protected byte[] j;
    protected boolean k;
    protected byte[] l;
    private cf n;

    protected JSAFE_PublicKey(CryptoModule cryptoModule, String string) {
        this.c = cryptoModule;
        this.d = string;
    }

    public static JSAFE_PublicKey getInstance(byte[] byArray, int n2, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_PublicKey.a(byArray, n2, string, ce.a());
    }

    public static JSAFE_PublicKey getInstance(byte[] byArray, int n2, String string, FIPS140Context fIPS140Context) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_PublicKey.a(byArray, n2, string, fIPS140Context.a());
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws JSAFE_UnimplementedException {
        try {
            return n2 + bk.a(byArray, n2, null, null, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_UnimplementedException("Could not read BER data.");
        }
    }

    public static JSAFE_PublicKey getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_PublicKey.a(string, null, string2, ce.a(), null, null);
    }

    public static JSAFE_PublicKey getInstance(String string, String string2, FIPS140Context fIPS140Context) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_PublicKey.a(string, null, string2, fIPS140Context.a(), null, null);
    }

    private static JSAFE_PublicKey a(String string, byte[] byArray, String string2, cf cf2, JSAFE_Session[] jSAFE_SessionArray, JSAFE_PublicKey jSAFE_PublicKey) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        block17: {
            if (byArray == null) {
                JSAFE_PublicKey.a(string, string2);
            }
            try {
                if (!string2.equalsIgnoreCase(ca.c.toString())) break block17;
                if (jSAFE_PublicKey == null) {
                    jSAFE_PublicKey = ej.a(string, null);
                    jSAFE_PublicKey.n = cf2;
                    jSAFE_PublicKey.d = string;
                    jSAFE_PublicKey.h = byArray;
                    jSAFE_PublicKey.i = ca.c.toString();
                }
                if (jSAFE_SessionArray == null) {
                    return jSAFE_PublicKey;
                }
                if (jSAFE_SessionArray != null && jSAFE_SessionArray.length == 1) {
                    CryptoModule cryptoModule;
                    jSAFE_PublicKey.c = cryptoModule = jSAFE_SessionArray[0].a();
                    if (jSAFE_PublicKey.j != null) {
                        try {
                            jSAFE_PublicKey.setKeyData("KeyToken", new byte[][]{new byte[0], jSAFE_PublicKey.j});
                        }
                        catch (JSAFE_InvalidKeyException jSAFE_InvalidKeyException) {
                            throw new JSAFE_InvalidParameterException(jSAFE_InvalidKeyException);
                        }
                    }
                    return jSAFE_PublicKey;
                }
                throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (bj bj2) {
                // empty catch block
            }
        }
        ca[] caArray = JSAFE_PublicKey.a(string2);
        String string3 = dt.b(string);
        for (ca ca2 : caArray) {
            if (ca2.equals(ca.c)) {
                throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
            }
            try {
                cj cj2 = cl.a(cf2, ca2);
                if (byArray == null) {
                    return ej.a(string3, (CryptoModule)cj2);
                }
                return ej.a(bk.b(byArray, 0, cj2), (CryptoModule)cj2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (bj bj3) {
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
        }
        throw new JSAFE_UnimplementedException("Algorithm not supported on any devices");
    }

    private static JSAFE_PublicKey a(byte[] byArray, int n2, String string, cf cf2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        byte[] byArray2 = byArray;
        if (n2 > 0) {
            JSAFE_PublicKey.a(byArray, n2);
            byArray2 = dp.b(byArray, n2, byArray.length - n2);
        }
        try {
            return JSAFE_PublicKey.a(null, byArray2, string, cf2, null, null);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            throw new JSAFE_UnimplementedException(jSAFE_InvalidParameterException);
        }
    }

    void a(JSAFE_Session[] jSAFE_SessionArray) throws JSAFE_InvalidKeyException {
        if (this.c == null) {
            try {
                JSAFE_PublicKey.a(this.d, this.h, this.i, this.n, jSAFE_SessionArray, this);
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new JSAFE_InvalidKeyException(jSAFE_UnimplementedException);
            }
            catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
                throw new JSAFE_InvalidKeyException(jSAFE_InvalidParameterException);
            }
        }
    }

    public static JSAFE_PublicKey getInstance(String string, JSAFE_Session jSAFE_Session) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_PublicKey.a(string, jSAFE_Session);
    }

    private static JSAFE_PublicKey a(String string, JSAFE_Session jSAFE_Session) throws JSAFE_UnimplementedException {
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        try {
            if (jSAFE_Session != null) {
                CryptoModule cryptoModule = jSAFE_Session.a();
                String string2 = dt.b(string);
                return ej.a(string2, cryptoModule);
            }
            throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (bj bj2) {
            // empty catch block
        }
        throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
    }

    @Override
    public String getDevice() {
        if (this.c != null) {
            return this.c.getDeviceType();
        }
        return this.i;
    }

    public boolean isValidPublicKey() {
        return this.isValidPublicKey(null);
    }

    public boolean isValidPublicKey(SecureRandom secureRandom) {
        if (this.b == null) {
            return false;
        }
        return this.b.isValid(com.rsa.jsafe.a.a(secureRandom));
    }

    public String[] getDeviceList() {
        Object[] objectArray = new String[1];
        Arrays.fill(objectArray, this.getDevice());
        return objectArray;
    }

    @Override
    public String getAlgorithm() {
        return this.d;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JSAFE_PublicKey jSAFE_PublicKey = (JSAFE_PublicKey)super.clone();
        jSAFE_PublicKey.b = (PublicKey)dc.a(this.b);
        jSAFE_PublicKey.l = dc.a(this.l);
        return jSAFE_PublicKey;
    }

    @Override
    public String getKeyWrappingFormat(boolean bl2) {
        return this.getAlgorithm() + "PublicKeyBER";
    }

    public boolean dataEquals(Object object) {
        byte[][] byArray;
        if (!(object instanceof JSAFE_PublicKey)) {
            return false;
        }
        if (!((JSAFE_PublicKey)object).getAlgorithm().equals(this.getAlgorithm())) {
            return false;
        }
        if (this.k && ((JSAFE_PublicKey)object).k) {
            return Arrays.equals(this.l, ((JSAFE_PublicKey)object).l);
        }
        byte[][] byArray2 = this.getKeyData();
        if (byArray2.length != (byArray = ((JSAFE_PublicKey)object).getKeyData()).length) {
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (Arrays.equals(byArray[i2], byArray2[i2])) continue;
            return false;
        }
        return true;
    }

    protected void a(byte[] byArray) {
        this.k = true;
        this.l = (byte[])byArray.clone();
    }

    protected byte[] a() {
        return (byte[])this.l.clone();
    }

    public boolean equals(Object object) {
        return this.dataEquals(object);
    }

    public int hashCode() {
        try {
            CRC32 cRC32 = new CRC32();
            cRC32.update(this.getKeyData(this.d + "PublicKeyBER")[0]);
            return (int)cRC32.getValue();
        }
        catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
            return -1;
        }
    }

    protected void b() {
        this.k = false;
        dn.a.a(this.l);
    }

    @Override
    public abstract byte[][] getKeyData();

    @Override
    public abstract byte[][] getKeyData(String var1) throws JSAFE_UnimplementedException;

    @Override
    public abstract int getMaximumKeyLength();

    @Override
    public abstract int getMinimumKeyLength();

    @Override
    public abstract String[] getSupportedGetFormats();

    @Override
    public abstract String[] getSupportedSetFormats();

    @Override
    public abstract void setKeyData(String var1, byte[][] var2) throws JSAFE_InvalidKeyException, JSAFE_UnimplementedException;

    @Override
    public abstract void setKeyData(byte[][] var1) throws JSAFE_InvalidKeyException;

    @Override
    public void clearSensitiveData() {
        this.b();
        if (this.b != null) {
            dn.a.a(this.b);
        }
        this.b = null;
    }

    protected abstract boolean c();

    protected abstract DomainParams d();

    protected abstract byte[] e();

    protected PublicKey f() {
        return this.b;
    }

    PublicKey a(CryptoModule cryptoModule) {
        if (this.b == null) {
            return null;
        }
        Key key = do.a(this.b, cryptoModule);
        return (PublicKey)(key == null ? this.b.clone() : key);
    }

    protected void a(int n2, byte[][] byArray) throws JSAFE_InvalidKeyException {
        if (byArray == null || byArray.length != n2) {
            throw new JSAFE_InvalidKeyException("Invalid key data length, expected " + n2);
        }
    }

    protected void a(byte[][] byArray) throws JSAFE_InvalidKeyException {
        try {
            this.b();
            this.b = bl.b(this.getAlgorithm(), byArray, this.c);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_InvalidKeyException("Couldn't create key with given data.");
        }
    }

    protected void b(byte[][] byArray) throws JSAFE_InvalidKeyException {
        try {
            this.a(1, byArray);
            this.b();
            PublicKey publicKey = bk.b(byArray[0], 0, this.c);
            if (!publicKey.getAlg().equals(this.getAlgorithm())) {
                throw new JSAFE_InvalidKeyException("Invalid " + this.getAlgorithm() + " key BER.");
            }
            this.b = publicKey;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new JSAFE_InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    @Override
    public void delete() throws SecurityException {
        if (this.c.getDeviceType().equalsIgnoreCase(ca.c.toString())) {
            j j2 = (j)((Object)this.b);
            try {
                j2.deleteKeyFromDevice();
            }
            catch (CryptoException cryptoException) {
                throw new SecurityException(cryptoException);
            }
        }
    }
}

