/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.crypto.AlgInputParams;
import com.rsa.crypto.BadPaddingException;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.IllegalBlockSizeException;
import com.rsa.crypto.InvalidAlgorithmParameterException;
import com.rsa.crypto.InvalidKeyException;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.SecretKey;
import com.rsa.crypto.SecureRandom;
import com.rsa.crypto.SymmCipher;
import com.rsa.cryptoj.o.bj;
import com.rsa.cryptoj.o.bk;
import com.rsa.cryptoj.o.ca;
import com.rsa.cryptoj.o.ce;
import com.rsa.cryptoj.o.cf;
import com.rsa.cryptoj.o.cj;
import com.rsa.cryptoj.o.cl;
import com.rsa.cryptoj.o.dc;
import com.rsa.cryptoj.o.dk;
import com.rsa.cryptoj.o.dl;
import com.rsa.cryptoj.o.dn;
import com.rsa.cryptoj.o.dp;
import com.rsa.cryptoj.o.dv;
import com.rsa.cryptoj.o.ef;
import com.rsa.cryptoj.o.eg;
import com.rsa.cryptoj.o.eh;
import com.rsa.cryptoj.o.ei;
import com.rsa.cryptoj.o.ej;
import com.rsa.cryptoj.o.ex;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_IVException;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_Key;
import com.rsa.jsafe.JSAFE_Object;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import com.rsa.jsafe.a;
import java.util.Arrays;

public abstract class JSAFE_SymmetricCipher
extends JSAFE_Object {
    protected static final String a = "Cannot unwrap key, object needs new initialization.";
    protected static final String b = "Cannot wrap key, object needs new initialization.";
    private static final String A = "Cannot wrap the given key into a BER.";
    private static final String B = "The key to wrap is null.";
    protected static final String c = "Cannot re-initialize this object.";
    protected static final String d = "Object not initialized.";
    private static final String C = "IV missing.";
    private static final String D = "Object not initialized for encryption.";
    private static final String E = "Object not initialized for decryption.";
    protected static final String h = "PrivateKeyBER";
    static final String i = "PublicKeyBER";
    private static final String F = "XTS";
    private static final String G = "CCM";
    private static final String H = "GCM";
    private static final String I = "ECB";
    private static final String J = "CTR";
    private static final String K = "BPS";
    protected int j;
    protected static final int k = 1;
    protected static final int l = 2;
    protected static final int m = 3;
    protected static final int n = 4;
    protected static final int o = 5;
    protected static final int p = 6;
    protected static final int q = 7;
    protected static final int r = 8;
    protected static final int s = 9;
    private static final int L = 1;
    private static final int M = 2;
    protected CryptoModule t;
    protected ef u;
    protected SymmCipher v;
    protected SecretKey w;
    protected byte[] x;
    protected byte[] y;
    protected SecureRandom z;

    protected JSAFE_SymmetricCipher(CryptoModule cryptoModule, SymmCipher symmCipher, ef ef2) throws JSAFE_UnimplementedException {
        this.t = cryptoModule;
        this.v = symmCipher;
        this.u = ef2;
        byte[] byArray = (byte[])ef2.d().get("iv");
        if (byArray != null) {
            try {
                this.setIV(byArray, 0, byArray.length);
            }
            catch (JSAFE_IVException jSAFE_IVException) {
                throw new JSAFE_UnimplementedException(jSAFE_IVException.getMessage());
            }
        }
        this.j = 1;
    }

    public static JSAFE_SymmetricCipher getInstance(byte[] byArray, int n2, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        return JSAFE_SymmetricCipher.a(byArray, n2, string, ce.a());
    }

    public static JSAFE_SymmetricCipher getInstance(byte[] byArray, int n2, String string, FIPS140Context fIPS140Context) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_IVException {
        return JSAFE_SymmetricCipher.a(byArray, n2, string, fIPS140Context.a());
    }

    private static JSAFE_SymmetricCipher a(byte[] byArray, int n2, String string, cf cf2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        byte[] byArray2 = byArray;
        if (n2 > 0) {
            JSAFE_SymmetricCipher.a(byArray, n2);
            byArray2 = dp.b(byArray, n2, byArray.length - n2);
        }
        return JSAFE_SymmetricCipher.a(null, byArray2, string, cf2);
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws JSAFE_UnimplementedException {
        return ef.a(byArray, n2);
    }

    public static JSAFE_SymmetricCipher getInstance(String string, String string2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_SymmetricCipher.a(string, null, string2, ce.a());
    }

    public static JSAFE_SymmetricCipher getInstance(String string, JSAFE_Session jSAFE_Session) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_SymmetricCipher.a(string, jSAFE_Session);
    }

    public static JSAFE_SymmetricCipher getInstance(String string, String string2, FIPS140Context fIPS140Context) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        return JSAFE_SymmetricCipher.a(string, null, string2, fIPS140Context.a());
    }

    private static JSAFE_SymmetricCipher a(String string, byte[] byArray, String string2, cf cf2) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        ca[] caArray;
        if (byArray == null) {
            JSAFE_SymmetricCipher.a(string, string2);
        }
        for (ca ca2 : caArray = JSAFE_SymmetricCipher.a(string2)) {
            if (ca2.equals(ca.c)) {
                throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
            }
            try {
                cj cj2 = cl.a(cf2, ca2);
                ef ef2 = byArray != null ? ef.a(cj2, byArray, 0) : ef.a(cj2, string);
                SymmCipher symmCipher = cj2.newSymmetricCipher(ef2.a());
                if (ef2.g()) {
                    return new ei(cj2, symmCipher, ef2);
                }
                return new eh(cj2, symmCipher, ef2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (bj bj2) {
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
        }
        throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
    }

    private static JSAFE_SymmetricCipher a(String string, JSAFE_Session jSAFE_Session) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (string == null) {
            throw new JSAFE_UnimplementedException("Cannot instantiate: no transformation given.");
        }
        try {
            if (jSAFE_Session != null) {
                CryptoModule cryptoModule = jSAFE_Session.a();
                ef ef2 = ef.a(cryptoModule, string);
                if (ef2.g()) {
                    throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
                }
                SymmCipher symmCipher = cryptoModule.newSymmetricCipher(ef2.a());
                return new eh(cryptoModule, symmCipher, ef2);
            }
            throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (bj bj2) {
            // empty catch block
        }
        throw new JSAFE_UnimplementedException("Algorithm not supported on any devices: " + string);
    }

    public abstract byte[] getDERAlgorithmID() throws JSAFE_UnimplementedException;

    public String getDevice() {
        return this.t.getDeviceType();
    }

    public String[] getDeviceList() {
        Object[] objectArray = new String[this.u.f()];
        Arrays.fill(objectArray, this.getDevice());
        return objectArray;
    }

    public String getEncryptionAlgorithm() {
        return this.u.j();
    }

    public String getFeedbackMode() {
        return this.u.k();
    }

    public String getPaddingScheme() {
        return this.u.l();
    }

    public String getDigestAlgorithm() {
        return this.u.m();
    }

    public String getPasswordStandard() {
        return this.u.n();
    }

    public int getBlockSize() {
        int n2 = this.v.getFeedbackSize();
        if (n2 > 0) {
            return n2;
        }
        return this.v.getBlockSize();
    }

    public JSAFE_SecretKey getBlankKey() {
        try {
            return ex.a(this.u.o(), this.t);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int[] getAlgorithmParameters() {
        return this.u.u();
    }

    public void setAlgorithmParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        this.u.b(nArray);
    }

    public int[] getFeedbackParameters() {
        int n2 = this.v.getFeedbackSize();
        if (n2 > 0) {
            return new int[]{n2 * 8};
        }
        return new int[0];
    }

    public int[] getPaddingParameters() {
        return new int[0];
    }

    public int[] getPBEParameters() {
        return this.u.p();
    }

    public void setPBEParameters(int[] nArray) throws JSAFE_InvalidParameterException {
        this.u.a(nArray);
    }

    public void generateIV(java.security.SecureRandom secureRandom) throws JSAFE_IVException, JSAFE_InvalidUseException {
        if (this.u.h()) {
            return;
        }
        if (this.u.k().equalsIgnoreCase(H)) {
            if (this.y != null && this.y.length == 21) {
                return;
            }
            byte[] byArray = new byte[21];
            if (this.y == null) {
                byArray[0] = 12;
            } else {
                System.arraycopy(this.y, 0, byArray, 0, this.y.length);
            }
            byte[] byArray2 = (byte[])this.t.getModuleOperations().perform("gcmIV", null);
            System.arraycopy(byArray2, 0, byArray, 9, 12);
            this.y = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.y, 0, byArray.length);
            return;
        }
        if (secureRandom == null) {
            throw new JSAFE_InvalidUseException("IV generation needs a random object.");
        }
        if (this.u.k().equalsIgnoreCase(G) || this.u.k().equalsIgnoreCase(F) || this.u.k().equalsIgnoreCase(K)) {
            throw new JSAFE_InvalidUseException("IV generation not supported for BPS, CCM or XTS modes");
        }
        int n2 = this.b(this.v.getBlockSize());
        if (n2 <= 0) {
            throw new JSAFE_IVException("IV generation is not supported in this feedback mode");
        }
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        this.setIV(byArray, 0, byArray.length);
    }

    public void setIV(byte[] byArray, int n2, int n3) throws JSAFE_IVException {
        if (this.u.h()) {
            return;
        }
        try {
            dv.a(byArray, n2, n3);
        }
        catch (JSAFE_InputException jSAFE_InputException) {
            throw new JSAFE_IVException("Invalid Parameter");
        }
        if (this.u.k().equals(G) || this.u.k().equals(H) || this.u.k().equals(F) || this.u.k().equals(K)) {
            this.y = new byte[n3];
            System.arraycopy(byArray, n2, this.y, 0, n3);
            return;
        }
        this.c(n3);
        if (this.j == 4 || this.j == 5 || this.j == 8 || this.j == 9) {
            this.x = new byte[n3];
            System.arraycopy(byArray, n2, this.x, 0, n3);
        } else {
            this.y = new byte[n3];
            System.arraycopy(byArray, n2, this.y, 0, n3);
            this.x = null;
            if (this.w != null) {
                this.v.init(1, this.w, this.a(), this.z);
            }
        }
    }

    public byte[] getIV() {
        try {
            byte[] byArray;
            AlgInputParams algInputParams = (AlgInputParams)this.v.getAlgorithmParams();
            if (algInputParams != null && (byArray = (byte[])algInputParams.get("iv")) != null && byArray.length > 0) {
                this.y = byArray;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (H.equals(this.u.k()) && this.y.length == 9) {
            try {
                this.generateIV(null);
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                // empty catch block
            }
        }
        return dc.a(this.y);
    }

    public void generateSalt(java.security.SecureRandom secureRandom) throws JSAFE_InvalidUseException {
    }

    public void setSalt(byte[] byArray, int n2, int n3) {
    }

    public byte[] getSalt() {
        return null;
    }

    public int getOutputBufferSize(int n2) {
        return this.v.getOutputSize(n2);
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        this.encryptInit(jSAFE_SecretKey, null);
    }

    public void encryptInit(JSAFE_SecretKey jSAFE_SecretKey, java.security.SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        this.z = com.rsa.jsafe.a.b(secureRandom);
        byte[] byArray = this.a(jSAFE_SecretKey.e(), this.z);
        if (byArray != null) {
            jSAFE_SecretKey.setSecretKeyData(byArray, 0, byArray.length);
        }
    }

    protected abstract byte[] a(SecretKey var1, SecureRandom var2) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException;

    public void encryptReInit() throws JSAFE_InvalidUseException, JSAFE_IVException {
        if (this.u.h()) {
            throw new JSAFE_InvalidUseException(c);
        }
        if ((this.j == 9 || this.j == 8 || this.j == 5 || this.j == 4) && this.x != null) {
            System.arraycopy(this.x, 0, this.y, 0, this.x.length);
            this.x = null;
        }
        if (this.j == 9 || this.j == 8) {
            try {
                this.v.init(1, this.w, this.a(), this.z);
                this.j = 2;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new JSAFE_InvalidUseException(invalidAlgorithmParameterException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new JSAFE_InvalidUseException(invalidKeyException);
            }
        } else if (this.j == 5 || this.j == 4) {
            this.v.reInit(this.a());
            this.j = 2;
        } else if (this.j == 2) {
            this.j = 2;
        } else if (this.j == 7 || this.j == 3 || this.j == 6) {
            this.j = 3;
        } else {
            throw new JSAFE_InvalidUseException(d);
        }
    }

    public byte[] encryptUpdate(byte[] byArray, int n2, int n3) throws JSAFE_InvalidUseException, JSAFE_IVException {
        return this.a(1, byArray, n2, n3);
    }

    public int encryptUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws JSAFE_InvalidUseException, JSAFE_IVException {
        if (!(this.j != 2 && this.j != 3 || !this.v.isIVRequired() || this.y != null && this.y.length != 0)) {
            throw new JSAFE_InvalidUseException(C);
        }
        if (this.j == 3) {
            this.v.init(1, this.w, this.a(), this.z);
            this.j = 2;
        }
        if (this.j == 2 || this.j == 4) {
            this.j = 4;
            return this.v.update(byArray, n2, n3, byArray2, n4);
        }
        throw new JSAFE_InvalidUseException(D);
    }

    public byte[] wrapPrivateKey(JSAFE_PrivateKey jSAFE_PrivateKey, boolean bl2) throws JSAFE_InvalidUseException {
        return this.wrapPrivateKey(jSAFE_PrivateKey, bl2, null);
    }

    public byte[] wrapPrivateKey(JSAFE_PrivateKey jSAFE_PrivateKey, boolean bl2, String string) throws JSAFE_InvalidUseException {
        if (jSAFE_PrivateKey == null) {
            throw new JSAFE_InvalidUseException(B);
        }
        if (string != null) {
            int n2;
            if (string.endsWith("PEM") || string.startsWith("SSLC")) {
                try {
                    return this.a(jSAFE_PrivateKey, string);
                }
                catch (Exception exception) {
                    throw new JSAFE_InvalidUseException(exception);
                }
            }
            String[] stringArray = jSAFE_PrivateKey.getSupportedGetFormats();
            for (n2 = 0; !(n2 >= stringArray.length || string.equals(stringArray[n2]) && string.endsWith("BER")); ++n2) {
            }
            if (n2 >= stringArray.length) {
                throw new JSAFE_InvalidUseException("The format, " + string + ", is not valid for this key");
            }
        }
        try {
            return this.a(jSAFE_PrivateKey, bl2, string);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidUseException(jSAFE_Exception);
        }
    }

    public byte[] wrapPublicKey(JSAFE_PublicKey jSAFE_PublicKey, boolean bl2) throws JSAFE_InvalidUseException {
        if (jSAFE_PublicKey == null) {
            throw new JSAFE_InvalidUseException(B);
        }
        try {
            return this.a(jSAFE_PublicKey, bl2);
        }
        catch (Exception exception) {
            throw new JSAFE_InvalidUseException(exception);
        }
    }

    public byte[] wrapSecretKey(JSAFE_SecretKey jSAFE_SecretKey, boolean bl2) throws JSAFE_InvalidUseException {
        if (jSAFE_SecretKey == null) {
            throw new JSAFE_InvalidUseException(B);
        }
        try {
            return this.a(jSAFE_SecretKey, bl2);
        }
        catch (Exception exception) {
            throw new JSAFE_InvalidUseException(exception);
        }
    }

    public byte[] encryptFinal() throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException {
        return this.a(1);
    }

    public int encryptFinal(byte[] byArray, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException {
        if (this.j == 2 || this.j == 4) {
            this.j = 5;
            try {
                return this.v.doFinal(byArray, n2);
            }
            catch (BadPaddingException badPaddingException) {
                throw new JSAFE_PaddingException(badPaddingException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new JSAFE_InputException(illegalBlockSizeException);
            }
        }
        if (this.j == 6 || this.j == 8) {
            throw new JSAFE_InvalidUseException(D);
        }
        throw new JSAFE_InvalidUseException(d);
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        this.decryptInit(jSAFE_SecretKey, null);
    }

    public void decryptInit(JSAFE_SecretKey jSAFE_SecretKey, java.security.SecureRandom secureRandom) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException {
        this.z = com.rsa.jsafe.a.b(secureRandom);
        byte[] byArray = this.b(jSAFE_SecretKey.e(), this.z);
        if (byArray != null) {
            jSAFE_SecretKey.setSecretKeyData(byArray, 0, byArray.length);
        }
    }

    protected abstract byte[] b(SecretKey var1, SecureRandom var2) throws JSAFE_InvalidUseException, JSAFE_InvalidKeyException, JSAFE_IVException;

    public void decryptReInit() throws JSAFE_InvalidUseException, JSAFE_IVException {
        if (this.u.h()) {
            throw new JSAFE_InvalidUseException(c);
        }
        if ((this.j == 9 || this.j == 8 || this.j == 5 || this.j == 4) && this.x != null) {
            System.arraycopy(this.x, 0, this.y, 0, this.x.length);
            this.x = null;
        }
        if (this.j == 5 || this.j == 4) {
            this.v.init(2, this.w, this.a(), this.z);
            this.j = 6;
        } else if (this.j == 9 || this.j == 8) {
            this.v.reInit(this.a());
            this.j = 6;
        } else if (this.j == 6) {
            this.j = 6;
        } else if (this.j == 3 || this.j == 7 || this.j == 2) {
            this.j = 7;
        } else {
            throw new JSAFE_InvalidUseException(d);
        }
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n2, int n3, boolean bl2) throws JSAFE_InvalidUseException {
        return this.unwrapPrivateKey(byArray, n2, n3, bl2, null);
    }

    public JSAFE_PrivateKey unwrapPrivateKey(byte[] byArray, int n2, int n3, boolean bl2, String string) throws JSAFE_InvalidUseException {
        if (this.j != 6) {
            throw new JSAFE_InvalidUseException(a);
        }
        if (string == null) {
            string = this.getDevice();
        }
        if (bl2) {
            int[] nArray = dl.a(byArray, n2);
            n2 = nArray[0];
            n3 = nArray[1];
        }
        try {
            return this.a(byArray, n2, n3, string);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidUseException(jSAFE_Exception);
        }
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n2, int n3, boolean bl2) throws JSAFE_InvalidUseException {
        return this.unwrapPublicKey(byArray, n2, n3, bl2, null);
    }

    public JSAFE_PublicKey unwrapPublicKey(byte[] byArray, int n2, int n3, boolean bl2, String string) throws JSAFE_InvalidUseException {
        Object[] objectArray;
        if (this.j != 6) {
            throw new JSAFE_InvalidUseException(a);
        }
        if (string == null) {
            string = this.getDevice();
        }
        if (bl2) {
            objectArray = dl.a(byArray, n2);
            n2 = objectArray[0];
            n3 = objectArray[1];
        }
        objectArray = new byte[this.getOutputBufferSize(n3)];
        try {
            int n4 = this.decryptUpdate(byArray, n2, n3, (byte[])objectArray, 0);
            this.decryptFinal((byte[])objectArray, n4);
            return this.b((byte[])objectArray, string);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new JSAFE_InvalidUseException(jSAFE_Exception);
        }
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n2, int n3, boolean bl2, String string) throws JSAFE_InvalidUseException {
        return this.unwrapSecretKey(byArray, n2, n3, bl2, string, null);
    }

    public JSAFE_SecretKey unwrapSecretKey(byte[] byArray, int n2, int n3, boolean bl2, String string, String string2) throws JSAFE_InvalidUseException {
        Object[] objectArray;
        if (this.j != 6 && this.j != 7) {
            throw new JSAFE_InvalidUseException(a);
        }
        if (string2 == null) {
            string2 = this.getDevice();
        }
        if (bl2) {
            objectArray = dl.a(byArray, n2);
            n2 = objectArray[0];
            n3 = objectArray[1];
        }
        objectArray = null;
        try {
            JSAFE_SecretKey jSAFE_SecretKey;
            objectArray = new byte[this.getOutputBufferSize(n3)];
            int n4 = this.decryptUpdate(byArray, n2, n3, (byte[])objectArray, 0);
            n4 += this.decryptFinal((byte[])objectArray, n4);
            CryptoModule cryptoModule = cl.a(this.t, JSAFE_SymmetricCipher.a(string2)[0]);
            if (bl2) {
                jSAFE_SecretKey = eg.a(cryptoModule, (byte[])objectArray, 0);
            } else {
                jSAFE_SecretKey = ex.a(string, cryptoModule);
                jSAFE_SecretKey.setSecretKeyData((byte[])objectArray, 0, n4);
            }
            JSAFE_SecretKey jSAFE_SecretKey2 = jSAFE_SecretKey;
            return jSAFE_SecretKey2;
        }
        catch (Exception exception) {
            throw new JSAFE_InvalidUseException(exception);
        }
        finally {
            dn.a.a((byte[])objectArray);
        }
    }

    public byte[] decryptUpdate(byte[] byArray, int n2, int n3) throws JSAFE_InvalidUseException, JSAFE_IVException {
        return this.a(2, byArray, n2, n3);
    }

    public int decryptUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws JSAFE_InvalidUseException, JSAFE_IVException {
        if (!(this.j != 6 && this.j != 7 || !this.v.isIVRequired() || this.y != null && this.y.length != 0)) {
            throw new JSAFE_InvalidUseException(C);
        }
        if (this.j == 7) {
            this.v.init(2, this.w, this.a(), this.z);
            this.j = 6;
        }
        if (this.j == 6 || this.j == 8) {
            this.j = 8;
            return this.v.update(byArray, n2, n3, byArray2, n4);
        }
        throw new JSAFE_InvalidUseException(E);
    }

    public byte[] decryptFinal() throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException {
        return this.a(2);
    }

    public int decryptFinal(byte[] byArray, int n2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException {
        if (this.j == 6 || this.j == 8) {
            this.j = 9;
            try {
                return this.v.doFinal(byArray, n2);
            }
            catch (BadPaddingException badPaddingException) {
                throw new JSAFE_PaddingException(badPaddingException);
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new JSAFE_InputException(illegalBlockSizeException);
            }
        }
        if (this.j == 2 || this.j == 4) {
            throw new JSAFE_InvalidUseException(E);
        }
        throw new JSAFE_InvalidUseException(d);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = (JSAFE_SymmetricCipher)super.clone();
        jSAFE_SymmetricCipher.v = (SymmCipher)this.v.clone();
        jSAFE_SymmetricCipher.z = this.z == null ? null : this.z.newInstance();
        jSAFE_SymmetricCipher.x = dc.a(this.x);
        jSAFE_SymmetricCipher.y = dc.a(this.y);
        jSAFE_SymmetricCipher.w = (SecretKey)dc.a(this.w);
        jSAFE_SymmetricCipher.j = this.j;
        return jSAFE_SymmetricCipher;
    }

    @Override
    public void clearSensitiveData() {
        dn.a.a(this.v);
    }

    private byte[] a(int n2, byte[] byArray, int n3, int n4) throws JSAFE_InvalidUseException, JSAFE_IVException {
        int n5 = this.getOutputBufferSize(n4);
        byte[] byArray2 = new byte[n5];
        n5 = n2 == 2 ? this.decryptUpdate(byArray, n3, n4, byArray2, 0) : this.encryptUpdate(byArray, n3, n4, byArray2, 0);
        return dp.a(n5, byArray2);
    }

    private byte[] a(int n2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException {
        byte[] byArray = new byte[this.getOutputBufferSize(0)];
        int n3 = n2 == 2 ? this.decryptFinal(byArray, 0) : this.encryptFinal(byArray, 0);
        return dp.a(n3, byArray);
    }

    protected byte[] a(JSAFE_PrivateKey jSAFE_PrivateKey, String string) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException, JSAFE_UnimplementedException, JSAFE_InvalidKeyException {
        return new byte[0];
    }

    private byte[] a(JSAFE_Key jSAFE_Key, boolean bl2) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException, JSAFE_UnimplementedException {
        return this.a(jSAFE_Key, bl2, null);
    }

    private byte[] a(JSAFE_Key jSAFE_Key, boolean bl2, String string) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException, JSAFE_UnimplementedException {
        byte[] byArray = null;
        int n2 = 0;
        if (bl2) {
            byArray = this.getDERAlgorithmID();
            if (byArray == null) {
                throw new JSAFE_InvalidUseException(A);
            }
            n2 = byArray.length;
        }
        return this.a(jSAFE_Key, bl2, string, byArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] a(JSAFE_Key jSAFE_Key, boolean bl2, String string, byte[] byArray, int n2, int n3) throws JSAFE_InvalidUseException, JSAFE_InputException, JSAFE_IVException, JSAFE_PaddingException, JSAFE_UnimplementedException {
        Object object;
        if (this.j != 2 && this.j != 3) {
            throw new JSAFE_InvalidUseException(b);
        }
        byte[] byArray2 = null;
        int n4 = 0;
        byte[][] byArray3 = null;
        try {
            object = string != null ? string : jSAFE_Key.getKeyWrappingFormat(bl2);
            byArray3 = jSAFE_Key.getKeyData((String)object);
            n4 = this.getOutputBufferSize(byArray3[0].length);
            byArray2 = new byte[n4];
            n4 = this.encryptUpdate(byArray3[0], 0, byArray3[0].length, byArray2, 0);
            n4 += this.encryptFinal(byArray2, n4);
        }
        finally {
            dn.a.a(byArray3);
        }
        if (!bl2) {
            if (n4 == byArray2.length) {
                return byArray2;
            }
            object = new byte[n4];
            System.arraycopy(byArray2, 0, object, 0, n4);
            return object;
        }
        return dl.a(byArray, n2, n3, byArray2, 0, n4);
    }

    protected JSAFE_PrivateKey a(byte[] byArray, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_InvalidKeyException, JSAFE_InvalidUseException {
        try {
            String string2 = bk.a(byArray, 0, false);
            CryptoModule cryptoModule = cl.a(this.t, JSAFE_SymmetricCipher.a(string)[0]);
            JSAFE_PrivateKey jSAFE_PrivateKey = ej.b(string2, cryptoModule);
            jSAFE_PrivateKey.setKeyData(string2 + h, new byte[][]{byArray});
            return jSAFE_PrivateKey;
        }
        catch (bj bj2) {
            throw new JSAFE_InvalidUseException("Device not available: " + string);
        }
    }

    private JSAFE_PublicKey b(byte[] byArray, String string) throws JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_InvalidKeyException, JSAFE_InvalidUseException {
        String string2 = bk.a(byArray, 0, true);
        try {
            CryptoModule cryptoModule = cl.a(this.t, JSAFE_SymmetricCipher.a(string)[0]);
            JSAFE_PublicKey jSAFE_PublicKey = ej.a(string2, cryptoModule);
            jSAFE_PublicKey.setKeyData(string2 + i, new byte[][]{byArray});
            return jSAFE_PublicKey;
        }
        catch (bj bj2) {
            throw new JSAFE_InvalidUseException("Device not available: " + string);
        }
    }

    protected AlgInputParams a() {
        AlgInputParams algInputParams = this.u.d();
        if (this.y != null && this.y.length > 0) {
            algInputParams.set("iv", this.y);
        }
        return algInputParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSAFE_PrivateKey a(byte[] byArray, int n2, int n3, String string) throws JSAFE_InvalidUseException, JSAFE_PaddingException, JSAFE_InputException, JSAFE_IVException, JSAFE_UnimplementedException, JSAFE_InvalidParameterException, JSAFE_InvalidKeyException {
        JSAFE_PrivateKey jSAFE_PrivateKey;
        byte[] byArray2 = null;
        try {
            byArray2 = new byte[this.getOutputBufferSize(n3)];
            int n4 = this.decryptUpdate(byArray, n2, n3, byArray2, 0);
            this.decryptFinal(byArray2, n4);
            jSAFE_PrivateKey = this.a(byArray2, string);
        }
        catch (Throwable throwable) {
            dk.a(byArray2);
            throw throwable;
        }
        dk.a(byArray2);
        return jSAFE_PrivateKey;
    }

    private int b(int n2) {
        if (this.u.k().equalsIgnoreCase(I)) {
            return 0;
        }
        if (this.u.k().equalsIgnoreCase(J)) {
            return 16;
        }
        if (this.u.k().equalsIgnoreCase(H)) {
            return 21;
        }
        return n2;
    }

    private void c(int n2) throws JSAFE_IVException {
        if (this.v.isIVRequired() && !this.u.a(n2, this.v.getBlockSize())) {
            throw new JSAFE_IVException("Invalid IV length.");
        }
    }
}

