/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe;

import com.rsa.crypto.AlgParamGenerator;
import com.rsa.crypto.DHParams;
import com.rsa.crypto.DSAParams;
import com.rsa.cryptoj.o.ca;
import com.rsa.cryptoj.o.ce;
import com.rsa.cryptoj.o.cf;
import com.rsa.cryptoj.o.cj;
import com.rsa.cryptoj.o.cl;
import com.rsa.jsafe.FIPS140Context;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.a;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class JSAFE_VerifyPQG {
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final int VERSION_FIPS186_2 = 2;
    public static final int VERSION_FIPS186_3 = 3;

    private JSAFE_VerifyPQG() {
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n3) {
        return JSAFE_VerifyPQG.verifyPQGParams(byArray, byArray2, n2, byArray3, byArray4, byArray5, n3, null);
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n3, FIPS140Context fIPS140Context) {
        try {
            return JSAFE_VerifyPQG.verifyPQGParams(byArray, byArray2, byArray3, byArray4, n3, DIGEST_SHA1, 2, null, fIPS140Context);
        }
        catch (JSAFE_InvalidParameterException jSAFE_InvalidParameterException) {
            return false;
        }
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, String string) throws JSAFE_InvalidParameterException {
        return JSAFE_VerifyPQG.verifyPQGParams(byArray, byArray2, byArray3, byArray4, n2, string, null, null);
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, String string, JSAFE_SecureRandom jSAFE_SecureRandom, FIPS140Context fIPS140Context) throws JSAFE_InvalidParameterException {
        int n3 = 3;
        if (DIGEST_SHA1.equals(string)) {
            n3 = 2;
        }
        return JSAFE_VerifyPQG.verifyPQGParams(byArray, byArray2, byArray3, byArray4, n2, string, n3, jSAFE_SecureRandom, fIPS140Context);
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, String string, int n3) throws JSAFE_InvalidParameterException {
        return JSAFE_VerifyPQG.verifyPQGParams(byArray, byArray2, byArray3, byArray4, n2, string, n3, null, null);
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, String string, int n3, JSAFE_SecureRandom jSAFE_SecureRandom, FIPS140Context fIPS140Context) throws JSAFE_InvalidParameterException {
        SecureRandom secureRandom;
        cf cf2 = fIPS140Context == null ? ce.a() : fIPS140Context.a();
        cj cj2 = cl.a(cf2, ca.a);
        if (jSAFE_SecureRandom == null) {
            try {
                secureRandom = JSAFE_SecureRandom.getInstance("FIPS186Random", cj2.getDeviceType());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                secureRandom = null;
            }
        } else {
            secureRandom = jSAFE_SecureRandom;
        }
        AlgParamGenerator algParamGenerator = cj2.newAlgParamGenerator("DSA");
        DSAParams dSAParams = cj2.getKeyBuilder().newDSAParams(byArray2, byArray3, byArray4, byArray, n2, string);
        algParamGenerator.initVerify(dSAParams, a.b(secureRandom));
        return algParamGenerator.verify();
    }

    public static boolean verifyX942DHParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, JSAFE_SecureRandom jSAFE_SecureRandom, FIPS140Context fIPS140Context) throws JSAFE_InvalidParameterException {
        SecureRandom secureRandom;
        cf cf2 = fIPS140Context == null ? ce.a() : fIPS140Context.a();
        cj cj2 = cl.a(cf2, ca.a);
        if (jSAFE_SecureRandom == null) {
            try {
                secureRandom = JSAFE_SecureRandom.getInstance("HMACDRBG256", cj2.getDeviceType());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                secureRandom = null;
            }
        } else {
            secureRandom = jSAFE_SecureRandom;
        }
        AlgParamGenerator algParamGenerator = cj2.newAlgParamGenerator("DH");
        DHParams dHParams = cj2.getKeyBuilder().newDHParams(byArray2, byArray4, byArray3, null, byArray, n2);
        algParamGenerator.initVerify(dHParams, a.b(secureRandom));
        return algParamGenerator.verify();
    }

    public static boolean verifyX942DHParams(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2) throws JSAFE_InvalidParameterException {
        return JSAFE_VerifyPQG.verifyX942DHParams(byArray, byArray2, byArray3, byArray4, n2, null, null);
    }
}

