/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.o.a;
import com.rsa.cryptoj.o.ac;
import com.rsa.cryptoj.o.ad;
import com.rsa.cryptoj.o.d;
import com.rsa.cryptoj.o.dc;
import com.rsa.cryptoj.o.dg;
import com.rsa.cryptoj.o.dp;
import com.rsa.jsafe.cert.GeneralName;
import com.rsa.jsafe.cert.ObjectID;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AuthorityKeyIdentifier {
    private byte[] a;
    private List<GeneralName> b;
    private BigInteger c;
    private d d;
    private byte[] e;

    public AuthorityKeyIdentifier(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Issuer certificate is null");
        }
        this.a = x509Certificate.getExtensionValue(ObjectID.SUBJECT_KEY_ID_EXTN.toString());
        if (this.a == null) {
            throw new IllegalArgumentException("Subject key identifier extension not present in the certificate, " + x509Certificate.getSubjectX500Principal());
        }
        this.a = ((ad)com.rsa.cryptoj.o.a.a(ac.a, this.a, 0)).h();
        this.a = ((ad)com.rsa.cryptoj.o.a.a(ac.a, this.a, 0)).h();
        this.c = x509Certificate.getSerialNumber();
        this.b = new ArrayList<GeneralName>();
        this.b.add(new GeneralName(x509Certificate.getSubjectX500Principal()));
        this.a();
    }

    public AuthorityKeyIdentifier(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Key identifier is null or empty");
        }
        this.a = dc.a(byArray);
        this.a();
    }

    public AuthorityKeyIdentifier(byte[] byArray, List<GeneralName> list, BigInteger bigInteger) {
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("Key identifier is null or empty");
        }
        if (list == null || list.contains(null) || list.isEmpty()) {
            throw new IllegalArgumentException("Issuer name cannot be null or empty");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Issuer serial number cannot be null");
        }
        this.a = dc.a(byArray);
        this.b = Collections.unmodifiableList(new ArrayList<GeneralName>(list));
        this.c = bigInteger;
        this.a();
    }

    private void a() {
        boolean bl2 = this.b != null && !this.b.isEmpty();
        Object[] objectArray = null;
        if (bl2) {
            objectArray = new Object[this.b.size()];
            for (int i2 = 0; i2 < this.b.size(); ++i2) {
                objectArray[i2] = com.rsa.cryptoj.o.a.a("GeneralName", this.b.get(i2).getEncoded(), 0);
            }
        }
        this.d = com.rsa.cryptoj.o.a.a("AuthorityKeyIdentifier", (Object)new Object[]{this.a, objectArray, bl2 ? this.c : null});
        this.e = com.rsa.cryptoj.o.a.c(this.d);
    }

    public byte[] getKeyIdentifier() {
        return dc.a(this.a);
    }

    public List<GeneralName> getIssuerName() {
        return this.b;
    }

    public BigInteger getIssuerSerialNum() {
        return this.c;
    }

    public d getASN1Value() {
        return this.d;
    }

    public int hashCode() {
        return dg.a(7, this.e);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.e, ((AuthorityKeyIdentifier)object).e);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Authority Key Identifier [").append(dp.a);
        if (this.a != null) {
            stringBuffer.append("      ").append("Key Identifier [");
            stringBuffer.append(dp.a(this.a));
            stringBuffer.append("]").append(dp.a);
        }
        if (this.b != null) {
            stringBuffer.append("      ").append("Issuer Name [").append(dp.a);
            for (GeneralName generalName : this.b) {
                stringBuffer.append("      ").append(generalName).append(dp.a);
            }
            stringBuffer.append("   ").append("]").append(dp.a);
        }
        if (this.c != null) {
            stringBuffer.append("   ").append("Issuer Serial Num [").append(dp.a);
            stringBuffer.append("      ").append(this.c.toString());
            stringBuffer.append("   ").append("]").append(dp.a);
        }
        stringBuffer.append("   ").append("]").append(dp.a);
        return stringBuffer.toString();
    }
}

