/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert;

import com.rsa.cryptoj.o.ce;
import com.rsa.cryptoj.o.cf;
import com.rsa.cryptoj.o.om;
import com.rsa.cryptoj.o.oy;
import com.rsa.cryptoj.o.pc;
import com.rsa.cryptoj.o.pg;
import com.rsa.cryptoj.o.pi;
import com.rsa.cryptoj.o.pk;
import com.rsa.jsafe.cert.CertComplianceAdjustment;
import com.rsa.jsafe.cert.CertCreationException;
import com.rsa.jsafe.cert.CertCreationParameterSpec;
import com.rsa.jsafe.cert.IssuerInformation;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.b;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

public final class CertCreationFactory {
    private final pk a;

    private CertCreationFactory(om om2, cf cf2, SecureRandom secureRandom) {
        this.a = new pk(cf2, secureRandom, om2);
    }

    public static CertCreationFactory getInstance(String string) {
        return CertCreationFactory.a(string, ce.a(), null);
    }

    public static CertCreationFactory getInstance(String string, FIPS140Context fIPS140Context) {
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        return CertCreationFactory.a(string, b.a((FIPS140Context)fIPS140Context), null);
    }

    public static CertCreationFactory getInstance(String string, SecureRandom secureRandom) {
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CertCreationFactory.a(string, ce.a(), secureRandom);
    }

    public static CertCreationFactory getInstance(String string, FIPS140Context fIPS140Context, SecureRandom secureRandom) {
        if (fIPS140Context == null) {
            throw new IllegalArgumentException("The context is null");
        }
        if (secureRandom == null) {
            throw new IllegalArgumentException("The SecureRandom obj is null");
        }
        return CertCreationFactory.a(string, b.a((FIPS140Context)fIPS140Context), secureRandom);
    }

    public String getType() {
        return this.a.a();
    }

    private static CertCreationFactory a(String string, cf cf2, SecureRandom secureRandom) {
        if (string == null) {
            throw new IllegalArgumentException("Validation type is null");
        }
        cf2.l();
        if (string.equalsIgnoreCase("X.509-SuiteB")) {
            return new CertCreationFactory(new pi(), cf2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-Strict")) {
            return new CertCreationFactory(new pg(), cf2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509-NoValidation")) {
            return new CertCreationFactory(new pc(), cf2, secureRandom);
        }
        if (string.equalsIgnoreCase("X.509")) {
            return new CertCreationFactory(new oy(), cf2, secureRandom);
        }
        throw new IllegalArgumentException("Unknown/unsupported validation type");
    }

    public X509Certificate generateCertificate(IssuerInformation issuerInformation, CertCreationParameterSpec certCreationParameterSpec) throws CertCreationException {
        return this.a.a(issuerInformation, certCreationParameterSpec, new CertComplianceAdjustment());
    }

    public X509Certificate generateCertificate(IssuerInformation issuerInformation, CertCreationParameterSpec certCreationParameterSpec, CertComplianceAdjustment certComplianceAdjustment) throws CertCreationException {
        return this.a.a(issuerInformation, certCreationParameterSpec, certComplianceAdjustment);
    }
}

