/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert.cmp;

import com.rsa.jsafe.cert.cmp.CMPException;
import com.rsa.jsafe.cert.cmp.CMPInvalidRequestException;
import com.rsa.jsafe.cert.cmp.CMPMessage;
import com.rsa.jsafe.cert.cmp.CertConfirmationMessage;
import com.rsa.jsafe.cert.cmp.CertResponse;
import com.rsa.jsafe.cert.cmp.CertResponseMessage;
import com.rsa.jsafe.cert.cmp.CertStatus;
import com.rsa.jsafe.cert.cmp.MessageHeaderInfo;
import com.rsa.jsafe.cert.cmp.StatusInfo;
import com.rsa.jsafe.cert.cmp.a;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class CertConfirmationMessageImpl
extends a
implements CertConfirmationMessage {
    private final List<CertStatus> b = new ArrayList<CertStatus>();
    private byte[] c;
    private CMPMessage.Type d;

    public CertConfirmationMessageImpl(CertResponseMessage certResponseMessage, StatusInfo statusInfo) {
        if (certResponseMessage == null || statusInfo == null) {
            throw new IllegalArgumentException("Input cannot be null.");
        }
        if (certResponseMessage.getCertResponseList().size() != 1) {
            throw new CMPInvalidRequestException("Response message expected one certificate response.");
        }
        this.a(certResponseMessage);
        this.a(certResponseMessage.getCertResponseList().get(0), null, statusInfo);
    }

    public CertConfirmationMessageImpl(CertResponseMessage certResponseMessage, StatusInfo statusInfo, StatusInfo statusInfo2) {
        if (certResponseMessage == null || statusInfo == null || statusInfo2 == null) {
            throw new IllegalArgumentException("Input cannot be null.");
        }
        if (certResponseMessage.getCertResponseList().size() != 2) {
            throw new CMPInvalidRequestException("Response message expected two certificate responses.");
        }
        this.a(certResponseMessage);
        this.a(certResponseMessage.getCertResponseList().get(0), null, statusInfo);
        this.a(certResponseMessage.getCertResponseList().get(1), null, statusInfo2);
    }

    public CertConfirmationMessageImpl(CertResponseMessage certResponseMessage, PrivateKey privateKey, StatusInfo statusInfo) {
        if (certResponseMessage == null || statusInfo == null) {
            throw new IllegalArgumentException("Input cannot be null.");
        }
        if (certResponseMessage.getCertResponseList().size() != 1) {
            throw new CMPInvalidRequestException("Response message expected one certificate response.");
        }
        this.a(certResponseMessage);
        this.a(certResponseMessage.getCertResponse(), privateKey, statusInfo);
    }

    public CertConfirmationMessageImpl(CertResponseMessage certResponseMessage, PrivateKey privateKey, StatusInfo statusInfo, StatusInfo statusInfo2) {
        if (certResponseMessage == null || privateKey == null || statusInfo == null || statusInfo2 == null) {
            throw new IllegalArgumentException("Input cannot be null.");
        }
        if (certResponseMessage.getCertResponseList().size() != 2) {
            throw new CMPInvalidRequestException("Response message expected one certificate response.");
        }
        this.a(certResponseMessage);
        this.a(certResponseMessage.getCertResponseList().get(0), privateKey, statusInfo);
        this.a(certResponseMessage.getCertResponseList().get(1), privateKey, statusInfo2);
    }

    private void a(CertResponse certResponse, PrivateKey privateKey, final StatusInfo statusInfo) {
        if (certResponse.getStatusInfo().getStatus() != StatusInfo.Status.ACCEPTED && certResponse.getStatusInfo().getStatus() != StatusInfo.Status.GRANTED_WITH_MOD) {
            throw new CMPInvalidRequestException("Response did not contain certificate.");
        }
        try {
            X509Certificate x509Certificate;
            final BigInteger bigInteger = certResponse.getRequestID();
            X509Certificate x509Certificate2 = x509Certificate = certResponse.getCertificate() == null ? certResponse.getCertificate(privateKey) : certResponse.getCertificate();
            if (x509Certificate == null) {
                throw new CMPInvalidRequestException("Response did not contain a certificate.");
            }
            this.b.add(new CertStatus(){

                @Override
                public X509Certificate getCert() {
                    return x509Certificate;
                }

                @Override
                public BigInteger getRequestID() {
                    return bigInteger;
                }

                @Override
                public StatusInfo getStatusInfo() {
                    return statusInfo;
                }
            });
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CMPException("Could not decrypt certificate", generalSecurityException);
        }
    }

    private void a(CertResponseMessage certResponseMessage) {
        this.c = certResponseMessage.getSenderNonce();
        this.a = new MessageHeaderInfo();
        if (certResponseMessage.getRecipient() != null) {
            this.a.setSender(certResponseMessage.getRecipient());
        }
        if (certResponseMessage.getSender() != null) {
            this.a.setRecipient(certResponseMessage.getSender());
        }
        if (certResponseMessage.getTransactionID() != null) {
            this.a.setTransactionID(certResponseMessage.getTransactionID());
        }
        this.a.setSenderKeyID(certResponseMessage.getSenderKeyID());
        this.d = certResponseMessage.getMessageType();
    }

    @Override
    public List<CertStatus> getCertStatuses() {
        return this.b;
    }

    @Override
    public byte[] getRecipientNonce() {
        return this.c == null ? null : (byte[])this.c.clone();
    }

    @Override
    public CMPMessage.Type getMessageType() {
        return CMPMessage.Type.CERTIFICATE_CONFIRM;
    }

    public CMPMessage.Type getMessageTypeToConfirm() {
        return this.d;
    }
}

