/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert.crmf;

import com.rsa.cryptoj.o.dg;
import com.rsa.cryptoj.o.dp;
import com.rsa.jsafe.cert.crmf.CertTemplateSpec;
import com.rsa.jsafe.cert.crmf.ControlsSpec;
import com.rsa.jsafe.cert.crmf.ProofOfPossessionSpec;
import com.rsa.jsafe.cert.crmf.RegInfoSpec;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

public final class CRMFParameterSpec
implements AlgorithmParameterSpec {
    private static final String a = "Input parameters cannot be null";
    private BigInteger b;
    private CertTemplateSpec c;
    private RegInfoSpec d;
    private ControlsSpec e;
    private ProofOfPossessionSpec f;

    public CRMFParameterSpec(BigInteger bigInteger, CertTemplateSpec certTemplateSpec) {
        if (bigInteger == null || certTemplateSpec == null) {
            throw new IllegalArgumentException(a);
        }
        this.b = bigInteger;
        this.c = (CertTemplateSpec)certTemplateSpec.clone();
    }

    public CRMFParameterSpec(BigInteger bigInteger, CertTemplateSpec certTemplateSpec, ProofOfPossessionSpec proofOfPossessionSpec) {
        this(bigInteger, certTemplateSpec);
        this.f = proofOfPossessionSpec;
    }

    public CRMFParameterSpec(BigInteger bigInteger, CertTemplateSpec certTemplateSpec, RegInfoSpec regInfoSpec) {
        this(bigInteger, certTemplateSpec);
        if (regInfoSpec != null) {
            this.d = (RegInfoSpec)regInfoSpec.clone();
        }
    }

    public CRMFParameterSpec(BigInteger bigInteger, CertTemplateSpec certTemplateSpec, ControlsSpec controlsSpec) {
        this(bigInteger, certTemplateSpec);
        if (controlsSpec != null) {
            this.e = (ControlsSpec)controlsSpec.clone();
        }
    }

    public CRMFParameterSpec(BigInteger bigInteger, CertTemplateSpec certTemplateSpec, ProofOfPossessionSpec proofOfPossessionSpec, RegInfoSpec regInfoSpec) {
        this(bigInteger, certTemplateSpec, proofOfPossessionSpec);
        if (regInfoSpec != null) {
            this.d = (RegInfoSpec)regInfoSpec.clone();
        }
    }

    public CRMFParameterSpec(BigInteger bigInteger, CertTemplateSpec certTemplateSpec, ProofOfPossessionSpec proofOfPossessionSpec, ControlsSpec controlsSpec) {
        this(bigInteger, certTemplateSpec, proofOfPossessionSpec);
        if (controlsSpec != null) {
            this.e = (ControlsSpec)controlsSpec.clone();
        }
    }

    public CRMFParameterSpec(BigInteger bigInteger, CertTemplateSpec certTemplateSpec, RegInfoSpec regInfoSpec, ControlsSpec controlsSpec) {
        this(bigInteger, certTemplateSpec, regInfoSpec);
        if (controlsSpec != null) {
            this.e = (ControlsSpec)controlsSpec.clone();
        }
    }

    public CRMFParameterSpec(BigInteger bigInteger, CertTemplateSpec certTemplateSpec, ProofOfPossessionSpec proofOfPossessionSpec, RegInfoSpec regInfoSpec, ControlsSpec controlsSpec) {
        this(bigInteger, certTemplateSpec, proofOfPossessionSpec, regInfoSpec);
        if (controlsSpec != null) {
            this.e = (ControlsSpec)controlsSpec.clone();
        }
    }

    public BigInteger getCertReqId() {
        return this.b;
    }

    public CertTemplateSpec getCertTemplate() {
        return (CertTemplateSpec)this.c.clone();
    }

    public RegInfoSpec getRegInfo() {
        return this.d == null ? null : (RegInfoSpec)this.d.clone();
    }

    public ControlsSpec getControls() {
        return this.e == null ? null : (ControlsSpec)this.e.clone();
    }

    public ProofOfPossessionSpec getPOP() {
        return this.f;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CRMFParameterSpec)) {
            return false;
        }
        CRMFParameterSpec cRMFParameterSpec = (CRMFParameterSpec)object;
        return this.b.equals(cRMFParameterSpec.b) && (this.c == null ? cRMFParameterSpec.c == null : this.c.equals(cRMFParameterSpec.c)) && (this.e == null ? cRMFParameterSpec.e == null : this.e.equals(cRMFParameterSpec.e)) && (this.d == null ? cRMFParameterSpec.d == null : this.d.equals(cRMFParameterSpec.d)) && (this.f == null ? cRMFParameterSpec.f == null : this.f.equals(cRMFParameterSpec.f));
    }

    public int hashCode() {
        int n2 = 7;
        n2 = dg.a(n2, this.b);
        n2 = dg.a(n2, this.c);
        n2 = dg.a(n2, this.d);
        n2 = dg.a(n2, this.e);
        n2 = dg.a(n2, this.f);
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CRMFParameterSpec: [ ").append(dp.a);
        stringBuffer.append("reqID: ").append(this.b).append(dp.a);
        stringBuffer.append("template: ").append(this.c).append(dp.a);
        if (this.e != null) {
            stringBuffer.append("controls: ").append(this.e).append(dp.a);
        }
        if (this.f != null) {
            stringBuffer.append("pop: ").append(this.f).append(dp.a);
        }
        if (this.d != null) {
            stringBuffer.append("regInfo: ").append(this.d).append(dp.a);
        }
        return stringBuffer.toString();
    }
}

