/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cert.crmf;

import com.rsa.cryptoj.o.a;
import com.rsa.cryptoj.o.b;
import com.rsa.cryptoj.o.dc;
import com.rsa.cryptoj.o.dg;
import com.rsa.cryptoj.o.dp;
import com.rsa.jsafe.cert.InvalidEncodingException;
import com.rsa.jsafe.cert.crmf.CertTemplateSpec;
import com.rsa.jsafe.cert.crmf.ControlsSpec;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class RegInfoSpec
implements Cloneable {
    private static final String a = "Names must be a non-null, non-empty string and must not start with a numeric character.";
    private BigInteger b;
    private Map<String, String> c;
    private CertTemplateSpec d;
    private ControlsSpec e;
    private List<byte[]> f;
    private static final Pattern g = Pattern.compile("^[0-9].*");

    public void setNameValuePairs(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            throw new IllegalArgumentException("Expected non-null, non-empty nameValuePairs Map");
        }
        for (String string : map.keySet()) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException(a);
            }
            if (!g.matcher(string).matches()) continue;
            throw new IllegalArgumentException(a);
        }
        this.c = Collections.unmodifiableMap(new LinkedHashMap<String, String>(map));
    }

    public void setCertRequest(BigInteger bigInteger, CertTemplateSpec certTemplateSpec, ControlsSpec controlsSpec) {
        if (bigInteger == null || certTemplateSpec == null) {
            throw new IllegalArgumentException("Input reqId and newTemplate cannot be null");
        }
        this.b = bigInteger;
        this.d = (CertTemplateSpec)certTemplateSpec.clone();
        if (controlsSpec != null) {
            this.e = (ControlsSpec)controlsSpec.clone();
        }
    }

    public void addOtherRegInfo(byte[] byArray) throws InvalidEncodingException {
        try {
            com.rsa.cryptoj.o.a.a("AttributeTypeAndValue", byArray, 0);
        }
        catch (b b2) {
            throw new InvalidEncodingException("Invalid control encoding.");
        }
        if (this.f == null) {
            this.f = new ArrayList<byte[]>();
        }
        this.f.add(dc.a(byArray));
    }

    public Map<String, String> getNameValuePairs() {
        if (this.c == null) {
            return null;
        }
        return this.c;
    }

    public BigInteger getCertRequestID() {
        return this.b;
    }

    public CertTemplateSpec getCertRequestTemplate() {
        if (this.d != null) {
            return (CertTemplateSpec)this.d.clone();
        }
        return null;
    }

    public ControlsSpec getCertRequestControls() {
        if (this.e != null) {
            return (ControlsSpec)this.e.clone();
        }
        return null;
    }

    public List<byte[]> getOtherRegInfos() {
        return dc.a(this.f);
    }

    public int hashCode() {
        int n2 = 7;
        n2 = dg.a(n2, this.b);
        n2 = dg.a(n2, this.d);
        n2 = dg.a(n2, this.e);
        n2 = dg.a(n2, this.f);
        n2 = dg.a(n2, this.c);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegInfoSpec)) {
            return false;
        }
        RegInfoSpec regInfoSpec = (RegInfoSpec)object;
        return this.b == null ? regInfoSpec.b == null : (this.b.equals(regInfoSpec.b) && this.d == null ? regInfoSpec.d == null : (this.d.equals(regInfoSpec.d) && this.e == null ? regInfoSpec.e == null : (this.e.equals(regInfoSpec.e) && this.f == null ? regInfoSpec.f == null : (dp.b(this.f, regInfoSpec.f) && this.c == null ? regInfoSpec.c == null : this.c.equals(regInfoSpec.c)))));
    }

    public Object clone() {
        RegInfoSpec regInfoSpec;
        try {
            regInfoSpec = (RegInfoSpec)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Could not clone object.");
        }
        if (this.c != null) {
            regInfoSpec.c = new HashMap<String, String>(this.c);
        }
        if (regInfoSpec.d != null) {
            regInfoSpec.d = (CertTemplateSpec)this.d.clone();
        }
        if (regInfoSpec.e != null) {
            regInfoSpec.e = (ControlsSpec)this.e.clone();
        }
        return regInfoSpec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RegInfoSpec [").append(dp.a);
        if (this.c != null) {
            stringBuffer.append("nameValuePairs: [").append(dp.a);
            for (Map.Entry<String, String> object : this.c.entrySet()) {
                stringBuffer.append(object.getKey()).append(" -> ").append(object.getValue()).append(dp.a);
            }
            stringBuffer.append("]").append(dp.a);
        }
        if (this.b != null) {
            stringBuffer.append("certReq: [").append(dp.a);
            stringBuffer.append("reqId: ").append(this.b).append(dp.a);
            stringBuffer.append("template: ").append(this.d).append(dp.a);
            if (this.e != null) {
                stringBuffer.append("controls : ").append(this.e).append(dp.a);
            }
            stringBuffer.append("]").append(dp.a);
        }
        if (this.f != null) {
            stringBuffer.append("otherRegInfo: [").append(dp.a);
            for (byte[] byArray : this.f) {
                stringBuffer.append("encoding = ").append(dp.a(byArray)).append(dp.a);
            }
            stringBuffer.append("]").append(dp.a);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

