/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.cms;

import com.rsa.cryptoj.o.jb;
import com.rsa.cryptoj.o.jc;
import com.rsa.cryptoj.o.je;
import com.rsa.cryptoj.o.jl;
import com.rsa.cryptoj.o.js;
import com.rsa.jsafe.cert.Attribute;
import com.rsa.jsafe.cms.CMSException;
import com.rsa.jsafe.cms.KekRecipientInfo;
import com.rsa.jsafe.cms.KeyAgreeRecipientInfo;
import com.rsa.jsafe.cms.KeyTransRecipientInfo;
import com.rsa.jsafe.cms.PasswordRecipientInfo;
import com.rsa.jsafe.cms.SignerInfo;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.SecretKey;

public final class InfoObjectFactory {
    public static final String ENCRYPTION_RSA = "RSA";
    public static final String ENCRYPTION_RSAOAEP = "RSA/ECB/OAEPWithSHA1andMGF1Padding";
    public static final String ENCRYPTION_RSAOAEP_SHA256 = "RSA/ECB/OAEPWithSHA256AndMGF1Padding";
    public static final String ENCRYPTION_RSAOAEP_SHA512 = "RSA/ECB/OAEPWithSHA512AndMGF1Padding";
    public static final String KDF_PBKDF2WITHSHA1 = "PBKDF2withSHA1";
    public static final String KDF_PBKDF2WITHSHA224 = "PBKDF2withSHA224";
    public static final String KDF_PBKDF2WITHSHA256 = "PBKDF2withSHA256";
    public static final String KDF_PBKDF2WITHSHA384 = "PBKDF2withSHA384";
    public static final String KDF_PBKDF2WITHSHA512 = "PBKDF2withSHA512";
    public static final String KDF_PBKDF2WITHSHA512_224 = "PBKDF2withSHA512-224";
    public static final String KDF_PBKDF2WITHSHA512_256 = "PBKDF2withSHA512-256";
    public static final String KEYAGREE_ECDH = "ECDH";
    public static final String KEYAGREE_DH = "DH";
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final String DIGEST_SHA512_224 = "SHA512-224";
    public static final String DIGEST_SHA512_256 = "SHA512-256";
    public static final String SIGNATURE_SHA1_WITH_RSAPSS = "SHA1withRSAPSS";
    public static final String SIGNATURE_SHA224_WITH_RSAPSS = "SHA224withRSAPSS";
    public static final String SIGNATURE_SHA256WITH_RSASAPSS = "SHA256withRSAPSS";
    public static final String SIGNATURE_SHA384_WITH_RSAPSS = "SHA384withRSAPSS";
    public static final String SIGNATURE_SHA512_WITH_RSAPSS = "SHA512withRSAPSS";
    public static final String SIGNATURE_SHA512_224_WITH_RSAPSS = "SHA512-224withRSAPSS";
    public static final String SIGNATURE_SHA512_256_WITH_RSAPSS = "SHA512-256withRSAPSS";

    private InfoObjectFactory() {
    }

    public static KeyTransRecipientInfo newKeyTransRecipientInfo(X509Certificate x509Certificate, String string) throws CMSException {
        return new je(x509Certificate, string);
    }

    public static PasswordRecipientInfo newPasswordRecipientInfo(char[] cArray) throws CMSException {
        return new jl(cArray, KDF_PBKDF2WITHSHA256, 100000);
    }

    public static PasswordRecipientInfo newPasswordRecipientInfo(char[] cArray, String string, int n2) throws CMSException {
        return new jl(cArray, string, n2);
    }

    public static KekRecipientInfo newKekRecipientInfo(byte[] byArray, SecretKey secretKey) throws CMSException {
        return new jb(byArray, secretKey);
    }

    public static KekRecipientInfo newKekRecipientInfo(byte[] byArray, SecretKey secretKey, Date date) throws CMSException {
        return new jb(byArray, secretKey, date);
    }

    public static KekRecipientInfo newKekRecipientInfo(byte[] byArray, SecretKey secretKey, Date date, String string, byte[] byArray2) throws CMSException {
        return new jb(byArray, secretKey, date, string, byArray2);
    }

    public static KeyAgreeRecipientInfo newKeyAgreeRecipientInfo(X509Certificate x509Certificate, PrivateKey privateKey, X509Certificate x509Certificate2) throws CMSException {
        return new jc(x509Certificate, privateKey, x509Certificate2);
    }

    public static KeyAgreeRecipientInfo newKeyAgreeRecipientInfo(X509Certificate x509Certificate) throws CMSException {
        return new jc(x509Certificate);
    }

    public static KeyAgreeRecipientInfo newKeyAgreeRecipientInfo(PublicKey publicKey, PrivateKey privateKey, X509Certificate x509Certificate) throws CMSException {
        return new jc(publicKey, privateKey, x509Certificate);
    }

    public static SignerInfo newSignerInfo(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws CMSException {
        return new js(privateKey, x509Certificate, string, null, null);
    }

    public static SignerInfo newSignerInfo(PrivateKey privateKey, X509Certificate x509Certificate, String string, Attribute[] attributeArray, Attribute[] attributeArray2) throws CMSException {
        return new js(privateKey, x509Certificate, string, attributeArray, attributeArray2);
    }

    public static SignerInfo newSignerInfo(PrivateKey privateKey, X509Certificate x509Certificate, String string, Attribute[] attributeArray, Attribute[] attributeArray2, Provider provider) throws CMSException {
        return new js(privateKey, x509Certificate, string, attributeArray, attributeArray2, provider);
    }
}

