/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.crypto;

import com.rsa.crypto.CryptoException;
import com.rsa.cryptoj.o.bi;
import com.rsa.cryptoj.o.bv;
import com.rsa.cryptoj.o.bx;
import com.rsa.cryptoj.o.ca;
import com.rsa.cryptoj.o.ce;
import com.rsa.cryptoj.o.cf;
import com.rsa.cryptoj.o.cl;
import com.rsa.cryptoj.o.co;
import com.rsa.cryptoj.o.cr;
import com.rsa.cryptoj.o.dc;
import com.rsa.cryptoj.o.dn;
import com.rsa.cryptoj.o.dr;
import com.rsa.cryptoj.o.ke;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.crypto.FIPS140SecurityLevel;
import com.rsa.jsafe.crypto.JSAFE_InvalidUseException;
import com.rsa.jsafe.provider.Assurance;
import com.rsa.jsafe.provider.JsafeJCE;
import com.rsa.jsafe.security.spec.DSADomainParameterGenerationSpec;
import java.io.File;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Calendar;

public final class CryptoJ {
    private static final String a = "Method only available for FIPS140 compliant jar.";
    private static final String b = "Can't change the user role in a non-FIPS140 toolkit";
    private static final String c = "Can't change the mode in a non-FIPS140 toolkit";
    public static final String CRYPTO_J_VERSION = dr.a();
    public static final int NOT_INITIALIZED = 0;
    public static final int UNDER_SELF_TEST = 1;
    public static final int OPERATIONAL = 2;
    public static final int FAILED = 3;
    public static final int FIPS140_MODE = 0;
    public static final int NON_FIPS140_MODE = 1;
    public static final int FIPS140_SSL_MODE = 2;
    public static final int FIPS140_ECC_MODE = 0;
    public static final int FIPS140_SSL_ECC_MODE = 2;
    public static final int CRYPTO_OFFICER_ROLE = 10;
    public static final int USER_ROLE = 11;
    public static final int CRYPTO_OFFICER_ROLE_PIN_POS = 0;
    public static final int USER_ROLE_PIN_POS = 1;
    private static byte[][] d;

    private CryptoJ() {
    }

    public static FIPS140Context getFIPS140Context() {
        return new FIPS140Context(ce.a());
    }

    public static SecureRandom getSeeder() {
        return bv.a();
    }

    public static void setSeeder(SecureRandom secureRandom, boolean bl2) {
        bv.a(secureRandom, bl2);
    }

    public static void setSeeder(SecureRandom secureRandom) {
        CryptoJ.setSeeder(secureRandom, true);
    }

    public static SecureRandom getDefaultRandom() {
        return CryptoJ.getDefaultRandom(null);
    }

    public static SecureRandom getDefaultRandom(FIPS140Context fIPS140Context) {
        if (!(co.i() != 2 || fIPS140Context != null && fIPS140Context.isUserRole())) {
            throw new SecurityException("For FIPS140 Security Level 2 context must be in user role.");
        }
        cf cf2 = fIPS140Context == null ? ce.a() : fIPS140Context.ctx();
        return ke.a(cf2);
    }

    public static boolean isNativeAvailable(String string) {
        return co.n();
    }

    public static boolean isNativeAvailable() {
        return co.n();
    }

    public static boolean isFIPS140Compliant() {
        return co.f();
    }

    public static boolean isAndroid() {
        return co.e();
    }

    public static int getState() {
        try {
            CryptoJ.runSelfTests();
        }
        catch (JSAFE_InvalidUseException jSAFE_InvalidUseException) {
            // empty catch block
        }
        return cr.a();
    }

    public static boolean inJCEStaticInitialization() {
        return cr.b();
    }

    public static int getMode() {
        return ce.a().c();
    }

    public static void setMode(int n2) throws JSAFE_InvalidUseException {
        if (!CryptoJ.isFIPS140Compliant()) {
            throw new JSAFE_InvalidUseException(c);
        }
        try {
            if (ce.a().c() == n2) {
                return;
            }
            ce.a(cf.a(n2, ce.a().d()));
        }
        catch (SecurityException securityException) {
            throw new JSAFE_InvalidUseException(securityException);
        }
    }

    public static int getRole() {
        return ce.a().d();
    }

    public static void setRole(int n2) throws JSAFE_InvalidUseException {
        if (!CryptoJ.isFIPS140Compliant()) {
            throw new JSAFE_InvalidUseException(b);
        }
        try {
            if (ce.a().d() == n2) {
                return;
            }
            ce.a(cf.a(ce.a().c(), n2));
        }
        catch (SecurityException securityException) {
            throw new JSAFE_InvalidUseException(securityException);
        }
    }

    public static void disableLibrary() {
    }

    public static void disableLibrary(FIPS140Context fIPS140Context) {
    }

    public static boolean selfTestPassed() {
        cl.a(ce.a(), ca.a);
        return true;
    }

    public static boolean runSelfTests() throws JSAFE_InvalidUseException {
        if (!co.f()) {
            throw new JSAFE_InvalidUseException(a);
        }
        cl.a(ce.a(), ca.a);
        return true;
    }

    public static boolean runSelfTests(FIPS140Context fIPS140Context) throws JSAFE_InvalidUseException {
        if (!co.f()) {
            throw new JSAFE_InvalidUseException(a);
        }
        cl.a(fIPS140Context.ctx(), ca.a);
        return true;
    }

    public static boolean isInFIPS140Mode() {
        return ce.a().e();
    }

    public static boolean isInSSLMode() {
        return ce.a().f();
    }

    public static boolean isInECCMode() {
        return ce.a().g();
    }

    public static boolean notInFIPS140Mode() {
        return ce.a().h();
    }

    public static void checkIntegrity() {
    }

    public static FIPS140SecurityLevel getFIPS140SecurityLevel() {
        return FIPS140SecurityLevel.a();
    }

    public static boolean isFIPS140SecurityLevelOne() {
        return co.i() == 1;
    }

    public static boolean isFIPS140SecurityLevelTwo() {
        return co.i() == 2;
    }

    public static byte[][] initFIPS140RolePINs() throws JSAFE_InvalidUseException {
        try {
            return bx.a(null, null, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
        catch (bi bi2) {
            throw new JSAFE_InvalidUseException(bi2.getMessage());
        }
    }

    public static byte[][] initFIPS140RolePINs(Calendar calendar, Calendar calendar2) throws JSAFE_InvalidUseException {
        try {
            return bx.a(calendar, calendar2, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[][] initFIPS140RolePINs(File file) throws JSAFE_InvalidUseException {
        try {
            return bx.a(null, null, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[][] initFIPS140RolePINs(Calendar calendar, Calendar calendar2, File file) throws JSAFE_InvalidUseException {
        try {
            return bx.a(calendar, calendar2, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[] resetFIPS140RolePIN(byte[] byArray, int n2) throws JSAFE_InvalidUseException {
        try {
            return bx.a(byArray, n2, null, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[] resetFIPS140RolePIN(byte[] byArray, int n2, Calendar calendar) throws JSAFE_InvalidUseException {
        try {
            return bx.a(byArray, n2, calendar, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[] resetFIPS140RolePIN(byte[] byArray, int n2, File file) throws JSAFE_InvalidUseException {
        try {
            return bx.a(byArray, n2, null, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static byte[] resetFIPS140RolePIN(byte[] byArray, int n2, Calendar calendar, File file) throws JSAFE_InvalidUseException {
        try {
            return bx.a(byArray, n2, calendar, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static void setFIPS140RolePIN(byte[] byArray, int n2, byte[] byArray2) throws JSAFE_InvalidUseException {
        try {
            bx.a(byArray, n2, byArray2, null, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static void setFIPS140RolePIN(byte[] byArray, int n2, byte[] byArray2, Calendar calendar) throws JSAFE_InvalidUseException {
        try {
            bx.a(byArray, n2, byArray2, calendar, null);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static void setFIPS140RolePIN(byte[] byArray, int n2, byte[] byArray2, File file) throws JSAFE_InvalidUseException {
        try {
            bx.a(byArray, n2, byArray2, null, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static void setFIPS140RolePIN(byte[] byArray, int n2, byte[] byArray2, Calendar calendar, File file) throws JSAFE_InvalidUseException {
        try {
            bx.a(byArray, n2, byArray2, calendar, file);
        }
        catch (CryptoException cryptoException) {
            throw new JSAFE_InvalidUseException(cryptoException.getMessage());
        }
    }

    public static String getFIPS140ModuleName() {
        return "RSA BSAFE Crypto-J JSAFE and JCE Software Module";
    }

    public static void fips186RandomClearQ(SecureRandom secureRandom) {
    }

    public static void fips186RandomSetQ(SecureRandom secureRandom, byte[] byArray) {
    }

    public static void setX931TestResult(byte[][] byArray) {
        d = new byte[byArray.length][];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            CryptoJ.d[i2] = dc.a(byArray[i2]);
        }
    }

    public static byte[][] getX931TestResult() {
        if (d == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[d.length][];
        for (int i2 = 0; i2 < d.length; ++i2) {
            if (d == null) continue;
            byArrayArray[i2] = dc.a(d[i2]);
            dn.a.a(d[i2]);
            CryptoJ.d[i2] = null;
        }
        d = null;
        return byArrayArray;
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n3) {
        return CryptoJ.verifyPQGParams(byArray, byArray2, n2, byArray3, byArray4, byArray5, n3, null);
    }

    public static boolean verifyPQGParams(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n3, FIPS140Context fIPS140Context) {
        BigInteger bigInteger = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = new BigInteger(1, byArray3);
        BigInteger bigInteger3 = new BigInteger(1, byArray4);
        BigInteger bigInteger4 = byArray5 == null ? null : new BigInteger(1, byArray5);
        DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec = new DSADomainParameterGenerationSpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, byArray, n3);
        return Assurance.verifyDSAParameters((DSADomainParameterGenerationSpec)dSADomainParameterGenerationSpec, (String)"SHA1", (int)2, null, (FIPS140Context)fIPS140Context);
    }

    public static void setDiscardFirstBlockForCRNG(SecureRandom secureRandom, boolean bl2) {
    }

    public static void main(String[] stringArray) {
        JsafeJCE.main((String[])stringArray);
    }
}

