/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.CertJ;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Service;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Date;
import java.util.Vector;

public final class DatabaseService
extends Service {
    public DatabaseService(CertJ certJ) {
        super(certJ);
    }

    public void insertCertificate(Certificate certificate) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).insertCertificate(certificate);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.insertCertificate: no provider is found to handle this method(" + string.substring(1) + ").");
        }
    }

    public void insertCertificates(Certificate[] certificateArray) throws NoServiceException, DatabaseException {
        if (certificateArray == null) {
            throw new DatabaseException("DatabaseService.insertCertificates: certs should not be null.");
        }
        for (int i = 0; i < certificateArray.length; ++i) {
            this.insertCertificate(certificateArray[i]);
        }
    }

    public void insertCRL(CRL cRL) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).insertCRL(cRL);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.insertCRL: no provider is found to handle this method(" + string.substring(1) + ").");
        }
    }

    public void insertCRLs(CRL[] cRLArray) throws NoServiceException, DatabaseException {
        if (cRLArray == null) {
            throw new DatabaseException("DatabaseService.insertCRLs: crls should not be null.");
        }
        for (int i = 0; i < cRLArray.length; ++i) {
            this.insertCRL(cRLArray[i]);
        }
    }

    public void insertPrivateKeyByCertificate(Certificate certificate, JSAFE_PrivateKey jSAFE_PrivateKey) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).insertPrivateKeyByCertificate(certificate, jSAFE_PrivateKey);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.insertPrivateKeyByCertificate: no provider is found to handle this method(" + string.substring(1) + ").");
        }
    }

    public void insertPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).insertPrivateKeyByPublicKey(jSAFE_PublicKey, jSAFE_PrivateKey);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.insertPrivateKeyByPublicKey: no provider is found to handle this method(" + string.substring(1) + ").");
        }
    }

    public int selectCertificateByIssuerAndSerialNumber(X500Name x500Name, byte[] byArray, Vector vector) throws NoServiceException, DatabaseException {
        this.j();
        if (vector == null) {
            throw new DatabaseException("DatabaseService.selectCertificateByIssuerAndSerialNumber: certList should not be null.");
        }
        int n = vector.size();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                int n2 = ((DatabaseInterface)((Object)this.getProviderAt(i))).selectCertificateByIssuerAndSerialNumber(x500Name, byArray, vector);
                bl = false;
                if (n2 <= 0) continue;
                return vector.size() - n;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.selectCertificateByIssuerAndSerialNumber: no provider is found to handle this method(" + string.substring(1) + ").");
        }
        return 0;
    }

    public int selectCertificateBySubject(X500Name x500Name, Vector vector) throws NoServiceException, DatabaseException {
        this.j();
        if (vector == null) {
            throw new DatabaseException("DatabaseService.selectCertificateBySubject: certList should not be null.");
        }
        int n = vector.size();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).selectCertificateBySubject(x500Name, vector);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.selectCertificateBySubject: no provider is found to handle this method(" + string.substring(1) + ").");
        }
        return vector.size() - n;
    }

    public int selectCertificateByExtensions(X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws NoServiceException, DatabaseException {
        this.j();
        if (vector == null) {
            throw new DatabaseException("DatabaseService.selectCertificateByExtensions: certList should not be null.");
        }
        int n = vector.size();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).selectCertificateByExtensions(x500Name, x509V3Extensions, vector);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.selectCertificateByExtensions: no provider is found to handle this method(" + string.substring(1) + ").");
        }
        return vector.size() - n;
    }

    public Certificate firstCertificate() throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                Certificate certificate = ((DatabaseInterface)((Object)this.getProviderAt(i))).firstCertificate();
                bl = false;
                if (certificate == null) continue;
                return certificate;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.firstCertificate: no provider is found to handle this method(" + string.substring(1) + ").");
        }
        return null;
    }

    public Certificate nextCertificate() throws NoServiceException, DatabaseException {
        Certificate certificate;
        this.j();
        int n = this.g();
        if (n < 0) {
            throw new DatabaseException("DatabaseService.nextCertificate: no iterator is set up. Call firstCertificate first.");
        }
        try {
            certificate = ((DatabaseInterface)((Object)this.getProviderAt(n))).nextCertificate();
        }
        catch (NotSupportedException notSupportedException) {
            throw new DatabaseException("DatabaseService.nextCertificate: " + notSupportedException.getMessage());
        }
        if (certificate != null) {
            return certificate;
        }
        for (int i = n + 1; i < this.getProviderCount(); ++i) {
            try {
                certificate = ((DatabaseInterface)((Object)this.getProviderAt(i))).firstCertificate();
                if (certificate == null) continue;
                return certificate;
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasMoreCertificates() throws NoServiceException, DatabaseException {
        this.j();
        int n = this.g();
        if (n < 0) {
            throw new DatabaseException("DatabaseService.hasMoreCertificates: no iterator is set up.");
        }
        boolean bl = false;
        try {
            bl = ((DatabaseInterface)((Object)this.getProviderAt(n))).hasMoreCertificates();
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("DatabaseService.hasMoreCertificates: a provider is found to handle this method.");
        }
        if (bl) {
            return true;
        }
        Certificate certificate = null;
        try {
            certificate = ((DatabaseInterface)((Object)this.getProviderAt(n))).nextCertificate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = n + 1; i < this.getProviderCount(); ++i) {
            DatabaseInterface databaseInterface = (DatabaseInterface)((Object)this.getProviderAt(i));
            try {
                databaseInterface.setupCertificateIterator();
            }
            catch (NotSupportedException notSupportedException) {
                continue;
            }
            catch (DatabaseException databaseException) {
                throw new NoServiceException("DatabaseService.hasMoreCertificates: unable to setup an iterator for a provider(" + databaseException.getMessage() + ").");
            }
            try {
                if (databaseInterface.hasMoreCertificates()) {
                    return true;
                }
                certificate = databaseInterface.nextCertificate();
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                throw new DatabaseException("DatabaseService.hasMoreCertificates: " + notSupportedException.getMessage());
            }
        }
        return false;
    }

    public int selectCRLByIssuerAndTime(X500Name x500Name, Date date, Vector vector) throws NoServiceException, DatabaseException {
        this.j();
        if (vector == null) {
            throw new DatabaseException("DatabaseService.selectCRLByIssuerAndTime: crlList should not be null.");
        }
        Vector vector2 = new Vector();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).selectCRLByIssuerAndTime(x500Name, date, vector2);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.selectCRLByIssuerAndTime: no provider is found to handle this method(" + string.substring(1) + ").");
        }
        Date date2 = new Date(0L);
        X509CRL x509CRL = null;
        for (int i = 0; i < vector2.size(); ++i) {
            X509CRL x509CRL2 = (X509CRL)vector2.elementAt(i);
            Date date3 = x509CRL2.getThisUpdate();
            if (!date3.after(date2)) continue;
            date2 = date3;
            x509CRL = x509CRL2;
        }
        if (x509CRL == null) {
            return 0;
        }
        if (!vector.contains(x509CRL)) {
            vector.addElement(x509CRL);
        }
        return 1;
    }

    public CRL firstCRL() throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                CRL cRL = ((DatabaseInterface)((Object)this.getProviderAt(i))).firstCRL();
                bl = false;
                if (cRL == null) continue;
                return cRL;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.firstCRL: no provider is found to handle this method(" + string.substring(1) + ").");
        }
        return null;
    }

    public CRL nextCRL() throws NoServiceException, DatabaseException {
        CRL cRL;
        this.j();
        int n = this.h();
        if (n < 0) {
            throw new DatabaseException("DatabaseService.nextCRL: no iterator is set up. Call firstCRL first.");
        }
        try {
            cRL = ((DatabaseInterface)((Object)this.getProviderAt(n))).nextCRL();
        }
        catch (NotSupportedException notSupportedException) {
            throw new DatabaseException("DatabaseService.nextCRL: " + notSupportedException.getMessage());
        }
        if (cRL != null) {
            return cRL;
        }
        for (int i = n + 1; i < this.getProviderCount(); ++i) {
            try {
                cRL = ((DatabaseInterface)((Object)this.getProviderAt(i))).firstCRL();
                if (cRL == null) continue;
                return cRL;
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasMoreCRLs() throws NoServiceException, DatabaseException {
        this.j();
        int n = this.h();
        if (n < 0) {
            throw new DatabaseException("DatabaseService.hasMoreCRLs: no iterator is set up.");
        }
        boolean bl = false;
        try {
            bl = ((DatabaseInterface)((Object)this.getProviderAt(n))).hasMoreCRLs();
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("DatabaseService.hasMoreCRLs: a provider is found to handle this method.");
        }
        if (bl) {
            return true;
        }
        CRL cRL = null;
        try {
            cRL = ((DatabaseInterface)((Object)this.getProviderAt(n))).nextCRL();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = n + 1; i < this.getProviderCount(); ++i) {
            DatabaseInterface databaseInterface = (DatabaseInterface)((Object)this.getProviderAt(i));
            try {
                databaseInterface.setupCRLIterator();
            }
            catch (NotSupportedException notSupportedException) {
                continue;
            }
            catch (DatabaseException databaseException) {
                throw new NoServiceException("DatabaseService.hasMoreCRLs: unable to setup an iterator for a provider(" + databaseException.getMessage() + ").");
            }
            try {
                if (databaseInterface.hasMoreCRLs()) {
                    return true;
                }
                cRL = databaseInterface.nextCRL();
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                throw new DatabaseException("DatabaseService.hasMoreCRLs: " + notSupportedException.getMessage());
            }
        }
        return false;
    }

    public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate certificate) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                jSAFE_PrivateKey = ((DatabaseInterface)((Object)this.getProviderAt(i))).selectPrivateKeyByCertificate(certificate);
                bl = false;
                if (jSAFE_PrivateKey == null) continue;
                return jSAFE_PrivateKey;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.selectPrivateKeyByCertificate: no provider is found to handle this method(" + string.substring(1) + ").");
        }
        return null;
    }

    public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                jSAFE_PrivateKey = ((DatabaseInterface)((Object)this.getProviderAt(i))).selectPrivateKeyByPublicKey(jSAFE_PublicKey);
                bl = false;
                if (jSAFE_PrivateKey == null) continue;
                return jSAFE_PrivateKey;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.selectPrivateKeyByPublicKey: no provider is found to handle this method(" + string.substring(1) + ").");
        }
        return null;
    }

    public JSAFE_PrivateKey firstPrivateKey() throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                JSAFE_PrivateKey jSAFE_PrivateKey = ((DatabaseInterface)((Object)this.getProviderAt(i))).firstPrivateKey();
                bl = false;
                if (jSAFE_PrivateKey == null) continue;
                return jSAFE_PrivateKey;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.firstPrivateKey: no provider is found to handle this method(" + string.substring(1) + ").");
        }
        return null;
    }

    public JSAFE_PrivateKey nextPrivateKey() throws NoServiceException, DatabaseException {
        JSAFE_PrivateKey jSAFE_PrivateKey;
        this.j();
        int n = this.i();
        if (n < 0) {
            throw new DatabaseException("DatabaseService.nextPrivateKey: no iterator is set up. Call firstPrivateKey first.");
        }
        try {
            jSAFE_PrivateKey = ((DatabaseInterface)((Object)this.getProviderAt(n))).nextPrivateKey();
        }
        catch (NotSupportedException notSupportedException) {
            throw new DatabaseException("DatabaseService.nextPrivateKey: " + notSupportedException.getMessage());
        }
        if (jSAFE_PrivateKey != null) {
            return jSAFE_PrivateKey;
        }
        for (int i = n + 1; i < this.getProviderCount(); ++i) {
            try {
                jSAFE_PrivateKey = ((DatabaseInterface)((Object)this.getProviderAt(i))).firstPrivateKey();
                if (jSAFE_PrivateKey == null) continue;
                return jSAFE_PrivateKey;
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasMorePrivateKeys() throws NoServiceException, DatabaseException {
        this.j();
        int n = this.i();
        if (n < 0) {
            throw new DatabaseException("DatabaseService.hasMorePrivateKeys: no iterator is set up.");
        }
        boolean bl = false;
        try {
            bl = ((DatabaseInterface)((Object)this.getProviderAt(n))).hasMorePrivateKeys();
        }
        catch (NotSupportedException notSupportedException) {
            throw new NoServiceException("DatabaseService.hasMorePrivateKeys: a provider is found to handle this method.");
        }
        if (bl) {
            return true;
        }
        JSAFE_PrivateKey jSAFE_PrivateKey = null;
        try {
            jSAFE_PrivateKey = ((DatabaseInterface)((Object)this.getProviderAt(n))).nextPrivateKey();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = n + 1; i < this.getProviderCount(); ++i) {
            DatabaseInterface databaseInterface = (DatabaseInterface)((Object)this.getProviderAt(i));
            try {
                databaseInterface.setupPrivateKeyIterator();
            }
            catch (NotSupportedException notSupportedException) {
                continue;
            }
            catch (DatabaseException databaseException) {
                throw new NoServiceException("DatabaseService.hasMorePrivateKeys: unable to setup an iterator for a provider(" + databaseException.getMessage() + ").");
            }
            try {
                if (databaseInterface.hasMorePrivateKeys()) {
                    return true;
                }
                jSAFE_PrivateKey = databaseInterface.nextPrivateKey();
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                throw new DatabaseException("DatabaseService.hasMorePrivateKeys: " + notSupportedException.getMessage());
            }
        }
        return false;
    }

    public void deleteCertificate(X500Name x500Name, byte[] byArray) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).deleteCertificate(x500Name, byArray);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.deleteCertificate: no provider is found to handle this method(" + string.substring(1) + ").");
        }
    }

    public void deleteCRL(X500Name x500Name, Date date) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).deleteCRL(x500Name, date);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.deleteCRL: no provider is found to handle this method(" + string.substring(1) + ").");
        }
    }

    public void deletePrivateKeyByCertificate(Certificate certificate) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).deletePrivateKeyByCertificate(certificate);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.deletePrivateKeyByCertificate: no provider is found to handle this method(" + string.substring(1) + ").");
        }
    }

    public void deletePrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws NoServiceException, DatabaseException {
        this.j();
        boolean bl = true;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).deletePrivateKeyByPublicKey(jSAFE_PublicKey);
                bl = false;
                continue;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.deletePrivateKeyByPublicKey: no provider is found to handle this method(" + string.substring(1) + ").");
        }
    }

    private void a() throws NoServiceException, DatabaseException {
        this.j();
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).setupCertificateIterator();
                return;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
                continue;
            }
        }
        throw new NoServiceException("DatabaseService.setupCertificateIterator: no provider is found to handle this method(" + string.substring(1) + ").");
    }

    private void b() throws NoServiceException, DatabaseException {
        this.j();
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).setupCRLIterator();
                return;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
                continue;
            }
        }
        throw new NoServiceException("DatabaseService.setupCRLIterator: no provider is found to handle this method(" + string.substring(1) + ").");
    }

    private void c() throws NoServiceException, DatabaseException {
        this.j();
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).setupPrivateKeyIterator();
                return;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
                continue;
            }
        }
        throw new NoServiceException("DatabaseService.setupPrivateKeyIterator: no provider is found to handle this method(" + string.substring(1) + ").");
    }

    private boolean d() throws NoServiceException, DatabaseException {
        this.j();
        return this.g() >= 0;
    }

    private boolean e() throws NoServiceException, DatabaseException {
        this.j();
        return this.h() >= 0;
    }

    private boolean f() throws NoServiceException, DatabaseException {
        this.j();
        return this.i() >= 0;
    }

    private int g() throws NoServiceException, DatabaseException {
        boolean bl = true;
        int n = -1;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                boolean bl2 = ((DatabaseInterface)((Object)this.getProviderAt(i))).isCertificateIteratorSetup();
                bl = false;
                if (!bl2) continue;
                n = i;
                break;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.findCurrentCertificateIterator: no provider is found to handle isCertificateIteratorSetup method(" + string.substring(1) + ").");
        }
        return n;
    }

    private int h() throws NoServiceException, DatabaseException {
        boolean bl = true;
        int n = -1;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                boolean bl2 = ((DatabaseInterface)((Object)this.getProviderAt(i))).isCRLIteratorSetup();
                bl = false;
                if (!bl2) continue;
                n = i;
                break;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.findCurrentCRLIterator: no provider is found to handle isCRLIteratorSetup method(" + string.substring(1) + ").");
        }
        return n;
    }

    private int i() throws NoServiceException, DatabaseException {
        boolean bl = true;
        int n = -1;
        String string = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                boolean bl2 = ((DatabaseInterface)((Object)this.getProviderAt(i))).isPrivateKeyIteratorSetup();
                bl = false;
                if (!bl2) continue;
                n = i;
                break;
            }
            catch (NotSupportedException notSupportedException) {
                string = string + "/" + notSupportedException.getMessage();
            }
        }
        if (bl) {
            throw new NoServiceException("DatabaseService.findCurrentPrivateKeyIterator: no provider is found to handle isPrivateKeyIteratorSetup method(" + string.substring(1) + ").");
        }
        return n;
    }

    private void j() throws NoServiceException {
        if (this.getProviderCount() == 0) {
            throw new NoServiceException("DatabaseService.checkForEmptyService: no Database provider is bound to this service. Use CertJ.registerService followed by CertJ.bindService or CertJ.bindServices to obtain a non-empty DatabaseService object.");
        }
    }
}

