/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTCTimeContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509V3Extensions;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public class RevokedCertificates
implements Cloneable,
Serializable {
    private Vector[] a = this.a(3);
    protected static int special;
    private boolean b = false;
    private ASN1Template c = null;

    public RevokedCertificates() {
    }

    public RevokedCertificates(byte[] byArray, int n, int n2) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(n2, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n3 = ofContainer.getContainerCount();
            for (int i = 0; i < n3; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                EncodedContainer encodedContainer = new EncodedContainer(77824);
                IntegerContainer integerContainer = new IntegerContainer(0);
                EncodedContainer encodedContainer2 = new EncodedContainer(65280);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer2, encodedContainer, endContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                byte[] byArray2 = new byte[integerContainer.dataLen];
                System.arraycopy(integerContainer.data, integerContainer.dataOffset, byArray2, 0, integerContainer.dataLen);
                this.a[0].addElement(byArray2);
                if (encodedContainer.dataPresent) {
                    this.a[2].addElement(new X509V3Extensions(encodedContainer.data, encodedContainer.dataOffset, 0, 3));
                } else {
                    this.a[2].addElement(null);
                }
                ChoiceContainer choiceContainer = new ChoiceContainer(0);
                GenTimeContainer genTimeContainer = new GenTimeContainer(65536);
                UTCTimeContainer uTCTimeContainer = new UTCTimeContainer(65536);
                ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{choiceContainer, genTimeContainer, uTCTimeContainer, endContainer};
                ASN1.berDecode((byte[])encodedContainer2.data, (int)encodedContainer2.dataOffset, (ASN1Container[])aSN1ContainerArray3);
                if (genTimeContainer.dataPresent) {
                    this.a[1].addElement(genTimeContainer.theTime);
                    continue;
                }
                if (!uTCTimeContainer.dataPresent) continue;
                this.a[1].addElement(uTCTimeContainer.theTime);
            }
        }
        catch (Exception exception) {
            throw new CertificateException("Cannot decode the BER of Revoked Certificates.");
        }
    }

    private Vector[] a(int n) {
        Vector[] vectorArray = new Vector[n];
        for (int i = 0; i < n; ++i) {
            vectorArray[i] = new Vector();
        }
        return vectorArray;
    }

    public void addRevokedCertificate(byte[] byArray, Date date, X509V3Extensions x509V3Extensions) throws CertificateException {
        if (byArray == null || date == null) {
            throw new CertificateException("Values cannot be NULL.");
        }
        this.a[0].addElement(byArray);
        this.a[1].addElement(date);
        if (x509V3Extensions != null && x509V3Extensions.getExtensionsType() != 3) {
            throw new CertificateException("Wrong extensions type: should be CRLEntry extensions.");
        }
        this.a[2].addElement(x509V3Extensions);
    }

    public byte[] getSerialNumber(int n) throws CertificateException {
        if (n >= this.getCertificateCount()) {
            throw new CertificateException("Invalid index");
        }
        return (byte[])this.a[0].elementAt(n);
    }

    public Date getRevocationDate(int n) throws CertificateException {
        if (n >= this.getCertificateCount()) {
            throw new CertificateException("Invalid index");
        }
        return (Date)this.a[1].elementAt(n);
    }

    public X509V3Extensions getExtensions(int n) throws CertificateException {
        if (n >= this.getCertificateCount()) {
            throw new CertificateException("Invalid index");
        }
        X509V3Extensions x509V3Extensions = (X509V3Extensions)this.a[2].elementAt(n);
        if (x509V3Extensions != null) {
            return x509V3Extensions;
        }
        return null;
    }

    public int getCertificateCount() {
        return this.a[0].size();
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n) throws CertificateException {
        special = n;
        this.b(n);
        try {
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException(aSN_Exception.getMessage());
        }
    }

    public int getDEREncoding(byte[] byArray, int n, int n2, boolean bl) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Specified array is null.");
        }
        try {
            block7: {
                block6: {
                    this.b = bl;
                    if (this.c == null) break block6;
                    if (n2 == special) break block7;
                }
                this.getDERLen(n2);
            }
            int n3 = this.c.derEncode(byArray, n);
            this.c = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.c = null;
            throw new CertificateException("Unable to encode Revoked Certificates.");
        }
    }

    private void b(int n) throws CertificateException {
        Object[] objectArray;
        if (this.c != null) {
            if (n == special) {
                return;
            }
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        try {
            objectArray = new OfContainer(n, 12288, (ASN1Container)new EncodedContainer(12288));
            vector.addElement(objectArray);
            for (int i = 0; i < this.a[0].size(); ++i) {
                EncodedContainer encodedContainer = this.c(i);
                objectArray.addContainer((ASN1Container)encodedContainer);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Can't encode RevokedCerts" + aSN_Exception.getMessage());
        }
        objectArray = new ASN1Container[vector.size()];
        vector.copyInto(objectArray);
        this.c = new ASN1Template((ASN1Container[])objectArray);
    }

    private EncodedContainer c(int n) throws CertificateException {
        EncodedContainer encodedContainer = null;
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer2 = null;
        try {
            Object[] objectArray;
            GenTimeContainer genTimeContainer;
            Object object;
            if (this.a[2].elementAt(n) != null) {
                int n2 = ((X509V3Extensions)this.a[2].elementAt(n)).getDERLen(0);
                object = new byte[n2];
                int n3 = 0;
                int n4 = ((X509V3Extensions)this.a[2].elementAt(n)).getDEREncoding((byte[])object, n3, 0);
                encodedContainer2 = new EncodedContainer(77824, true, 0, object, n3, n4);
            }
            byte[] byArray = (byte[])this.a[0].elementAt(n);
            object = new IntegerContainer(0, true, 0, byArray, 0, byArray.length, true);
            Date date = (Date)this.a[1].elementAt(n);
            ASN1Template aSN1Template = null;
            if (this.b) {
                genTimeContainer = new GenTimeContainer(0, true, 0, date);
                if (encodedContainer2 != null) {
                    objectArray = new ASN1Container[]{sequenceContainer, (ASN1Container)object, genTimeContainer, encodedContainer2, endContainer};
                    aSN1Template = new ASN1Template(objectArray);
                } else {
                    objectArray = new ASN1Container[]{sequenceContainer, (ASN1Container)object, genTimeContainer, endContainer};
                    aSN1Template = new ASN1Template(objectArray);
                }
            } else {
                genTimeContainer = new UTCTimeContainer(0, true, 0, date);
                if (encodedContainer2 != null) {
                    objectArray = new ASN1Container[]{sequenceContainer, (ASN1Container)object, genTimeContainer, encodedContainer2, endContainer};
                    aSN1Template = new ASN1Template(objectArray);
                } else {
                    objectArray = new ASN1Container[]{sequenceContainer, (ASN1Container)object, genTimeContainer, endContainer};
                    aSN1Template = new ASN1Template(objectArray);
                }
            }
            aSN1Template.derEncodeInit();
            int n5 = aSN1Template.derEncodeInit();
            objectArray = new byte[n5];
            n5 = aSN1Template.derEncode((byte[])objectArray, 0);
            encodedContainer = new EncodedContainer(12288, true, 0, (byte[])objectArray, 0, n5);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException(" Can't encode RevokedCertificates");
        }
        return encodedContainer;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RevokedCertificates)) {
            return false;
        }
        RevokedCertificates revokedCertificates = (RevokedCertificates)object;
        int n = this.a.length;
        int n2 = revokedCertificates.a.length;
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = this.a[i].size();
            if (n4 != (n3 = revokedCertificates.a[i].size())) {
                return false;
            }
            for (int j = 0; j < n4; ++j) {
                if (this.a[i].elementAt(j).equals(revokedCertificates.a[i].elementAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        RevokedCertificates revokedCertificates = new RevokedCertificates();
        for (int i = 0; i < this.a.length; ++i) {
            for (int j = 0; j < this.a[i].size(); ++j) {
                revokedCertificates.a[i].addElement(this.a[i].elementAt(j));
            }
        }
        try {
            if (this.c != null) {
                revokedCertificates.b(special);
            }
        }
        catch (CertificateException certificateException) {
            throw new CloneNotSupportedException("Cannot get ASN1 Template");
        }
        return revokedCertificates;
    }
}

