/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

public class Pseudonym
extends X501Attribute
implements Cloneable,
Serializable {
    private String a;
    private int b;
    ASN1Template c;

    public Pseudonym() {
        super(17, "pseudonym");
    }

    public Pseudonym(String string, int n) throws AttributeException {
        this();
        this.setPseudonym(string, n);
    }

    protected void decodeValue(byte[] byArray, int n) throws AttributeException {
        block9: {
            if (byArray == null) {
                throw new AttributeException("Encoding is null.");
            }
            this.reset();
            try {
                SetContainer setContainer = new SetContainer(0);
                EndContainer endContainer = new EndContainer();
                ChoiceContainer choiceContainer = new ChoiceContainer(0);
                PrintStringContainer printStringContainer = new PrintStringContainer(0, 1, -1);
                TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0, 1, -1);
                UniversalStringContainer universalStringContainer = new UniversalStringContainer(0, 1, -1);
                BMPStringContainer bMPStringContainer = new BMPStringContainer(0, 1, -1);
                UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                IA5StringContainer iA5StringContainer = new IA5StringContainer(0, 1, -1);
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, choiceContainer, printStringContainer, teletexStringContainer, universalStringContainer, bMPStringContainer, uTF8StringContainer, iA5StringContainer, endContainer, endContainer};
                ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
                if (printStringContainer.dataPresent) {
                    this.b = 4864;
                    this.a = printStringContainer.getValueAsString();
                    break block9;
                }
                if (teletexStringContainer.dataPresent) {
                    this.b = 5120;
                    this.a = teletexStringContainer.getValueAsString();
                    break block9;
                }
                if (universalStringContainer.dataPresent) {
                    this.b = 7168;
                    this.a = universalStringContainer.getValueAsString();
                    break block9;
                }
                if (bMPStringContainer.dataPresent) {
                    this.b = 7680;
                    this.a = bMPStringContainer.getValueAsString();
                    break block9;
                }
                if (uTF8StringContainer.dataPresent) {
                    this.b = 3072;
                    this.a = this.utf8Decode(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                    break block9;
                }
                if (iA5StringContainer.dataPresent) {
                    this.b = 5632;
                    this.a = iA5StringContainer.getValueAsString();
                    break block9;
                }
                throw new AttributeException("DirectoryString expected.");
            }
            catch (ASN_Exception aSN_Exception) {
                throw new AttributeException("Could not BER decode Pseudonym." + aSN_Exception.getMessage());
            }
        }
    }

    public void setPseudonym(String string, int n) throws AttributeException {
        if (string == null) {
            throw new AttributeException("Pseudonym is null.");
        }
        this.reset();
        this.a = string;
        if (n != 4864 && n != 5120 && n != 7168 && n != 3072 && n != 7680 && n != 5632) {
            throw new AttributeException("Invalid String Type.");
        }
        this.b = n;
    }

    public String getPseudonym() {
        return this.a;
    }

    protected int derEncodeValueInit() {
        this.c = null;
        if (this.a == null) {
            return 0;
        }
        this.special = this.special;
        if (this.b == 0) {
            this.b = 3072;
        }
        try {
            Object[] objectArray;
            EndContainer endContainer = new EndContainer();
            SetContainer setContainer = new SetContainer(0, true, 0);
            ChoiceContainer choiceContainer = new ChoiceContainer(0, 0);
            TeletexStringContainer teletexStringContainer = null;
            switch (this.b) {
                case 5120: {
                    teletexStringContainer = new TeletexStringContainer(0, true, 0, this.a);
                    break;
                }
                case 4864: {
                    teletexStringContainer = new PrintStringContainer(0, true, 0, this.a);
                    break;
                }
                case 7168: {
                    teletexStringContainer = new UniversalStringContainer(0, true, 0, this.a);
                    break;
                }
                case 5632: {
                    teletexStringContainer = new IA5StringContainer(0, true, 0, this.a);
                    break;
                }
                case 3072: {
                    objectArray = this.utf8Encode(this.a);
                    if (objectArray.length < 2) {
                        return 0;
                    }
                    teletexStringContainer = new UTF8StringContainer(0, true, 0, objectArray, 2, objectArray.length - 2);
                    break;
                }
                case 7680: {
                    teletexStringContainer = new BMPStringContainer(0, true, 0, this.a);
                    break;
                }
                default: {
                    return 0;
                }
            }
            objectArray = new ASN1Container[]{setContainer, choiceContainer, teletexStringContainer, endContainer, endContainer};
            this.c = new ASN1Template((ASN1Container[])objectArray);
            return this.c.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.c.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Pseudonym pseudonym = new Pseudonym();
        if (this.a != null) {
            pseudonym.a = this.a;
        }
        pseudonym.b = this.b;
        super.copyValues(pseudonym);
        return pseudonym;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Pseudonym)) {
            return false;
        }
        Pseudonym pseudonym = (Pseudonym)object;
        if (this.a == null) {
            return pseudonym.a == null;
        }
        if (pseudonym.a == null) {
            return false;
        }
        return this.a.equals(pseudonym.a);
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.c = null;
    }
}

