/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.ChallengePassword;
import com.rsa.certj.cert.attributes.ContentType;
import com.rsa.certj.cert.attributes.CountryOfCitizenship;
import com.rsa.certj.cert.attributes.CountryOfResidence;
import com.rsa.certj.cert.attributes.DateOfBirth;
import com.rsa.certj.cert.attributes.FriendlyName;
import com.rsa.certj.cert.attributes.Gender;
import com.rsa.certj.cert.attributes.LocalKeyID;
import com.rsa.certj.cert.attributes.MessageDigest;
import com.rsa.certj.cert.attributes.NonStandardAttribute;
import com.rsa.certj.cert.attributes.PlaceOfBirth;
import com.rsa.certj.cert.attributes.PostalAddress;
import com.rsa.certj.cert.attributes.Pseudonym;
import com.rsa.certj.cert.attributes.SigningTime;
import com.rsa.certj.cert.attributes.V3ExtensionAttribute;
import com.rsa.certj.cert.attributes.VeriSignCRSDualEnrollmentStatus;
import com.rsa.certj.cert.attributes.VeriSignCRSFailureInfo;
import com.rsa.certj.cert.attributes.VeriSignCRSMessageType;
import com.rsa.certj.cert.attributes.VeriSignCRSPKIStatus;
import com.rsa.certj.cert.attributes.VeriSignCRSRecipientNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSSenderNonce;
import com.rsa.certj.cert.attributes.VeriSignCRSTransactionID;
import com.rsa.certj.cert.attributes.VeriSignCRSVersion;
import com.rsa.certj.cert.attributes.VeriSignSmartCSP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class X501Attribute
implements Cloneable,
Serializable {
    public static final int SIGNING_TIME = 0;
    public static final int CHALLENGE_PASSWORD = 1;
    public static final int X509_V3_EXTENSION = 2;
    public static final int FRIENDLY_NAME = 3;
    public static final int LOCAL_KEY_ID = 4;
    public static final int SMART_CSP = 5;
    public static final int CRS_MESSAGE_TYPE = 6;
    public static final int CRS_PKI_STATUS = 7;
    public static final int CRS_FAILURE_INFO = 8;
    public static final int CRS_SENDER_NONCE = 9;
    public static final int CRS_RECIPIENT_NONCE = 10;
    public static final int CRS_TRANSACTION_ID = 11;
    public static final int CRS_VERSION = 12;
    public static final int CRS_DUAL_STATUS = 13;
    public static final int CONTENT_TYPE = 14;
    public static final int MESSAGE_DIGEST = 15;
    public static final int POSTAL_ADDRESS = 16;
    public static final int PSEUDONYM = 17;
    public static final int DATE_OF_BIRTH = 18;
    public static final int PLACE_OF_BIRTH = 19;
    public static final int GENDER = 20;
    public static final int COUNTRY_OF_CITIZENSHIP = 21;
    public static final int COUNTRY_OF_RESIDENCE = 22;
    public static final int NON_STANDARD = 23;
    protected static byte[][] OID_LIST = new byte[][]{{42, -122, 72, -122, -9, 13, 1, 9, 5}, {42, -122, 72, -122, -9, 13, 1, 9, 7}, {42, -122, 72, -122, -9, 13, 1, 9, 14}, {42, -122, 72, -122, -9, 13, 1, 9, 20}, {42, -122, 72, -122, -9, 13, 1, 9, 21}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 1}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 2}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 3}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 4}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 5}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 6}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 7}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 9}, {96, -122, 72, 1, -122, -8, 69, 1, 9, 10}, {42, -122, 72, -122, -9, 13, 1, 9, 3}, {42, -122, 72, -122, -9, 13, 1, 9, 4}, {85, 4, 16}, {85, 4, 65}, {43, 6, 1, 5, 5, 7, 9, 1}, {43, 6, 1, 5, 5, 7, 9, 2}, {43, 6, 1, 5, 5, 7, 9, 3}, {43, 6, 1, 5, 5, 7, 9, 4}, {43, 6, 1, 5, 5, 7, 9, 5}};
    protected int attributeTypeFlag;
    byte[] a;
    protected int special;
    protected ASN1Template asn1Template;
    protected String attributeTypeString;

    protected X501Attribute(int n, String string) {
        this.attributeTypeFlag = n;
        if (n != 23) {
            this.a = new byte[OID_LIST[n].length];
            System.arraycopy(OID_LIST[n], 0, this.a, 0, this.a.length);
        }
        this.attributeTypeString = string;
    }

    public static X501Attribute getInstance(byte[] byArray, int n, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        ASN1Container[] aSN1ContainerArray = X501Attribute.decodeAttribute(byArray, n, n2);
        int n3 = X501Attribute.a(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, aSN1ContainerArray[1].dataLen);
        X501Attribute x501Attribute = null;
        switch (n3) {
            case 0: {
                x501Attribute = new SigningTime();
                break;
            }
            case 1: {
                x501Attribute = new ChallengePassword();
                break;
            }
            case 2: {
                x501Attribute = new V3ExtensionAttribute();
                break;
            }
            case 3: {
                x501Attribute = new FriendlyName();
                break;
            }
            case 4: {
                x501Attribute = new LocalKeyID();
                break;
            }
            case 5: {
                x501Attribute = new VeriSignSmartCSP();
                break;
            }
            case 6: {
                x501Attribute = new VeriSignCRSMessageType();
                break;
            }
            case 7: {
                x501Attribute = new VeriSignCRSPKIStatus();
                break;
            }
            case 8: {
                x501Attribute = new VeriSignCRSFailureInfo();
                break;
            }
            case 9: {
                x501Attribute = new VeriSignCRSSenderNonce();
                break;
            }
            case 10: {
                x501Attribute = new VeriSignCRSRecipientNonce();
                break;
            }
            case 11: {
                x501Attribute = new VeriSignCRSTransactionID();
                break;
            }
            case 12: {
                x501Attribute = new VeriSignCRSVersion();
                break;
            }
            case 13: {
                x501Attribute = new VeriSignCRSDualEnrollmentStatus();
                break;
            }
            case 14: {
                x501Attribute = new ContentType();
                break;
            }
            case 15: {
                x501Attribute = new MessageDigest();
                break;
            }
            case 16: {
                x501Attribute = new PostalAddress();
                break;
            }
            case 17: {
                x501Attribute = new Pseudonym();
                break;
            }
            case 18: {
                x501Attribute = new DateOfBirth();
                break;
            }
            case 19: {
                x501Attribute = new PlaceOfBirth();
                break;
            }
            case 20: {
                x501Attribute = new Gender();
                break;
            }
            case 21: {
                x501Attribute = new CountryOfCitizenship();
                break;
            }
            case 22: {
                x501Attribute = new CountryOfResidence();
                break;
            }
            case 23: {
                x501Attribute = new NonStandardAttribute();
                ((X501Attribute)x501Attribute).a = new byte[aSN1ContainerArray[1].dataLen];
                System.arraycopy(aSN1ContainerArray[1].data, aSN1ContainerArray[1].dataOffset, ((X501Attribute)x501Attribute).a, 0, aSN1ContainerArray[1].dataLen);
            }
        }
        ((X501Attribute)x501Attribute).decodeValue(aSN1ContainerArray[2].data, aSN1ContainerArray[2].dataOffset);
        for (int i = 0; i < aSN1ContainerArray.length; ++i) {
            aSN1ContainerArray[i].clearSensitiveData();
        }
        return x501Attribute;
    }

    protected static ASN1Container[] decodeAttribute(byte[] byArray, int n, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n2);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000);
            EncodedContainer encodedContainer = new EncodedContainer(12544);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            return aSN1ContainerArray;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Cannot read the BER of the attribute.");
        }
    }

    private static int a(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return 23;
        }
        for (int i = 0; i < 23; ++i) {
            int n3;
            if (n2 != OID_LIST[i].length) continue;
            for (n3 = 0; n3 < n2 && (byArray[n3 + n] & 0xFF) == (OID_LIST[i][n3] & 0xFF); ++n3) {
            }
            if (n3 < n2) continue;
            return i;
        }
        return 23;
    }

    public String getAttributeTypeString() {
        return this.attributeTypeString;
    }

    protected abstract void decodeValue(byte[] var1, int var2) throws AttributeException;

    public byte[] getOID() {
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    public boolean compareOID(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        if (byArray.length != this.a.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == this.a[i]) continue;
            return false;
        }
        return true;
    }

    public int getAttributeType() {
        return this.attributeTypeFlag;
    }

    public int getDERLen(int n) {
        return this.derEncodeAttributeLen(n, this.derEncodeValueInit());
    }

    protected abstract int derEncodeValueInit();

    public static int getNextBEROffset(byte[] byArray, int n) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        try {
            return n + ASN1Lengths.determineLength((byte[])byArray, (int)n);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not read the BER encoding.");
        }
    }

    public int getDEREncoding(byte[] byArray, int n, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Passed array is null.");
        }
        return this.derEncodeAttribute(byArray, n, n2);
    }

    public boolean isAttributeType(int n) {
        return n == this.attributeTypeFlag;
    }

    public int derEncodeAttributeLen(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        this.special = n;
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, this.a, 0, this.a.length);
            EncodedContainer encodedContainer = new EncodedContainer(12544, true, 0, null, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            this.asn1Template = new ASN1Template(aSN1ContainerArray);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    protected int derEncodeAttribute(byte[] byArray, int n, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Passed array is null.");
        }
        if ((this.asn1Template == null || this.special != n2) && this.getDERLen(n2) == 0) {
            throw new AttributeException("Could not encode, missing data");
        }
        int n3 = 0;
        try {
            n3 = this.asn1Template.derEncode(byArray, n);
            this.asn1Template = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
        n3 += this.derEncodeValue(byArray, n + n3);
        return n3;
    }

    protected abstract int derEncodeValue(byte[] var1, int var2);

    protected void copyValues(X501Attribute x501Attribute) {
        x501Attribute.special = this.special;
        if (this.asn1Template == null) {
            return;
        }
        x501Attribute.getDERLen(this.special);
    }

    public abstract Object clone() throws CloneNotSupportedException;

    protected void reset() {
        this.asn1Template = null;
        this.special = 0;
    }

    protected byte[] utf8Encode(String string) throws AttributeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new AttributeException("pseudonym.utf8Encode: unable to utf8-encode " + string + "(" + iOException.getMessage() + ").");
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected String utf8Decode(byte[] byArray, int n, int n2) throws AttributeException {
        byte[] byArray2 = new byte[n2 + 2];
        byArray2[0] = (byte)(n2 >> 8 & 0xFF);
        byArray2[1] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray, n, byArray2, 2, n2);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2, 0, byArray2.length);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            return dataInputStream.readUTF();
        }
        catch (IOException iOException) {
            throw new AttributeException("Pseudonym.utf8Decode: " + iOException.getMessage() + ").");
        }
    }

    public void clearSensitiveData() {
        this.reset();
    }
}

