/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.BiometricData;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class BiometricInfo
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private Vector a = new Vector();
    ASN1Template b;

    public BiometricInfo() {
        this.extensionTypeFlag = 124;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.BIO_INFO_OID);
        this.extensionTypeString = "Biometric_Info";
    }

    public BiometricInfo(BiometricData biometricData, boolean bl) {
        this.extensionTypeFlag = 124;
        this.criticality = bl;
        this.setSpecialOID(X509V3Extension.BIO_INFO_OID);
        this.extensionTypeString = "Biometric_Info";
        if (biometricData != null) {
            this.a.addElement(biometricData);
        }
    }

    public void addBioData(BiometricData biometricData) {
        if (biometricData != null) {
            this.a.addElement(biometricData);
        }
    }

    public int getBioDataCount() {
        return this.a.size();
    }

    public BiometricData getBioData(int n) throws CertificateException {
        if (this.a.size() <= n || n < 0) {
            throw new CertificateException("Specified index is invalid.");
        }
        return (BiometricData)this.a.elementAt(n);
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null || n < 0) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n2 = ofContainer.getContainerCount();
            for (int i = 0; i < n2; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                BiometricData biometricData = new BiometricData(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.a.addElement(biometricData);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Cannot decode the BER of this extension." + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new CertificateException("Cannot decode the BER of this etension." + nameException.getMessage());
        }
    }

    public int derEncodeValueInit() {
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = null;
            vector.addElement(ofContainer);
            for (int i = 0; i < this.a.size(); ++i) {
                try {
                    BiometricData biometricData = (BiometricData)this.a.elementAt(i);
                    int n = biometricData.getDERLen(0);
                    byte[] byArray = new byte[n];
                    n = biometricData.getDEREncoding(byArray, 0, 0);
                    encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n);
                    ofContainer.addContainer((ASN1Container)encodedContainer);
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    return 0;
                }
                catch (NameException nameException) {
                    return 0;
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.b = new ASN1Template((ASN1Container[])objectArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.b.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        BiometricInfo biometricInfo = new BiometricInfo();
        for (int i = 0; i < this.a.size(); ++i) {
            biometricInfo.a.addElement(((BiometricData)this.a.elementAt(i)).clone());
        }
        if (this.b != null) {
            biometricInfo.derEncodeValueInit();
        }
        super.copyValues(biometricInfo);
        return biometricInfo;
    }

    protected void reset() {
        super.reset();
        this.a = new Vector();
        this.b = null;
    }
}

