/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class CRLDistributionPoints
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    public static final int REASON_FLAGS_BITS = 7;
    public static final int REASON_FLAGS_MASK = -33554432;
    public static final int UNUSED = Integer.MIN_VALUE;
    public static final int KEY_COMPROMISE = 0x40000000;
    public static final int CA_COMPROMISE = 0x20000000;
    public static final int AFFILIATION_CHANGED = 0x10000000;
    public static final int SUPERSEDED = 0x8000000;
    public static final int CESSATION_OF_OPERATION = 0x4000000;
    public static final int CERTIFICATE_HOLD = 0x2000000;
    private Vector[] a = this.a();
    private static final int b = 0xA10000;
    private static final int c = 0x810001;
    private static final int d = 8454146;
    private static final int e = 0x800000;
    private static final int f = 0x800001;
    ASN1Template g;

    public CRLDistributionPoints() {
        this.extensionTypeFlag = 31;
        this.criticality = false;
        this.setStandardOID(31);
        this.extensionTypeString = "CRLDistributionPoints";
    }

    public CRLDistributionPoints(RDN rDN, int n, GeneralNames generalNames, boolean bl) {
        this.extensionTypeFlag = 31;
        this.criticality = bl;
        this.setStandardOID(31);
        this.a[0].addElement(rDN);
        this.a[1].addElement(new Integer(n));
        this.a[2].addElement(generalNames);
        this.extensionTypeString = "CRLDistributionPoints";
    }

    public CRLDistributionPoints(GeneralNames generalNames, int n, GeneralNames generalNames2, boolean bl) {
        this.extensionTypeFlag = 31;
        this.criticality = bl;
        this.setStandardOID(31);
        this.a[0].addElement(generalNames);
        this.a[1].addElement(new Integer(n));
        this.a[2].addElement(generalNames2);
        this.extensionTypeString = "CRLDistributionPoints";
    }

    private Vector[] a() {
        Vector[] vectorArray = new Vector[3];
        for (int i = 0; i < 3; ++i) {
            vectorArray[i] = new Vector();
        }
        return vectorArray;
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(0, 12288, (ASN1Container)new EncodedContainer(12288));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n2 = ofContainer.getContainerCount();
            for (int i = 0; i < n2; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                SequenceContainer sequenceContainer = new SequenceContainer(0);
                EndContainer endContainer = new EndContainer();
                ChoiceContainer choiceContainer = new ChoiceContainer(0xA10000);
                EncodedContainer encodedContainer = new EncodedContainer(0x803000);
                EncodedContainer encodedContainer2 = new EncodedContainer(8401153);
                BitStringContainer bitStringContainer = new BitStringContainer(0x810001);
                EncodedContainer encodedContainer3 = new EncodedContainer(8466434);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer, encodedContainer2, endContainer, bitStringContainer, encodedContainer3, endContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                if (encodedContainer.dataPresent) {
                    this.a[0].addElement(new GeneralNames(encodedContainer.data, encodedContainer.dataOffset, 0x800000));
                } else if (encodedContainer2.dataPresent) {
                    this.a[0].addElement(new RDN(encodedContainer2.data, encodedContainer2.dataOffset, 0x800001));
                } else {
                    this.a[0].addElement(null);
                }
                if (bitStringContainer.dataPresent) {
                    if (bitStringContainer.dataLen > 4) {
                        throw new CertificateException("Could not decode CRLDistributionPoints extension.");
                    }
                    if (bitStringContainer.dataLen == 0) {
                        this.a[1].addElement(new Integer(0));
                    } else {
                        int n3 = 0;
                        int n4 = bitStringContainer.dataOffset;
                        int n5 = 24;
                        while (n4 < bitStringContainer.dataOffset + bitStringContainer.dataLen) {
                            n3 |= (bitStringContainer.data[n4] & 0xFF) << n5;
                            ++n4;
                            n5 -= 8;
                        }
                        this.a[1].addElement(new Integer(n3 &= 0xFE000000));
                    }
                } else {
                    this.a[1].addElement(new Integer(-1));
                }
                if (encodedContainer3.dataPresent) {
                    this.a[2].addElement(new GeneralNames(encodedContainer3.data, encodedContainer3.dataOffset, 8454146));
                    continue;
                }
                this.a[2].addElement(null);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode CRLDistributionPoints extension.");
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not create new GeneralNames object.");
        }
    }

    public void addDistributionPoints(RDN rDN, int n, GeneralNames generalNames) {
        this.a[0].addElement(rDN);
        if (n == -1) {
            this.a[1].addElement(new Integer(-1));
        } else {
            this.a[1].addElement(new Integer(n &= 0xFE000000));
        }
        this.a[2].addElement(generalNames);
    }

    public void addDistributionPoints(GeneralNames generalNames, int n, GeneralNames generalNames2) {
        this.a[0].addElement(generalNames);
        if (n == -1) {
            this.a[1].addElement(new Integer(-1));
        } else {
            this.a[1].addElement(new Integer(n &= 0xFE000000));
        }
        this.a[2].addElement(generalNames2);
    }

    public Object getDistributionPointName(int n) throws NameException {
        if (this.a[0].size() <= n) {
            throw new NameException("Specified index is invalid.");
        }
        if (this.a[0] == null) {
            return null;
        }
        return this.a[0].elementAt(n);
    }

    public int getReasonFlags(int n) throws NameException {
        if (this.a[1].size() <= n) {
            throw new NameException("Specified index is invalid.");
        }
        Integer n2 = (Integer)this.a[1].elementAt(n);
        return n2;
    }

    public GeneralNames getCRLIssuer(int n) throws NameException {
        if (this.a[2].size() <= n) {
            throw new NameException("Specified index is invalid.");
        }
        return (GeneralNames)this.a[2].elementAt(n);
    }

    public int getDistributionPointCount() {
        return this.a[0].size();
    }

    public int derEncodeValueInit() {
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(0, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
            EndContainer endContainer = new EndContainer();
            vector.addElement(ofContainer);
            for (int i = 0; i < this.a[0].size(); ++i) {
                try {
                    EncodedContainer encodedContainer;
                    Object[] objectArray;
                    int n;
                    int n2 = 0;
                    SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                    ChoiceContainer choiceContainer = null;
                    BitStringContainer bitStringContainer = null;
                    EncodedContainer encodedContainer2 = null;
                    EncodedContainer encodedContainer3 = null;
                    ASN1Template aSN1Template = null;
                    if (this.a[0].elementAt(i) != null) {
                        choiceContainer = new ChoiceContainer(0xA10000, 0);
                        encodedContainer3 = this.a(i);
                        n2 = 1;
                    }
                    if ((n = ((Integer)this.a[1].elementAt(i)).intValue()) != -1) {
                        bitStringContainer = new BitStringContainer(0x810001, true, 0, n, 7, true);
                        n2 = n2 == 0 ? 2 : 3;
                    }
                    if (this.a[2].elementAt(i) != null) {
                        encodedContainer2 = this.b(i);
                        if (n2 == 0) {
                            n2 = 4;
                        } else if (n2 == 1) {
                            n2 = 5;
                        } else if (n2 == 2) {
                            n2 = 6;
                        } else if (n2 == 3) {
                            n2 = 7;
                        }
                    }
                    switch (n2) {
                        case 0: {
                            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, endContainer};
                            aSN1Template = new ASN1Template(aSN1ContainerArray);
                            break;
                        }
                        case 1: {
                            objectArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer3, endContainer, endContainer};
                            aSN1Template = new ASN1Template((ASN1Container[])objectArray);
                            break;
                        }
                        case 2: {
                            encodedContainer = new EncodedContainer[]{sequenceContainer, bitStringContainer, endContainer};
                            aSN1Template = new ASN1Template((ASN1Container[])encodedContainer);
                            break;
                        }
                        case 3: {
                            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer3, endContainer, bitStringContainer, endContainer};
                            aSN1Template = new ASN1Template(aSN1ContainerArray);
                            break;
                        }
                        case 4: {
                            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer2, endContainer};
                            aSN1Template = new ASN1Template(aSN1ContainerArray);
                            break;
                        }
                        case 5: {
                            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer3, endContainer, encodedContainer2, endContainer};
                            aSN1Template = new ASN1Template(aSN1ContainerArray);
                            break;
                        }
                        case 6: {
                            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, bitStringContainer, encodedContainer2, endContainer};
                            aSN1Template = new ASN1Template(aSN1ContainerArray);
                            break;
                        }
                        case 7: {
                            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer3, endContainer, bitStringContainer, encodedContainer2, endContainer};
                            aSN1Template = new ASN1Template(aSN1ContainerArray);
                        }
                    }
                    int n3 = aSN1Template.derEncodeInit();
                    objectArray = new byte[n3];
                    n3 = aSN1Template.derEncode(objectArray, 0);
                    encodedContainer = new EncodedContainer(12288, true, 0, objectArray, 0, n3);
                    ofContainer.addContainer((ASN1Container)encodedContainer);
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    return 0;
                }
                catch (CertificateException certificateException) {
                    return 0;
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.g = new ASN1Template((ASN1Container[])objectArray);
            return this.g.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    private EncodedContainer a(int n) throws CertificateException {
        EncodedContainer encodedContainer = null;
        int n2 = 0;
        byte[] byArray = null;
        try {
            if (this.a[0].elementAt(n) instanceof GeneralNames) {
                n2 = ((GeneralNames)this.a[0].elementAt(n)).getDERLen(0x800000);
                byArray = new byte[n2];
                n2 = ((GeneralNames)this.a[0].elementAt(n)).getDEREncoding(byArray, 0, 0x800000);
                encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n2);
            } else if (this.a[0].elementAt(n) instanceof RDN) {
                n2 = ((RDN)this.a[0].elementAt(n)).getDERLen(0x800001);
                byArray = new byte[n2];
                n2 = ((RDN)this.a[0].elementAt(n)).getDEREncoding(byArray, 0, 0x800001);
                encodedContainer = new EncodedContainer(12544, true, 0, byArray, 0, n2);
            }
            return encodedContainer;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Can't encode DistributionPointNames" + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new CertificateException("Can't encode DistributionPointNames" + nameException.getMessage());
        }
    }

    private EncodedContainer b(int n) throws CertificateException {
        try {
            int n2 = ((GeneralNames)this.a[2].elementAt(n)).getDERLen(8454146);
            byte[] byArray = new byte[n2];
            n2 = ((GeneralNames)this.a[2].elementAt(n)).getDEREncoding(byArray, 0, 8454146);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n2);
            return encodedContainer;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Can't encode cRLIssuer" + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new CertificateException("Can't encode cRLIssuer" + nameException.getMessage());
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.g == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.g.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CRLDistributionPoints cRLDistributionPoints = new CRLDistributionPoints();
        for (int i = 0; i < this.a[0].size(); ++i) {
            if (this.a[0].elementAt(i) == null) {
                cRLDistributionPoints.a[0].addElement(null);
            }
            if (this.a[0].elementAt(i) instanceof GeneralNames) {
                cRLDistributionPoints.a[0].addElement(((GeneralNames)this.a[0].elementAt(i)).clone());
            } else if (this.a[0].elementAt(i) instanceof RDN) {
                cRLDistributionPoints.a[0].addElement(((RDN)this.a[0].elementAt(i)).clone());
            }
            cRLDistributionPoints.a[1].addElement(new Integer((Integer)this.a[1].elementAt(i)));
            if (this.a[2].elementAt(i) == null) {
                cRLDistributionPoints.a[2].addElement(null);
                continue;
            }
            cRLDistributionPoints.a[2].addElement(((GeneralNames)this.a[2].elementAt(i)).clone());
        }
        if (this.g != null) {
            cRLDistributionPoints.derEncodeValueInit();
        }
        super.copyValues(cRLDistributionPoints);
        return cRLDistributionPoints;
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.g = null;
    }
}

