/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.IntegerContainer;
import com.rsa.certj.cert.CRLExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class CRLNumber
extends X509V3Extension
implements Cloneable,
Serializable,
CRLExtension {
    private byte[] a = null;
    ASN1Template b;

    private CRLNumber(boolean bl) {
        this.extensionTypeFlag = 20;
        this.criticality = bl;
        this.setStandardOID(20);
        this.extensionTypeString = "CRLNumber";
    }

    public CRLNumber() {
        this(false);
        this.setCRLNumber(0);
    }

    public CRLNumber(int n, boolean bl) {
        this(bl);
        this.setCRLNumber(n);
    }

    public CRLNumber(byte[] byArray, int n, int n2, boolean bl) {
        this(bl);
        this.setCRLNumber(byArray, n, n2);
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        IntegerContainer integerContainer = new IntegerContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{integerContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.a = new byte[integerContainer.dataLen];
            System.arraycopy(integerContainer.data, integerContainer.dataOffset, this.a, 0, integerContainer.dataLen);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode CRLNumber extension.");
        }
    }

    public void setCRLNumber(int n) {
        this.a = this.intToByteArray(n);
    }

    public void setCRLNumber(byte[] byArray, int n, int n2) {
        this.a = new byte[n2];
        System.arraycopy(byArray, n, this.a, 0, n2);
    }

    public int getCRLNumber() throws CertificateException {
        if (this.a.length > 4) {
            throw new CertificateException("Can not represent integer in 32 bits.");
        }
        return this.byteArrayToInt(this.a);
    }

    public byte[] getCRLNumberAsByteArray() {
        return this.a;
    }

    public int derEncodeValueInit() {
        try {
            IntegerContainer integerContainer = new IntegerContainer(0, true, 0, this.a, 0, this.a.length, true);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{integerContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.b.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CRLNumber cRLNumber = new CRLNumber();
        if (this.a != null) {
            cRLNumber.a = (byte[])this.a.clone();
        }
        if (this.b != null) {
            cRLNumber.derEncodeValueInit();
        }
        super.copyValues(cRLNumber);
        return cRLNumber;
    }

    protected void reset() {
        super.reset();
        this.setCRLNumber(0);
        this.b = null;
    }
}

