/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.GenTimeContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Date;

public class CRLReference
extends X509V3Extension
implements Cloneable,
Serializable,
OCSPSingleExtension {
    private static final int a = 0xA10000;
    ASN1Template b;
    private String c;
    private byte[] d;
    private int e;
    private Date f;

    public CRLReference() {
        this.extensionTypeFlag = 119;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.CRL_REFERENCE_OID);
        this.extensionTypeString = "CRLReference";
        this.c = null;
        this.d = null;
        this.e = 0;
        this.f = null;
    }

    public CRLReference(String string, byte[] byArray, int n, int n2, Date date) {
        this.extensionTypeFlag = 119;
        this.criticality = false;
        this.setSpecialOID(X509V3Extension.CRL_REFERENCE_OID);
        this.extensionTypeString = "CRLReference";
        this.setURL(string);
        this.setCRLTime(date);
        this.setCRLNumber(byArray, n, n2);
    }

    public int derEncodeValueInit() {
        try {
            ASN1Container[] aSN1ContainerArray;
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            IA5StringContainer iA5StringContainer = null;
            IntegerContainer integerContainer = null;
            GenTimeContainer genTimeContainer = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.c != null) {
                iA5StringContainer = new IA5StringContainer(0xA10000, true, 0, this.c);
                bl3 = true;
            }
            if (this.d != null) {
                integerContainer = new IntegerContainer(0xA10001, true, 0, this.d, 0, this.e, true);
                bl2 = true;
            }
            if (this.f != null) {
                genTimeContainer = new GenTimeContainer(10551298, true, 0, this.f);
                bl = true;
            }
            if (bl3 && bl2 && bl) {
                throw new CertificateException("Could not encode CRLReference extension.");
            }
            if (bl3) {
                aSN1ContainerArray = new ASN1Container[]{sequenceContainer, iA5StringContainer, endContainer};
                this.b = new ASN1Template(aSN1ContainerArray);
            }
            if (bl2) {
                aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, endContainer};
                this.b = new ASN1Template(aSN1ContainerArray);
            }
            if (bl) {
                aSN1ContainerArray = new ASN1Container[]{sequenceContainer, genTimeContainer, endContainer};
                this.b = new ASN1Template(aSN1ContainerArray);
            }
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
        catch (CertificateException certificateException) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.b.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0);
            IA5StringContainer iA5StringContainer = new IA5StringContainer(0xA10000);
            IntegerContainer integerContainer = new IntegerContainer(0xA10001);
            GenTimeContainer genTimeContainer = new GenTimeContainer(10551298);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, iA5StringContainer, integerContainer, genTimeContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            if (iA5StringContainer.dataPresent) {
                this.setURL(iA5StringContainer.getValueAsString());
            } else {
                this.c = null;
            }
            if (integerContainer.dataPresent) {
                this.d = new byte[integerContainer.dataLen];
                System.arraycopy(integerContainer.data, integerContainer.dataOffset, this.d, 0, integerContainer.dataLen);
                this.e = integerContainer.dataLen;
            } else {
                this.d = null;
            }
            if (genTimeContainer.dataPresent) {
                this.setCRLTime(genTimeContainer.theTime);
            } else {
                this.f = null;
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode CRLReference extension.");
        }
    }

    public String getURL() {
        return this.c;
    }

    public void setURL(String string) {
        this.c = string == null ? null : new String(string);
    }

    public byte[] getCRLNumber() {
        return this.d;
    }

    public void setCRLNumber(byte[] byArray, int n, int n2) {
        if (this.d == null || n2 == 0) {
            this.d = null;
            this.e = 0;
        } else {
            this.d = new byte[n2];
            System.arraycopy(byArray, n, this.d, 0, n2);
            this.e = n2;
        }
    }

    public Date getCRLTime() {
        return this.f;
    }

    public void setCRLTime(Date date) {
        this.f = date == null ? null : new Date(date.getTime());
    }

    public Object clone() throws CloneNotSupportedException {
        CRLReference cRLReference = new CRLReference();
        if (this.c != null) {
            cRLReference.c = new String(this.c);
        }
        if (this.f != null) {
            cRLReference.f = new Date(this.f.getTime());
        }
        if (this.d != null) {
            cRLReference.e = this.e;
            cRLReference.d = new byte[cRLReference.e];
            System.arraycopy(this.d, 0, cRLReference.d, 0, cRLReference.e);
        }
        if (this.b != null) {
            cRLReference.derEncodeValueInit();
        }
        super.copyValues(cRLReference);
        return cRLReference;
    }
}

