/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;
import java.util.Vector;

public class ExtendedKeyUsage
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    public static byte[] ID_KP_SERVER_AUTH = new byte[]{43, 6, 1, 5, 5, 7, 3, 1};
    public static byte[] ID_KP_CLIENT_AUTH = new byte[]{43, 6, 1, 5, 5, 7, 3, 2};
    public static byte[] ID_KP_CODE_SIGNING = new byte[]{43, 6, 1, 5, 5, 7, 3, 3};
    public static byte[] ID_KP_EMAIL_PROTECTION = new byte[]{43, 6, 1, 5, 5, 7, 3, 4};
    public static byte[] ID_KP_TIME_STAMPING = new byte[]{43, 6, 1, 5, 5, 7, 3, 8};
    public static byte[] ID_KP_OCSP_SIGNING = new byte[]{43, 6, 1, 5, 5, 7, 3, 9};
    private Vector[] a = this.a(3);
    ASN1Template b;

    public ExtendedKeyUsage() {
        this.extensionTypeFlag = 37;
        this.criticality = false;
        this.setStandardOID(37);
        this.extensionTypeString = "ExtendedKeyUsage";
    }

    public ExtendedKeyUsage(byte[] byArray, int n, int n2, boolean bl) {
        this.extensionTypeFlag = 37;
        this.criticality = bl;
        this.setStandardOID(37);
        if (byArray != null && n2 != 0) {
            this.a[0].addElement(byArray);
            this.a[1].addElement(new Integer(n));
            this.a[2].addElement(new Integer(n2));
        }
        this.extensionTypeString = "ExtendedKeyUsage";
    }

    private Vector[] a(int n) {
        Vector[] vectorArray = new Vector[n];
        for (int i = 0; i < n; ++i) {
            vectorArray[i] = new Vector();
        }
        return vectorArray;
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(this.special, 12288, (ASN1Container)new EncodedContainer(1536));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            int n2 = ofContainer.getContainerCount();
            for (int i = 0; i < n2; ++i) {
                ASN1Container aSN1Container = ofContainer.containerAt(i);
                OIDContainer oIDContainer = new OIDContainer(0x1000000);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{oIDContainer};
                ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                this.a[0].addElement(oIDContainer.data);
                this.a[1].addElement(new Integer(oIDContainer.dataOffset));
                this.a[2].addElement(new Integer(oIDContainer.dataLen));
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode Extended Key Usage extension.");
        }
    }

    public void addExtendedKeyUsage(byte[] byArray, int n, int n2) {
        if (byArray != null && n2 != 0) {
            this.a[0].addElement(byArray);
            this.a[1].addElement(new Integer(n));
            this.a[2].addElement(new Integer(n2));
        }
    }

    public byte[] getExtendedKeyUsage(int n) throws CertificateException {
        if (n >= this.a[0].size()) {
            throw new CertificateException(" Invalid Index ");
        }
        if (this.a[0].elementAt(n) != null) {
            Integer n2 = (Integer)this.a[1].elementAt(n);
            Integer n3 = (Integer)this.a[2].elementAt(n);
            byte[] byArray = new byte[n3.intValue()];
            System.arraycopy((byte[])this.a[0].elementAt(n), n2, byArray, 0, n3);
            return byArray;
        }
        return null;
    }

    public int getKeyUsageCount() {
        return this.a[0].size();
    }

    public int derEncodeValueInit() {
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(this.special, true, 0, 12288, (ASN1Container)new EncodedContainer(1536));
            vector.addElement(ofContainer);
            for (int i = 0; i < this.a[0].size(); ++i) {
                try {
                    EncodedContainer encodedContainer = this.b(i);
                    ofContainer.addContainer((ASN1Container)encodedContainer);
                    continue;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.b = new ASN1Template((ASN1Container[])objectArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    private EncodedContainer b(int n) throws NameException {
        try {
            int n2 = (Integer)this.a[1].elementAt(n);
            int n3 = (Integer)this.a[2].elementAt(n);
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, (byte[])this.a[0].elementAt(n), n2, n3);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{oIDContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            int n4 = aSN1Template.derEncodeInit();
            byte[] byArray = new byte[n4];
            n4 = aSN1Template.derEncode(byArray, 0);
            EncodedContainer encodedContainer = new EncodedContainer(1536, true, 0, byArray, 0, n4);
            return encodedContainer;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException(" Can't encode Extended Key Usage");
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.b.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage();
        for (int i = 0; i < this.a.length; ++i) {
            for (int j = 0; j < this.a[i].size(); ++j) {
                extendedKeyUsage.a[i].addElement(this.a[i].elementAt(j));
            }
        }
        if (this.b != null) {
            extendedKeyUsage.derEncodeValueInit();
        }
        super.copyValues(extendedKeyUsage);
        return extendedKeyUsage;
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.b = null;
    }
}

