/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDContainer;
import com.rsa.certj.cert.CRLEntryExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.OCSPSingleExtension;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class HoldInstructionCode
extends X509V3Extension
implements Cloneable,
Serializable,
CRLEntryExtension,
OCSPSingleExtension {
    private byte[] a;
    private int b;
    private int c;
    ASN1Template d;

    public HoldInstructionCode() {
        this.extensionTypeFlag = 23;
        this.criticality = false;
        this.setStandardOID(23);
        this.extensionTypeString = "HoldInstructionCode";
    }

    public HoldInstructionCode(byte[] byArray, int n, int n2, boolean bl) {
        this.extensionTypeFlag = 23;
        this.criticality = bl;
        if (byArray != null && n2 != 0) {
            this.setCode(byArray, n, n2);
        }
        this.setStandardOID(23);
        this.extensionTypeString = "HoldInstructionCode";
    }

    public void setCode(byte[] byArray, int n, int n2) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try {
            OIDContainer oIDContainer = new OIDContainer(0, true, 0, byArray, n, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{oIDContainer};
            this.a = ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
            this.b = 1 + ASN1Lengths.determineLengthLen((byte[])this.a, (int)1);
            this.c = this.a.length - this.b;
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            this.b = 0;
            this.c = 0;
            return;
        }
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        OIDContainer oIDContainer = new OIDContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{oIDContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            throw new CertificateException("Could not decode HoldInstructionCode extension.");
        }
        this.setCode(oIDContainer.data, oIDContainer.dataOffset, oIDContainer.dataLen);
    }

    public byte[] getCode() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.c];
        System.arraycopy(this.a, this.b, byArray, 0, this.c);
        return byArray;
    }

    public int derEncodeValueInit() {
        try {
            OIDContainer oIDContainer = new OIDContainer(0, true, 0, this.a, this.b, this.c);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{oIDContainer};
            this.d = new ASN1Template(aSN1ContainerArray);
            return this.d.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.d == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.d.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        HoldInstructionCode holdInstructionCode = new HoldInstructionCode();
        if (this.a != null) {
            holdInstructionCode.a = (byte[])this.a.clone();
            holdInstructionCode.b = this.b;
            holdInstructionCode.c = this.c;
        }
        super.copyValues(holdInstructionCode);
        return holdInstructionCode;
    }

    protected void reset() {
        super.reset();
        this.a = null;
        this.c = 0;
        this.b = 0;
    }
}

