/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.CertExtension;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.extensions.X509V3Extension;
import java.io.Serializable;

public class PolicyConstraints
extends X509V3Extension
implements Cloneable,
Serializable,
CertExtension {
    private int a = -1;
    private int b = -1;
    ASN1Template c;
    private static final int d = 0x810000;
    private static final int e = 0x810001;

    public PolicyConstraints() {
        this.extensionTypeFlag = 36;
        this.criticality = false;
        this.setStandardOID(36);
        this.extensionTypeString = "PolicyConstraints";
    }

    public PolicyConstraints(int n, int n2, boolean bl) {
        this.extensionTypeFlag = 36;
        this.criticality = bl;
        this.setStandardOID(36);
        this.a = n;
        this.b = n2;
        this.extensionTypeString = "PolicyConstraints";
    }

    public void decodeValue(byte[] byArray, int n) throws CertificateException {
        if (byArray == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = new IntegerContainer(0x810000);
        IntegerContainer integerContainer2 = new IntegerContainer(0x810001);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CertificateException("Could not decode Policy Constraints extension.");
        }
        if (integerContainer.dataPresent) {
            this.a = this.a(integerContainer.data, integerContainer.dataOffset, integerContainer.dataLen);
        }
        if (integerContainer2.dataPresent) {
            this.b = this.a(integerContainer2.data, integerContainer2.dataOffset, integerContainer2.dataLen);
        }
    }

    private int a(byte[] byArray, int n, int n2) throws CertificateException {
        if (byArray == null || n2 == 0) {
            return 0;
        }
        if (n2 > 4) {
            throw new CertificateException("Could not decode AuthorityKeyID extension.");
        }
        int n3 = 0;
        for (int i = n; i < n2 + n; ++i) {
            n3 <<= 8;
            n3 |= byArray[i] & 0xFF;
        }
        return n3;
    }

    public void setExplicitPolicy(int n) {
        this.a = n;
    }

    public void setPolicyMapping(int n) {
        this.b = n;
    }

    public int getExplicitPolicy() {
        return this.a;
    }

    public int getPolicyMapping() {
        return this.b;
    }

    public int derEncodeValueInit() {
        SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
        EndContainer endContainer = new EndContainer();
        IntegerContainer integerContainer = null;
        if (this.a != -1) {
            integerContainer = new IntegerContainer(0x810000, true, 0, this.a);
        }
        IntegerContainer integerContainer2 = null;
        if (this.b != -1) {
            integerContainer2 = new IntegerContainer(0x810001, true, 0, this.b);
        }
        if (integerContainer != null) {
            if (integerContainer2 != null) {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, integerContainer2, endContainer};
                this.c = new ASN1Template(aSN1ContainerArray);
            } else {
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, endContainer};
                this.c = new ASN1Template(aSN1ContainerArray);
            }
        } else if (integerContainer2 != null) {
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer2, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
        } else {
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
        }
        try {
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public int derEncodeValue(byte[] byArray, int n) {
        if (byArray == null) {
            return 0;
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.c.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PolicyConstraints policyConstraints = new PolicyConstraints();
        policyConstraints.a = this.a;
        policyConstraints.b = this.b;
        if (this.c != null) {
            policyConstraints.derEncodeValueInit();
        }
        super.copyValues(policyConstraints);
        return policyConstraints;
    }

    protected void reset() {
        super.reset();
        this.a = 0;
        this.b = 0;
        this.c = null;
    }
}

