/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import java.io.Serializable;

public class NonStandardControl
extends Control
implements Cloneable,
Serializable {
    private byte[] a;
    ASN1Template b;

    public NonStandardControl() {
        this.controlTypeFlag = 6;
        this.controlTypeString = "NonStandardControl";
    }

    public NonStandardControl(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        this.controlTypeFlag = 6;
        if (byArray != null && n2 != 0) {
            ((Control)this).a = new byte[n2];
            System.arraycopy(byArray, n, ((Control)this).a, 0, n2);
        }
        if (byArray2 != null && n4 != 0) {
            this.a = new byte[n4];
            System.arraycopy(byArray2, n3, this.a, 0, n4);
        }
        this.controlTypeString = "NonStandardControl";
    }

    protected void decodeValue(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Non Standard Control encoding is null.");
        }
        this.a = new byte[byArray.length - n];
        System.arraycopy(byArray, n, this.a, 0, byArray.length - n);
    }

    public void setOID(byte[] byArray, int n, int n2) {
        if (byArray != null && n2 != 0) {
            ((Control)this).a = new byte[n2];
            System.arraycopy(byArray, n, ((Control)this).a, 0, n2);
        }
    }

    public void setValue(byte[] byArray, int n, int n2) {
        if (byArray != null && n2 != 0) {
            this.a = new byte[n2];
            System.arraycopy(byArray, n, this.a, 0, n2);
        }
    }

    public byte[] getValue() {
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    protected int derEncodeValueInit() throws CRMFException {
        this.b = null;
        if (this.a == null || ((Control)this).a == null) {
            throw new CRMFException("Values are not set in Non Standard Control.");
        }
        try {
            EncodedContainer encodedContainer = new EncodedContainer(65280, true, 0, this.a, 0, this.a.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{encodedContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode Non Standard Control. " + aSN_Exception.getMessage());
        }
    }

    protected int derEncodeValue(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode Non Standard Control. ");
        }
        int n2 = 0;
        try {
            n2 = this.b.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode Non Standard Control. " + aSN_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        NonStandardControl nonStandardControl = new NonStandardControl();
        if (this.a != null) {
            nonStandardControl.a = (byte[])this.a.clone();
        }
        if (((Control)this).a != null) {
            ((Control)nonStandardControl).a = (byte[])((Control)this).a.clone();
        }
        super.copyValues(nonStandardControl);
        return nonStandardControl;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NonStandardControl)) {
            return false;
        }
        NonStandardControl nonStandardControl = (NonStandardControl)object;
        if (!CertJUtils.byteArraysEqual(this.a, nonStandardControl.a)) {
            return false;
        }
        return CertJUtils.byteArraysEqual(((Control)this).a, ((Control)nonStandardControl).a);
    }
}

