/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.certj.crmf.Control;
import java.io.Serializable;
import java.util.Vector;

public class PKIPublicationInfo
extends Control
implements Cloneable,
Serializable {
    public static final int DONT_PUBLISH = 0;
    public static final int PLEASE_PUBLISH = 1;
    public static final int DONT_CARE = 0;
    public static final int X500 = 1;
    public static final int WEB = 2;
    public static final int LDAP = 3;
    private int a;
    private Vector[] b = this.a(2);
    ASN1Template c;
    private int d = 0;

    public PKIPublicationInfo() {
        this.controlTypeFlag = 2;
        ((Control)this).a = new byte[Control.OID_LIST[2].length];
        System.arraycopy(Control.OID_LIST[2], 0, ((Control)this).a, 0, ((Control)this).a.length);
        this.controlTypeString = "PKIPublicationInfo";
    }

    protected void decodeValue(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("PKIPublicationInfo Encoding is null.");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(this.d);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer = new EncodedContainer(77824);
            IntegerContainer integerContainer = new IntegerContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.a = integerContainer.getValueAsInt();
            if (this.a != 0 && this.a != 1) {
                throw new CRMFException("Invalid action option.");
            }
            if (encodedContainer.dataPresent) {
                OfContainer ofContainer = new OfContainer(65536, 12288, (ASN1Container)new EncodedContainer(12288));
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{ofContainer};
                ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])aSN1ContainerArray2);
                int n2 = ofContainer.getContainerCount();
                for (int i = 0; i < n2; ++i) {
                    ASN1Container aSN1Container = ofContainer.containerAt(i);
                    EncodedContainer encodedContainer2 = new EncodedContainer(130816);
                    IntegerContainer integerContainer2 = new IntegerContainer(0);
                    ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{sequenceContainer, integerContainer2, encodedContainer2, endContainer};
                    ASN1.berDecode((byte[])aSN1Container.data, (int)aSN1Container.dataOffset, (ASN1Container[])aSN1ContainerArray3);
                    if (encodedContainer2.dataPresent) {
                        GeneralName generalName = new GeneralName(encodedContainer2.data, encodedContainer2.dataOffset, 65536);
                        this.b[1].addElement(generalName);
                    } else {
                        this.b[1].addElement(null);
                    }
                    int n3 = integerContainer2.getValueAsInt();
                    if (n3 != 0 && n3 != 1 && n3 != 2 && n3 != 3) {
                        throw new CRMFException("Invalid pubMethod option");
                    }
                    this.b[0].addElement(new Integer(n3));
                }
            }
        }
        catch (Exception exception) {
            throw new CRMFException("Cannot decode PKIPublicationInfo control." + exception.getMessage());
        }
    }

    private Vector[] a(int n) {
        Vector[] vectorArray = new Vector[n];
        for (int i = 0; i < n; ++i) {
            vectorArray[i] = new Vector();
        }
        return vectorArray;
    }

    public void setAction(int n) throws CRMFException {
        if (n != 0 && n != 1) {
            throw new CRMFException("Invalid action option.");
        }
        this.a = n;
    }

    public int getAction() {
        return this.a;
    }

    public void addSinglePubInfo(int n, GeneralName generalName) throws CRMFException {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new CRMFException("Invalid pubMethod option");
        }
        this.b[0].addElement(new Integer(n));
        if (generalName != null) {
            try {
                this.b[1].addElement((GeneralName)generalName.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new CRMFException("Invalid value." + cloneNotSupportedException.getMessage());
            }
        } else {
            this.b[1].addElement(null);
        }
    }

    public int getSinglePubInfoCount() {
        return this.b[0].size();
    }

    public int getPubMethod(int n) throws CRMFException {
        if (n < this.b[0].size()) {
            return (Integer)this.b[0].elementAt(n);
        }
        throw new CRMFException("Invalid index.");
    }

    public GeneralName getPubLocation(int n) throws CRMFException {
        if (n < this.b[1].size()) {
            return (GeneralName)this.b[1].elementAt(n);
        }
        throw new CRMFException("Invalid index.");
    }

    protected int derEncodeValue(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Passed in array is null in PKIPublicationInfo control.");
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control.");
        }
        int n2 = 0;
        try {
            n2 = this.c.derEncode(byArray, n);
            this.asn1Template = null;
            return n2;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control." + aSN_Exception.getMessage());
        }
    }

    protected int derEncodeValueInit() throws CRMFException {
        this.c = null;
        Vector<EncodedContainer> vector = new Vector<EncodedContainer>();
        try {
            SequenceContainer sequenceContainer;
            Object[] objectArray;
            ASN1Container[] aSN1ContainerArray;
            EncodedContainer encodedContainer;
            boolean bl = false;
            int n = 0;
            byte[] byArray = null;
            EndContainer endContainer = new EndContainer();
            int n2 = this.b[0].size();
            if (n2 > 0) {
                bl = true;
                encodedContainer = new OfContainer(this.d, true, 0, 12288, (ASN1Container)new EncodedContainer(12288));
                vector.addElement(encodedContainer);
                for (int i = 0; i < n2; ++i) {
                    boolean bl2 = false;
                    if (this.b[1].elementAt(i) != null) {
                        n = ((GeneralName)this.b[1].elementAt(i)).getDERLen(0);
                        byArray = new byte[n];
                        n = ((GeneralName)this.b[1].elementAt(i)).getDEREncoding(byArray, 0, 0);
                        bl2 = true;
                    }
                    aSN1ContainerArray = new SequenceContainer(0, true, 0);
                    EncodedContainer encodedContainer2 = new EncodedContainer(130816, bl2, 0, byArray, 0, n);
                    IntegerContainer integerContainer = new IntegerContainer(0, true, 0, ((Integer)this.b[0].elementAt(i)).intValue());
                    ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{aSN1ContainerArray, integerContainer, encodedContainer2, endContainer};
                    ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray2);
                    int n3 = aSN1Template.derEncodeInit();
                    byte[] byArray2 = new byte[n3];
                    n3 = aSN1Template.derEncode(byArray2, 0);
                    EncodedContainer encodedContainer3 = new EncodedContainer(12288, true, 0, byArray2, 0, n3);
                    encodedContainer.addContainer((ASN1Container)encodedContainer3);
                }
                objectArray = new ASN1Container[vector.size()];
                vector.copyInto(objectArray);
                sequenceContainer = new ASN1Template((ASN1Container[])objectArray);
                n = sequenceContainer.derEncodeInit();
                byArray = new byte[n];
                n = sequenceContainer.derEncode(byArray, 0);
            }
            encodedContainer = new EncodedContainer(77824, bl, 0, byArray, 0, n);
            objectArray = new IntegerContainer(0, true, 0, this.a);
            sequenceContainer = new SequenceContainer(this.d, true, 0);
            aSN1ContainerArray = new ASN1Container[]{sequenceContainer, objectArray, encodedContainer, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
            return this.c.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control." + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new CRMFException("Cannot encode PKIPublicationInfo control." + nameException.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PKIPublicationInfo pKIPublicationInfo = new PKIPublicationInfo();
        pKIPublicationInfo.a = this.a;
        for (int i = 0; i < this.b.length; ++i) {
            for (int j = 0; j < this.b[i].size(); ++j) {
                pKIPublicationInfo.b[i].addElement(this.b[i].elementAt(j));
            }
        }
        pKIPublicationInfo.d = this.d;
        super.copyValues(pKIPublicationInfo);
        return pKIPublicationInfo;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PKIPublicationInfo)) {
            return false;
        }
        PKIPublicationInfo pKIPublicationInfo = (PKIPublicationInfo)object;
        if (this.a != pKIPublicationInfo.a) {
            return false;
        }
        int n = this.b.length;
        int n2 = pKIPublicationInfo.b.length;
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = this.b[i].size();
            if (n4 != (n3 = pKIPublicationInfo.b[i].size())) {
                return false;
            }
            for (int j = 0; j < n4; ++j) {
                if (this.b[i].elementAt(j) == null) {
                    if (pKIPublicationInfo.b[i].elementAt(j) == null) continue;
                    return false;
                }
                if (pKIPublicationInfo.b[i].elementAt(j) == null) {
                    return false;
                }
                if (this.b[i].elementAt(j).equals(pKIPublicationInfo.b[i].elementAt(j))) continue;
                return false;
            }
        }
        return true;
    }
}

