/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.io.Serializable;

public class POPOSigningKeyInput
implements Cloneable,
Serializable {
    private ASN1Template a = null;
    private byte[] b = null;
    private int c = 0;
    private GeneralName d = null;
    private byte[] e;
    private byte[] f = null;
    private char[] g = null;
    byte[] h = new byte[]{42, -122, 72, -122, -10, 125, 7, 66, 13};
    byte[] i = new byte[]{43, 6, 1, 5, 5, 8, 1, 2};

    public POPOSigningKeyInput() {
    }

    public POPOSigningKeyInput(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("POPOSigningKeyInput Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0x810000);
        ChoiceContainer choiceContainer = new ChoiceContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(0xA0FF00);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        EncodedContainer encodedContainer3 = new EncodedContainer(12288);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer, encodedContainer2, endContainer, encodedContainer3, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("FIRST" + aSN_Exception.getMessage());
        }
        try {
            if (encodedContainer.dataPresent) {
                this.d = new GeneralName(encodedContainer.data, encodedContainer.dataOffset, 0xA00000);
            }
        }
        catch (NameException nameException) {
            throw new CRMFException("NAME " + nameException.getMessage());
        }
        if (encodedContainer2.dataPresent) {
            this.a(encodedContainer2.data, encodedContainer2.dataOffset);
        }
        this.setSubjectPublicKey(encodedContainer3.data, encodedContainer3.dataOffset);
    }

    private void a(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("PKMACValue Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, bitStringContainer, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the PKMACValue." + aSN_Exception.getMessage());
        }
        this.b(encodedContainer.data, encodedContainer.dataOffset);
        this.f = new byte[bitStringContainer.dataLen];
        System.arraycopy(bitStringContainer.data, bitStringContainer.dataOffset, this.f, 0, bitStringContainer.dataLen);
    }

    public boolean verifyPKMACValue() throws CRMFException {
        if (this.g == null) {
            throw new CRMFException("Secret value is not set in POPOSigningKeyInput.");
        }
        if (this.e == null) {
            throw new CRMFException("Public Key is not set in POPOSigningKeyInput.");
        }
        try {
            String string = "PBE/HMAC/SHA1/PKIXPBE-" + this.c;
            JSAFE_MAC jSAFE_MAC = JSAFE_MAC.getInstance((String)string, (String)"Java");
            jSAFE_MAC.setSalt(this.b, 0, this.b.length);
            JSAFE_SecretKey jSAFE_SecretKey = jSAFE_MAC.getBlankKey();
            jSAFE_SecretKey.setPassword(this.g, 0, this.g.length);
            jSAFE_MAC.verifyInit(jSAFE_SecretKey, null);
            jSAFE_MAC.verifyUpdate(this.e, 0, this.e.length);
            boolean bl = jSAFE_MAC.verifyFinal(this.f, 0, this.f.length);
            return bl;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException(jSAFE_Exception.getMessage());
        }
    }

    private void b(byte[] byArray, int n) throws CRMFException {
        String string;
        if (byArray == null) {
            throw new CRMFException("Password-Based MAC algorithm ID Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        OIDContainer oIDContainer = new OIDContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the PKMAC algID." + aSN_Exception.getMessage());
        }
        if (this.h.length != oIDContainer.dataLen) {
            throw new CRMFException("Wrong OID for Password-Based MAC.");
        }
        for (int i = 0; i < oIDContainer.dataLen; ++i) {
            if (this.h[i] == oIDContainer.data[i + oIDContainer.dataOffset]) continue;
            throw new CRMFException("Wrong OID for Password-Based MAC.");
        }
        SequenceContainer sequenceContainer2 = new SequenceContainer(0);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        IntegerContainer integerContainer = new IntegerContainer(0);
        EncodedContainer encodedContainer3 = new EncodedContainer(12288);
        ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, octetStringContainer, encodedContainer2, integerContainer, encodedContainer3, endContainer};
        try {
            ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])aSN1ContainerArray2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
        this.b = new byte[octetStringContainer.dataLen];
        System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.b, 0, octetStringContainer.dataLen);
        try {
            this.c = integerContainer.getValueAsInt();
            string = AlgorithmID.berDecodeAlgID((byte[])encodedContainer2.data, (int)encodedContainer2.dataOffset, (int)10, null);
            if (string == null) {
                throw new CRMFException("Cannot recognize the digest algorithm.");
            }
            if (!string.equals("SHA1")) {
                throw new CRMFException("Digest algorithm SHA1 was expected.");
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
        try {
            string = new SequenceContainer(0);
            EncodedContainer encodedContainer4 = new EncodedContainer(65280);
            OIDContainer oIDContainer2 = new OIDContainer(0);
            ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{string, oIDContainer2, encodedContainer4, endContainer};
            ASN1.berDecode((byte[])encodedContainer3.data, (int)encodedContainer3.dataOffset, (ASN1Container[])aSN1ContainerArray3);
            if (oIDContainer2.dataLen != this.i.length) {
                throw new CRMFException("Wrong HMAC OID.");
            }
            for (int i = 0; i < this.i.length; ++i) {
                if (oIDContainer2.data[i + oIDContainer2.dataOffset] == this.i[i]) continue;
                throw new CRMFException("Wrong HMAC OID.");
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the HMAC algID." + aSN_Exception.getMessage());
        }
    }

    public void setSharedSecret(char[] cArray, int n, int n2) throws CRMFException {
        if (cArray == null || n2 == 0) {
            throw new CRMFException("Shared secret is null in PBMParameter.");
        }
        this.g = new char[cArray.length];
        System.arraycopy(cArray, n, this.g, 0, n2);
    }

    public void setSalt(byte[] byArray, int n, int n2) throws CRMFException {
        if (byArray == null || n2 == 0) {
            throw new CRMFException("The Salt value is null in PBMParameter.");
        }
        this.b = new byte[n2];
        System.arraycopy(byArray, n, this.b, 0, n2);
    }

    public byte[] getSalt() {
        if (this.b == null) {
            return null;
        }
        byte[] byArray = new byte[this.b.length];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        return byArray;
    }

    public int getIterationCount() {
        return this.c;
    }

    public void setIterationCount(int n) {
        this.c = n;
    }

    public GeneralName getSenderName() throws CRMFException {
        if (this.d == null) {
            return null;
        }
        try {
            return (GeneralName)this.d.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException(cloneNotSupportedException.getMessage());
        }
    }

    public void setSenderName(GeneralName generalName) throws CRMFException {
        if (generalName == null) {
            throw new CRMFException("Passed in SenderName is null.");
        }
        try {
            this.d = (GeneralName)generalName.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException(cloneNotSupportedException.getMessage());
        }
    }

    public void setSubjectPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws CRMFException {
        if (jSAFE_PublicKey == null) {
            throw new CRMFException("Public key is null in POPOSigningKeyInput.");
        }
        try {
            String string = null;
            string = jSAFE_PublicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : jSAFE_PublicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] byArray = jSAFE_PublicKey.getKeyData(string);
            this.e = byArray[0];
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not read the public key in POPOSigningKeyInput. " + jSAFE_Exception.getMessage());
        }
    }

    public void setSubjectPublicKey(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Public key encoding is null in POPOSigningKeyInput.");
        }
        JSAFE_PublicKey jSAFE_PublicKey = null;
        try {
            byArray[n] = 48;
            jSAFE_PublicKey = JSAFE_PublicKey.getInstance((byte[])byArray, (int)n, (String)"Java");
            this.setSubjectPublicKey(jSAFE_PublicKey);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not read the public key in POPOSigningKeyInput. " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey() throws CRMFException {
        if (this.e == null) {
            return null;
        }
        try {
            return JSAFE_PublicKey.getInstance((byte[])this.e, (int)0, (String)"Java");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Cannot retrieve the public key in POPOSigningKeyInput: " + jSAFE_Exception.getMessage());
        }
    }

    public byte[] getSubjectPublicKeyBER() {
        if (this.e == null) {
            return null;
        }
        return (byte[])this.e.clone();
    }

    public byte[] getPKMACValue() {
        if (this.f == null) {
            return null;
        }
        byte[] byArray = new byte[this.f.length];
        System.arraycopy(this.f, 0, byArray, 0, this.f.length);
        return byArray;
    }

    private void a() throws CRMFException {
        if (this.g == null) {
            throw new CRMFException("Shared Secret is not set in PKMAC value.");
        }
        if (this.b == null) {
            throw new CRMFException("Salt value is not set in PKMAC value.");
        }
        if (this.e == null) {
            throw new CRMFException("Public Key is not set in PKMAC value.");
        }
        if (this.c == 0) {
            throw new CRMFException("Iteration count is not set in PKMAC value.");
        }
        try {
            String string = "PBE/HMAC/SHA1/PKIXPBE-" + this.c;
            JSAFE_MAC jSAFE_MAC = JSAFE_MAC.getInstance((String)string, (String)"Java");
            jSAFE_MAC.setSalt(this.b, 0, this.b.length);
            JSAFE_SecretKey jSAFE_SecretKey = jSAFE_MAC.getBlankKey();
            jSAFE_SecretKey.setPassword(this.g, 0, this.g.length);
            jSAFE_MAC.macInit(jSAFE_SecretKey, null);
            jSAFE_MAC.macUpdate(this.e, 0, this.e.length);
            this.f = jSAFE_MAC.macFinal();
            jSAFE_MAC.clearSensitiveData();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException(jSAFE_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        POPOSigningKeyInput pOPOSigningKeyInput = new POPOSigningKeyInput();
        pOPOSigningKeyInput.c = this.c;
        if (this.b != null) {
            pOPOSigningKeyInput.b = new byte[this.b.length];
            System.arraycopy(this.b, 0, pOPOSigningKeyInput.b, 0, this.b.length);
        }
        if (this.d != null) {
            pOPOSigningKeyInput.d = (GeneralName)this.d.clone();
        }
        if (this.e != null) {
            pOPOSigningKeyInput.e = new byte[this.e.length];
            System.arraycopy(this.e, 0, pOPOSigningKeyInput.e, 0, this.e.length);
        }
        if (this.f != null) {
            pOPOSigningKeyInput.f = new byte[this.f.length];
            System.arraycopy(this.f, 0, pOPOSigningKeyInput.f, 0, this.f.length);
        }
        if (this.g != null) {
            pOPOSigningKeyInput.g = new char[this.g.length];
            System.arraycopy(this.g, 0, pOPOSigningKeyInput.g, 0, this.g.length);
        }
        try {
            if (this.a != null) {
                pOPOSigningKeyInput.b();
            }
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
        return pOPOSigningKeyInput;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof POPOSigningKeyInput)) {
            return false;
        }
        POPOSigningKeyInput pOPOSigningKeyInput = (POPOSigningKeyInput)object;
        try {
            int n = this.getDERLen();
            int n2 = pOPOSigningKeyInput.getDERLen();
            if (n != n2) {
                return false;
            }
            if (n == 0 || n2 == 0) {
                return false;
            }
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n2];
            n = this.getDEREncoding(byArray, 0);
            if (n != (n2 = pOPOSigningKeyInput.getDEREncoding(byArray2, 0))) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
        }
        catch (CRMFException cRMFException) {
            return false;
        }
        return true;
    }

    public static int getNextBEROffset(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("POPOSigningKeyInput Encoding is null.");
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding." + aSN_Exception.getMessage());
        }
    }

    public int getDERLen() throws CRMFException {
        return this.b();
    }

    public int getDEREncoding(byte[] byArray, int n) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified POPOSigningKeyInput array is null.");
        }
        int n2 = 0;
        try {
            if (this.a == null) {
                this.getDERLen();
            }
            n2 = this.a.derEncode(byArray, n);
            this.a = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            throw new CRMFException("Unable to encode POPOSigningKeyInput." + aSN_Exception.getMessage());
        }
        return n2;
    }

    private int b() throws CRMFException {
        try {
            EncodedContainer encodedContainer;
            EncodedContainer encodedContainer2;
            EncodedContainer encodedContainer3;
            EncodedContainer encodedContainer4;
            ChoiceContainer choiceContainer;
            Object object;
            Object object2;
            boolean bl = true;
            boolean bl2 = true;
            byte[] byArray = null;
            int n = 0;
            byte[] byArray2 = null;
            int n2 = 0;
            if (this.e == null) {
                throw new CRMFException("Public key is not set.");
            }
            if (this.d != null) {
                bl2 = false;
                n = this.d.getDERLen(0xA00000);
                byArray = new byte[n];
                n = this.d.getDEREncoding(byArray, 0, 0xA00000);
            } else {
                bl = false;
                if (this.f == null) {
                    this.a();
                }
                object2 = new byte[this.i.length + 6];
                object2[0] = 48;
                object2[1] = (byte)(this.i.length + 4);
                object2[2] = 6;
                object2[3] = (byte)this.i.length;
                System.arraycopy(this.i, 0, object2, 4, this.i.length);
                object2[this.i.length + 4] = 5;
                object2[this.i.length + 5] = 0;
                object = AlgorithmID.derEncodeAlgID((String)"SHA1", (int)10, null, (int)0, (int)0);
                choiceContainer = new SequenceContainer(0, true, 0);
                encodedContainer4 = new OctetStringContainer(0, true, 0, this.b, 0, this.b.length);
                encodedContainer3 = new EncodedContainer(12288, true, 0, (byte[])object, 0, ((EndContainer)object).length);
                encodedContainer2 = new IntegerContainer(0, true, 0, this.c);
                encodedContainer = new EncodedContainer(12288, true, 0, object2, 0, ((byte[])object2).length);
                EndContainer endContainer = new EndContainer();
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{choiceContainer, encodedContainer4, encodedContainer3, encodedContainer2, encodedContainer, endContainer};
                ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
                int n3 = aSN1Template.derEncodeInit();
                byte[] byArray3 = new byte[n3];
                n3 = aSN1Template.derEncode(byArray3, 0);
                byte[] byArray4 = new byte[this.h.length + n3 + 4];
                byArray4[0] = 48;
                byArray4[1] = (byte)(this.h.length + n3 + 2);
                byArray4[2] = 6;
                byArray4[3] = (byte)this.h.length;
                System.arraycopy(this.h, 0, byArray4, 4, this.h.length);
                System.arraycopy(byArray3, 0, byArray4, this.h.length + 4, byArray3.length);
                SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                EncodedContainer encodedContainer5 = new EncodedContainer(12288, true, 0, byArray4, 0, byArray4.length);
                BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, this.f, 0, this.f.length);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, encodedContainer5, bitStringContainer, endContainer};
                ASN1Template aSN1Template2 = new ASN1Template(aSN1ContainerArray2);
                n2 = aSN1Template2.derEncodeInit();
                byArray2 = new byte[n2];
                n2 = aSN1Template2.derEncode(byArray2, 0);
            }
            object2 = new SequenceContainer(0x810000, true, 0);
            object = new EndContainer();
            choiceContainer = new ChoiceContainer(0, 0);
            encodedContainer4 = new EncodedContainer(0xA00000, bl, 0, byArray, 0, n);
            encodedContainer3 = new EncodedContainer(12288, bl2, 0, byArray2, 0, n2);
            encodedContainer2 = new EncodedContainer(12288, true, 0, this.e, 0, this.e.length);
            encodedContainer = new EncodedContainer[]{(ASN1Container)object2, choiceContainer, encodedContainer4, encodedContainer3, object, encodedContainer2, object};
            this.a = new ASN1Template((ASN1Container[])encodedContainer);
            return this.a.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Unable to encode POPOSigningKeyInput." + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new CRMFException("Unable to encode POPOSigningKeyInput." + nameException.getMessage());
        }
    }
}

