/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.pkcs7.Data;
import com.rsa.certj.pkcs7.DigestedData;
import com.rsa.certj.pkcs7.EncryptedData;
import com.rsa.certj.pkcs7.EnvelopedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.spi.path.CertPathCtx;
import java.io.Serializable;

public abstract class ContentInfo
implements Cloneable,
Serializable {
    public static final int DATA = 1;
    public static final int SIGNED_DATA = 2;
    public static final int ENVELOPED_DATA = 3;
    public static final int DIGESTED_DATA = 5;
    public static final int ENCRYPTED_DATA = 6;
    public static final int NO_CONTENT = 0;
    public static final int PKCS7_VERSION_NUMBER_0 = 0;
    public static final int PKCS7_VERSION_NUMBER_1 = 1;
    static final byte[] a = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 0};
    static final int b = 9;
    protected int contentType;
    protected int maxBufferSize = 0;
    protected ContentInfo content;
    protected CertPathCtx theCertPathCtx;
    protected CertJ theCertJ;
    protected ASN1Container[] contentASN1Def;
    protected ASN1Template contentASN1Template;
    private ASN1Container[] c;
    protected ASN1Template contentInfoASN1Template;
    protected int derLen = 0;
    protected int numberOfBytesRead;
    protected String theDevice;
    protected String[] theDeviceList;
    protected byte[] internalBuffer;
    protected int internalOffset;
    protected int internalBufferLen;
    protected byte[] contentInfoEncoding = null;
    protected int incompleteContainer = 0;
    protected byte[] contentEncoding = null;
    protected final int ENCODE = 0;
    protected final int DECODE = 1;
    protected int flag = 0;

    protected ContentInfo() {
    }

    public static ContentInfo getInstance(int n, CertJ certJ, CertPathCtx certPathCtx) throws PKCS7Exception {
        switch (n) {
            case 1: {
                return new Data();
            }
            case 2: {
                return new SignedData(certJ, certPathCtx);
            }
            case 3: {
                return new EnvelopedData(certJ, certPathCtx);
            }
            case 5: {
                return new DigestedData(certJ, certPathCtx);
            }
            case 6: {
                return new EncryptedData(certJ, certPathCtx);
            }
        }
        throw new PKCS7Exception("Cannot build PKCS #7 content object: unknown type.");
    }

    public static ContentInfo getInstance(byte[] byArray, int n, int n2, CertJ certJ, CertPathCtx certPathCtx) throws PKCS7Exception {
        int n3;
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("Cannot build PKCS #7 content object: OID is null.");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid content type.");
        }
        if (n2 != 9) {
            throw new PKCS7Exception("Cannot build PKCS #7 content object: unknown OID.");
        }
        for (n3 = 0; n3 < 7; ++n3) {
            if (byArray[n3 + n] == a[n3]) continue;
            throw new PKCS7Exception("Cannot build PKCS #7 content object: unknown OID.");
        }
        n3 = byArray[n2 + n - 1] & 0xFF;
        switch (n3) {
            case 1: {
                return new Data();
            }
            case 2: {
                return new SignedData(certJ, certPathCtx);
            }
            case 3: {
                return new EnvelopedData(certJ, certPathCtx);
            }
            case 5: {
                return new DigestedData(certJ, certPathCtx);
            }
            case 6: {
                return new EncryptedData(certJ, certPathCtx);
            }
        }
        throw new PKCS7Exception("Cannot build PKCS #7 content object: unknown OID.");
    }

    public static int getMessageType(byte[] byArray, int n, int n2) throws PKCS7Exception {
        return ContentInfo.getMessageType(byArray, n, n2, 0);
    }

    public static int getMessageType(byte[] byArray, int n, int n2, int n3) throws PKCS7Exception {
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("Cannot read the message: data is null.");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid message data");
        }
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(n3);
            EndContainer endContainer = new EndContainer();
            OIDContainer oIDContainer = new OIDContainer(0x1000000);
            EncodedContainer encodedContainer = new EncodedContainer(10616576);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            aSN1Template.berDecodeInit();
            int n4 = aSN1Template.berDecodeUpdate(byArray, n, n2);
            if (!aSN1ContainerArray[1].isComplete()) {
                return -1;
            }
            if (aSN1ContainerArray[1].dataLen != 9) {
                throw new PKCS7Exception("Unknown OID.");
            }
            byte by = aSN1ContainerArray[1].data[aSN1ContainerArray[1].dataOffset + aSN1ContainerArray[1].dataLen - 1];
            return by;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot read message: " + aSN_Exception.getMessage());
        }
    }

    public void setDevice(String string) {
        this.theDevice = string;
    }

    public String getDevice() {
        if (this.theDevice != null) {
            return this.theDevice;
        }
        if (this.theCertJ != null) {
            return this.theCertJ.getDevice();
        }
        return null;
    }

    protected String getDeviceOrJava() {
        String string = this.getDevice();
        if (string == null) {
            return new String("Java");
        }
        return string;
    }

    public String[] getDeviceList() {
        String[] stringArray = null;
        if (this.theDeviceList != null) {
            stringArray = new String[this.theDeviceList.length];
            for (int i = 0; i < this.theDeviceList.length; ++i) {
                stringArray[i] = this.theDeviceList[i];
            }
        } else if (this.theDevice != null) {
            stringArray = new String[]{this.theDevice};
        } else if (this.theCertJ != null) {
            stringArray = new String[]{this.theCertJ.getDevice()};
        }
        return stringArray;
    }

    public int getContentType() {
        return this.contentType;
    }

    public void setCertJ(CertJ certJ) {
        this.theCertJ = certJ;
    }

    public void setCertPath(CertPathCtx certPathCtx) {
        this.theCertPathCtx = certPathCtx;
    }

    public ContentInfo getContent() {
        return this.content;
    }

    public int getContentInfoDERLen() throws PKCS7Exception {
        return this.getContentInfoDERLen(0);
    }

    public int getContentInfoDERLen(int n) throws PKCS7Exception {
        this.c = this.a(true, n);
        this.contentInfoASN1Template = new ASN1Template(this.c);
        try {
            this.derLen = this.contentInfoASN1Template.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception(aSN_Exception.getMessage());
        }
        return this.derLen;
    }

    protected abstract int getContentDERLen() throws PKCS7Exception;

    public int writeMessage(byte[] byArray, int n) throws PKCS7Exception {
        return this.writeMessage(byArray, n, 0);
    }

    public int writeMessage(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null || n < 0 || byArray.length == 0) {
            throw new PKCS7Exception("Cannot write message: output array is null.");
        }
        int n3 = n;
        if (this.derLen == 0) {
            this.getContentInfoDERLen(n2);
        }
        try {
            n += this.contentInfoASN1Template.derEncode(byArray, n);
            byArray[n - 1] = (byte)this.contentType;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot encode contentInfo: " + aSN_Exception.getMessage());
        }
        if (this.contentInfoEncoding != null) {
            System.arraycopy(this.contentInfoEncoding, 0, byArray, n, this.contentInfoEncoding.length);
            n += this.contentInfoEncoding.length;
        } else {
            n += this.writeContent(byArray, n);
        }
        this.derLen = 0;
        return n - n3;
    }

    protected abstract int writeContent(byte[] var1, int var2) throws PKCS7Exception;

    public boolean readInit(byte[] byArray, int n, int n2) throws PKCS7Exception {
        return this.readInit(byArray, n, n2, 0);
    }

    public boolean readInit(byte[] byArray, int n, int n2, int n3) throws PKCS7Exception {
        return this.readInit(byArray, n, n2, n3, 0);
    }

    public boolean readInit(byte[] byArray, int n, int n2, int n3, int n4) throws PKCS7Exception {
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("Cannot read message: data is null.");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid message data");
        }
        try {
            this.maxBufferSize = n4;
            this.c = this.a(false, n3);
            this.contentInfoASN1Template = new ASN1Template(this.c);
            this.contentInfoASN1Template.berDecodeInit();
            this.numberOfBytesRead = this.contentInfoASN1Template.berDecodeUpdate(byArray, n, n2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot read message: " + aSN_Exception.getMessage());
        }
        if (!this.c[1].isComplete()) {
            return false;
        }
        this.contentInfoEncoding = new byte[this.c[2].dataLen];
        if (this.contentInfoEncoding.length > 0) {
            System.arraycopy(this.c[2].data, this.c[2].dataOffset, this.contentInfoEncoding, 0, this.c[2].dataLen);
            this.contentReadInit(this.c[2].data, this.c[2].dataOffset, this.c[2].dataLen);
        }
        return true;
    }

    protected abstract boolean contentReadInit(byte[] var1, int var2, int var3) throws PKCS7Exception;

    public int readUpdate(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("Cannot read message: data is null.");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid message data");
        }
        if (this.contentInfoASN1Template == null) {
            throw new PKCS7Exception("Need to call readInit() before readUpdate().");
        }
        try {
            this.numberOfBytesRead += this.contentInfoASN1Template.berDecodeUpdate(byArray, n, n2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot readUpdate message: " + aSN_Exception.getMessage());
        }
        if (this.contentInfoEncoding != null) {
            byte[] byArray2 = new byte[this.contentInfoEncoding.length];
            System.arraycopy(this.contentInfoEncoding, 0, byArray2, 0, this.contentInfoEncoding.length);
            this.contentInfoEncoding = new byte[byArray2.length + n2];
            System.arraycopy(byArray2, 0, this.contentInfoEncoding, 0, byArray2.length);
            System.arraycopy(byArray, n, this.contentInfoEncoding, byArray2.length, n2);
        }
        int n3 = this.contentReadUpdate(byArray, n, n2);
        return n3;
    }

    protected abstract int contentReadUpdate(byte[] var1, int var2, int var3) throws PKCS7Exception;

    public boolean readFinal() throws PKCS7Exception {
        if (this.contentInfoASN1Template == null) {
            throw new PKCS7Exception("Need to call readInit() before readFinal().");
        }
        try {
            this.contentInfoASN1Template.berDecodeFinal();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot call readFinal: " + aSN_Exception.getMessage());
        }
        if (!this.contentInfoASN1Template.isComplete()) {
            throw new PKCS7Exception("Cannot call readFinal, more message expected.");
        }
        return true;
    }

    public int bytesRead() {
        return this.numberOfBytesRead;
    }

    public boolean endOfMessage() {
        return this.contentASN1Def[0].isComplete();
    }

    public int getUnprocessedDataLen() {
        if (this.internalBuffer == null) {
            return 0;
        }
        return this.internalBuffer.length;
    }

    protected int copyNewData(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            return 0;
        }
        if (this.internalBuffer == null) {
            this.internalBuffer = n3 != 0 ? new byte[n3] : new byte[n2];
        }
        if (this.internalBuffer.length - this.internalOffset < n2) {
            byte[] byArray2 = new byte[this.internalBuffer.length];
            System.arraycopy(this.internalBuffer, 0, byArray2, 0, this.internalBuffer.length);
            this.internalBuffer = new byte[n2 + this.internalBuffer.length];
            System.arraycopy(byArray2, 0, this.internalBuffer, 0, byArray2.length);
            this.internalOffset = byArray2.length;
        }
        System.arraycopy(byArray, n, this.internalBuffer, this.internalOffset, n2);
        this.internalOffset += n2;
        return n2;
    }

    protected byte[] copyToOutput(ASN1Container aSN1Container) {
        byte[] byArray = null;
        if (this.internalBuffer == null) {
            byArray = new byte[aSN1Container.dataLen];
            System.arraycopy(aSN1Container.data, aSN1Container.dataOffset, byArray, 0, aSN1Container.dataLen);
        } else if (this.maxBufferSize != 0 && this.internalBuffer.length >= this.maxBufferSize) {
            System.arraycopy(aSN1Container.data, aSN1Container.dataOffset, this.internalBuffer, this.internalOffset, aSN1Container.dataLen);
            byArray = new byte[this.internalBuffer.length];
            System.arraycopy(this.internalBuffer, 0, byArray, 0, this.internalBuffer.length);
        } else {
            byArray = new byte[aSN1Container.dataLen + this.internalBuffer.length];
            System.arraycopy(this.internalBuffer, 0, byArray, 0, this.internalBuffer.length);
            System.arraycopy(aSN1Container.data, aSN1Container.dataOffset, byArray, this.internalBuffer.length, aSN1Container.dataLen);
        }
        this.clearInternalBuffer(this.internalBuffer);
        this.internalBuffer = null;
        this.internalOffset = 0;
        this.incompleteContainer = 0;
        return byArray;
    }

    protected void clearInternalBuffer(byte[] byArray) {
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
        }
    }

    ASN1Container[] a(boolean bl, int n) throws PKCS7Exception {
        SequenceContainer sequenceContainer = new SequenceContainer(n, true, 0);
        EndContainer endContainer = new EndContainer();
        int n2 = 0;
        if (bl) {
            n2 = this.contentInfoEncoding != null ? this.contentInfoEncoding.length : this.getContentDERLen();
        }
        try {
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, a, 0, 9);
            EncodedContainer encodedContainer = new EncodedContainer(10616576, true, 0, this.maxBufferSize, null, 0, n2);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            return aSN1ContainerArray;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("ContentInfo.getASN1Containers: " + aSN_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ContentInfo contentInfo = (ContentInfo)super.clone();
        contentInfo.theDevice = this.theDevice;
        contentInfo.theDeviceList = this.getDeviceList();
        contentInfo.contentType = this.contentType;
        if (this.content != null) {
            contentInfo.content = (ContentInfo)this.content.clone();
        }
        contentInfo.theCertPathCtx = this.theCertPathCtx;
        contentInfo.theCertJ = this.theCertJ;
        try {
            if (this.contentInfoASN1Template != null) {
                contentInfo.getContentInfoDERLen();
            }
        }
        catch (PKCS7Exception pKCS7Exception) {
            throw new CloneNotSupportedException("Could not copy ASN1Template.");
        }
        return contentInfo;
    }

    public void clearInternalContentBuffer() {
        this.contentInfoEncoding = null;
    }

    public void clearSensitiveData() {
        if (this.content != null) {
            this.content.clearSensitiveData();
        }
        this.contentType = 0;
        this.content = null;
        this.theDevice = null;
        this.theDeviceList = null;
        this.contentInfoASN1Template = null;
        this.contentASN1Template = null;
        this.derLen = 0;
        this.clearInternalBuffer(this.internalBuffer);
        this.internalBuffer = null;
        this.internalOffset = 0;
        this.incompleteContainer = 0;
        this.theCertPathCtx = null;
        this.theCertJ = null;
    }

    protected void finalize() {
        this.clearSensitiveData();
    }
}

