/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.pkcs7;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.pkcs7.DigestedData;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;

public class SignerInfo
implements Cloneable,
Serializable {
    private static final int a = 0x810000;
    private static final int b = 0x810001;
    private int c = 1;
    private X500Name d = null;
    private byte[] e = null;
    private byte[] f = null;
    private X501Attributes g = null;
    private byte[] h = null;
    private X501Attributes i = null;
    private byte[] j = null;
    private String k = null;
    private String l = null;
    private byte[] m = null;
    protected static int special;
    private ASN1Template n = null;

    public SignerInfo() {
    }

    protected SignerInfo(byte[] byArray, int n, int n2) throws PKCS7Exception {
        try {
            if (byArray == null) {
                throw new PKCS7Exception("Encoding is null.");
            }
            SequenceContainer sequenceContainer = new SequenceContainer(n2);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = new IntegerContainer(0);
            EncodedContainer encodedContainer = new EncodedContainer(12288);
            EncodedContainer encodedContainer2 = new EncodedContainer(12288);
            EncodedContainer encodedContainer3 = new EncodedContainer(8466688);
            EncodedContainer encodedContainer4 = new EncodedContainer(12288);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0);
            EncodedContainer encodedContainer5 = new EncodedContainer(8466689);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, integerContainer, encodedContainer, encodedContainer2, encodedContainer3, encodedContainer4, octetStringContainer, encodedContainer5, endContainer};
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
            this.c = integerContainer.getValueAsInt();
            SequenceContainer sequenceContainer2 = new SequenceContainer(n2);
            EncodedContainer encodedContainer6 = new EncodedContainer(12288);
            IntegerContainer integerContainer2 = new IntegerContainer(0);
            ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, encodedContainer6, integerContainer2, endContainer};
            ASN1.berDecode((byte[])encodedContainer.data, (int)encodedContainer.dataOffset, (ASN1Container[])aSN1ContainerArray2);
            this.d = new X500Name(encodedContainer6.data, encodedContainer6.dataOffset, 0);
            if (integerContainer2.dataLen == 0) {
                throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: Serial Number is null.");
            }
            this.e = new byte[integerContainer2.dataLen];
            System.arraycopy(integerContainer2.data, integerContainer2.dataOffset, this.e, 0, integerContainer2.dataLen);
            if (encodedContainer2.dataLen == 0) {
                throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: Digest algorithm is missing.");
            }
            this.f = new byte[encodedContainer2.dataLen];
            System.arraycopy(encodedContainer2.data, encodedContainer2.dataOffset, this.f, 0, encodedContainer2.dataLen);
            if (encodedContainer3.dataPresent) {
                this.m = new byte[encodedContainer3.dataLen];
                System.arraycopy(encodedContainer3.data, encodedContainer3.dataOffset, this.m, 0, encodedContainer3.dataLen);
                this.m[0] = 49;
                this.g = new X501Attributes(encodedContainer3.data, encodedContainer3.dataOffset, 0x810000);
            }
            if (encodedContainer4.dataLen == 0) {
                throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: Encryption algorithm is missing.");
            }
            this.h = new byte[encodedContainer4.dataLen];
            System.arraycopy(encodedContainer4.data, encodedContainer4.dataOffset, this.h, 0, encodedContainer4.dataLen);
            if (octetStringContainer.dataLen == 0) {
                throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: Encrypted digest is missing.");
            }
            this.j = new byte[octetStringContainer.dataLen];
            System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.j, 0, octetStringContainer.dataLen);
            if (encodedContainer5.dataPresent) {
                this.i = new X501Attributes(encodedContainer5.data, encodedContainer5.dataOffset, 0x810001);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: " + aSN_Exception.getMessage());
        }
        catch (AttributeException attributeException) {
            throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: " + attributeException.getMessage());
        }
        catch (NameException nameException) {
            throw new PKCS7Exception("Cannot decode the BER of the SignerInfo: " + nameException.getMessage());
        }
    }

    public void setVersionNumber(int n) {
        this.c = n;
    }

    public int getVersionNumber() {
        return this.c;
    }

    public void setIssuerAndSerialNumber(X500Name x500Name, byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (x500Name == null) {
            throw new PKCS7Exception("Issuer name is null.");
        }
        try {
            this.d = (X500Name)x500Name.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Invalid name.");
        }
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("SerialNumber is null.");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid SerialNumber");
        }
        this.e = new byte[n2];
        System.arraycopy(byArray, n, this.e, 0, n2);
    }

    public X500Name getIssuerName() throws PKCS7Exception {
        if (this.d == null) {
            return null;
        }
        try {
            return (X500Name)this.d.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Invalid attributes.");
        }
    }

    public byte[] getSerialNumber() {
        if (this.e == null) {
            return null;
        }
        return (byte[])this.e.clone();
    }

    public byte[] getIssuerAndSerialNumber() throws PKCS7Exception {
        if (this.d == null || this.e == null) {
            throw new PKCS7Exception("Cannot get issuerSerial, not all values set.");
        }
        try {
            int n = this.d.getDERLen(0);
            byte[] byArray = new byte[n];
            n = this.d.getDEREncoding(byArray, 0, 0);
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            IntegerContainer integerContainer = null;
            integerContainer = (this.e[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.e, 0, this.e.length, true) : new IntegerContainer(0, true, 0, this.e, 0, this.e.length, false);
            EncodedContainer encodedContainer = new EncodedContainer(12288, true, 0, byArray, 0, n);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, integerContainer, endContainer};
            return ASN1.derEncode((ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot encode issuerSerial: " + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new PKCS7Exception("Cannot encode issuerSerial: " + nameException.getMessage());
        }
    }

    public void setDigestAlgorithm(String string) throws PKCS7Exception {
        this.f = DigestedData.a(string);
        this.k = string;
    }

    public void setDigestAlgorithm(byte[] byArray, int n, int n2) throws PKCS7Exception {
        this.f = DigestedData.a(byArray, n, n2);
    }

    public byte[] getDigestAlgorithmOID() {
        return this.f;
    }

    public String getDigestAlgorithmName() throws PKCS7Exception {
        return DigestedData.a(this.f, this.k);
    }

    public void setAuthenticatedAttrs(X501Attributes x501Attributes) throws PKCS7Exception {
        if (x501Attributes == null) {
            throw new PKCS7Exception("Attributes are null");
        }
        try {
            this.g = (X501Attributes)x501Attributes.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Invalid attributes: " + cloneNotSupportedException.getMessage());
        }
    }

    protected byte[] getAuthenticatedAttrsBer() {
        if (this.m != null) {
            return this.m;
        }
        return null;
    }

    public X501Attributes getAuthenticatedAttrs() throws PKCS7Exception {
        if (this.g == null) {
            return null;
        }
        try {
            return (X501Attributes)this.g.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Invalid attributes.");
        }
    }

    public void setEncryptionAlgorithm(String string) throws PKCS7Exception {
        if (string == null) {
            throw new PKCS7Exception("Could not set algorithm OID: name is null.");
        }
        this.l = string;
        if (string.indexOf("RSA") != -1) {
            try {
                JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = JSAFE_AsymmetricCipher.getInstance((String)string, (String)"Java");
                this.h = jSAFE_AsymmetricCipher.getDERAlgorithmID();
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new PKCS7Exception("Could not set algorithm OID: " + jSAFE_Exception.getMessage());
            }
        } else if (string.indexOf("DSA") != -1) {
            try {
                JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((String)"SHA1/DSA/NoPad", (String)"Java");
                this.h = jSAFE_Signature.getDERAlgorithmID();
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new PKCS7Exception("Could not set algorithm OID: " + jSAFE_Exception.getMessage());
            }
        } else {
            throw new PKCS7Exception("Could not set Encryption Algorithm, " + string + " is invalid algorithm.");
        }
    }

    public void setEncryptionAlgorithm(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null || n2 <= 0) {
            throw new PKCS7Exception("Could not set algorithm OID: OID is null");
        }
        if (n < 0 || n + n2 > byArray.length) {
            throw new PKCS7Exception("Invalid Encryption Algorithm Identifier.");
        }
        this.h = new byte[n2];
        System.arraycopy(byArray, n, this.h, 0, n2);
    }

    public byte[] getEncryptionAlgorithmOID() {
        if (this.h == null) {
            return null;
        }
        return (byte[])this.h.clone();
    }

    public String getEncryptionAlgorithmName() throws PKCS7Exception {
        if (this.h == null) {
            return null;
        }
        if (this.l != null) {
            return this.l;
        }
        try {
            JSAFE_AsymmetricCipher jSAFE_AsymmetricCipher = JSAFE_AsymmetricCipher.getInstance((byte[])this.h, (int)0, (String)"Java");
            return jSAFE_AsymmetricCipher.getEncryptionAlgorithm();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            try {
                JSAFE_Signature jSAFE_Signature = JSAFE_Signature.getInstance((byte[])this.h, (int)0, (String)"Java");
                return jSAFE_Signature.getSignatureAlgorithm();
            }
            catch (JSAFE_Exception jSAFE_Exception2) {
                throw new PKCS7Exception("Could not get encryption algorithm name: " + jSAFE_Exception2.getMessage());
            }
        }
    }

    protected void setEncryptedDigest(byte[] byArray, int n, int n2) {
        if (byArray != null && n2 != 0) {
            this.j = new byte[n2];
            System.arraycopy(byArray, n, this.j, 0, n2);
        }
    }

    public byte[] getEncryptedDigest() {
        if (this.j == null) {
            return null;
        }
        return (byte[])this.j.clone();
    }

    public void setUnauthenticatedAttrs(X501Attributes x501Attributes) throws PKCS7Exception {
        if (x501Attributes == null) {
            throw new PKCS7Exception("Null attributes.");
        }
        try {
            this.i = (X501Attributes)x501Attributes.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Invalid attributes: " + cloneNotSupportedException.getMessage());
        }
    }

    public X501Attributes getUnauthenticatedAttrs() throws PKCS7Exception {
        if (this.i == null) {
            return null;
        }
        try {
            return (X501Attributes)this.i.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new PKCS7Exception("Invalid attributes: " + cloneNotSupportedException.getMessage());
        }
    }

    protected static int getNextBEROffset(byte[] byArray, int n) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Encoding is null.");
        }
        if (byArray[n] == 0 && byArray[n + 1] == 0) {
            return n + 2;
        }
        try {
            return n + 1 + ASN1Lengths.determineLengthLen((byte[])byArray, (int)(n + 1)) + ASN1Lengths.determineLength((byte[])byArray, (int)(n + 1));
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Unable to determine length of the BER: " + aSN_Exception.getMessage());
        }
    }

    protected int getDERLen(int n) throws PKCS7Exception {
        special = n;
        return this.a();
    }

    protected int getDEREncoding(byte[] byArray, int n, int n2) throws PKCS7Exception {
        if (byArray == null) {
            throw new PKCS7Exception("Passed array is null.");
        }
        try {
            block7: {
                block6: {
                    if (this.n == null) break block6;
                    if (n2 == special) break block7;
                }
                this.getDERLen(n2);
            }
            int n3 = this.n.derEncode(byArray, n);
            this.n = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.n = null;
            throw new PKCS7Exception("Unable to encode SignerInfo: " + aSN_Exception.getMessage());
        }
    }

    private int a() throws PKCS7Exception {
        if (this.d == null || this.e == null) {
            throw new PKCS7Exception("Cannot encode SignerInfo: issuerName or SerialNumber is not set.");
        }
        try {
            Object object;
            Object object2;
            int n = this.d.getDERLen(0);
            byte[] byArray = new byte[n];
            n = this.d.getDEREncoding(byArray, 0, 0);
            EncodedContainer encodedContainer = null;
            if (this.g != null) {
                n = this.g.getDERLen(0x810000);
                object2 = new byte[n];
                n = this.g.getDEREncoding((byte[])object2, 0, 0x810000);
                encodedContainer = new EncodedContainer(8466688, true, 0, object2, 0, n);
            }
            object2 = null;
            if (this.i != null) {
                n = this.i.getDERLen(0x810001);
                object = new byte[n];
                n = this.i.getDEREncoding((byte[])object, 0, 0x810001);
                object2 = new EncodedContainer(8466689, true, 0, (byte[])object, 0, n);
            }
            object = new SequenceContainer(0, true, 0);
            EndContainer endContainer = new EndContainer();
            EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, byArray, 0, byArray.length);
            IntegerContainer integerContainer = null;
            integerContainer = (this.e[0] & 0x80) >> 7 == 0 ? new IntegerContainer(0, true, 0, this.e, 0, this.e.length, true) : new IntegerContainer(0, true, 0, this.e, 0, this.e.length, false);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{object, encodedContainer2, integerContainer, endContainer};
            ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
            n = aSN1Template.derEncodeInit();
            byte[] byArray2 = new byte[n];
            aSN1Template.derEncode(byArray2, 0);
            SequenceContainer sequenceContainer = new SequenceContainer(special, true, 0);
            IntegerContainer integerContainer2 = new IntegerContainer(0, true, 0, this.c);
            EncodedContainer encodedContainer3 = new EncodedContainer(12288, true, 0, byArray2, 0, byArray2.length);
            if (this.f == null) {
                throw new PKCS7Exception("DigestAlgorithmIdentifier is not set.");
            }
            EncodedContainer encodedContainer4 = new EncodedContainer(12288, true, 0, this.f, 0, this.f.length);
            if (this.h == null) {
                throw new PKCS7Exception("EncryptionAlgorithmIdentifier is not set.");
            }
            EncodedContainer encodedContainer5 = new EncodedContainer(12288, true, 0, this.h, 0, this.h.length);
            int n2 = 0;
            if (this.j != null) {
                n2 = this.j.length;
            }
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, this.j, 0, n2);
            if (encodedContainer != null) {
                if (object2 != null) {
                    ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, integerContainer2, encodedContainer3, encodedContainer4, encodedContainer, encodedContainer5, octetStringContainer, (ASN1Container)object2, endContainer};
                    this.n = new ASN1Template(aSN1ContainerArray2);
                } else {
                    ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{sequenceContainer, integerContainer2, encodedContainer3, encodedContainer4, encodedContainer, encodedContainer5, octetStringContainer, endContainer};
                    this.n = new ASN1Template(aSN1ContainerArray3);
                }
            } else if (object2 != null) {
                ASN1Container[] aSN1ContainerArray4 = new ASN1Container[]{sequenceContainer, integerContainer2, encodedContainer3, encodedContainer4, encodedContainer5, octetStringContainer, (ASN1Container)object2, endContainer};
                this.n = new ASN1Template(aSN1ContainerArray4);
            } else {
                ASN1Container[] aSN1ContainerArray5 = new ASN1Container[]{sequenceContainer, integerContainer2, encodedContainer3, encodedContainer4, encodedContainer5, octetStringContainer, endContainer};
                this.n = new ASN1Template(aSN1ContainerArray5);
            }
            return this.n.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new PKCS7Exception("Cannot encode SignerInfo: " + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new PKCS7Exception("Cannot encode X500Name: " + nameException.getMessage());
        }
        catch (AttributeException attributeException) {
            throw new PKCS7Exception("Cannot encode X501Attributes: " + attributeException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SignerInfo)) {
            return false;
        }
        SignerInfo signerInfo = (SignerInfo)object;
        if (this.c != signerInfo.c) {
            return false;
        }
        if (this.d != null ? !this.d.equals(signerInfo.d) : signerInfo.d != null) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.e, signerInfo.e)) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.f, signerInfo.f)) {
            return false;
        }
        if (this.g != null ? !this.g.equals(signerInfo.g) : signerInfo.g != null) {
            return false;
        }
        if (!CertJUtils.byteArraysEqual(this.h, signerInfo.h)) {
            return false;
        }
        if (this.i != null ? !this.i.equals(signerInfo.i) : signerInfo.i != null) {
            return false;
        }
        return CertJUtils.byteArraysEqual(this.j, signerInfo.j);
    }

    public Object clone() throws CloneNotSupportedException {
        SignerInfo signerInfo = new SignerInfo();
        signerInfo.c = this.c;
        if (this.d != null) {
            signerInfo.d = (X500Name)this.d.clone();
        }
        if (this.e != null) {
            signerInfo.e = new byte[this.e.length];
            System.arraycopy(this.e, 0, signerInfo.e, 0, this.e.length);
        }
        if (this.f != null) {
            signerInfo.f = new byte[this.f.length];
            System.arraycopy(this.f, 0, signerInfo.f, 0, this.f.length);
        }
        if (this.g != null) {
            signerInfo.g = (X501Attributes)this.g.clone();
        }
        if (this.h != null) {
            signerInfo.h = new byte[this.h.length];
            System.arraycopy(this.h, 0, signerInfo.h, 0, this.h.length);
        }
        if (this.i != null) {
            signerInfo.i = (X501Attributes)this.i.clone();
        }
        if (this.j != null) {
            signerInfo.j = new byte[this.j.length];
            System.arraycopy(this.j, 0, signerInfo.j, 0, this.j.length);
        }
        if (this.m != null) {
            signerInfo.m = new byte[this.m.length];
            System.arraycopy(this.m, 0, signerInfo.m, 0, this.m.length);
        }
        try {
            if (this.n != null) {
                signerInfo.a();
            }
        }
        catch (PKCS7Exception pKCS7Exception) {
            throw new CloneNotSupportedException("Cannot set ASN1 template:" + pKCS7Exception.getMessage());
        }
        return signerInfo;
    }
}

