/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.db.Ck;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Date;
import java.util.Vector;

public final class MemoryDB
extends Provider {
    private Vector a = null;
    private Vector b = null;
    private Vector c = null;
    private Vector d = null;

    public MemoryDB(String string) throws InvalidParameterException {
        super(1, string);
    }

    public MemoryDB(String string, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws InvalidParameterException {
        super(1, string);
        if (vector3 == null || vector4 == null || vector3.size() != vector4.size()) {
            throw new InvalidParameterException("MemoryDB.MemoryDB: privateKeys and publicKeys should have the same number of elements.");
        }
        if (vector != null) {
            this.a = vector;
        }
        if (vector2 != null) {
            this.b = vector2;
        }
        if (vector3 != null) {
            this.c = vector3;
            this.d = vector4;
        }
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("MemoryDB.instantiate: " + invalidParameterException.getMessage());
        }
    }

    private final class Implementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private Vector a;
        private Vector b;
        private Vector c;
        private Vector d;
        private int e;
        private int f;
        private int g;
        private Object h = new Object();
        private Object i = new Object();
        private Object j = new Object();

        private Implementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
            this.a = MemoryDB.this.a == null ? new Vector() : MemoryDB.this.a;
            this.b = MemoryDB.this.b == null ? new Vector() : MemoryDB.this.b;
            if (MemoryDB.this.c == null) {
                this.c = new Vector();
                this.d = new Vector();
            } else {
                this.c = MemoryDB.this.c;
                this.d = MemoryDB.this.d;
            }
            this.e = -1;
            this.f = -1;
            this.g = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertCertificate(Certificate certificate) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("MemoryDBProvider.insertCertificate: cert should not be null.");
            }
            Vector vector = this.a;
            synchronized (vector) {
                if (!this.a.contains(certificate)) {
                    try {
                        this.a.addElement((Certificate)((X509Certificate)certificate).clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.insertCertificate: Unable to clone the certificate(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertCRL(CRL cRL) throws DatabaseException {
            if (cRL == null) {
                throw new DatabaseException("MemoryDBProvider.insertCRL: crl should not be null.");
            }
            Vector vector = this.b;
            synchronized (vector) {
                if (!this.b.contains(cRL)) {
                    try {
                        this.b.addElement((CRL)((X509CRL)cRL).clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.insertCRL: Unable to clone the CRL(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
            }
        }

        public void insertPrivateKeyByCertificate(Certificate certificate, JSAFE_PrivateKey jSAFE_PrivateKey) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("MemoryDB$Implementation.insertPrivateKeyByCertificate: cert should not be null");
            }
            try {
                this.insertPrivateKeyByPublicKey(certificate.getSubjectPublicKey(this.certJ.getDevice()), jSAFE_PrivateKey);
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("MemoryDB$Implementation.insertPrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws DatabaseException {
            if (jSAFE_PublicKey == null || jSAFE_PrivateKey == null) {
                throw new DatabaseException("MemoryDBProvider.insertPrivateKeyByPublicKey: Neither publicKey nor privateKey should be null.");
            }
            Vector vector = this.c;
            synchronized (vector) {
                if (!this.d.contains(jSAFE_PublicKey)) {
                    try {
                        this.c.addElement((JSAFE_PrivateKey)jSAFE_PrivateKey.clone());
                        this.d.addElement((JSAFE_PublicKey)jSAFE_PublicKey.clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.insertPrivateKeyByPublicKey: Unable to clone a key(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateByIssuerAndSerialNumber(X500Name x500Name, byte[] byArray, Vector vector) throws DatabaseException {
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("MemoryDBProvider.Neither issuerName nor serialNumber should be null.");
            }
            Vector vector2 = this.a;
            synchronized (vector2) {
                for (int i = 0; i < this.a.size(); ++i) {
                    try {
                        X509Certificate x509Certificate = (X509Certificate)this.a.elementAt(i);
                        if (!x500Name.equals(x509Certificate.getIssuerName()) || !CertJUtils.byteArraysEqual(byArray, x509Certificate.getSerialNumber())) continue;
                        if (!vector.contains(x509Certificate)) {
                            vector.addElement((Certificate)x509Certificate.clone());
                        }
                        return 1;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.selectCertificateByIssuerAndSerialNumber: Unable to clone a certificate(" + cloneNotSupportedException.getMessage() + ").");
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateBySubject(X500Name x500Name, Vector vector) throws DatabaseException {
            if (x500Name == null) {
                throw new DatabaseException("MemoryDBProvider.selectCertificateBySubject: subjectName should not be null.");
            }
            int n = 0;
            Vector vector2 = this.a;
            synchronized (vector2) {
                for (int i = 0; i < this.a.size(); ++i) {
                    try {
                        X509Certificate x509Certificate = (X509Certificate)this.a.elementAt(i);
                        X500Name x500Name2 = x509Certificate.getSubjectName();
                        if (!x500Name2.equals(x500Name)) continue;
                        if (!vector.contains(x509Certificate)) {
                            vector.addElement((Certificate)x509Certificate.clone());
                        }
                        ++n;
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.selectCertificateByIssuerAndSerialNumber: Unable to clone a certificate(" + cloneNotSupportedException.getMessage() + ").");
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateByExtensions(X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws DatabaseException {
            if (x500Name == null && x509V3Extensions == null) {
                throw new DatabaseException("MemoryDB.selectCertificateByExtensions: Either baseName or extensions should have a non-null value.");
            }
            int n = 0;
            Vector vector2 = this.a;
            synchronized (vector2) {
                try {
                    for (int i = 0; i < this.a.size(); ++i) {
                        X509V3Extensions x509V3Extensions2;
                        X509Certificate x509Certificate = (X509Certificate)this.a.elementAt(i);
                        if (x500Name != null && !x509Certificate.getSubjectName().contains(x500Name) || !CertJUtils.compareExtensions(x509V3Extensions, x509V3Extensions2 = x509Certificate.getExtensions())) continue;
                        if (!vector.contains(x509Certificate)) {
                            vector.addElement((Certificate)x509Certificate.clone());
                        }
                        ++n;
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new DatabaseException("MemoryDBProvider.selectCertificateByExtensions: Unable to clone a certificate(" + cloneNotSupportedException.getMessage() + ").");
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCertificateIteratorSetup() {
            Object object = this.h;
            synchronized (object) {
                return this.e >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCertificateIterator() {
            Object object = this.h;
            synchronized (object) {
                this.e = 0;
            }
        }

        public Certificate firstCertificate() throws DatabaseException {
            Object object = this.h;
            synchronized (object) {
                this.setupCertificateIterator();
                Vector vector = this.a;
                synchronized (vector) {
                    if (this.a.size() == 0) {
                        this.e = -1;
                        return null;
                    }
                    try {
                        return (Certificate)((X509Certificate)this.a.elementAt(this.e++)).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.firstCertificate: Unable to clone a certificate(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
            }
        }

        public Certificate nextCertificate() throws DatabaseException {
            Object object = this.h;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                Vector vector = this.a;
                synchronized (vector) {
                    if (this.e >= this.a.size()) {
                        this.e = -1;
                        return null;
                    }
                    try {
                        return (Certificate)((X509Certificate)this.a.elementAt(this.e++)).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.nextCertificate: Unable to clone a certificate(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCertificates() throws DatabaseException {
            Object object = this.h;
            synchronized (object) {
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                Vector vector = this.a;
                synchronized (vector) {
                    return this.e < this.a.size();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCRLByIssuerAndTime(X500Name x500Name, Date date, Vector vector) throws DatabaseException {
            if (x500Name == null || date == null) {
                throw new DatabaseException("MemoryDBProvider.selectCRLByIssuerAndTime: Neither issuerName nor time should be null.");
            }
            Date date2 = new Date(0L);
            X509CRL x509CRL = null;
            Vector vector2 = this.b;
            synchronized (vector2) {
                for (int i = 0; i < this.b.size(); ++i) {
                    try {
                        Date date3;
                        X509CRL x509CRL2 = (X509CRL)this.b.elementAt(i);
                        X500Name x500Name2 = x509CRL2.getIssuerName();
                        if (!x500Name.equals(x500Name2) || (date3 = x509CRL2.getThisUpdate()).after(date) || !date3.after(date2)) continue;
                        date2 = date3;
                        x509CRL = x509CRL2;
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                if (x509CRL == null) {
                    return 0;
                }
                if (!vector.contains(x509CRL)) {
                    try {
                        vector.addElement((CRL)x509CRL.clone());
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.selectCRLByIssuerAndTime: Unable to clone a CRL(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
                return 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCRLIteratorSetup() {
            Object object = this.i;
            synchronized (object) {
                return this.f >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCRLIterator() {
            Object object = this.i;
            synchronized (object) {
                this.f = 0;
            }
        }

        public CRL firstCRL() throws DatabaseException {
            Object object = this.i;
            synchronized (object) {
                this.setupCRLIterator();
                Vector vector = this.b;
                synchronized (vector) {
                    if (this.b.size() == 0) {
                        this.f = -1;
                        return null;
                    }
                    try {
                        return (CRL)((X509CRL)this.b.elementAt(this.f++)).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.firstCRL: Unable to clone a CRL(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
            }
        }

        public CRL nextCRL() throws DatabaseException {
            Object object = this.i;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                Vector vector = this.b;
                synchronized (vector) {
                    if (this.f >= this.b.size()) {
                        this.f = -1;
                        return null;
                    }
                    try {
                        return (CRL)((X509CRL)this.b.elementAt(this.f++)).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDBProvider.nextCRL: Unable to clone a CRL(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCRLs() throws DatabaseException {
            Object object = this.i;
            synchronized (object) {
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                Vector vector = this.b;
                synchronized (vector) {
                    return this.f < this.b.size();
                }
            }
        }

        public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate certificate) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("MemoryDB$Implementation.selectPrivateKeyByCertificate: cert should not be null.");
            }
            try {
                return this.selectPrivateKeyByPublicKey(certificate.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("MemoryDB$Implementation.selectPrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws DatabaseException {
            if (jSAFE_PublicKey == null) {
                throw new DatabaseException("MemoryDB$Implementation.selectPrivateKeyByPublicKey: publicKey should not be null.");
            }
            Vector vector = this.c;
            synchronized (vector) {
                for (int i = 0; i < this.d.size(); ++i) {
                    if (!jSAFE_PublicKey.equals(this.d.elementAt(i))) continue;
                    try {
                        return (JSAFE_PrivateKey)((JSAFE_PrivateKey)this.c.elementAt(i)).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDB$Implementation.selectPrivateKeyByPublicKeyUnable to clone a private key().");
                    }
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPrivateKeyIteratorSetup() {
            Object object = this.j;
            synchronized (object) {
                return this.g >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupPrivateKeyIterator() {
            Object object = this.j;
            synchronized (object) {
                this.g = 0;
            }
        }

        public JSAFE_PrivateKey firstPrivateKey() throws DatabaseException {
            Object object = this.j;
            synchronized (object) {
                this.setupPrivateKeyIterator();
                Vector vector = this.c;
                synchronized (vector) {
                    if (this.c.size() == 0) {
                        this.g = -1;
                        return null;
                    }
                    try {
                        return (JSAFE_PrivateKey)((JSAFE_PrivateKey)this.c.elementAt(this.g++)).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDB$Implementation.firstPrivateKey: Unable to clone a private key(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
            }
        }

        public JSAFE_PrivateKey nextPrivateKey() throws DatabaseException {
            Object object = this.j;
            synchronized (object) {
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                Vector vector = this.c;
                synchronized (vector) {
                    if (this.g >= this.c.size()) {
                        this.g = -1;
                        return null;
                    }
                    try {
                        return (JSAFE_PrivateKey)((JSAFE_PrivateKey)this.c.elementAt(this.g++)).clone();
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new DatabaseException("MemoryDB$Implementation.nextPrivateKey: Unable to clone a private key(" + cloneNotSupportedException.getMessage() + ").");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMorePrivateKeys() throws DatabaseException {
            Object object = this.j;
            synchronized (object) {
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                Vector vector = this.c;
                synchronized (vector) {
                    return this.g < this.c.size();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteCertificate(X500Name x500Name, byte[] byArray) throws DatabaseException {
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("MemoryDB$Implementation.deleteCertificate: Neither issuerName nor serialNumber should be null.");
            }
            Vector vector = this.a;
            synchronized (vector) {
                for (int i = 0; i < this.a.size(); ++i) {
                    try {
                        X509Certificate x509Certificate = (X509Certificate)this.a.elementAt(i);
                        if (!x500Name.equals(x509Certificate.getIssuerName()) || !CertJUtils.byteArraysEqual(byArray, x509Certificate.getSerialNumber())) continue;
                        this.a.removeElementAt(i);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteCRL(X500Name x500Name, Date date) throws DatabaseException {
            if (x500Name == null || date == null) {
                throw new DatabaseException("MemoryDB$Implementation.deleteCRL: Neither issuerName nor lastUpdate should be null.");
            }
            Vector vector = this.b;
            synchronized (vector) {
                for (int i = 0; i < this.b.size(); ++i) {
                    try {
                        X509CRL x509CRL = (X509CRL)this.b.elementAt(i);
                        if (!x500Name.equals(x509CRL.getIssuerName()) || !x509CRL.getThisUpdate().equals(date)) continue;
                        this.b.removeElementAt(i);
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        }

        public void deletePrivateKeyByCertificate(Certificate certificate) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("MemoryDB$Implementation.deletePrivateKeyByCertificate: cert should not be null.");
            }
            try {
                this.deletePrivateKeyByPublicKey(certificate.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("MemoryDB$Implementation.deletePrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws DatabaseException {
            if (jSAFE_PublicKey == null) {
                throw new DatabaseException("MemoryDB$Implementation.deletePrivateKeyByPublicKey: publickKey should not be null.");
            }
            Vector vector = this.c;
            synchronized (vector) {
                for (int i = 0; i < this.c.size(); ++i) {
                    if (!jSAFE_PublicKey.equals(this.d.elementAt(i))) continue;
                    this.c.removeElementAt(i);
                    this.d.removeElementAt(i);
                    return;
                }
            }
        }

        public String toString() {
            return "In-memory database provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Ck ck) throws InvalidParameterException {
            this(certJ, string);
        }
    }
}

