/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db;

import codebase.Code4jni;
import codebase.Data4;
import codebase.Data4jni;
import codebase.Error4;
import codebase.Error4entry;
import codebase.Error4field;
import codebase.Error4file;
import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4relateMatch;
import codebase.Error4tagName;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4byteArray;
import codebase.Field4deleteFlag;
import codebase.Field4info;
import codebase.Field4stringBuffer;
import codebase.Tag4info;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJException;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.db.CRLFields;
import com.rsa.certj.provider.db.CertFields;
import com.rsa.certj.provider.db.Cl;
import com.rsa.certj.provider.db.Cm;
import com.rsa.certj.provider.db.KeyFields;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_SymmetricCipher;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public final class NativeDB
extends Provider {
    private static final String a = ".cdx";
    private static final String b = ".dbf";
    private static final String c = ".fpt";
    private static final char d = 'c';
    private static final char e = 'r';
    private static final char f = 'p';
    protected static final String SUBJECT_FIELD_NAME = "SUBJECT";
    protected static final String ISSUER_FIELD_NAME = "ISSUER";
    protected static final String SERIAL_FIELD_NAME = "SERIAL";
    protected static final String CERT_FIELD_NAME = "CERT";
    protected static final String CRL_ISSUER_FIELD_NAME = "ISSUER";
    protected static final String THIS_UPDATE_FIELD_NAME = "LAST";
    protected static final String CRL_FIELD_NAME = "CRL";
    protected static final String SPKI_FIELD_NAME = "SPKI";
    protected static final String KEY_FIELD_NAME = "KEY";
    protected static final String SALT_FIELD_NAME = "SALT";
    protected static final String IV_FIELD_NAME = "IV";
    private static final String g = "SUBJECT";
    private static final String h = "ISN";
    private static final String i = "ILU";
    private static final String j = "SPKI";
    private static final String k = ".NOT.DELETED()";
    private static final int l = 128;
    private static final int m = 128;
    private static final int n = 128;
    private static final int o = 32;
    private static final int p = 4;
    private static final int q = 20;
    private static final int r = 8;
    private static final int s = 8;
    private static final byte t = 0;
    private static final byte u = 1;
    private static final byte v = 2;
    private static final String w = "rsadb";
    private static final String x = "NAME";
    private static final String y = "ID";
    private static final String z = "NAME";
    private static final int aa = 7;
    private static final int ab = 32;
    private static final String ac = "PBE/SHA1/3DES_EDE/CBC/PKCS5V2PBE-1000-3";
    private static final long ad = 3L;
    private static Hashtable ae = new Hashtable();
    private static Hashtable af = new Hashtable();
    private static Code4jni ag = null;
    private static Object ah = new Object();
    File ai;
    String aj;
    char[] ak;
    boolean al;

    public static boolean create(String string, String string2) throws InvalidParameterException, DatabaseException {
        if (string == null) {
            throw new InvalidParameterException("NativeDB.create: pathString should not be null.");
        }
        return NativeDB.create(new File(string), string2);
    }

    public static boolean create(File file, String string) throws InvalidParameterException, DatabaseException {
        if (file == null) {
            throw new InvalidParameterException("NativeDB.create: path should not be null.");
        }
        if (string == null) {
            throw new InvalidParameterException("NativeDB.create: databaseName should not be null.");
        }
        return NativeDB.a(file, string);
    }

    public static boolean delete(String string, String string2) throws InvalidParameterException, DatabaseException {
        if (string == null) {
            throw new InvalidParameterException("NativeDB.delete: pathString should not be null.");
        }
        return NativeDB.delete(new File(string), string2);
    }

    public static boolean delete(File file, String string) throws InvalidParameterException, DatabaseException {
        if (file == null) {
            throw new InvalidParameterException("NativeDB.delete: path should not be null.");
        }
        if (string == null) {
            throw new InvalidParameterException("NativeDB.delete: databaseName should not be null.");
        }
        return NativeDB.b(file, string);
    }

    public static String[] listAllDatabaseNames(String string) throws InvalidParameterException, DatabaseException {
        if (string == null) {
            throw new InvalidParameterException("NativeDB.listAllDatabaseNames: pathString should not be null.");
        }
        return NativeDB.listAllDatabaseNames(new File(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] listAllDatabaseNames(File file) throws InvalidParameterException, DatabaseException {
        if (file == null) {
            throw new InvalidParameterException("NativeDB.listAllDatabaseNames: path should not be null.");
        }
        if (!file.exists()) {
            throw new DatabaseException("NativeDB.listAllDatabaseNames: no database in " + file.toString() + ".");
        }
        Code4jni code4jni = NativeDB.c();
        Object object = NativeDB.a(file);
        synchronized (object) {
            Data4jni data4jni = NativeDB.a(code4jni, file);
            try {
                NativeDB.e(data4jni);
                int n = data4jni.recCount();
                Vector<String> vector = new Vector<String>();
                Field4stringBuffer field4stringBuffer = new Field4stringBuffer((Data4)data4jni, "NAME");
                Field4stringBuffer field4stringBuffer2 = new Field4stringBuffer((Data4)data4jni, y);
                Field4deleteFlag field4deleteFlag = new Field4deleteFlag((Data4)data4jni);
                for (int i = 1; i <= n; ++i) {
                    data4jni.go(i);
                    if (field4deleteFlag.deleted) continue;
                    vector.addElement(NativeDB.b(field4stringBuffer.contents));
                }
                String[] stringArray = new String[vector.size()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)vector.elementAt(i);
                }
                String[] stringArray2 = stringArray;
                return stringArray2;
            }
            catch (IOException iOException) {
                throw new DatabaseException("NativeDB.listAllDatabaseNames: " + iOException.getMessage());
            }
            catch (Error4 error4) {
                throw new DatabaseException("NativeDB.listAllDatabaseNames: " + NativeDB.error4Message(error4));
            }
            finally {
                NativeDB.f(data4jni);
            }
        }
    }

    public NativeDB(String string, String string2, String string3, char[] cArray, boolean bl) throws InvalidParameterException, DatabaseException {
        super(1, string);
        if (string2 == null) {
            throw new InvalidParameterException("NativeDB.NativeDB: pathString should not be null.");
        }
        if (string3 == null) {
            throw new InvalidParameterException("NativeDB.NativeDB: databaseName should not be null.");
        }
        this.ai = new File(string2);
        this.aj = string3;
        this.ak = cArray;
        this.al = bl;
    }

    public NativeDB(String string, File file, String string2, char[] cArray, boolean bl) throws InvalidParameterException, DatabaseException {
        super(1, string);
        if (file == null) {
            throw new InvalidParameterException("NativeDB.NativeDB: path should not be null.");
        }
        if (string2 == null) {
            throw new InvalidParameterException("NativeDB.NativeDB: databaseName should not be null.");
        }
        this.ai = file;
        this.aj = string2;
        this.ak = cArray;
        this.al = bl;
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            boolean bl;
            if (this.al && !(bl = NativeDB.a(this.ai, this.aj))) {
                throw new ProviderManagementException("NativeDB.instantiate: creation of database failed. Check if the database already exists.If so, delete the database first if you want to create a new database with the same name, or create NativeDB with newDatabase being false if you want to use the existing database.");
            }
            return new Implementation(certJ, this.getName(), null);
        }
        catch (CertJException certJException) {
            throw new ProviderManagementException("NativeDB.instantiate: " + certJException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Code4jni c() throws DatabaseException {
        Object object = ah;
        synchronized (object) {
            if (ag != null) {
                return ag;
            }
            try {
                ag = new Code4jni();
            }
            catch (IOException iOException) {
                throw new DatabaseException("NativeDB.getCode4: Java Native Interface access failed. (" + iOException.getMessage() + ").");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new DatabaseException("NativeDB.getCode4: Java Native Interface access failed. You need to install NativeDB library for your platform. (" + unsatisfiedLinkError.getMessage() + ").");
            }
            ag.safety(false);
            try {
                ag.accessMode((byte)1);
            }
            catch (Error4usage error4usage) {
                throw new DatabaseException("NativeDB.getCode4: unable to get exclusive lock on database" + NativeDB.error4Message((Error4)((Object)error4usage)));
            }
            return ag;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String b(Code4jni code4jni, File file, String string) throws DatabaseException {
        Object object = NativeDB.a(file);
        synchronized (object) {
            Data4jni data4jni = NativeDB.a(code4jni, file);
            try {
                NativeDB.e(data4jni);
                Field4stringBuffer field4stringBuffer = new Field4stringBuffer((Data4)data4jni, y);
                int n = NativeDB.b(data4jni, string);
                if (n == 0) {
                    String string2 = null;
                    return string2;
                }
                data4jni.go(n);
                String string3 = field4stringBuffer.contents.toString();
                return string3;
            }
            catch (IOException iOException) {
                throw new DatabaseException("NativeDB.findExistingId: " + iOException.getMessage());
            }
            catch (Error4 error4) {
                throw new DatabaseException("NativeDB.findExistingId: " + NativeDB.error4Message(error4));
            }
            finally {
                NativeDB.f(data4jni);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String c(Code4jni code4jni, File file, String string) throws DatabaseException {
        if (NativeDB.b(code4jni, file, string) != null) {
            return null;
        }
        Object object = NativeDB.a(file);
        synchronized (object) {
            Data4jni data4jni = NativeDB.a(code4jni, file);
            try {
                NativeDB.e(data4jni);
                Field4byteArray field4byteArray = new Field4byteArray((Data4)data4jni, "NAME");
                Field4stringBuffer field4stringBuffer = new Field4stringBuffer((Data4)data4jni, y);
                Field4deleteFlag field4deleteFlag = new Field4deleteFlag((Data4)data4jni);
                int n = NativeDB.b(data4jni, string);
                if (n != 0) {
                    String string2 = null;
                    return string2;
                }
                data4jni.go(1);
                StringBuffer stringBuffer = field4stringBuffer.contents;
                n = NativeDB.d(data4jni);
                data4jni.go(n);
                StringBuffer stringBuffer2 = NativeDB.a(string);
                byte[] byArray = stringBuffer2.toString().getBytes();
                field4byteArray.contents = new byte[33];
                System.arraycopy(byArray, 0, field4byteArray.contents, 0, 32);
                field4byteArray.contents[32] = 0;
                field4stringBuffer.contents = stringBuffer;
                field4deleteFlag.deleted = false;
                data4jni.update();
                NativeDB.f(data4jni);
                data4jni.open(new File(file, w).toString());
                data4jni.go(1);
                field4stringBuffer.contents = NativeDB.a(stringBuffer);
                data4jni.update();
                String string3 = stringBuffer.toString();
                return string3;
            }
            catch (IOException iOException) {
                throw new DatabaseException("NativeDB.addDatabase: " + iOException.getMessage());
            }
            catch (Error4 error4) {
                throw new DatabaseException("NativeDB.addDatabase: " + NativeDB.error4Message(error4));
            }
            finally {
                NativeDB.f(data4jni);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String d(Code4jni code4jni, File file, String string) throws DatabaseException {
        Object object = NativeDB.a(file);
        synchronized (object) {
            Data4jni data4jni = NativeDB.a(code4jni, file);
            try {
                NativeDB.e(data4jni);
                Field4byteArray field4byteArray = new Field4byteArray((Data4)data4jni, "NAME");
                Field4stringBuffer field4stringBuffer = new Field4stringBuffer((Data4)data4jni, y);
                Field4deleteFlag field4deleteFlag = new Field4deleteFlag((Data4)data4jni);
                int n = NativeDB.b(data4jni, string);
                if (n == 0) {
                    String string2 = null;
                    return string2;
                }
                data4jni.go(n);
                String string3 = field4stringBuffer.contents.toString();
                data4jni.go(1);
                byte[] byArray = field4byteArray.contents;
                field4byteArray.contents = NativeDB.a(n);
                data4jni.update();
                data4jni.go(n);
                field4byteArray.contents = byArray;
                field4deleteFlag.deleted = true;
                data4jni.update();
                String string4 = string3;
                return string4;
            }
            catch (IOException iOException) {
                throw new DatabaseException("NativeDB.deleteDatabase: " + iOException.getMessage());
            }
            catch (Error4 error4) {
                throw new DatabaseException("NativeDB.deleteDatabase: " + NativeDB.error4Message(error4));
            }
            finally {
                NativeDB.f(data4jni);
            }
        }
    }

    private static Data4jni a(Code4jni code4jni, File file) throws DatabaseException {
        try {
            String string = new File(file, w).toString();
            Data4jni data4jni = new Data4jni(code4jni);
            try {
                data4jni.open(string);
            }
            catch (IOException iOException) {
                throw new DatabaseException("NativeDB.openMasterTable: " + iOException.getMessage());
            }
            catch (Error4 error4) {
                NativeDB.a(data4jni, string);
                data4jni.open(string);
            }
            NativeDB.c(data4jni);
            NativeDB.f(data4jni);
            data4jni.open(string);
            return data4jni;
        }
        catch (IOException iOException) {
            throw new DatabaseException("NativeDB.openMasterTable: " + iOException.getMessage());
        }
        catch (Error4 error4) {
            throw new DatabaseException("NativeDB.openMasterTable: " + NativeDB.error4Message(error4));
        }
    }

    private static void c(Data4jni data4jni) throws DatabaseException {
        try {
            Field4byteArray field4byteArray = new Field4byteArray((Data4)data4jni, "NAME");
            data4jni.go(1);
            byte[] byArray = new byte[4];
            System.arraycopy(field4byteArray.contents, 4, byArray, 0, 4);
            int n = NativeDB.b(byArray);
            if ((long)n != 3L) {
                throw new DatabaseException("NativeDB.checkSchemaVersion: schema version(" + n + ") is wrong(" + 3L + " is expected).");
            }
        }
        catch (IOException iOException) {
            throw new DatabaseException("NativeDB.checkSchemaVersion: " + iOException.getMessage());
        }
        catch (Error4 error4) {
            throw new DatabaseException("NativeDB.checkSchemaVersion: " + NativeDB.error4Message(error4));
        }
    }

    private static void a(Data4jni data4jni, String string) throws DatabaseException {
        try {
            Field4info field4info = new Field4info();
            Tag4info tag4info = new Tag4info();
            field4info.add("NAME", 'C', 33, 0, false);
            field4info.add(y, 'C', 7, 0, false);
            tag4info.add("NAME", "NAME", k, (byte)20, false);
            data4jni.create(string, field4info, tag4info);
            data4jni.blank();
            data4jni.append();
            Field4byteArray field4byteArray = new Field4byteArray((Data4)data4jni, "NAME");
            Field4stringBuffer field4stringBuffer = new Field4stringBuffer((Data4)data4jni, y);
            Field4deleteFlag field4deleteFlag = new Field4deleteFlag((Data4)data4jni);
            field4byteArray.contents = NativeDB.a(0);
            field4stringBuffer.contents = new StringBuffer("aaaaaaa");
            field4deleteFlag.deleted = true;
            data4jni.update();
            NativeDB.f(data4jni);
        }
        catch (IOException iOException) {
            throw new DatabaseException("NativeDB.createMasterFile: " + iOException.getMessage());
        }
        catch (Error4 error4) {
            throw new DatabaseException("NativeDB.createMasterFile: " + NativeDB.error4Message(error4));
        }
    }

    private static byte[] a(int n) {
        byte[] byArray = new byte[33];
        byte[] byArray2 = NativeDB.b(n);
        System.arraycopy(byArray2, 0, byArray, 0, 4);
        byArray2 = NativeDB.b(3L);
        System.arraycopy(byArray2, 0, byArray, 4, 4);
        for (int i = 8; i < 33; ++i) {
            byArray[i] = 32;
        }
        return byArray;
    }

    private static StringBuffer a(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer(new String(stringBuffer));
        for (int i = 0; i < 7; ++i) {
            char c = (char)(stringBuffer2.charAt(i) + '\u0001');
            if (c == '{') {
                stringBuffer2.setCharAt(i, '0');
                break;
            }
            if (c != ':') {
                stringBuffer2.setCharAt(i, c);
                break;
            }
            stringBuffer2.setCharAt(i, 'a');
        }
        return stringBuffer2;
    }

    private static int b(Data4jni data4jni, String string) throws DatabaseException {
        try {
            data4jni.select("NAME");
            int n = data4jni.seek(NativeDB.a(string).toString());
            if (n == 0) {
                return data4jni.recNo();
            }
            return 0;
        }
        catch (Error4 error4) {
            throw new DatabaseException("NativeDB.getMasterRecord: " + NativeDB.error4Message(error4));
        }
    }

    private static StringBuffer a(String string) {
        if (string.length() > 32) {
            return new StringBuffer(string.substring(0, 32));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < 32 - string.length(); ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer;
    }

    private static String b(StringBuffer stringBuffer) {
        int n = 0;
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            if (stringBuffer.charAt(i) == ' ') continue;
            n = i + 1;
            break;
        }
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return new String(cArray);
    }

    private static int d(Data4jni data4jni) throws DatabaseException {
        try {
            Field4byteArray field4byteArray = new Field4byteArray((Data4)data4jni, "NAME");
            data4jni.go(1);
            byte[] byArray = field4byteArray.contents;
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 0, byArray2, 0, 4);
            int n = NativeDB.b(byArray2);
            if (n == 0) {
                int n2 = 0;
                n2 = data4jni.bottom();
                if (n2 != 0 && n2 != 3) {
                    throw new DatabaseException("NativeDB.findAvailableMasterRecord: error in going to the bottom.");
                }
                data4jni.blank();
                data4jni.append();
                return data4jni.recNo();
            }
            data4jni.go(n);
            byte[] byArray3 = field4byteArray.contents;
            data4jni.go(1);
            field4byteArray.contents = byArray3;
            data4jni.update();
            return n;
        }
        catch (IOException iOException) {
            throw new DatabaseException("NativeDB.findAvailableMasterRecord: " + iOException.getMessage());
        }
        catch (Error4 error4) {
            throw new DatabaseException("NativeDB.findAvailableMasterRecord: " + NativeDB.error4Message(error4));
        }
    }

    private static String b(File file, String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(c);
        stringBuffer.append(string);
        return new File(file, stringBuffer.toString()).toString();
    }

    private static void b(String string) {
        boolean bl = true;
        File file = new File(string + a);
        if (file.exists() && (bl = file.delete())) {
            while (file.exists()) {
            }
        }
        if ((file = new File(string + b)).exists() && (bl = file.delete())) {
            while (file.exists()) {
            }
        }
        if ((file = new File(string + c)).exists() && (bl = file.delete())) {
            while (file.exists()) {
            }
        }
    }

    private static byte[] b(long l) {
        byte[] byArray = new byte[4];
        long l2 = l;
        for (int i = byArray.length - 1; i >= 0; --i) {
            byArray[i] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return byArray;
    }

    private static int b(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = byArray[i];
            if (n2 < 0) {
                n2 += 256;
            }
            n <<= 8;
            n |= n2;
        }
        return n;
    }

    private static boolean a(File file, String string) throws DatabaseException {
        Code4jni code4jni;
        String string2;
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new DatabaseException("NativeDB.createDatabase: unable to create directory " + file.toString() + ".");
            }
            while (!file.exists()) {
            }
        }
        if ((string2 = NativeDB.c(code4jni = NativeDB.c(), file, string)) == null) {
            return false;
        }
        Data4jni data4jni = null;
        try {
            data4jni = new Data4jni(code4jni);
        }
        catch (Error4 error4) {
            throw new DatabaseException("NativeDB.createDatabase: Creating each database with one deleted record failed." + NativeDB.error4Message(error4));
        }
        NativeDB.c(data4jni, NativeDB.b(file, string2, 'c'));
        NativeDB.d(data4jni, NativeDB.b(file, string2, 'r'));
        NativeDB.e(data4jni, NativeDB.b(file, string2, 'p'));
        return true;
    }

    private static void c(Data4jni data4jni, String string) throws DatabaseException {
        try {
            Field4info field4info = new Field4info();
            Tag4info tag4info = new Tag4info();
            field4info.add("SUBJECT", 'C', 128, 0, false);
            field4info.add("ISSUER", 'C', 128, 0, false);
            field4info.add(SERIAL_FIELD_NAME, 'C', 32, 0, false);
            field4info.add(CERT_FIELD_NAME, 'M', 1, 0, false);
            tag4info.add("SUBJECT", "SUBJECT", k, (byte)0, false);
            tag4info.add(h, "ISSUER+SERIAL", k, (byte)0, false);
            data4jni.create(string, field4info, tag4info);
            data4jni.blank();
            data4jni.append();
            CertFields certFields = new CertFields(data4jni);
            certFields.subject.contents = NativeDB.b(0L);
            certFields.issuer.contents = new byte[0];
            certFields.serial.contents = new byte[0];
            certFields.cert.contents = new byte[0];
            certFields.deleted.deleted = true;
            data4jni.update();
        }
        catch (IOException iOException) {
            throw new DatabaseException("NativeDB.createCertDatabase: " + iOException.getMessage());
        }
        catch (Error4 error4) {
            NativeDB.b(string);
            throw new DatabaseException("NativeDB.createCertDatabase: Creating a database with one deleted record failed." + NativeDB.error4Message(error4));
        }
        finally {
            NativeDB.f(data4jni);
        }
    }

    private static void d(Data4jni data4jni, String string) throws DatabaseException {
        try {
            Field4info field4info = new Field4info();
            Tag4info tag4info = new Tag4info();
            field4info.add("ISSUER", 'C', 128, 0, false);
            field4info.add(THIS_UPDATE_FIELD_NAME, 'C', 4, 0, false);
            field4info.add(CRL_FIELD_NAME, 'M', 1, 0, false);
            tag4info.add(i, "ISSUER+LAST", k, (byte)0, true);
            data4jni.create(string, field4info, tag4info);
            data4jni.blank();
            data4jni.append();
            CRLFields cRLFields = new CRLFields(data4jni);
            cRLFields.issuer.contents = NativeDB.b(0L);
            cRLFields.thisUpdate.contents = new byte[0];
            cRLFields.crl.contents = new byte[0];
            cRLFields.deleted.deleted = true;
            data4jni.update();
        }
        catch (IOException iOException) {
            throw new DatabaseException("NativeDB.createCRLDatabase: " + iOException.getMessage());
        }
        catch (Error4 error4) {
            NativeDB.b(string);
            throw new DatabaseException("NativeDB.createCRLDatabase: Creating a database with one deleted record failed." + NativeDB.error4Message(error4));
        }
        finally {
            NativeDB.f(data4jni);
        }
    }

    private static void e(Data4jni data4jni, String string) throws DatabaseException {
        try {
            Field4info field4info = new Field4info();
            Tag4info tag4info = new Tag4info();
            field4info.add("SPKI", 'C', 20, 0, false);
            field4info.add(SALT_FIELD_NAME, 'C', 8, 0, false);
            field4info.add(IV_FIELD_NAME, 'C', 8, 0, false);
            field4info.add(KEY_FIELD_NAME, 'M', 1, 0, false);
            tag4info.add("SPKI", "SPKI", k, (byte)20, true);
            data4jni.create(string, field4info, tag4info);
            data4jni.blank();
            data4jni.append();
            KeyFields keyFields = new KeyFields(data4jni);
            keyFields.spki.contents = NativeDB.b(0L);
            keyFields.salt.contents = new byte[0];
            keyFields.iv.contents = new byte[0];
            keyFields.key.contents = new byte[0];
            keyFields.deleted.deleted = true;
            data4jni.update();
        }
        catch (IOException iOException) {
            throw new DatabaseException("NativeDB.createKeyDatabase: " + iOException.getMessage());
        }
        catch (Error4 error4) {
            NativeDB.b(string);
            throw new DatabaseException("NativeDB.createKeyDatabase: Creating a database with one deleted record failed." + NativeDB.error4Message(error4));
        }
        finally {
            NativeDB.f(data4jni);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean b(File file, String string) throws DatabaseException {
        Data4jni data4jni;
        Data4jni data4jni2;
        Data4jni data4jni3;
        if (!file.exists()) {
            return false;
        }
        Code4jni code4jni = NativeDB.c();
        try {
            data4jni3 = new Data4jni(code4jni);
            data4jni2 = new Data4jni(code4jni);
            data4jni = new Data4jni(code4jni);
        }
        catch (Error4usage error4usage) {
            throw new DatabaseException("NativeDB.removeDatabase: unable to create Data4jni(" + NativeDB.error4Message((Error4)((Object)error4usage)) + ").");
        }
        String string2 = NativeDB.d(code4jni, file, string);
        if (string2 == null) {
            return false;
        }
        try {
            String string3 = NativeDB.b(file, string2, 'c');
            String string4 = NativeDB.b(file, string2, 'r');
            String string5 = NativeDB.b(file, string2, 'p');
            data4jni3.open(string3);
            NativeDB.e(data4jni3);
            data4jni2.open(string4);
            NativeDB.e(data4jni2);
            data4jni.open(string5);
            NativeDB.e(data4jni);
            NativeDB.b(string3);
            NativeDB.b(string4);
            NativeDB.b(string5);
            Hashtable hashtable = af;
            synchronized (hashtable) {
                af.remove(new File(file, string2));
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            throw new DatabaseException("NativeDB.removeDatabase: " + iOException.getMessage());
        }
        catch (Error4 error4) {
            throw new DatabaseException("NativeDB.removeDatabase: unable to delete database files" + NativeDB.error4Message(error4));
        }
        finally {
            NativeDB.f(data4jni3);
            NativeDB.f(data4jni2);
            NativeDB.f(data4jni);
        }
    }

    private static String a(Error4entry error4entry) {
        return "unable to position to a record entry";
    }

    private static String a(Error4field error4field) {
        return "unable to associate Field4 object with a database field";
    }

    private static String a(Error4file error4file) {
        return "unable to create or open file";
    }

    private static String a(Error4locked error4locked) {
        return "unable to lock an item that has been already locked";
    }

    private static String a(Error4message error4message) {
        return "unable to understand a server message";
    }

    private static String a(Error4relateMatch error4relateMatch) {
        return "unable to locate a slave record";
    }

    private static String a(Error4tagName error4tagName) {
        return "specified tag name is not open";
    }

    private static String a(Error4unexpected error4unexpected) {
        String string = error4unexpected.getMessage();
        String string2 = string.substring(16, string.length());
        int n = Integer.parseInt(string2, 10);
        if (n <= -400 && n >= -600) {
            return "expression evaluation error";
        }
        if (n <= -1300 && n >= -1400) {
            return "communication error";
        }
        if (n <= -2100 && n >= -2110) {
            return "server error";
        }
        switch (n) {
            case -10: {
                return "An error occurred while attempting to close a file.";
            }
            case -30: {
                return "An error occurred while attempting to determine the length of a file. This error occurs when CodeBase runs out of valid file handles. If you receive this error, reduce the number of files opened by your application at any given time.";
            }
            case -40: {
                return "An error occurred while setting the length of a file. This error occurs when an application does not have write access to the file or is out of disk space.";
            }
            case -70: {
                return "An error occurred while reading a file.";
            }
            case -80: {
                return "An error occurred while attempting to remove a file. This error will occur when the file is opened by another user or the current process, and an attempt is made to remove that file.";
            }
            case -90: {
                return "An error occurred while renaming a file. This error can be caused when the file name already exists.";
            }
            case -110: {
                return "An error occurred while unlocking part of a file.";
            }
            case -120: {
                return "An error occurred while writing to a file. This error can occur when the disk is full.";
            }
            case -200: {
                return "Database corruption detected. This error occurs when attempting to open a database that is not actually a true data file. If the file is a data file, its header and possibly its data is corrupt.";
            }
            case -220: {
                return "A data field had an unrecognized field type.";
            }
            case -230: {
                return "The total record length is too large. The maximum is 65534 bytes.";
            }
            case -250: {
                return "This error can occur if Data4.seek(double) tries to do a seek on a non-numeric tag.";
            }
            case -300: {
                return "A tag entry is missing. This error occurs when a key, corresponding to a database record, should be in a tag but is not.";
            }
            case -310: {
                return "An index corruption was detected.";
            }
            case -350: {
                return "An attempt to create an index failed because the Tag4info class contained invalid information.";
            }
            case -710: {
                return "A general CodeBase relation error was discovered.";
            }
            case -720: {
                return "CodeBase could not locate the master record's corresponding slave record.";
            }
            case -910: {
                return "CodeBase discovered an unexpected value in one of its internal variables.";
            }
            case -920: {
                return "CodeBase tried to allocate some memory from the heap but no memory was available.";
            }
            case -930: {
                return "A CodeBase method was passed an unexpected value.";
            }
            case -935: {
                return "A CodeBase method was passed a null value.";
            }
            case -940: {
                return "Exceeded maximum support due to demo version of CodeBase.";
            }
            case -950: {
                return "A CodeBase function returned an unexpected result to another CodeBase function.";
            }
            case -960: {
                return "Unexpected result while attempting to verify the integrity of a structure.";
            }
            case -970: {
                return "CodeBase internal structures have been detected as invalid.";
            }
            case -1090: {
                return "Operation generally not supported in this configuration.";
            }
            case -1095: {
                return "Version mismatch (e.g. client version mismatches server version).";
            }
            case -1110: {
                return "A memo file or entry is corrupt.";
            }
            case -1120: {
                return "Could not create memo file.";
            }
            case -1400: {
                return "The capabilities of CodeBase or the server have been maxed out. For example, the maximum allowable connections may have been exceeded by the server.";
            }
            case -1420: {
                return "The specified name was invalid or not found.";
            }
            case -1430: {
                return "The requested operation could not be performed because the requester has insufficient authority to perform the operation. For example, a user without creation privileges has made a call to Data4.create(java.lang.String, codebase.Field4info, codebase.Tag4info).";
            }
        }
        return "Unknown error code";
    }

    private static String a(Error4unique error4unique) {
        return "unable to add a duplicate key to a unique tag";
    }

    private static String b(Error4usage error4usage) {
        return "a CodeBase method is called in an incorrect manner";
    }

    protected static String error4Message(Error4 error4) throws DatabaseException {
        try {
            throw error4;
        }
        catch (Error4usage error4usage) {
            return NativeDB.b(error4usage);
        }
        catch (Error4unexpected error4unexpected) {
            return NativeDB.a(error4unexpected);
        }
        catch (Error4unique error4unique) {
            return NativeDB.a(error4unique);
        }
        catch (Error4locked error4locked) {
            return NativeDB.a(error4locked);
        }
        catch (Error4field error4field) {
            return NativeDB.a(error4field);
        }
        catch (Error4message error4message) {
            return NativeDB.a(error4message);
        }
        catch (Error4entry error4entry) {
            return NativeDB.a(error4entry);
        }
        catch (Error4file error4file) {
            return NativeDB.a(error4file);
        }
        catch (Error4tagName error4tagName) {
            return NativeDB.a(error4tagName);
        }
        catch (Error4relateMatch error4relateMatch) {
            return NativeDB.a(error4relateMatch);
        }
        catch (Error4 error42) {
            return "unknown CodeBase error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object a(File file) {
        Hashtable hashtable = ae;
        synchronized (hashtable) {
            Object object = ae.get(file);
            if (object == null) {
                object = new Object();
                ae.put(file, new Object());
            }
            return object;
        }
    }

    private static void e(Data4jni data4jni) throws DatabaseException {
        try {
            data4jni.lockAddAll();
            ag.lock();
        }
        catch (Error4 error4) {
            throw new DatabaseException("NativeDB.lock: " + NativeDB.error4Message(error4));
        }
    }

    private static void f(Data4jni data4jni) throws DatabaseException {
        try {
            data4jni.close();
        }
        catch (Error4 error4) {
            throw new DatabaseException("NativeDB.close: unable to close data4(" + NativeDB.error4Message(error4) + ").");
        }
    }

    private static JSAFE_SymmetricCipher b(byte[] byArray, byte[] byArray2, char[] cArray, boolean bl, CertJ certJ) throws DatabaseException {
        JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
        JSAFE_SecretKey jSAFE_SecretKey = null;
        try {
            jSAFE_SymmetricCipher = JSAFE_SymmetricCipher.getInstance((String)ac, (String)certJ.getDevice());
            jSAFE_SymmetricCipher.setIV(byArray2, 0, 8);
            jSAFE_SymmetricCipher.setSalt(byArray, 0, 8);
            jSAFE_SecretKey = jSAFE_SymmetricCipher.getBlankKey();
            jSAFE_SecretKey.setPassword(cArray, 0, cArray.length);
            if (bl) {
                jSAFE_SymmetricCipher.encryptInit(jSAFE_SecretKey, null);
            } else {
                jSAFE_SymmetricCipher.decryptInit(jSAFE_SecretKey, null);
            }
            return jSAFE_SymmetricCipher;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new DatabaseException("NativeDB.preparePBECipher: " + jSAFE_Exception.getMessage());
        }
    }

    static /* synthetic */ String a(Error4usage error4usage) {
        return NativeDB.b(error4usage);
    }

    static /* synthetic */ String a(File file, String string, char c) {
        return NativeDB.b(file, string, c);
    }

    static /* synthetic */ void a(Data4jni data4jni) throws DatabaseException {
        NativeDB.e(data4jni);
    }

    static /* synthetic */ void b(Data4jni data4jni) throws DatabaseException {
        NativeDB.f(data4jni);
    }

    static /* synthetic */ byte[] a(long l) {
        return NativeDB.b(l);
    }

    static /* synthetic */ int a(byte[] byArray) {
        return NativeDB.b(byArray);
    }

    private final class Implementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private int a = 0;
        private int b = 0;
        private int c = 0;
        private Object d = new Object();
        private Object e = new Object();
        private Object f = new Object();
        private Cm g;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Implementation(CertJ certJ, String string) throws InvalidParameterException, DatabaseException {
            super(certJ, string);
            String string2 = NativeDB.b(NativeDB.c(), NativeDB.this.ai, NativeDB.this.aj);
            if (string2 == null) {
                throw new DatabaseException("NativeDB$Implementation.Implementation: database named " + NativeDB.this.aj + " does not exist in " + NativeDB.this.ai.toString() + ".");
            }
            Hashtable hashtable = af;
            synchronized (hashtable) {
                File file = new File(NativeDB.this.ai, string2);
                this.g = (Cm)af.get(file);
                if (this.g == null) {
                    this.g = new Cm(NativeDB.this, NativeDB.this.ai, string2, null);
                    af.put(file, this.g);
                }
            }
        }

        public void insertCertificate(Certificate certificate) throws NotSupportedException, DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("NativeDB$Implementation.insertCertificate: certificate should not be null.");
            }
            if (!(certificate instanceof X509Certificate)) {
                throw new DatabaseException("NativeDB$Implementation.insertCertificate: certificate should be an instance of X509Certificate.");
            }
            X509Certificate x509Certificate = (X509Certificate)certificate;
            byte[] byArray = this.a(x509Certificate.getSubjectName(), 128);
            byte[] byArray2 = this.a(x509Certificate.getIssuerName(), 128);
            byte[] byArray3 = this.a(x509Certificate.getSerialNumber());
            byte[] byArray4 = this.a(x509Certificate.getIssuerName(), x509Certificate.getSerialNumber());
            byte[] byArray5 = new byte[x509Certificate.getDERLen(0)];
            try {
                x509Certificate.getDEREncoding(byArray5, 0, 0);
            }
            catch (CertificateException certificateException) {
                throw new NotSupportedException("NativeDB$Implementation.insertCertificate: unable to encode the given certificate(" + certificateException.getMessage() + ").");
            }
            Cm.a(this.g, x509Certificate, byArray4, byArray, byArray2, byArray3, byArray5);
        }

        public void insertCRL(CRL cRL) throws NotSupportedException, DatabaseException {
            if (cRL == null) {
                throw new DatabaseException("NativeDB$Implementation.insertCRL: genericCRL should not be null.");
            }
            if (!(cRL instanceof X509CRL)) {
                throw new DatabaseException("NativeDB$Implementation.insertCRL: genericCRL should be an instance of X509CRL.");
            }
            X509CRL x509CRL = (X509CRL)cRL;
            byte[] byArray = this.a(x509CRL.getIssuerName(), 128);
            byte[] byArray2 = this.a(x509CRL.getThisUpdate(), 4);
            byte[] byArray3 = new byte[x509CRL.getDERLen(0)];
            try {
                x509CRL.getDEREncoding(byArray3, 0, 0);
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("NativeDB$Implementation.insertCRL: " + certificateException.getMessage());
            }
            byte[] byArray4 = this.a(x509CRL.getIssuerName(), x509CRL.getThisUpdate());
            Cm.a(this.g, x509CRL, byArray4, byArray, byArray2, byArray3);
        }

        public void insertPrivateKeyByCertificate(Certificate certificate, JSAFE_PrivateKey jSAFE_PrivateKey) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("NativeDB$Implementation.insertPrivateKeyByCertificate: cert should not be null.");
            }
            try {
                this.insertPrivateKeyByPublicKey(certificate.getSubjectPublicKey(this.certJ.getDevice()), jSAFE_PrivateKey);
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("NativeDB$Implementation.insertPrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws DatabaseException {
            JSAFE_SecureRandom jSAFE_SecureRandom;
            if (jSAFE_PublicKey == null || jSAFE_PrivateKey == null) {
                throw new DatabaseException("NativeDB$Implementation.insertPrivateKeyByPublicKey: neither publicKey nor key should be null.");
            }
            byte[] byArray = this.a(jSAFE_PublicKey, this.certJ);
            byte[] byArray2 = new byte[8];
            byte[] byArray3 = new byte[8];
            try {
                jSAFE_SecureRandom = this.certJ.getRandomObject();
            }
            catch (CertJException certJException) {
                throw new DatabaseException("NativeDB$Implementation.insertPrivateKey: random provider is not available in certJ(" + certJException.getMessage() + ").");
            }
            jSAFE_SecureRandom.nextBytes(byArray2);
            jSAFE_SecureRandom.nextBytes(byArray3);
            byte[] byArray4 = this.a(jSAFE_PrivateKey, byArray2, byArray3, NativeDB.this.ak, this.certJ);
            Cm.a(this.g, jSAFE_PublicKey, byArray, byArray2, byArray3, byArray4, NativeDB.this.ak, this.certJ);
        }

        public int selectCertificateByIssuerAndSerialNumber(X500Name x500Name, byte[] byArray, Vector vector) throws DatabaseException {
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("NativeDB$Implementation.selectCertificateByIssuerAndSerialNumber: neither issuerName nor serialNumber should be null.");
            }
            byte[] byArray2 = this.a(x500Name, byArray);
            return Cm.a(this.g, x500Name, byArray, byArray2, vector);
        }

        public int selectCertificateBySubject(X500Name x500Name, Vector vector) throws DatabaseException {
            if (x500Name == null) {
                throw new DatabaseException("NativeDB$Implementation.selectCertificateBySubject: subjectName should not be null.");
            }
            byte[] byArray = this.a(x500Name, 128);
            return Cm.a(this.g, x500Name, byArray, vector);
        }

        public int selectCertificateByExtensions(X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws DatabaseException {
            if (x500Name == null && x509V3Extensions == null) {
                throw new DatabaseException("NativeDB.selectCertificateByExtensions: either baseName or extensions should have a non-null value.");
            }
            return Cm.a(this.g, x500Name, x509V3Extensions, vector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCertificateIteratorSetup() {
            Object object = this.d;
            synchronized (object) {
                return this.a != 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCertificateIterator() {
            Object object = this.d;
            synchronized (object) {
                this.a = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Certificate firstCertificate() throws DatabaseException {
            Object object = this.d;
            synchronized (object) {
                this.setupCertificateIterator();
                try {
                    return this.nextCertificate();
                }
                catch (DatabaseException databaseException) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Certificate nextCertificate() throws DatabaseException {
            Object object = this.d;
            synchronized (object) {
                Certificate certificate;
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                this.a = (certificate = Cm.a(this.g, this)) == null ? 0 : ++this.a;
                return certificate;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCertificates() throws DatabaseException {
            Object object = this.d;
            synchronized (object) {
                Certificate certificate;
                if (!this.isCertificateIteratorSetup()) {
                    this.setupCertificateIterator();
                }
                boolean bl = (certificate = Cm.a(this.g, this)) != null;
                return bl;
            }
        }

        public int selectCRLByIssuerAndTime(X500Name x500Name, Date date, Vector vector) throws DatabaseException {
            if (x500Name == null || date == null) {
                throw new DatabaseException("NativeDB$Implementation.selectCRLByIssuerAndTime: neither issuerName nor time should be nulll.");
            }
            byte[] byArray = this.a(x500Name, 128);
            return Cm.a(this.g, x500Name, date, byArray, vector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCRLIteratorSetup() {
            Object object = this.e;
            synchronized (object) {
                return this.b != 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCRLIterator() {
            Object object = this.e;
            synchronized (object) {
                this.b = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CRL firstCRL() throws DatabaseException {
            Object object = this.e;
            synchronized (object) {
                this.setupCRLIterator();
                try {
                    return this.nextCRL();
                }
                catch (DatabaseException databaseException) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CRL nextCRL() throws DatabaseException {
            Object object = this.e;
            synchronized (object) {
                CRL cRL;
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                this.b = (cRL = Cm.b(this.g, this)) == null ? 0 : ++this.b;
                return cRL;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMoreCRLs() throws DatabaseException {
            Object object = this.e;
            synchronized (object) {
                CRL cRL;
                if (!this.isCRLIteratorSetup()) {
                    this.setupCRLIterator();
                }
                boolean bl = (cRL = Cm.b(this.g, this)) != null;
                return bl;
            }
        }

        public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate certificate) throws NotSupportedException, DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("NativeDB$Implementation.selectPrivateKeyByCertificate: cert should not be null.");
            }
            try {
                return this.selectPrivateKeyByPublicKey(certificate.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("NativeDB$Implementation.selectPrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws DatabaseException {
            if (jSAFE_PublicKey == null) {
                throw new DatabaseException("NativeDB$Implementation.selectPrivateKeyByPublicKey: publicKey should not be null.");
            }
            byte[] byArray = this.a(jSAFE_PublicKey, this.certJ);
            return Cm.a(this.g, byArray, NativeDB.this.ak, this.certJ);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPrivateKeyIteratorSetup() {
            Object object = this.f;
            synchronized (object) {
                return this.c != 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupPrivateKeyIterator() {
            Object object = this.f;
            synchronized (object) {
                this.c = 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey firstPrivateKey() throws DatabaseException {
            Object object = this.f;
            synchronized (object) {
                this.setupPrivateKeyIterator();
                try {
                    return this.nextPrivateKey();
                }
                catch (DatabaseException databaseException) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey nextPrivateKey() throws DatabaseException {
            Object object = this.f;
            synchronized (object) {
                JSAFE_PrivateKey jSAFE_PrivateKey;
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                this.c = (jSAFE_PrivateKey = Cm.a(this.g, this, this.certJ, NativeDB.this.ak)) == null ? 0 : ++this.c;
                return jSAFE_PrivateKey;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasMorePrivateKeys() throws DatabaseException {
            Object object = this.f;
            synchronized (object) {
                JSAFE_PrivateKey jSAFE_PrivateKey;
                if (!this.isPrivateKeyIteratorSetup()) {
                    this.setupPrivateKeyIterator();
                }
                boolean bl = (jSAFE_PrivateKey = Cm.a(this.g, this, this.certJ, NativeDB.this.ak)) != null;
                return bl;
            }
        }

        public void deleteCertificate(X500Name x500Name, byte[] byArray) throws DatabaseException {
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("NativeDB$Implementation.deleteCertificate: neither issuerName nor serialNumber is null.");
            }
            byte[] byArray2 = this.a(x500Name, byArray);
            Cm.a(this.g, x500Name, byArray, byArray2);
        }

        public void deleteCRL(X500Name x500Name, Date date) throws NotSupportedException, DatabaseException {
            if (x500Name == null || date == null) {
                throw new DatabaseException("NativeDB$Implementation.deleteCRL: neither issuerName nor lastUpdate should be null.");
            }
            byte[] byArray = this.a(x500Name, date);
            Cm.a(this.g, x500Name, date, byArray);
        }

        public void deletePrivateKeyByCertificate(Certificate certificate) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("NativeDB$Implementation.deletePrivateKeyByCertificate: cert should not be null.");
            }
            try {
                this.deletePrivateKeyByPublicKey(certificate.getSubjectPublicKey(this.certJ.getDevice()));
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("NativeDB$Implementation.deletePrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws DatabaseException {
            if (jSAFE_PublicKey == null) {
                throw new DatabaseException("NativeDB$Implementation.deletePrivateKeyByCertificate: publicKey should not be null.");
            }
            byte[] byArray = this.a(jSAFE_PublicKey, this.certJ);
            Cm.b(this.g, byArray, NativeDB.this.ak, this.certJ);
        }

        public String toString() {
            return "NativeDB database provider named: " + super.getName();
        }

        private byte[] a(X500Name x500Name, int n) {
            int n2 = n;
            if (n == 0) {
                n2 = 128;
            }
            String string = x500Name.toString(false);
            string = string.toUpperCase();
            byte[] byArray = new byte[n2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            byte[] byArray2 = string.getBytes();
            if (string.length() < n2) {
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            } else {
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
            return byArray;
        }

        private byte[] a(byte[] byArray) {
            int n;
            byte[] byArray2 = new byte[32];
            for (n = 0; n < 32; ++n) {
                byArray2[n] = 0;
            }
            if (byArray.length < 32) {
                for (n = 0; n < byArray.length; ++n) {
                    byArray2[n] = byArray[n];
                }
            } else {
                for (n = 0; n < 32; ++n) {
                    byArray2[n] = byArray[n];
                }
            }
            return byArray2;
        }

        private byte[] a(X500Name x500Name, byte[] byArray) {
            byte[] byArray2 = new byte[160];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = 0;
            }
            byte[] byArray3 = this.a(x500Name, 0);
            if (byArray3.length < 128) {
                System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            } else {
                System.arraycopy(byArray3, 0, byArray2, 0, 128);
            }
            if (byArray.length < 32) {
                System.arraycopy(byArray, 0, byArray2, 128, byArray.length);
            } else {
                System.arraycopy(byArray, 0, byArray2, 128, 32);
            }
            return byArray2;
        }

        private byte[] a(X500Name x500Name, Date date) {
            byte[] byArray = new byte[132];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            byte[] byArray2 = this.a(x500Name, 128);
            if (byArray2.length < 128) {
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            } else {
                System.arraycopy(byArray2, 0, byArray, 0, 128);
            }
            byte[] byArray3 = this.a(date, 4);
            System.arraycopy(byArray3, 0, byArray, 128, 4);
            return byArray;
        }

        private byte[] a(Date date, int n) {
            long l = date.getTime() / 1000L;
            byte[] byArray = new byte[n];
            for (int i = n - 1; i >= 0; --i) {
                byArray[i] = (byte)l;
                l >>= 8;
            }
            return byArray;
        }

        private byte[] a(JSAFE_PublicKey jSAFE_PublicKey, CertJ certJ) throws DatabaseException {
            JSAFE_MessageDigest jSAFE_MessageDigest = null;
            try {
                byte[][] byArray = jSAFE_PublicKey.getKeyData(jSAFE_PublicKey.getAlgorithm() + "PublicKeyBER");
                byte[] byArray2 = byArray[0];
                int n = byArray2.length;
                jSAFE_MessageDigest = JSAFE_MessageDigest.getInstance((String)"SHA1", (String)certJ.getDevice());
                byte[] byArray3 = jSAFE_MessageDigest.getDERAlgorithmID();
                byte[] byArray4 = new byte[jSAFE_MessageDigest.getDigestSize()];
                jSAFE_MessageDigest.digestInit();
                int n2 = 64;
                for (int i = 0; i < n; i += n2) {
                    jSAFE_MessageDigest.digestUpdate(byArray2, i, n - i > n2 ? n2 : n - i);
                }
                int n3 = jSAFE_MessageDigest.digestFinal(byArray4, 0);
                byte[] byArray5 = byArray4;
                return byArray5;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new DatabaseException("NativeDB$Implementation.encodeSpki: " + jSAFE_Exception.getMessage());
            }
            finally {
                if (jSAFE_MessageDigest != null) {
                    jSAFE_MessageDigest.clearSensitiveData();
                }
            }
        }

        private byte[] a(JSAFE_PrivateKey jSAFE_PrivateKey, byte[] byArray, byte[] byArray2, char[] cArray, CertJ certJ) throws DatabaseException {
            byte[][] byArray3;
            Object object;
            byte by = 0;
            try {
                object = jSAFE_PrivateKey.getAlgorithm();
                if (((String)object).equals("RSA")) {
                    by = 0;
                } else if (((String)object).equals("DSA")) {
                    by = 1;
                } else {
                    throw new DatabaseException("NativeDB$Implementation.encryptPrivateKey: unknown private key type(" + (String)object + ").");
                }
                byArray3 = jSAFE_PrivateKey.getKeyData((String)object + "PrivateKeyBER");
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new DatabaseException("NativeDB$Implementation.encryptPrivateKey: private key operation failed(" + jSAFE_Exception.getMessage() + ".)");
            }
            object = this.a(byArray3[0], byArray, byArray2, cArray, certJ);
            byte[] byArray4 = new byte[((Object)object).length + 1];
            System.arraycopy(object, 0, byArray4, 1, ((Object)object).length);
            byArray4[0] = by;
            return byArray4;
        }

        private byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3, char[] cArray, CertJ certJ) throws DatabaseException {
            byte[] byArray4 = new byte[byArray.length + 8];
            JSAFE_SymmetricCipher jSAFE_SymmetricCipher = null;
            try {
                jSAFE_SymmetricCipher = NativeDB.b(byArray2, byArray3, cArray, true, certJ);
                int n = jSAFE_SymmetricCipher.encryptUpdate(byArray, 0, byArray.length, byArray4, 0);
                n += jSAFE_SymmetricCipher.encryptFinal(byArray4, n);
                byte[] byArray5 = new byte[n];
                System.arraycopy(byArray4, 0, byArray5, 0, n);
                byte[] byArray6 = byArray5;
                return byArray6;
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new DatabaseException("NativeDB$Implementation.pbeEncrypt: PBE encryption failed(" + jSAFE_Exception.getMessage() + ").");
            }
            finally {
                if (jSAFE_SymmetricCipher != null) {
                    jSAFE_SymmetricCipher.clearSensitiveData();
                }
            }
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Cl cl) throws InvalidParameterException, DatabaseException {
            this(certJ, string);
        }

        static /* synthetic */ int a(Implementation implementation) {
            return implementation.a;
        }

        static /* synthetic */ int b(Implementation implementation) {
            return implementation.a++;
        }

        static /* synthetic */ int c(Implementation implementation) {
            return implementation.a--;
        }

        static /* synthetic */ int d(Implementation implementation) {
            return implementation.b;
        }

        static /* synthetic */ int e(Implementation implementation) {
            return implementation.b++;
        }

        static /* synthetic */ int f(Implementation implementation) {
            return implementation.b--;
        }

        static /* synthetic */ int g(Implementation implementation) {
            return implementation.c;
        }

        static /* synthetic */ int h(Implementation implementation) {
            return implementation.c++;
        }

        static /* synthetic */ int i(Implementation implementation) {
            return implementation.c--;
        }
    }
}

