/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.db.pkcs11;

import com.rsa.certj.CertJ;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.provider.db.pkcs11.Co;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PKCS11SessionSpec;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Session;
import com.rsa.jsafe.JSAFE_SessionSpec;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.util.Date;
import java.util.Vector;

public final class PKCS11DB
extends Provider {
    private byte[] a = null;
    private byte[] b = new byte[4];
    private JSAFE_Session c = null;
    private boolean d = false;

    public PKCS11DB(String string, JSAFE_Session jSAFE_Session) throws InvalidParameterException {
        super(1, string);
        if (jSAFE_Session == null) {
            throw new InvalidParameterException("Passed in session is null.");
        }
        this.c = jSAFE_Session;
        this.a(string, jSAFE_Session);
    }

    public PKCS11DB(String string, JSAFE_PKCS11SessionSpec jSAFE_PKCS11SessionSpec) throws InvalidParameterException {
        super(1, string);
        if (jSAFE_PKCS11SessionSpec == null) {
            throw new InvalidParameterException("Spec is null.");
        }
        try {
            this.c = JSAFE_Session.getInstance((JSAFE_SessionSpec)jSAFE_PKCS11SessionSpec);
            this.d = true;
            this.a(string, this.c);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new InvalidParameterException("Cannot create PKCS#11 session. " + jSAFE_Exception.getMessage());
        }
    }

    public PKCS11DB(String string, String string2, String string3, char[] cArray, int n, int n2) throws InvalidParameterException {
        super(1, string);
        try {
            JSAFE_PKCS11SessionSpec jSAFE_PKCS11SessionSpec = new JSAFE_PKCS11SessionSpec(string2, string3, cArray, n, n2);
            this.c = JSAFE_Session.getInstance((JSAFE_SessionSpec)jSAFE_PKCS11SessionSpec);
            this.d = true;
            this.a(string, this.c);
            jSAFE_PKCS11SessionSpec.clearSensitiveData();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new InvalidParameterException("Cannot create PKCS#11 session. " + jSAFE_Exception.getMessage());
        }
    }

    private void a(String string, JSAFE_Session jSAFE_Session) throws InvalidParameterException {
        if (jSAFE_Session == null) {
            throw new InvalidParameterException("Passed in session is null.");
        }
        JSAFE_SessionSpec jSAFE_SessionSpec = jSAFE_Session.getSessionSpec();
        if (jSAFE_SessionSpec == null) {
            throw new InvalidParameterException("Passed in session does not contain spec.");
        }
        byte[] byArray = ((JSAFE_PKCS11SessionSpec)jSAFE_SessionSpec).getSessionHandle(jSAFE_Session);
        if (byArray == null) {
            throw new InvalidParameterException("Invalid PKCS#11 session: sessionHandle is null.");
        }
        byte[] byArray2 = ((JSAFE_PKCS11SessionSpec)jSAFE_SessionSpec).getCryptokiFunctions(jSAFE_Session);
        if (byArray2 == null) {
            throw new InvalidParameterException("Invalid PKCS#11 session: cryptoki function list is null.");
        }
        this.a = this.nativeInitCertCtx(string, byArray, byArray2, this.b);
        if (this.a == null) {
            throw new InvalidParameterException("PKCS11DB: cannot create provider.");
        }
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new PKCS11DBImplementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("PKCS11DB.instantiate: " + invalidParameterException.getMessage());
        }
    }

    public String toString() {
        return "PKCS11 database provider named: " + super.getName();
    }

    private native int nativeInsertCertificate(byte[] var1, byte[] var2, byte[] var3);

    private native byte[] nativeInitCertCtx(String var1, byte[] var2, byte[] var3, byte[] var4);

    private native int nativeInsertPrivateKey(byte[] var1, byte[] var2, byte[] var3);

    private native byte[][] nativeSelectCertByIssuerSerial(byte[] var1, byte[] var2, byte[] var3);

    private native byte[][] nativeSelectCertBySubject(byte[] var1, byte[] var2);

    private native byte[][] nativeSelectCertByExtensions(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private native byte[][] nativeSelectPrivateKey(byte[] var1, byte[] var2);

    private native byte[] nativeFirstCertificate(byte[] var1, byte[] var2);

    private native byte[] nativeNextCertificate(byte[] var1, byte[] var2);

    private native int nativeDeleteCert(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    private native byte[][] nativeFirstPrivateKey(byte[] var1, byte[] var2);

    private native byte[][] nativeNextPrivateKey(byte[] var1, byte[] var2);

    private native int nativeDeletePrivateKey(byte[] var1, byte[] var2);

    private native void nativeFinalizeSession(byte[] var1, byte[] var2);

    static /* synthetic */ byte[] a(PKCS11DB pKCS11DB, byte[] byArray) {
        pKCS11DB.a = byArray;
        return byArray;
    }

    static /* synthetic */ byte[] b(PKCS11DB pKCS11DB, byte[] byArray) {
        pKCS11DB.b = byArray;
        return byArray;
    }

    static {
        System.loadLibrary("certJpkcs11");
    }

    private final class PKCS11DBImplementation
    extends ProviderImplementation
    implements DatabaseInterface {
        private Object a = new Object();
        private Object b = new Object();
        private Object c = new Object();
        private Object d = new Object();
        private byte[] e = null;
        private byte[] f = null;

        private PKCS11DBImplementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertCertificate(Certificate certificate) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("PKCS11DBProvider.insertCertificate: cert should not be null.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.insertCertificate: Session is not open. Cert-C DB Provider is not initialized.");
            }
            if (PKCS11DB.this.b == null) {
                throw new DatabaseException("PKCS11DBProvider.insertCertificate: Session is not open.Cert-C context object is not initialized.");
            }
            X500Name x500Name = ((X509Certificate)certificate).getIssuerName();
            byte[] byArray = ((X509Certificate)certificate).getSerialNumber();
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("PKCS11DBProvider.insertCertificate: invalid certificate.IssuerName or SerialNumber is null.");
            }
            Vector vector = new Vector();
            try {
                int n = ((X509Certificate)certificate).getDERLen(0);
                if (n == 0) {
                    throw new DatabaseException("PKCS11DBProvider.insertCertificate: invalid certificate.Cannot DER-encode certificate.");
                }
                byte[] byArray2 = new byte[n];
                if ((n = ((X509Certificate)certificate).getDEREncoding(byArray2, 0, 0)) == 0) {
                    throw new DatabaseException("PKCS11DBProvider.insertCertificate: invalid certificate.Cannot DER-encode certificate.");
                }
                Object object = this.a;
                synchronized (object) {
                    if (PKCS11DB.this.nativeInsertCertificate(byArray2, PKCS11DB.this.a, PKCS11DB.this.b) != 0) {
                        throw new DatabaseException("PKCS11DBProvider.insertCertificate: unable to insert certificate");
                    }
                }
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("PKCS11DBProvider.insertCertificate: invalid certificate" + certificateException.getMessage());
            }
        }

        public void insertCRL(CRL cRL) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException("insertCRL method is not supported by PKCS11DB provider.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertPrivateKeyByCertificate(Certificate certificate, JSAFE_PrivateKey jSAFE_PrivateKey) throws DatabaseException {
            if (certificate == null || jSAFE_PrivateKey == null) {
                throw new DatabaseException("PKCS11DBImplementation.insertPrivateKeyByCertificate: cert and private key should not be null");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKey: Session is not open.");
            }
            Object object = this.b;
            synchronized (object) {
                if (this.selectPrivateKeyByCertificate(certificate) != null) {
                    return;
                }
            }
            try {
                object = this.a(jSAFE_PrivateKey);
                byte[] byArray = certificate.getSubjectPublicKeyBER();
                if (byArray == null) {
                    throw new DatabaseException("PKCS11DBImplementation.insertPrivateKeyByCertificate: Public key in certificate is null.");
                }
                Object object2 = this.b;
                synchronized (object2) {
                    if (PKCS11DB.this.nativeInsertPrivateKey(byArray, (byte[])object, PKCS11DB.this.a) != 0) {
                        throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByCertificate: unable to insert private key");
                    }
                }
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("PKCS11DBImplementation.insertPrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        private byte[] a(JSAFE_PrivateKey jSAFE_PrivateKey) throws DatabaseException {
            byte[][] byArray = null;
            try {
                int n;
                String[] stringArray = jSAFE_PrivateKey.getSupportedGetFormats();
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].equals("RSAPrivateKeyBER") && !stringArray[n].equals("DSAPrivateKeyBER") && !stringArray[n].equals("DSAPrivateKeyX957BER")) continue;
                    byArray = jSAFE_PrivateKey.getKeyData(stringArray[n]);
                    break;
                }
                if (n == stringArray.length) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByCertificate: cannot get private key BER data.");
                }
                if (byArray == null || byArray.length == 0 || byArray[0] == null) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByCertificate: cannot get private key data");
                }
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByCertificate: " + jSAFE_UnimplementedException.getMessage());
            }
            return byArray[0];
        }

        private byte[] a(JSAFE_PublicKey jSAFE_PublicKey) throws DatabaseException {
            byte[][] byArray = null;
            try {
                int n;
                String[] stringArray = jSAFE_PublicKey.getSupportedGetFormats();
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].equals("RSAPublicKeyBER") && !stringArray[n].equals("DSAPublicKeyBER") && !stringArray[n].equals("DSAPublicKeyX957BER")) continue;
                    byArray = jSAFE_PublicKey.getKeyData(stringArray[n]);
                    break;
                }
                if (n == stringArray.length) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByPublicKey: cannot get public key BER data.");
                }
                if (byArray == null || byArray.length == 0 || byArray[0] == null) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByPublicKey: cannot get public key data.");
                }
            }
            catch (JSAFE_UnimplementedException jSAFE_UnimplementedException) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByPublicKey: " + jSAFE_UnimplementedException.getMessage());
            }
            return byArray[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey, JSAFE_PrivateKey jSAFE_PrivateKey) throws DatabaseException {
            if (jSAFE_PublicKey == null || jSAFE_PrivateKey == null) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByPublicKey: Neither publicKey nor privateKey should be null.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.insertPrivateKey: Session is not open.");
            }
            Object object = this.b;
            synchronized (object) {
                if (this.selectPrivateKeyByPublicKey(jSAFE_PublicKey) != null) {
                    return;
                }
            }
            object = this.a(jSAFE_PrivateKey);
            byte[] byArray = this.a(jSAFE_PublicKey);
            Object object2 = this.b;
            synchronized (object2) {
                if (PKCS11DB.this.nativeInsertPrivateKey(byArray, (byte[])object, PKCS11DB.this.a) != 0) {
                    throw new DatabaseException("PKCS11DBProvider.insertPrivateKeyByPublicKey: unable to insert private key");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateByIssuerAndSerialNumber(X500Name x500Name, byte[] byArray, Vector vector) throws DatabaseException {
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("PKCS11DBProvider.Neither issuerName nor serialNumber should be null.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.selectCertificate: Session is not open.");
            }
            byte[] byArray2 = new byte[x500Name.getDERLen(0)];
            try {
                if (x500Name.getDEREncoding(byArray2, 0, 0) == 0) {
                    throw new DatabaseException("PKCS11DBProvider: Invalid IssuerName. Cannot DER-encode IssuerName.");
                }
            }
            catch (NameException nameException) {
                throw new DatabaseException("PKCS11DBProvider: Invalid IssuerName " + nameException.getMessage());
            }
            byte[][] byArray3 = null;
            Object object = this.a;
            synchronized (object) {
                byArray3 = PKCS11DB.this.nativeSelectCertByIssuerSerial(byArray2, byArray, PKCS11DB.this.a);
            }
            if (byArray3 == null) {
                return 0;
            }
            int n = 0;
            try {
                for (int i = 0; i < byArray3.length; ++i) {
                    X509Certificate x509Certificate = new X509Certificate(byArray3[i], 0, 0);
                    if (vector.contains(x509Certificate)) continue;
                    vector.addElement(x509Certificate);
                    ++n;
                }
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("PKCS11DBProvider: Invalid certificate." + certificateException.getMessage());
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateBySubject(X500Name x500Name, Vector vector) throws DatabaseException {
            if (x500Name == null) {
                throw new DatabaseException("PKCS11DBProvider.selectCertificateBySubject: subjectName should not be null.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.selectCertificate: Session is not open.");
            }
            byte[] byArray = new byte[x500Name.getDERLen(0)];
            try {
                if (x500Name.getDEREncoding(byArray, 0, 0) == 0) {
                    throw new DatabaseException("PKCS11DBProvider: Invalid SubjectName. Cannot DER-encode SubjectName.");
                }
            }
            catch (NameException nameException) {
                throw new DatabaseException("PKCS11DBProvider: Invalid SubjectName " + nameException.getMessage());
            }
            byte[][] byArray2 = null;
            Object object = this.a;
            synchronized (object) {
                byArray2 = PKCS11DB.this.nativeSelectCertBySubject(byArray, PKCS11DB.this.a);
            }
            if (byArray2 == null) {
                return 0;
            }
            int n = 0;
            try {
                for (int i = 0; i < byArray2.length; ++i) {
                    X509Certificate x509Certificate = new X509Certificate(byArray2[i], 0, 0);
                    if (vector.contains(x509Certificate)) continue;
                    vector.addElement(x509Certificate);
                    ++n;
                }
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("PKCS11DBProvider: Invalid certificate." + certificateException.getMessage());
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int selectCertificateByExtensions(X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws DatabaseException {
            if (x500Name == null || x509V3Extensions == null) {
                throw new DatabaseException("PKCS11DBProvider.selectCertificateByExtensions: Either baseName or extensions should have a non-null value.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.selectCertificate: Session is not open.");
            }
            if (PKCS11DB.this.b == null) {
                throw new DatabaseException("PKCS11DBProvider.selectCertificate: Session is not open.");
            }
            byte[] byArray = new byte[x500Name.getDERLen(0)];
            try {
                if (x500Name.getDEREncoding(byArray, 0, 0) == 0) {
                    throw new DatabaseException("PKCS11DBProvider: Invalid BaseName. Cannot DER-encode BaseName.");
                }
            }
            catch (NameException nameException) {
                throw new DatabaseException("PKCS11DBProvider: Invalid BaseName " + nameException.getMessage());
            }
            byte[] byArray2 = new byte[x509V3Extensions.getDERLen(0)];
            if (x509V3Extensions.getDEREncoding(byArray2, 0, 0) == 0) {
                throw new DatabaseException("PKCS11DBProvider: Invalid extensions. Cannot DER-encode extensions.");
            }
            byte[][] byArray3 = null;
            Object object = this.a;
            synchronized (object) {
                byArray3 = PKCS11DB.this.nativeSelectCertByExtensions(byArray, byArray2, PKCS11DB.this.a, PKCS11DB.this.b);
            }
            if (byArray3 == null) {
                return 0;
            }
            int n = 0;
            try {
                for (int i = 0; i < byArray3.length; ++i) {
                    X509Certificate x509Certificate = new X509Certificate(byArray3[i], 0, 0);
                    if (vector.contains(x509Certificate)) continue;
                    vector.addElement(x509Certificate);
                    ++n;
                }
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("PKCS11DBProvider: Invalid certificate." + certificateException.getMessage());
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCertificateIteratorSetup() {
            Object object = this.c;
            synchronized (object) {
                return this.e != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupCertificateIterator() {
            Object object = this.c;
            synchronized (object) {
                this.e = new byte[4];
                this.e[0] = 0;
                this.e[1] = 0;
                this.e[2] = 0;
                this.e[3] = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Certificate firstCertificate() throws DatabaseException {
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.firstCertificate: Session is not open.");
            }
            byte[] byArray = null;
            this.setupCertificateIterator();
            Object object = this.c;
            synchronized (object) {
                byArray = PKCS11DB.this.nativeFirstCertificate(this.e, PKCS11DB.this.a);
                if (byArray == null) {
                    this.e = null;
                    return null;
                }
            }
            try {
                return new X509Certificate(byArray, 0, 0);
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("PKCS11DBProvider: " + certificateException.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Certificate nextCertificate() throws DatabaseException {
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.nextCertificate: Session is not open.");
            }
            if (!this.isCertificateIteratorSetup()) {
                throw new DatabaseException("PKCS11DBProvider.nextCertificate: iterator is not set up.");
            }
            byte[] byArray = null;
            Object object = this.c;
            synchronized (object) {
                byArray = this.e[0] == 0 && this.e[1] == 0 && this.e[2] == 0 && this.e[3] == 0 ? PKCS11DB.this.nativeFirstCertificate(this.e, PKCS11DB.this.a) : PKCS11DB.this.nativeNextCertificate(this.e, PKCS11DB.this.a);
                if (byArray == null) {
                    this.e = null;
                    return null;
                }
            }
            try {
                return new X509Certificate(byArray, 0, 0);
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("PKCS11DBProvider: " + certificateException.getMessage());
            }
        }

        public boolean hasMoreCertificates() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException("PKCS11 DB provider does not supporthasMoreCertificates() method");
        }

        public int selectCRLByIssuerAndTime(X500Name x500Name, Date date, Vector vector) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException("PKCS11DB Provider does not support selectCRLByIssuerAndTime method.");
        }

        public boolean isCRLIteratorSetup() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException("PKCS11 DB provider does not supportisCRLIteratorSetup() method");
        }

        public void setupCRLIterator() throws NotSupportedException {
            throw new NotSupportedException("PKCS11 DB provider does not supportsetupCRLIterator() method");
        }

        public CRL firstCRL() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException("PKCS11 DB provider does not supportfirstCRL() method");
        }

        public CRL nextCRL() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException("PKCS11 DB provider does not supportnextCRL() method");
        }

        public boolean hasMoreCRLs() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException("PKCS11 DB provider does not supporthasMoreCRLs() method");
        }

        private JSAFE_PrivateKey a(byte[][] byArray) throws DatabaseException {
            JSAFE_PrivateKey jSAFE_PrivateKey = null;
            try {
                if (byArray.length == 1) {
                    jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance((byte[])byArray[0], (int)0, (String)"Java");
                } else if (byArray[0] != null && byArray[1] != null && byArray[1].length >= 8) {
                    if (byArray[1][7] == 0) {
                        jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance((String)"RSA", (String)"PKCS11");
                    } else if (byArray[1][7] == 1) {
                        jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance((String)"DSA", (String)"PKCS11");
                    } else if (byArray[1][7] == 2) {
                        jSAFE_PrivateKey = JSAFE_PrivateKey.getInstance((String)"DH", (String)"PKCS11");
                    } else {
                        throw new DatabaseException("PKCS11DBImplementation.selectPrivateKeyByCertificate: Invalid Private key - unknown algorithm.");
                    }
                    jSAFE_PrivateKey.setKeyData("KeyToken", byArray);
                }
            }
            catch (JSAFE_Exception jSAFE_Exception) {
                throw new DatabaseException("Cannot se the private key data" + jSAFE_Exception.getMessage());
            }
            return jSAFE_PrivateKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate certificate) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("PKCS11DBImplementation.selectPrivateKeyByCertificate: cert should not be null.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.selectPrivateKey: Session is not open.");
            }
            try {
                byte[][] byArray = null;
                byte[] byArray2 = certificate.getSubjectPublicKeyBER();
                if (byArray2 == null) {
                    throw new DatabaseException("Cert does not contain public key info.");
                }
                Object object = this.b;
                synchronized (object) {
                    byArray = PKCS11DB.this.nativeSelectPrivateKey(byArray2, PKCS11DB.this.a);
                }
                if (byArray == null) {
                    return null;
                }
                return this.a(byArray);
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("PKCS11DBImplementation.selectPrivateKeyByCertificate: " + certificateException.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws DatabaseException {
            if (jSAFE_PublicKey == null) {
                throw new DatabaseException("PKCS11DBImplementation.selectPrivateKeyByPublicKey: publicKey should not be null.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.selectPrivateKey: Session is not open.");
            }
            byte[] byArray = this.a(jSAFE_PublicKey);
            byte[][] byArray2 = null;
            Object object = this.b;
            synchronized (object) {
                byArray2 = PKCS11DB.this.nativeSelectPrivateKey(byArray, PKCS11DB.this.a);
            }
            if (byArray2 == null) {
                return null;
            }
            return this.a(byArray2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPrivateKeyIteratorSetup() {
            Object object = this.d;
            synchronized (object) {
                return this.f != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupPrivateKeyIterator() {
            Object object = this.d;
            synchronized (object) {
                this.f = new byte[4];
                this.f[0] = 0;
                this.f[1] = 0;
                this.f[2] = 0;
                this.f[3] = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey firstPrivateKey() throws DatabaseException {
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.firstPrivateKey: Session is not open.");
            }
            byte[][] byArray = null;
            this.setupPrivateKeyIterator();
            Object object = this.d;
            synchronized (object) {
                byArray = PKCS11DB.this.nativeFirstPrivateKey(this.f, PKCS11DB.this.a);
                if (byArray == null) {
                    this.f = null;
                    return null;
                }
            }
            return this.a(byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JSAFE_PrivateKey nextPrivateKey() throws DatabaseException {
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.nextPrivateKey: Session is not open.");
            }
            if (!this.isPrivateKeyIteratorSetup()) {
                throw new DatabaseException("PKCS11DBProvider.nextPrivateKey: iterator is not set up.");
            }
            byte[][] byArray = null;
            Object object = this.d;
            synchronized (object) {
                byArray = this.f[0] == 0 && this.f[1] == 0 && this.f[2] == 0 && this.f[3] == 0 ? PKCS11DB.this.nativeFirstPrivateKey(this.f, PKCS11DB.this.a) : PKCS11DB.this.nativeNextPrivateKey(this.f, PKCS11DB.this.a);
                if (byArray == null) {
                    this.f = null;
                    return null;
                }
            }
            return this.a(byArray);
        }

        public boolean hasMorePrivateKeys() throws NotSupportedException, DatabaseException {
            throw new NotSupportedException("PKCS11 DB provider does not supporthasMorePrivateKeys() method");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteCertificate(X500Name x500Name, byte[] byArray) throws DatabaseException {
            if (x500Name == null || byArray == null) {
                throw new DatabaseException("PKCS11DBImplementation.deleteCertificate: Neither issuerName nor serialNumber should be null.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.deleteCertificate: Session is not open.Cert-C DB provider is not initialized.");
            }
            if (PKCS11DB.this.b == null) {
                throw new DatabaseException("PKCS11DBProvider.deleteCertificate: Session is not open.Cert-C context object is not initialized.");
            }
            byte[] byArray2 = new byte[x500Name.getDERLen(0)];
            try {
                if (x500Name.getDEREncoding(byArray2, 0, 0) == 0) {
                    throw new DatabaseException("PKCS11DBProvider: Invalid IssuerName. Cannot DER-encode Issuer Name.");
                }
            }
            catch (NameException nameException) {
                throw new DatabaseException("PKCS11DBProvider: Invalid IssuerName " + nameException.getMessage());
            }
            int n = 0;
            Object object = this.a;
            synchronized (object) {
                n = PKCS11DB.this.nativeDeleteCert(byArray2, byArray, PKCS11DB.this.a, PKCS11DB.this.b);
            }
            if (n != 0) {
                throw new DatabaseException("PKCS11DBProvider: Unable to delete certificate.");
            }
        }

        public void deleteCRL(X500Name x500Name, Date date) throws NotSupportedException, DatabaseException {
            throw new NotSupportedException("deleteCRL method is not supported by PKCS11DB provider.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deletePrivateKeyByCertificate(Certificate certificate) throws DatabaseException {
            if (certificate == null) {
                throw new DatabaseException("PKCS11DBImplementation.deletePrivateKeyByCertificate: cert should not be null.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.deletePrivateKey: Session is not open.");
            }
            int n = 0;
            try {
                byte[] byArray = certificate.getSubjectPublicKeyBER();
                if (byArray == null) {
                    throw new DatabaseException("PKCS11DBProvider: cert is missing public Key.");
                }
                Object object = this.b;
                synchronized (object) {
                    n = PKCS11DB.this.nativeDeletePrivateKey(byArray, PKCS11DB.this.a);
                }
            }
            catch (CertificateException certificateException) {
                throw new DatabaseException("PKCS11DBProvider: invalid cert." + certificateException.getMessage());
            }
            if (n != 0) {
                throw new DatabaseException("PKCS11DBProvider: Unable to delete private key.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deletePrivateKeyByPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws DatabaseException {
            if (jSAFE_PublicKey == null) {
                throw new DatabaseException("PKCS11DBImplementation.deletePrivateKeyByPublicKey: publicKey should not be null.");
            }
            if (PKCS11DB.this.a == null) {
                throw new DatabaseException("PKCS11DBProvider.deletePrivateKey: Session is not open.");
            }
            byte[] byArray = this.a(jSAFE_PublicKey);
            int n = 0;
            Object object = this.b;
            synchronized (object) {
                n = PKCS11DB.this.nativeDeletePrivateKey(byArray, PKCS11DB.this.a);
            }
            if (n != 0) {
                throw new DatabaseException("PKCS11DB: Unable to delete private key.");
            }
        }

        public void unregister() {
            if (PKCS11DB.this.a != null) {
                PKCS11DB.this.nativeFinalizeSession(PKCS11DB.this.a, PKCS11DB.this.b);
            }
            if (PKCS11DB.this.d) {
                PKCS11DB.this.c.clearSensitiveData();
                PKCS11DB.this.c.closeSession();
            }
            PKCS11DB.a(PKCS11DB.this, null);
            PKCS11DB.b(PKCS11DB.this, null);
        }

        protected void finalize() {
            this.unregister();
        }

        /* synthetic */ PKCS11DBImplementation(CertJ certJ, String string, Co co) throws InvalidParameterException {
            this(certJ, string);
        }
    }
}

