/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.path;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.AuthorityKeyID;
import com.rsa.certj.cert.extensions.BasicConstraints;
import com.rsa.certj.cert.extensions.BuiltInDomainDefinedAttributes;
import com.rsa.certj.cert.extensions.BuiltInStandardAttributes;
import com.rsa.certj.cert.extensions.CertPolicies;
import com.rsa.certj.cert.extensions.EDIPartyName;
import com.rsa.certj.cert.extensions.ExtendedNetworkAddress;
import com.rsa.certj.cert.extensions.ExtensionAttribute;
import com.rsa.certj.cert.extensions.ExtensionAttributes;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.GeneralSubtrees;
import com.rsa.certj.cert.extensions.IssuerAltName;
import com.rsa.certj.cert.extensions.KeyUsage;
import com.rsa.certj.cert.extensions.NameConstraints;
import com.rsa.certj.cert.extensions.ORAddress;
import com.rsa.certj.cert.extensions.ORName;
import com.rsa.certj.cert.extensions.OtherName;
import com.rsa.certj.cert.extensions.PDSParameter;
import com.rsa.certj.cert.extensions.PersonalName;
import com.rsa.certj.cert.extensions.PolicyConstraints;
import com.rsa.certj.cert.extensions.PolicyQualifiers;
import com.rsa.certj.cert.extensions.SubjectAltName;
import com.rsa.certj.cert.extensions.SubjectKeyID;
import com.rsa.certj.cert.extensions.UnformattedPostalAddress;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.certj.provider.path.CertPathCommon;
import com.rsa.certj.provider.path.Cp;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.PolicyInformation;
import java.util.Vector;

public final class PKIXCertPath
extends Provider {
    private static final int a = 0;
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 3;

    public PKIXCertPath(String string) throws InvalidParameterException {
        super(3, string);
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("PKIXCertPath.instantiate: " + invalidParameterException.getMessage());
        }
    }

    private class CertPathState {
        protected Vector initialPolicySet;
        protected Vector acceptablePolicySet;
        protected GeneralNames constrainedSubtrees;
        protected GeneralNames excludedSubtrees;
        protected int explicitPolicy;
        protected int policyMapping;

        protected CertPathState(Vector vector, Vector vector2, GeneralNames generalNames, GeneralNames generalNames2, int n, int n2) {
            this.initialPolicySet = vector;
            this.acceptablePolicySet = vector2;
            this.constrainedSubtrees = generalNames;
            this.excludedSubtrees = generalNames2;
            this.explicitPolicy = n;
            this.policyMapping = n2;
        }
    }

    private final class Implementation
    extends CertPathCommon {
        private Implementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
        }

        protected void getNextCertCandidates(CertPathCtx certPathCtx, Object object, Vector vector) throws CertPathException {
            X500Name x500Name = null;
            X509V3Extensions x509V3Extensions = null;
            if (object instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)object;
                x500Name = x509Certificate.getIssuerName();
                x509V3Extensions = x509Certificate.getExtensions();
            } else if (object instanceof X509CRL) {
                X509CRL x509CRL = (X509CRL)object;
                x500Name = x509CRL.getIssuerName();
                x509V3Extensions = x509CRL.getExtensions();
            } else {
                throw new CertPathException("PKIXCertPath$Implementation.getNextCertCandidates: does not support startObjects other than X509Certificate or X509CRL.");
            }
            this.a(certPathCtx, x500Name, x509V3Extensions, vector);
        }

        protected boolean verifyPath(CertPathCtx certPathCtx, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws CertPathException {
            Vector vector5 = vector2 == null ? null : new Vector();
            Vector vector6 = vector3 == null ? null : new Vector();
            Vector vector7 = vector4 == null ? null : new Vector();
            int n = vector.size();
            CertPathState certPathState = this.a(certPathCtx, n);
            X509Certificate x509Certificate = (X509Certificate)vector.elementAt(n - 1);
            this.a(certPathCtx, certPathState, x509Certificate, vector7);
            int n2 = n - 1;
            int n3 = n - n2;
            while (n2 > 0) {
                X509Certificate x509Certificate2;
                ++n3;
                if (!this.verifyRevocation(certPathCtx, x509Certificate2 = (X509Certificate)vector.elementAt(--n2), vector5, vector6)) {
                    return false;
                }
                X509V3Extensions x509V3Extensions = x509Certificate2.getExtensions();
                if (!this.a(certPathState, x509Certificate2.getSubjectName(), x509V3Extensions)) {
                    return false;
                }
                if (!this.a(certPathState, n3, x509V3Extensions, vector7)) {
                    return false;
                }
                if (!this.a(certPathState)) {
                    return false;
                }
                if (!this.a(certPathCtx, x509V3Extensions, n2)) {
                    return false;
                }
                if (n2 != 0) {
                    if (!this.a(certPathCtx, x509V3Extensions)) {
                        return false;
                    }
                    this.a(certPathCtx, certPathState, x509V3Extensions);
                    this.a(certPathState, x509V3Extensions, n3);
                    if (!this.b(certPathCtx, x509V3Extensions)) {
                        return false;
                    }
                }
                x509Certificate = x509Certificate2;
            }
            CertJUtils.mergeLists(vector2, vector5);
            CertJUtils.mergeLists(vector3, vector6);
            CertJUtils.mergeLists(vector4, vector7);
            return true;
        }

        private boolean a(CertPathState certPathState, X500Name x500Name, X509V3Extensions x509V3Extensions) {
            GeneralName generalName = new GeneralName();
            try {
                generalName.setGeneralName(x500Name, 5);
            }
            catch (NameException nameException) {
                return false;
            }
            if (!this.a(certPathState, generalName)) {
                return false;
            }
            SubjectAltName subjectAltName = null;
            try {
                if (x509V3Extensions != null) {
                    subjectAltName = (SubjectAltName)x509V3Extensions.getExtensionByType(17);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (subjectAltName == null) {
                return this.a(certPathState, x500Name);
            }
            return this.a(certPathState, subjectAltName.getGeneralNames());
        }

        private boolean a(CertPathState certPathState, int n, X509V3Extensions x509V3Extensions, Vector vector) {
            if (certPathState.policyMapping > n) {
                this.a(certPathState, x509V3Extensions);
            }
            CertPolicies certPolicies = null;
            try {
                if (x509V3Extensions != null) {
                    certPolicies = (CertPolicies)x509V3Extensions.getExtensionByType(32);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (certPolicies == null) {
                return true;
            }
            if (certPathState.initialPolicySet != null && certPathState.explicitPolicy <= n) {
                for (int i = 0; i < certPolicies.getPoliciesCount(); ++i) {
                    byte[] byArray = null;
                    try {
                        byArray = certPolicies.getCertPolicyId(i);
                    }
                    catch (CertificateException certificateException) {
                        // empty catch block
                    }
                    if (CertJUtils.containsByteArray(certPathState.initialPolicySet, byArray)) continue;
                    return false;
                }
            }
            if (certPolicies.getCriticality()) {
                this.a(certPathState, certPolicies, vector);
                if (certPathState.acceptablePolicySet.size() == 0) {
                    return false;
                }
            }
            return true;
        }

        private void a(CertPathState certPathState, CertPolicies certPolicies, Vector vector) {
            Vector<byte[]> vector2 = new Vector<byte[]>();
            for (int i = 0; i < certPolicies.getPoliciesCount(); ++i) {
                byte[] byArray = null;
                try {
                    byArray = certPolicies.getCertPolicyId(i);
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
                vector2.addElement(byArray);
                if (vector == null) continue;
                PolicyQualifiers policyQualifiers = null;
                try {
                    policyQualifiers = certPolicies.getPolicyQualifiers(i);
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
                try {
                    PolicyInformation policyInformation = new PolicyInformation(byArray, policyQualifiers);
                    vector.addElement(policyInformation);
                    continue;
                }
                catch (CertPathException certPathException) {
                    // empty catch block
                }
            }
            if (certPathState.acceptablePolicySet == null) {
                certPathState.acceptablePolicySet = vector2;
            } else {
                CertJUtils.intersectByteArrayLists(certPathState.acceptablePolicySet, vector2);
            }
        }

        private boolean a(CertPathState certPathState) {
            if (certPathState.acceptablePolicySet == null) {
                return true;
            }
            if (certPathState.acceptablePolicySet.size() == 0) {
                return false;
            }
            if (certPathState.initialPolicySet == null) {
                return true;
            }
            Vector vector = (Vector)certPathState.acceptablePolicySet.clone();
            CertJUtils.intersectByteArrayLists(vector, certPathState.initialPolicySet);
            return vector.size() != 0;
        }

        private boolean a(CertPathCtx certPathCtx, X509V3Extensions x509V3Extensions, int n) {
            if (x509V3Extensions == null) {
                return true;
            }
            int n2 = certPathCtx.getPathOptions();
            if ((n2 & 0x80) != 0) {
                return true;
            }
            block6: for (int i = 0; i < x509V3Extensions.getExtensionCount(); ++i) {
                X509V3Extension x509V3Extension = null;
                try {
                    x509V3Extension = x509V3Extensions.getExtensionByIndex(i);
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
                if (!x509V3Extension.getCriticality()) break;
                switch (x509V3Extension.getExtensionType()) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 35: {
                        continue block6;
                    }
                    case 19: {
                        int n3;
                        if ((n2 & 0x20) != 0 || (n3 = ((BasicConstraints)x509V3Extension).getPathLen()) < 0 || n3 + 1 >= n) continue block6;
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean a(CertPathCtx certPathCtx, X509V3Extensions x509V3Extensions) {
            if ((certPathCtx.getPathOptions() & 0x20) != 0) {
                return true;
            }
            BasicConstraints basicConstraints = null;
            try {
                if (x509V3Extensions != null) {
                    basicConstraints = (BasicConstraints)x509V3Extensions.getExtensionByType(19);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (basicConstraints == null) {
                return false;
            }
            return basicConstraints.getCA();
        }

        private void a(CertPathCtx certPathCtx, CertPathState certPathState, X509V3Extensions x509V3Extensions) {
            if ((certPathCtx.getPathOptions() & 0x10) != 0) {
                return;
            }
            NameConstraints nameConstraints = null;
            try {
                if (x509V3Extensions != null) {
                    nameConstraints = (NameConstraints)x509V3Extensions.getExtensionByType(30);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (nameConstraints == null) {
                return;
            }
            GeneralSubtrees generalSubtrees = nameConstraints.getPermittedSubtrees();
            if (certPathState.constrainedSubtrees == null) {
                certPathState.constrainedSubtrees = new GeneralNames();
                this.b(certPathState.constrainedSubtrees, generalSubtrees);
            } else {
                this.a(certPathState.constrainedSubtrees, generalSubtrees);
            }
            this.b(certPathState.excludedSubtrees, nameConstraints.getExcludedSubtrees());
        }

        private void a(CertPathState certPathState, X509V3Extensions x509V3Extensions, int n) {
            PolicyConstraints policyConstraints = null;
            try {
                if (x509V3Extensions != null) {
                    policyConstraints = (PolicyConstraints)x509V3Extensions.getExtensionByType(36);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (policyConstraints == null) {
                return;
            }
            int n2 = policyConstraints.getExplicitPolicy();
            int n3 = policyConstraints.getPolicyMapping();
            if (n2 != -1 && n + n2 < certPathState.explicitPolicy) {
                certPathState.explicitPolicy = n + n2;
            }
            if (n3 != -1 && n + n3 < certPathState.policyMapping) {
                certPathState.policyMapping = n + n3;
            }
        }

        private boolean b(CertPathCtx certPathCtx, X509V3Extensions x509V3Extensions) {
            if ((certPathCtx.getPathOptions() & 0x40) != 0) {
                return true;
            }
            X509V3Extension x509V3Extension = null;
            try {
                if (x509V3Extensions != null) {
                    x509V3Extension = (KeyUsage)x509V3Extensions.getExtensionByType(15);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (x509V3Extension == null) {
                return true;
            }
            if (!x509V3Extension.getCriticality()) {
                return true;
            }
            return (((KeyUsage)x509V3Extension).getKeyUsage() & 0x4000000) != 0;
        }

        private boolean a(CertPathState certPathState, GeneralNames generalNames) {
            try {
                for (int i = 0; i < generalNames.getNameCount(); ++i) {
                    if (this.a(certPathState, generalNames.getGeneralName(i))) continue;
                    return false;
                }
                return true;
            }
            catch (NameException nameException) {
                return false;
            }
        }

        private boolean a(CertPathState certPathState, GeneralName generalName) {
            int n = generalName.getGeneralNameType();
            try {
                GeneralName generalName2;
                int n2;
                boolean bl = false;
                if (certPathState.constrainedSubtrees != null) {
                    for (n2 = 0; n2 < certPathState.constrainedSubtrees.getNameCount(); ++n2) {
                        generalName2 = certPathState.constrainedSubtrees.getGeneralName(n2);
                        if (n != generalName2.getGeneralNameType()) continue;
                        bl = true;
                        if (this.a(generalName, generalName2, n)) continue;
                        return false;
                    }
                    if (!bl) {
                        return false;
                    }
                }
                for (n2 = 0; n2 < certPathState.excludedSubtrees.getNameCount(); ++n2) {
                    generalName2 = certPathState.excludedSubtrees.getGeneralName(n2);
                    if (n != generalName2.getGeneralNameType() || !this.a(generalName, generalName2, n)) continue;
                    return false;
                }
                return true;
            }
            catch (NameException nameException) {
                return false;
            }
        }

        private boolean a(CertPathState certPathState, X500Name x500Name) {
            for (int i = 0; i < x500Name.getRDNCount(); ++i) {
                try {
                    GeneralName generalName;
                    int n;
                    RDN rDN = x500Name.getRDN(i);
                    AttributeValueAssertion attributeValueAssertion = rDN.getAttribute(7);
                    if (attributeValueAssertion == null) continue;
                    String string = attributeValueAssertion.getStringAttribute();
                    if (certPathState.constrainedSubtrees != null) {
                        for (n = 0; n < certPathState.constrainedSubtrees.getNameCount(); ++n) {
                            generalName = certPathState.constrainedSubtrees.getGeneralName(n);
                            if (generalName.getGeneralNameType() != 7 || this.b(string, (String)generalName.getGeneralName())) continue;
                            return false;
                        }
                    }
                    for (n = 0; n < certPathState.excludedSubtrees.getNameCount(); ++n) {
                        generalName = certPathState.excludedSubtrees.getGeneralName(n);
                        if (generalName.getGeneralNameType() != 7 || !this.b(string, (String)generalName.getGeneralName())) continue;
                        return false;
                    }
                    continue;
                }
                catch (NameException nameException) {
                    // empty catch block
                }
            }
            return true;
        }

        private void a(CertPathState certPathState, X509V3Extensions x509V3Extensions) {
        }

        private void a(GeneralNames generalNames, GeneralSubtrees generalSubtrees) {
            try {
                for (int i = generalNames.getNameCount() - 1; i >= 0; --i) {
                    GeneralName generalName = generalNames.getGeneralName(i);
                    boolean bl = false;
                    block10: for (int j = 0; j < generalSubtrees.getSubtreeCount(); ++j) {
                        GeneralName generalName2 = null;
                        try {
                            generalName2 = generalSubtrees.getBase(j);
                            if (generalName2.getGeneralNameType() != generalName.getGeneralNameType()) {
                                continue;
                            }
                        }
                        catch (NameException nameException) {
                            // empty catch block
                        }
                        switch (this.a(generalName, generalName2)) {
                            case 1: 
                            case 2: {
                                bl = true;
                                continue block10;
                            }
                            case 3: {
                                bl = true;
                                Vector vector = generalNames.getGeneralNames();
                                vector.setElementAt(generalName2, i);
                            }
                            case 0: {
                                continue block10;
                            }
                        }
                    }
                    if (bl) continue;
                    Vector vector = generalNames.getGeneralNames();
                    vector.removeElementAt(i);
                }
            }
            catch (NameException nameException) {
                // empty catch block
            }
        }

        private void b(GeneralNames generalNames, GeneralSubtrees generalSubtrees) {
            try {
                for (int i = 0; i < generalSubtrees.getSubtreeCount(); ++i) {
                    GeneralName generalName = null;
                    try {
                        generalName = generalSubtrees.getBase(i);
                    }
                    catch (NameException nameException) {
                        return;
                    }
                    boolean bl = false;
                    block10: for (int j = generalNames.getNameCount() - 1; j >= 0; --j) {
                        GeneralName generalName2 = generalNames.getGeneralName(j);
                        if (generalName.getGeneralNameType() != generalName2.getGeneralNameType()) continue;
                        switch (this.a(generalName2, generalName)) {
                            case 1: 
                            case 3: {
                                bl = true;
                                continue block10;
                            }
                            case 2: {
                                bl = true;
                                Vector vector = generalNames.getGeneralNames();
                                vector.setElementAt(generalName, i);
                                continue block10;
                            }
                            case 0: {
                                continue block10;
                            }
                        }
                    }
                    if (bl) continue;
                    generalNames.addGeneralName(generalName);
                }
            }
            catch (NameException nameException) {
                // empty catch block
            }
        }

        private CertPathState a(CertPathCtx certPathCtx, int n) {
            byte[][] byArray = certPathCtx.getPolicies();
            Vector vector = null;
            Vector vector2 = null;
            if (byArray != null) {
                vector = this.a(byArray);
                vector2 = this.a(byArray);
            }
            return new CertPathState(vector, vector2, null, new GeneralNames(), n + 1, n + 1);
        }

        private void a(CertPathCtx certPathCtx, CertPathState certPathState, X509Certificate x509Certificate, Vector vector) {
            X509V3Extensions x509V3Extensions = null;
            x509V3Extensions = x509Certificate.getExtensions();
            this.a(certPathState, 1, x509V3Extensions, vector);
            this.a(certPathCtx, certPathState, x509V3Extensions);
            this.a(certPathState, x509V3Extensions, 1);
        }

        private void a(CertPathCtx certPathCtx, X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws CertPathException {
            if ((certPathCtx.getPathOptions() & 0x200) != 0) {
                this.findCertBySubject(certPathCtx, x500Name, vector);
                return;
            }
            AuthorityKeyID authorityKeyID = null;
            try {
                if (x509V3Extensions != null) {
                    authorityKeyID = (AuthorityKeyID)x509V3Extensions.getExtensionByType(35);
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (authorityKeyID != null) {
                this.a(certPathCtx, x500Name, authorityKeyID, vector);
            } else {
                this.findCertBySubject(certPathCtx, x500Name, vector);
            }
        }

        private void a(CertPathCtx certPathCtx, X500Name x500Name, AuthorityKeyID authorityKeyID, Vector vector) throws CertPathException {
            byte[] byArray = authorityKeyID.getKeyID();
            if (byArray != null) {
                this.a(certPathCtx, x500Name, byArray, vector);
            } else {
                this.a(certPathCtx, authorityKeyID, vector);
            }
        }

        private void a(CertPathCtx certPathCtx, X500Name x500Name, byte[] byArray, Vector vector) throws CertPathException {
            Vector vector2 = new Vector();
            this.findCertBySubject(certPathCtx, x500Name, vector2);
            X509V3Extensions x509V3Extensions = null;
            int n = vector2.size();
            while (n > 0) {
                X509Certificate x509Certificate;
                if ((x509V3Extensions = (x509Certificate = (X509Certificate)vector2.elementAt(--n)).getExtensions()) == null) {
                    vector2.removeElementAt(n);
                    continue;
                }
                SubjectKeyID subjectKeyID = null;
                try {
                    if (x509V3Extensions != null) {
                        subjectKeyID = (SubjectKeyID)x509V3Extensions.getExtensionByType(14);
                    }
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
                if (subjectKeyID == null) {
                    vector2.removeElementAt(n);
                    continue;
                }
                if (CertJUtils.byteArraysEqual(byArray, subjectKeyID.getKeyID())) continue;
                vector2.removeElementAt(n);
            }
            CertJUtils.mergeLists(vector, vector2);
        }

        private void a(CertPathCtx certPathCtx, AuthorityKeyID authorityKeyID, Vector vector) throws CertPathException {
            byte[] byArray = authorityKeyID.getSerialNumber();
            if (byArray.length == 0) {
                return;
            }
            GeneralNames generalNames = authorityKeyID.getAuthorityCertIssuer();
            if (generalNames == null) {
                return;
            }
            try {
                for (int i = 0; i < generalNames.getNameCount(); ++i) {
                    GeneralName generalName = generalNames.getGeneralName(i);
                    if (generalName.getGeneralNameType() == 5) {
                        this.b(certPathCtx, (X500Name)generalName.getGeneralName(), byArray, vector);
                        continue;
                    }
                    this.a(certPathCtx, generalName, byArray, vector);
                }
            }
            catch (NameException nameException) {
                // empty catch block
            }
        }

        private void a(CertPathCtx certPathCtx, GeneralName generalName, byte[] byArray, Vector vector) throws CertPathException {
            X509V3Extensions x509V3Extensions;
            Cloneable cloneable;
            GeneralNames generalNames = new GeneralNames();
            generalNames.addGeneralName(generalName);
            try {
                cloneable = new IssuerAltName(generalNames, false);
                x509V3Extensions = new X509V3Extensions(1);
                x509V3Extensions.addV3Extension((X509V3Extension)cloneable);
            }
            catch (CertificateException certificateException) {
                return;
            }
            cloneable = new Vector();
            this.b(certPathCtx, null, x509V3Extensions, (Vector)cloneable);
            int n = ((Vector)cloneable).size();
            while (n > 0) {
                X509Certificate x509Certificate;
                if (CertJUtils.byteArraysEqual(byArray, (x509Certificate = (X509Certificate)((Vector)cloneable).elementAt(--n)).getSerialNumber())) continue;
                ((Vector)cloneable).removeElementAt(n);
            }
            CertJUtils.mergeLists(vector, (Vector)cloneable);
        }

        private boolean a(String string, String string2) {
            return this.a(string).equals(this.a(string2));
        }

        private String a(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ') {
                    if (bl) continue;
                    if (n != 0) {
                        stringBuffer.append(' ');
                        ++n;
                    }
                    bl = true;
                    continue;
                }
                if (bl) {
                    bl = false;
                }
                stringBuffer.append(c);
                ++n;
            }
            if (bl) {
                --n;
            }
            char[] cArray = new char[n];
            stringBuffer.getChars(0, n, cArray, 0);
            return new String(cArray).toUpperCase();
        }

        private int a(GeneralName generalName, GeneralName generalName2) {
            boolean bl;
            boolean bl2;
            switch (generalName.getGeneralNameType()) {
                case 1: {
                    OtherName otherName = (OtherName)generalName.getGeneralName();
                    OtherName otherName2 = (OtherName)generalName2.getGeneralName();
                    bl2 = this.a(otherName, otherName);
                    bl = this.a(otherName2, otherName);
                    break;
                }
                case 2: {
                    String string = (String)generalName.getGeneralName();
                    String string2 = (String)generalName2.getGeneralName();
                    bl2 = this.b(string, string);
                    bl = this.b(string2, string);
                    break;
                }
                case 3: {
                    String string = (String)generalName.getGeneralName();
                    String string3 = (String)generalName2.getGeneralName();
                    bl2 = this.c(string, string);
                    bl = this.c(string3, string);
                    break;
                }
                case 4: {
                    ORAddress oRAddress = (ORAddress)generalName.getGeneralName();
                    ORAddress oRAddress2 = (ORAddress)generalName2.getGeneralName();
                    bl2 = this.a(oRAddress, oRAddress);
                    bl = this.a(oRAddress2, oRAddress);
                    break;
                }
                case 5: {
                    X500Name x500Name = (X500Name)generalName.getGeneralName();
                    X500Name x500Name2 = (X500Name)generalName2.getGeneralName();
                    bl2 = this.a(x500Name, x500Name);
                    bl = this.a(x500Name2, x500Name);
                    break;
                }
                case 6: {
                    EDIPartyName eDIPartyName = (EDIPartyName)generalName.getGeneralName();
                    EDIPartyName eDIPartyName2 = (EDIPartyName)generalName2.getGeneralName();
                    bl2 = this.a(eDIPartyName, eDIPartyName);
                    bl = this.a(eDIPartyName2, eDIPartyName);
                    break;
                }
                case 7: {
                    String string = (String)generalName.getGeneralName();
                    String string4 = (String)generalName2.getGeneralName();
                    bl2 = this.d(string, string);
                    bl = this.d(string4, string);
                    break;
                }
                case 8: {
                    byte[] byArray = (byte[])generalName.getGeneralName();
                    byte[] byArray2 = (byte[])generalName2.getGeneralName();
                    bl2 = this.a(byArray, byArray);
                    bl = this.a(byArray2, byArray);
                    break;
                }
                case 9: {
                    String string = (String)generalName.getGeneralName();
                    String string5 = (String)generalName2.getGeneralName();
                    bl2 = this.e(string, string);
                    bl = this.e(string5, string);
                    break;
                }
                default: {
                    return 0;
                }
            }
            if (bl2 && bl) {
                return 1;
            }
            if (bl2) {
                return 2;
            }
            if (bl) {
                return 3;
            }
            return 0;
        }

        private boolean a(GeneralName generalName, GeneralName generalName2, int n) {
            switch (n) {
                case 1: {
                    return this.a((OtherName)generalName.getGeneralName(), (OtherName)generalName2.getGeneralName());
                }
                case 2: {
                    return this.b((String)generalName.getGeneralName(), (String)generalName2.getGeneralName());
                }
                case 3: {
                    return this.c((String)generalName.getGeneralName(), (String)generalName2.getGeneralName());
                }
                case 4: {
                    return this.a((ORAddress)generalName.getGeneralName(), (ORAddress)generalName2.getGeneralName());
                }
                case 5: {
                    return this.a((X500Name)generalName.getGeneralName(), (X500Name)generalName2.getGeneralName());
                }
                case 6: {
                    return this.a((EDIPartyName)generalName.getGeneralName(), (EDIPartyName)generalName2.getGeneralName());
                }
                case 7: {
                    return this.d((String)generalName.getGeneralName(), (String)generalName2.getGeneralName());
                }
                case 8: {
                    return this.a((byte[])generalName.getGeneralName(), (byte[])generalName2.getGeneralName());
                }
                case 9: {
                    return this.e((String)generalName.getGeneralName(), (String)generalName2.getGeneralName());
                }
            }
            return false;
        }

        private boolean a(OtherName otherName, OtherName otherName2) {
            if (otherName == null || otherName2 == null) {
                return false;
            }
            return otherName.equals(otherName2);
        }

        private boolean b(String string, String string2) {
            if (string == null || string2 == null) {
                return false;
            }
            if (this.f(string2, string)) {
                if (string.length() == string2.length()) {
                    return true;
                }
                if (string2.charAt(0) == '.') {
                    return true;
                }
                if (string.charAt(string.length() - 1 - string2.length()) == '@') {
                    return true;
                }
            }
            return false;
        }

        private boolean a(X500Name x500Name, X500Name x500Name2) {
            int n;
            if (x500Name == null || x500Name2 == null) {
                return false;
            }
            int n2 = x500Name.getRDNCount();
            if (n2 < (n = x500Name2.getRDNCount())) {
                return false;
            }
            try {
                for (int i = 0; i < n; ++i) {
                    if (this.a(x500Name.getRDN(i), x500Name2.getRDN(i))) continue;
                    return false;
                }
            }
            catch (NameException nameException) {
                return false;
            }
            return true;
        }

        private boolean c(String string, String string2) {
            if (string == null || string2 == null) {
                return false;
            }
            if (this.f(string2, string)) {
                if (string.length() == string2.length()) {
                    return true;
                }
                if (string.charAt(string.length() - 1 - string2.length()) == '.') {
                    return true;
                }
            }
            return false;
        }

        private boolean a(ORAddress oRAddress, ORAddress oRAddress2) {
            if (oRAddress == null || oRAddress2 == null) {
                return false;
            }
            BuiltInDomainDefinedAttributes builtInDomainDefinedAttributes = oRAddress.getBuiltInDomainDefinedAttributes();
            BuiltInDomainDefinedAttributes builtInDomainDefinedAttributes2 = oRAddress2.getBuiltInDomainDefinedAttributes();
            ExtensionAttributes extensionAttributes = oRAddress.getExtensionAttributes();
            ExtensionAttributes extensionAttributes2 = oRAddress2.getExtensionAttributes();
            return this.a(oRAddress.getBuiltInStandardAttributes(), oRAddress2.getBuiltInStandardAttributes()) && (builtInDomainDefinedAttributes == null && builtInDomainDefinedAttributes2 == null || builtInDomainDefinedAttributes != null && builtInDomainDefinedAttributes2 != null && this.a(builtInDomainDefinedAttributes, builtInDomainDefinedAttributes2)) && (extensionAttributes == null && extensionAttributes2 == null || extensionAttributes != null && extensionAttributes2 != null && this.a(extensionAttributes, extensionAttributes2));
        }

        private boolean a(EDIPartyName eDIPartyName, EDIPartyName eDIPartyName2) {
            if (eDIPartyName == null || eDIPartyName2 == null) {
                return false;
            }
            return eDIPartyName.equals(eDIPartyName2);
        }

        private boolean d(String string, String string2) {
            if (string == null || string2 == null) {
                return false;
            }
            String string3 = this.b(string);
            String string4 = this.b(string2);
            if (this.f(string4, string3)) {
                if (string3.length() == string4.length()) {
                    return true;
                }
                if (string4.charAt(0) == '.') {
                    return true;
                }
            }
            return false;
        }

        private boolean a(byte[] byArray, byte[] byArray2) {
            int n;
            int n2;
            int n3;
            if (byArray == null || byArray2 == null) {
                return false;
            }
            int n4 = byArray.length;
            int n5 = byArray2.length;
            byte[] byArray3 = new byte[16];
            byte[] byArray4 = new byte[16];
            switch (n4) {
                case 4: 
                case 16: {
                    n3 = n4;
                    for (n2 = 0; n2 < n3; ++n2) {
                        byArray3[n2] = 0;
                    }
                    break;
                }
                case 8: 
                case 32: {
                    n3 = n4 / 2;
                    for (n2 = 0; n2 < n3; ++n2) {
                        byArray3[n2] = ~byArray[n2 + n3];
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            switch (n5) {
                case 4: 
                case 16: {
                    n = n5;
                    for (n2 = 0; n2 < n; ++n2) {
                        byArray4[n2] = -1;
                    }
                    break;
                }
                case 8: 
                case 32: {
                    n = n5 / 2;
                    for (n2 = 0; n2 < n; ++n2) {
                        byArray4[n2] = byArray2[n + n2];
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            if (n3 != n) {
                return false;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                if ((byArray4[n2] & byArray[n2]) == byArray2[n2] && (byArray4[n2] & (byArray[n2] | byArray3[n2])) == byArray2[n2]) continue;
                return false;
            }
            return true;
        }

        private boolean e(String string, String string2) {
            if (string == null || string2 == null) {
                return false;
            }
            return string.equals(string2);
        }

        private boolean a(RDN rDN, RDN rDN2) {
            int n;
            if (rDN == null || rDN2 == null) {
                return false;
            }
            int n2 = rDN.getAttributeCount();
            if (n2 < (n = rDN2.getAttributeCount())) {
                return false;
            }
            Vector<AttributeValueAssertion> vector = new Vector<AttributeValueAssertion>();
            try {
                block2: for (int i = 0; i < n; ++i) {
                    AttributeValueAssertion attributeValueAssertion = rDN2.getAttributeByIndex(i);
                    for (int j = 0; j < n2; ++j) {
                        AttributeValueAssertion attributeValueAssertion2 = rDN.getAttributeByIndex(j);
                        if (!this.a(attributeValueAssertion2, attributeValueAssertion)) continue;
                        vector.addElement(attributeValueAssertion);
                        continue block2;
                    }
                }
            }
            catch (NameException nameException) {
                return false;
            }
            return n2 == vector.size();
        }

        private boolean a(AttributeValueAssertion attributeValueAssertion, AttributeValueAssertion attributeValueAssertion2) {
            String string;
            String string2;
            if (attributeValueAssertion == null || attributeValueAssertion2 == null) {
                return false;
            }
            if (attributeValueAssertion.getAttributeType() != attributeValueAssertion2.getAttributeType()) {
                return false;
            }
            try {
                string2 = attributeValueAssertion.getStringAttribute();
                string = attributeValueAssertion2.getStringAttribute();
            }
            catch (NameException nameException) {
                return false;
            }
            if (attributeValueAssertion.getAttributeType() == 7) {
                return this.b(string2, string);
            }
            switch (attributeValueAssertion.getValueType()) {
                case 4864: {
                    return this.a(string2, string);
                }
                case 3072: 
                case 5120: 
                case 7168: 
                case 7680: {
                    return string2.equals(string);
                }
            }
            return false;
        }

        private boolean a(BuiltInStandardAttributes builtInStandardAttributes, BuiltInStandardAttributes builtInStandardAttributes2) {
            if (builtInStandardAttributes == null || builtInStandardAttributes2 == null) {
                return false;
            }
            if (!this.a(builtInStandardAttributes.getCountryName(), builtInStandardAttributes2.getCountryName())) {
                return false;
            }
            if (!this.a(builtInStandardAttributes.getAdminDomainName(), builtInStandardAttributes2.getAdminDomainName())) {
                return false;
            }
            if (builtInStandardAttributes.getNetworkAddress() != null && !builtInStandardAttributes.getNetworkAddress().equals(builtInStandardAttributes2.getNetworkAddress())) {
                return false;
            }
            if (builtInStandardAttributes.getTerminalIdentifier() != null && !builtInStandardAttributes.getTerminalIdentifier().equals(builtInStandardAttributes2.getTerminalIdentifier())) {
                return false;
            }
            if (!this.a(builtInStandardAttributes.getPrivateDomainName(), builtInStandardAttributes2.getPrivateDomainName())) {
                return false;
            }
            if (builtInStandardAttributes.getOrganizationName() != null && !builtInStandardAttributes.getOrganizationName().equals(builtInStandardAttributes2.getOrganizationName())) {
                return false;
            }
            if (builtInStandardAttributes.getNumericUserIdentifier() != null && !builtInStandardAttributes.getNumericUserIdentifier().equals(builtInStandardAttributes2.getNumericUserIdentifier())) {
                return false;
            }
            if (!this.a(builtInStandardAttributes.getPersonalName(), builtInStandardAttributes2.getPersonalName())) {
                return false;
            }
            return builtInStandardAttributes.getOrganizationalUnitNames() == null || builtInStandardAttributes.getOrganizationalUnitNames().equals(builtInStandardAttributes2.getOrganizationalUnitNames());
        }

        private boolean a(BuiltInDomainDefinedAttributes builtInDomainDefinedAttributes, BuiltInDomainDefinedAttributes builtInDomainDefinedAttributes2) {
            if (builtInDomainDefinedAttributes == null || builtInDomainDefinedAttributes2 == null) {
                return false;
            }
            if (builtInDomainDefinedAttributes2.getAttributeCount() == 0) {
                return true;
            }
            if (builtInDomainDefinedAttributes.getAttributeCount() > builtInDomainDefinedAttributes2.getAttributeCount()) {
                return false;
            }
            try {
                for (int i = 0; i < builtInDomainDefinedAttributes.getAttributeCount(); ++i) {
                    if (builtInDomainDefinedAttributes.getAttribute(i).equals(builtInDomainDefinedAttributes2.getAttribute(i))) continue;
                    return false;
                }
            }
            catch (NameException nameException) {
                return false;
            }
            return true;
        }

        private boolean a(ExtensionAttributes extensionAttributes, ExtensionAttributes extensionAttributes2) {
            if (extensionAttributes == null || extensionAttributes2 == null) {
                return false;
            }
            int n = extensionAttributes.getAttributeCount();
            int n2 = extensionAttributes2.getAttributeCount();
            if (n2 == 0) {
                return true;
            }
            if (n > n2) {
                return false;
            }
            try {
                for (int i = 0; i < n; ++i) {
                    boolean bl = false;
                    for (int j = 0; j < n2; ++j) {
                        if (!this.a(extensionAttributes.getAttribute(i), extensionAttributes2.getAttribute(j))) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return false;
                }
            }
            catch (NameException nameException) {
                return false;
            }
            return true;
        }

        private boolean a(ExtensionAttribute extensionAttribute, ExtensionAttribute extensionAttribute2) {
            int n;
            if (extensionAttribute == null || extensionAttribute2 == null) {
                return false;
            }
            int n2 = extensionAttribute.getAttributeType();
            if (n2 != (n = extensionAttribute2.getAttributeType())) {
                return false;
            }
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    String string = (String)extensionAttribute.getAttribute();
                    String string2 = (String)extensionAttribute2.getAttribute();
                    if (string == null) {
                        return string2 == null;
                    }
                    return string.equals(string2);
                }
                case 8: 
                case 9: {
                    return this.a((ORName)extensionAttribute.getAttribute(), (ORName)extensionAttribute2.getAttribute());
                }
                case 4: {
                    return this.a((PersonalName)extensionAttribute.getAttribute(), (PersonalName)extensionAttribute2.getAttribute());
                }
                case 5: {
                    return this.a((String[])extensionAttribute.getAttribute(), (String[])extensionAttribute2.getAttribute());
                }
                case 6: {
                    return this.a((BuiltInDomainDefinedAttributes)extensionAttribute.getAttribute(), (BuiltInDomainDefinedAttributes)extensionAttribute2.getAttribute());
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    PDSParameter pDSParameter = (PDSParameter)extensionAttribute.getAttribute();
                    PDSParameter pDSParameter2 = (PDSParameter)extensionAttribute2.getAttribute();
                    if (pDSParameter == null) {
                        return pDSParameter2 == null;
                    }
                    return pDSParameter.equals(pDSParameter2);
                }
                case 16: {
                    UnformattedPostalAddress unformattedPostalAddress = (UnformattedPostalAddress)extensionAttribute.getAttribute();
                    UnformattedPostalAddress unformattedPostalAddress2 = (UnformattedPostalAddress)extensionAttribute2.getAttribute();
                    if (unformattedPostalAddress == null) {
                        return unformattedPostalAddress2 == null;
                    }
                    return unformattedPostalAddress.equals(unformattedPostalAddress2);
                }
                case 22: {
                    ExtendedNetworkAddress extendedNetworkAddress = (ExtendedNetworkAddress)extensionAttribute.getAttribute();
                    ExtendedNetworkAddress extendedNetworkAddress2 = (ExtendedNetworkAddress)extensionAttribute2.getAttribute();
                    if (extendedNetworkAddress == null) {
                        return extendedNetworkAddress2 == null;
                    }
                    return extendedNetworkAddress.equals(extendedNetworkAddress2);
                }
                case 23: {
                    return extensionAttribute.getAttribute() == extensionAttribute2.getAttribute();
                }
            }
            return false;
        }

        private boolean a(PersonalName personalName, PersonalName personalName2) {
            if (personalName == null || personalName2 == null) {
                return false;
            }
            return personalName.equals(personalName2);
        }

        private boolean a(String[] stringArray, String[] stringArray2) {
            if (stringArray == null || stringArray2 == null) {
                return false;
            }
            if (stringArray.length > stringArray2.length) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(stringArray2[i])) continue;
                return false;
            }
            return true;
        }

        private boolean a(UnformattedPostalAddress unformattedPostalAddress, UnformattedPostalAddress unformattedPostalAddress2) {
            if (unformattedPostalAddress == null || unformattedPostalAddress2 == null) {
                return false;
            }
            String[] stringArray = unformattedPostalAddress.getPrintableAddress();
            String[] stringArray2 = unformattedPostalAddress2.getPrintableAddress();
            if (stringArray == null) {
                if (stringArray2 != null) {
                    return false;
                }
            } else {
                if (stringArray.length > stringArray2.length) {
                    return false;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals(stringArray2[i])) continue;
                    return false;
                }
            }
            String string = unformattedPostalAddress.getTeletexString();
            String string2 = unformattedPostalAddress2.getTeletexString();
            if (string == null) {
                return string2 == null;
            }
            return string.equals(string2);
        }

        private boolean a(ORName oRName, ORName oRName2) {
            if (oRName == null || oRName2 == null) {
                return false;
            }
            return oRName.equals(oRName2);
        }

        private boolean f(String string, String string2) {
            int n = string.length();
            int n2 = string2.length();
            if (n2 < n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(n - 1 - i);
                char c2 = string2.charAt(n2 - 1 - i);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 97 + 65);
                }
                if (c2 >= 'a' && c2 <= 'z') {
                    c2 = (char)(c2 - 97 + 65);
                }
                if (c == c2) continue;
                return false;
            }
            return true;
        }

        private String b(String string) {
            int n;
            boolean bl = false;
            int n2 = 0;
            int n3 = string.length();
            for (n = 0; n < n3; ++n) {
                if (string.charAt(n) == '/') {
                    if (bl) {
                        n2 = n + 1;
                        break;
                    }
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                bl = false;
            }
            for (n = n2; n < n3 && string.charAt(n) != '/'; ++n) {
            }
            return new String(string.toCharArray(), n2, n - n2);
        }

        private void b(CertPathCtx certPathCtx, X500Name x500Name, byte[] byArray, Vector vector) throws CertPathException {
            Certificate[] certificateArray = certPathCtx.getTrustedCerts();
            if (certificateArray != null) {
                for (int i = 0; i < certificateArray.length; ++i) {
                    X509Certificate x509Certificate;
                    Certificate certificate = certificateArray[i];
                    if (!(certificate instanceof X509Certificate) || !x500Name.equals((x509Certificate = (X509Certificate)certificate).getIssuerName()) || !CertJUtils.byteArraysEqual(byArray, x509Certificate.getSerialNumber())) continue;
                    if (!vector.contains(x509Certificate)) {
                        vector.addElement(x509Certificate);
                    }
                    return;
                }
            }
            try {
                certPathCtx.getDatabase().selectCertificateByIssuerAndSerialNumber(x500Name, byArray, vector);
            }
            catch (NoServiceException noServiceException) {
                throw new CertPathException("PKIXCertPath$Implementation.findCertByIssuerAndSerial: " + noServiceException.getMessage());
            }
            catch (DatabaseException databaseException) {
                throw new CertPathException("PKIXCertPath$Implementation.findCertByIssuerAndSerial: " + databaseException.getMessage());
            }
        }

        private void b(CertPathCtx certPathCtx, X500Name x500Name, X509V3Extensions x509V3Extensions, Vector vector) throws CertPathException {
            Certificate[] certificateArray = certPathCtx.getTrustedCerts();
            if (certificateArray != null) {
                for (int i = 0; i < certificateArray.length; ++i) {
                    Certificate certificate = certificateArray[i];
                    if (!(certificate instanceof X509Certificate)) continue;
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    if (x500Name != null && !x509Certificate.getSubjectName().contains(x500Name) || !CertJUtils.compareExtensions(x509V3Extensions, x509Certificate.getExtensions()) || vector.contains(x509Certificate)) continue;
                    vector.addElement(x509Certificate);
                }
            }
            try {
                certPathCtx.getDatabase().selectCertificateByExtensions(x500Name, x509V3Extensions, vector);
            }
            catch (NoServiceException noServiceException) {
                throw new CertPathException("PKIXCertPath$Implementation.findCertByExtension: " + noServiceException.getMessage());
            }
            catch (DatabaseException databaseException) {
                throw new CertPathException("PKIXCertPath$Implementation.findCertByExtension: " + databaseException.getMessage());
            }
        }

        private Vector a(byte[][] byArray) {
            Vector<byte[]> vector = new Vector<byte[]>();
            if (byArray == null) {
                return vector;
            }
            for (int i = 0; i < byArray.length; ++i) {
                byte[] byArray2 = byArray[i];
                if (CertJUtils.containsByteArray(vector, byArray2)) continue;
                vector.addElement(byArray2);
            }
            return vector;
        }

        public String toString() {
            return "PKIX Certification Path provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Cp cp) throws InvalidParameterException {
            this(certJ, string);
        }
    }
}

