/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.provider.pki.cmp.CMPException;

public class TypeAndValue {
    private byte[] a = null;
    private byte[] b = null;
    private int c;
    private ASN1Template d = null;

    protected TypeAndValue(byte[] byArray, int n, int n2) throws CMPException {
        if (byArray == null) {
            throw new CMPException("TypeAndValue.TypeAndValue: ber should not be null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        OIDContainer oIDContainer = new OIDContainer(0x1000000);
        EncodedContainer encodedContainer = new EncodedContainer(130816);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
        try {
            ASN1.berDecode((byte[])byArray, (int)n, (ASN1Container[])aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("TypeAndValue.TypeAndValue: BER-decoding failed(" + aSN_Exception.getMessage() + ").");
        }
        this.a = new byte[oIDContainer.dataLen];
        System.arraycopy(oIDContainer.data, oIDContainer.dataOffset, this.a, 0, oIDContainer.dataLen);
        if (encodedContainer.dataPresent) {
            this.b = new byte[encodedContainer.dataLen];
            System.arraycopy(encodedContainer.data, encodedContainer.dataOffset, this.b, 0, encodedContainer.dataLen);
        }
    }

    public TypeAndValue(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws CMPException {
        if (byArray == null) {
            throw new CMPException("TypeAndValue.TypeAndValue: type should not be null.");
        }
        this.a = new byte[n2];
        System.arraycopy(byArray, n, this.a, 0, n2);
        if (byArray2 == null) {
            this.b = null;
        } else {
            this.b = new byte[n4];
            System.arraycopy(byArray2, n3, this.b, 0, n4);
        }
    }

    protected int getDERLen(int n) throws CMPException {
        this.c = n;
        try {
            SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
            OIDContainer oIDContainer = new OIDContainer(0x1000000, true, 0, this.a, 0, this.a.length);
            EncodedContainer encodedContainer = this.b == null ? new EncodedContainer(130816, false, 0, null, 0, 0) : new EncodedContainer(130816, true, 0, this.b, 0, this.b.length);
            EndContainer endContainer = new EndContainer();
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
            this.d = new ASN1Template(aSN1ContainerArray);
            return this.d.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("TypeAndValue.getDERLen: DER-encoding failed(" + aSN_Exception.getMessage() + ").");
        }
    }

    protected int getDEREncoding(byte[] byArray, int n, int n2) throws CMPException {
        if (byArray == null) {
            throw new CMPException("TypeAndValue.getDEREncoding: encoding should not be null.");
        }
        try {
            int n3;
            if ((this.d == null || n2 != this.c) && (n3 = this.getDERLen(n2)) == 0) {
                throw new CMPException("TypeAndValue.getDEREncoding: DER-encoding has 0 length.");
            }
            n3 = this.d.derEncode(byArray, n);
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("TypeAndValue.getDEREncoding: DER-encoding failed(" + aSN_Exception.getMessage() + ").");
        }
        finally {
            this.d = null;
        }
    }

    public byte[] getType() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.a.length];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        return byArray;
    }

    public byte[] getValue() {
        if (this.b == null) {
            return null;
        }
        byte[] byArray = new byte[this.b.length];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TypeAndValue)) {
            return false;
        }
        TypeAndValue typeAndValue = (TypeAndValue)object;
        return CertJUtils.byteArraysEqual(this.a, typeAndValue.a) && CertJUtils.byteArraysEqual(this.b, typeAndValue.b);
    }
}

