/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation;

import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.RevokedCertificates;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.CRLEvidence;
import com.rsa.certj.provider.revocation.Cae;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.certj.spi.revocation.CertStatusInterface;
import java.util.Date;
import java.util.Vector;

public final class CRLCertStatus
extends Provider {
    public CRLCertStatus(String string) throws InvalidParameterException {
        super(2, string);
    }

    public ProviderImplementation instantiate(CertJ certJ) throws ProviderManagementException {
        try {
            return new Implementation(certJ, this.getName(), null);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new ProviderManagementException("CRLCertStatus.instantiate: " + invalidParameterException.getMessage());
        }
    }

    private final class Implementation
    extends ProviderImplementation
    implements CertStatusInterface {
        private Implementation(CertJ certJ, String string) throws InvalidParameterException {
            super(certJ, string);
        }

        public CertRevocationInfo checkCertRevocation(CertPathCtx certPathCtx, Certificate certificate) throws NotSupportedException, CertStatusException {
            if (!(certificate instanceof X509Certificate)) {
                throw new NotSupportedException("CRLCertStatus$Implementation.checkCertRevocation: does not support certificat types other than X509Certificate.");
            }
            try {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                Date date = null;
                date = certPathCtx.getValidationTime() == null ? new Date() : certPathCtx.getValidationTime();
                Vector vector = new Vector();
                certPathCtx.getDatabase().selectCRLByIssuerAndTime(x509Certificate.getIssuerName(), date, vector);
                Vector vector2 = new Vector();
                Vector vector3 = new Vector();
                Vector vector4 = new Vector();
                for (int i = 0; i < vector.size(); ++i) {
                    X509CRL x509CRL = (X509CRL)vector.elementAt(i);
                    if (this.a(x509CRL, date) || !this.certJ.buildCertPath(certPathCtx, x509CRL, vector2, vector3, vector4, null)) continue;
                    CertJUtils.mergeLists(vector2, vector4);
                    CRLEvidence cRLEvidence = new CRLEvidence(x509CRL, vector2, vector3);
                    if (this.a(x509Certificate.getSerialNumber(), x509CRL)) {
                        return new CertRevocationInfo(1, 1, cRLEvidence);
                    }
                    return new CertRevocationInfo(0, 1, cRLEvidence);
                }
                return new CertRevocationInfo(2, 0, null);
            }
            catch (Exception exception) {
                throw new CertStatusException("CRLCertStatus$Implementation.checkCertRevocation: " + exception.getMessage());
            }
        }

        private boolean a(byte[] byArray, X509CRL x509CRL) {
            RevokedCertificates revokedCertificates = x509CRL.getRevokedCertificates();
            if (revokedCertificates == null) {
                return false;
            }
            for (int i = 0; i < revokedCertificates.getCertificateCount(); ++i) {
                try {
                    if (!CertJUtils.byteArraysEqual(byArray, revokedCertificates.getSerialNumber(i))) continue;
                    return true;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            return false;
        }

        private boolean a(X509CRL x509CRL, Date date) {
            Date date2 = x509CRL.getNextUpdate();
            return date2 != null && date.after(date2);
        }

        public String toString() {
            return "CRL Certificate Status provider named: " + super.getName();
        }

        /* synthetic */ Implementation(CertJ certJ, String string, Cae cae) throws InvalidParameterException {
            this(certJ, string);
        }
    }
}

