/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.revocation.ocsp;

import com.rsa.certj.DatabaseService;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.provider.revocation.ocsp.OCSPRequestControl;

public class OCSPResponder
implements Cloneable {
    public static final int PROFILE_GENERIC = 0;
    public static final int PROFILE_VALICERT = 1;
    public static final int PROFILE_RSAKCA = 2;
    public static final int PROFILE_VERISIGN = 3;
    private static final int a = 3;
    public static final int FLAG_DISABLE_NONCES = 1;
    public static final int FLAG_DISABLE_CERT_SEND = 2;
    public static final int FLAG_ENABLE_CHAIN_SEND = 4;
    public static final int FLAG_RESPONDER_NOCHECK = 8;
    private int b;
    private int c;
    private String[] d;
    private String[] e;
    private OCSPRequestControl f;
    private X509Certificate g;
    private X509Certificate[] h;
    private DatabaseService i;
    private int j;

    public OCSPResponder(int n, int n2, String[] stringArray, String[] stringArray2, OCSPRequestControl oCSPRequestControl, X509Certificate x509Certificate, X509Certificate[] x509CertificateArray, DatabaseService databaseService, int n3) throws InvalidParameterException {
        int n4;
        if (n < 0 || n > 3) {
            throw new InvalidParameterException("OCSPResponder.profile");
        }
        this.b = n;
        if ((n2 & 4) != 0 && (n2 & 2) != 0) {
            throw new InvalidParameterException("FLAG_ENABLE_CHAIN_SEND && FLAG_DISABLE_CERT_SEND incompatible");
        }
        this.c = n2;
        if (stringArray == null) {
            this.d = null;
        } else {
            this.d = new String[stringArray.length];
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                if (stringArray[n4] == null) continue;
                this.d[n4] = new String(stringArray[n4]);
            }
        }
        if (stringArray2 == null) {
            this.e = null;
        } else {
            this.e = new String[stringArray2.length];
            for (n4 = 0; n4 < stringArray2.length; ++n4) {
                if (stringArray2[n4] == null) continue;
                this.e[n4] = new String(stringArray2[n4]);
            }
        }
        try {
            this.f = oCSPRequestControl == null ? null : (OCSPRequestControl)oCSPRequestControl.clone();
            X509Certificate x509Certificate2 = this.g = x509Certificate == null ? null : (X509Certificate)x509Certificate.clone();
            if (x509CertificateArray == null) {
                throw new InvalidParameterException("responderCACerts == null");
            }
            this.h = new X509Certificate[x509CertificateArray.length];
            for (n4 = 0; n4 < x509CertificateArray.length; ++n4) {
                if (x509CertificateArray[n4] == null) {
                    throw new InvalidParameterException("responderCACerts[" + n4 + "] == null");
                }
                this.h[n4] = (X509Certificate)x509CertificateArray[n4].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.toString());
        }
        this.i = databaseService;
        this.j = n3;
    }

    public OCSPResponder(OCSPRequestControl oCSPRequestControl, X509Certificate[] x509CertificateArray) throws InvalidParameterException {
        try {
            this.b = 0;
            this.c = 0;
            OCSPRequestControl oCSPRequestControl2 = this.f = oCSPRequestControl == null ? null : (OCSPRequestControl)oCSPRequestControl.clone();
            if (x509CertificateArray == null) {
                throw new InvalidParameterException("responderCACerts == null");
            }
            this.h = new X509Certificate[x509CertificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                if (x509CertificateArray[i] == null) {
                    throw new InvalidParameterException("responderCACerts[" + i + "] == null");
                }
                this.h[i] = (X509Certificate)x509CertificateArray[i].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.toString());
        }
        this.i = this.i;
        this.j = 0;
    }

    public OCSPResponder(OCSPResponder oCSPResponder) throws InvalidParameterException {
        int n;
        int n2;
        if (oCSPResponder == null) {
            throw new InvalidParameterException("responder == null");
        }
        this.b = oCSPResponder.getProfile();
        this.c = oCSPResponder.getFlags();
        String[] stringArray = oCSPResponder.getDestList();
        if (stringArray == null) {
            this.d = null;
        } else {
            int n3 = stringArray.length;
            this.d = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                if (stringArray[n2] == null) continue;
                this.d[n2] = new String(stringArray[n2]);
            }
        }
        String[] stringArray2 = oCSPResponder.getProxyList();
        if (stringArray2 == null) {
            this.e = null;
        } else {
            n2 = stringArray2.length;
            this.e = new String[n2];
            for (n = 0; n < n2; ++n) {
                if (stringArray2[n] == null) continue;
                this.e[n] = new String(stringArray2[n]);
            }
        }
        try {
            this.f = oCSPResponder.getRequestControl() == null ? null : (OCSPRequestControl)oCSPResponder.getRequestControl().clone();
            this.g = oCSPResponder.getResponderCert() == null ? null : (X509Certificate)oCSPResponder.getResponderCert().clone();
            X509Certificate[] x509CertificateArray = oCSPResponder.getResponderCACerts();
            if (x509CertificateArray == null) {
                throw new InvalidParameterException("OCSPResponder.responderCACerts");
            }
            this.h = new X509Certificate[x509CertificateArray.length];
            for (n = 0; n < x509CertificateArray.length; ++n) {
                if (x509CertificateArray[n] == null) {
                    throw new InvalidParameterException("responderCACerts[" + n + "] == null");
                }
                this.h[n] = (X509Certificate)x509CertificateArray[n].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.toString());
        }
        this.i = oCSPResponder.getDatabase();
        this.j = oCSPResponder.getTimeTolerance();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return new OCSPResponder(this);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new CloneNotSupportedException(invalidParameterException.getMessage());
        }
    }

    public int getProfile() {
        return this.b;
    }

    public int getFlags() {
        return this.c;
    }

    public String[] getDestList() {
        return this.d;
    }

    public String[] getProxyList() {
        return this.e;
    }

    public OCSPRequestControl getRequestControl() {
        return this.f;
    }

    public X509Certificate getResponderCert() {
        return this.g;
    }

    public X509Certificate[] getResponderCACerts() {
        return this.h;
    }

    protected X509Certificate getResponderCACert(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        for (int i = 0; i < this.h.length; ++i) {
            if (!x509Certificate.getIssuerName().equals(this.h[i].getSubjectName())) continue;
            return this.h[i];
        }
        return null;
    }

    protected X509Certificate getResponderCACert(X509Certificate x509Certificate, String string) {
        if (x509Certificate == null || string == null || this.d == null) {
            return null;
        }
        for (int i = 0; i < this.d.length; ++i) {
            X509Certificate x509Certificate2;
            if (!string.equals(this.d[i]) || (x509Certificate2 = this.getResponderCACert(x509Certificate)) == null) continue;
            return x509Certificate2;
        }
        return null;
    }

    public void setProfile(int n) throws InvalidParameterException {
        if (n < 0 || n > 3) {
            throw new InvalidParameterException("OCSPResponder.profile");
        }
        this.b = n;
    }

    public void setFlags(int n) throws InvalidParameterException {
        this.c = n;
    }

    public void setProxyList(String[] stringArray) throws InvalidParameterException {
        if (stringArray == null) {
            this.e = null;
        } else {
            this.e = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) {
                    throw new InvalidParameterException("proxyList[" + i + "] == null");
                }
                this.e[i] = new String(stringArray[i]);
            }
        }
    }

    public void setRequestControl(OCSPRequestControl oCSPRequestControl) throws InvalidParameterException {
        try {
            this.f = oCSPRequestControl == null ? null : (OCSPRequestControl)oCSPRequestControl.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.getMessage());
        }
    }

    public void setResponderCACerts(X509Certificate[] x509CertificateArray) throws InvalidParameterException {
        if (x509CertificateArray == null) {
            throw new InvalidParameterException("responderCACerts");
        }
        try {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                if (x509CertificateArray[i] == null) {
                    throw new InvalidParameterException("responderCACerts[" + i + "] == null");
                }
                this.h[i] = (X509Certificate)x509CertificateArray[i].clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidParameterException(cloneNotSupportedException.getMessage());
        }
    }

    public void setDatabase(DatabaseService databaseService) throws InvalidParameterException {
        this.i = databaseService;
    }

    public DatabaseService getDatabase() {
        return this.i;
    }

    public void setTimeTolerance(int n) {
        this.j = n;
    }

    public int getTimeTolerance() {
        return this.j;
    }
}

