/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.xml;

import com.rsa.certj.xml.Base64Transformer;
import com.rsa.certj.xml.Canonicalizer;
import com.rsa.certj.xml.KeyInfo;
import com.rsa.certj.xml.NodeListImpl;
import com.rsa.certj.xml.Transformer;
import com.rsa.certj.xml.XMLException;
import com.rsa.certj.xml.dsig.Reference;
import com.rsa.certj.xml.dsig.XMLSignature;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserHandler {
    public static String PRINTWRITER_ENCODING = "UTF-8";
    public static String TEMPLATE_ID = null;
    public static String SYSTEM_ID = null;
    public static String PUBLIC_ID = null;
    public static String DTD_LOCATION = "file:///C:/xmldsig-core-schema.dtd";
    public static boolean setValidation = false;
    public static boolean setNameSpaces = true;
    private static boolean a = true;

    public static XMLSignature[] read(String string) throws XMLException {
        if (string == null) {
            throw new XMLException("Can't read a null file");
        }
        InputStream inputStream = null;
        try {
            inputStream = new URL(string).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (IOException iOException) {
                throw new XMLException("Can't read file: " + malformedURLException.getMessage() + "\n or " + iOException.getMessage());
            }
        }
        catch (IOException iOException) {
            throw new XMLException("Can't read file " + iOException.getMessage());
        }
        XMLSignature[] xMLSignatureArray = ParserHandler.read(new InputSource(inputStream));
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLException("Can't close file: " + iOException.getMessage());
        }
        return xMLSignatureArray;
    }

    public static XMLSignature[] read(File file) throws XMLException {
        if (file == null) {
            throw new XMLException("Error in reading XML document: File object is null");
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            XMLSignature[] xMLSignatureArray = ParserHandler.read(fileInputStream);
            fileInputStream.close();
            return xMLSignatureArray;
        }
        catch (IOException iOException) {
            throw new XMLException("Can't read file: " + iOException.getMessage());
        }
    }

    public static XMLSignature[] read(InputStream inputStream) throws XMLException {
        if (inputStream == null) {
            throw new XMLException("inputStream is null");
        }
        InputSource inputSource = new InputSource(inputStream);
        return ParserHandler.read(inputSource);
    }

    protected static XMLSignature[] read(InputSource inputSource) throws XMLException {
        String string;
        Object object;
        NodeList nodeList;
        if (inputSource == null) {
            throw new XMLException("Can't read the file: file is null");
        }
        Document document = null;
        if (PUBLIC_ID != null) {
            inputSource.setPublicId(PUBLIC_ID);
        }
        if (SYSTEM_ID != null) {
            inputSource.setSystemId(SYSTEM_ID);
        }
        if ((nodeList = (document = ParserHandler.parseXML(inputSource)).getElementsByTagNameNS("*", "Signature")).getLength() == 0) {
            throw new XMLException("This document does not contain XML signature.");
        }
        NodeListImpl nodeListImpl = new NodeListImpl();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            object = element.getPrefix();
            object = object == null ? "" : ":" + (String)object;
            string = element.getAttribute("xmlns" + (String)object);
            if (!string.equals(XMLSignature.SUPPORTED_XML_NAMESPACES[0]) && !string.equals(XMLSignature.SUPPORTED_XML_NAMESPACES[1])) continue;
            nodeListImpl.add(element);
        }
        if (nodeListImpl.getLength() == 0) {
            throw new XMLException("Unsupported namespace.");
        }
        XMLSignature[] xMLSignatureArray = new XMLSignature[nodeListImpl.getLength()];
        for (int i = 0; i < nodeListImpl.getLength(); ++i) {
            int n;
            xMLSignatureArray[i] = new XMLSignature();
            xMLSignatureArray[i].setDocument(document);
            object = (Element)nodeListImpl.item(i);
            xMLSignatureArray[i].setSignatureElement((Element)object);
            string = object.getPrefix();
            if (string == null) {
                string = "";
            } else {
                xMLSignatureArray[i].setNamespacePrefix(string);
                string = ":" + string;
            }
            if (object.hasAttribute("xmlns" + string)) {
                // empty if block
            }
            xMLSignatureArray[i].setXMLNamespace(object.getAttribute("xmlns" + string));
            if (object.hasAttribute("Id")) {
                xMLSignatureArray[i].setSignatureID(object.getAttribute("Id"));
            }
            ParserHandler.parseSignedInfo(xMLSignatureArray[i], (Element)object);
            NodeList nodeList2 = null;
            String string2 = xMLSignatureArray[i].getXMLNamespace();
            NodeList nodeList3 = object.getElementsByTagNameNS(string2, "Object");
            for (n = 0; n < nodeList3.getLength(); ++n) {
                xMLSignatureArray[i].addXMLObject((Element)nodeList3.item(n));
            }
            nodeList3 = object.getElementsByTagName("dsig:Object");
            for (n = 0; n < nodeList3.getLength(); ++n) {
                xMLSignatureArray[i].addXMLObject((Element)nodeList3.item(n));
            }
            NodeList nodeList4 = object.getElementsByTagNameNS(string2, "KeyInfo");
            if (nodeList4.getLength() > 0) {
                nodeList2 = nodeList4.item(0).getChildNodes();
                int n2 = 0;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    if (nodeList2.item(j).getNodeType() != 1) continue;
                    ++n2;
                }
                KeyInfo[] keyInfoArray = new KeyInfo[n2];
                int n3 = 0;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    if (nodeList2.item(j).getNodeType() != 1) continue;
                    String string3 = nodeList2.item(j).getNodeName();
                    keyInfoArray[n3] = KeyInfo.getInstance(string3);
                    keyInfoArray[n3].parseKeyInfo((Element)nodeList2.item(j), string2);
                    ++n3;
                }
                xMLSignatureArray[i].setKeyInfos(keyInfoArray);
            }
            xMLSignatureArray[i].setSignatureType(ParserHandler.checkSignatureType(xMLSignatureArray[i]));
        }
        return xMLSignatureArray;
    }

    public static Document parseXML(InputSource inputSource) throws XMLException {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(setValidation);
            documentBuilderFactory.setNamespaceAware(setNameSpaces);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ErrorHandler errorHandler = new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            };
            documentBuilder.setErrorHandler(errorHandler);
            document = documentBuilder.parse(inputSource);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new XMLException("Error in parser factory: " + factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException("Error configuring parser: " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new XMLException("Error in parsing: " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new XMLException("Error in reading: " + iOException.getMessage());
        }
        return document;
    }

    public static void parseSignedInfo(XMLSignature xMLSignature, Element element) throws XMLException {
        if (xMLSignature != null && element != null) {
            Object object;
            NodeList nodeList;
            int n;
            String string = xMLSignature.getXMLNamespace();
            NodeList nodeList2 = element.getElementsByTagNameNS(string, "SignedInfo");
            if (nodeList2.getLength() == 0) {
                throw new XMLException("Error in reading XML signature document:SignedInfo not available");
            }
            for (n = 0; n < nodeList2.getLength(); ++n) {
                if (nodeList2.item(n).getParentNode() != element) continue;
                xMLSignature.setSignedInfo(nodeList2.item(n));
                break;
            }
            if (n == nodeList2.getLength()) {
                throw new XMLException("Error in reading XML signature document:SignedInfo not available");
            }
            NodeList nodeList3 = element.getElementsByTagNameNS(string, "CanonicalizationMethod");
            if (nodeList3.getLength() == 0) {
                throw new XMLException("Error in reading XML Signature document:Canonicalization method missed");
            }
            Node node = nodeList3.item(0);
            if (!((Element)node).hasAttribute("Algorithm")) {
                throw new XMLException("Error in reading XML Signature document:Canonicalization algorithm missed");
            }
            String string2 = ((Element)node).getAttribute("Algorithm");
            xMLSignature.setCanonicalizationMethod(string2);
            NodeList nodeList4 = element.getElementsByTagNameNS(string, "SignatureMethod");
            if (nodeList4.getLength() == 0) {
                throw new XMLException("Error in reading XML signature document:SignatureMethod not available");
            }
            Element element2 = (Element)nodeList4.item(0);
            String string3 = element2.getAttribute("Algorithm");
            if (string3 == null) {
                throw new XMLException("Error in reading XML signature document:SignaureMethod value not available");
            }
            for (int i = 0; i < XMLSignature.SUPPORTED_MAC_ALGORITHMS.length; ++i) {
                if (!string3.equals(XMLSignature.SUPPORTED_MAC_ALGORITHMS[i])) continue;
                nodeList = element2.getElementsByTagNameNS(string, "HMACOutputLength");
                if (nodeList.getLength() <= 0) break;
                int n2 = Integer.parseInt(nodeList.item(0).getChildNodes().item(0).getNodeValue());
                xMLSignature.setHMACOutputLen(n2);
                break;
            }
            xMLSignature.setSignatureMethod(string3);
            NodeList nodeList5 = element.getElementsByTagNameNS(string, "Reference");
            if (nodeList5.getLength() > 0) {
                nodeList = ParserHandler.a(nodeList5);
                object = new Reference[nodeList.getLength()];
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object[i] = new Reference();
                    object[i].parseReference((Element)nodeList.item(i), string);
                }
            } else {
                throw new XMLException("Error in reading XML signature document:Reference not present");
            }
            xMLSignature.setReferences((Reference[])object);
            nodeList = element.getElementsByTagNameNS(string, "SignatureValue");
            if (nodeList.getLength() == 0) {
                throw new XMLException("Error in reading XML signature document:Signature value not available");
            }
            object = nodeList.item(0).getChildNodes();
            if (object.getLength() > 0) {
                String string4 = object.item(0).getNodeValue();
                byte[] byArray = Base64Transformer.decodeBase64Data(string4.getBytes(), 0, string4.getBytes().length);
                xMLSignature.setSignatureValue(byArray);
            }
        }
    }

    public static int checkSignatureType(XMLSignature xMLSignature) {
        Reference[] referenceArray = xMLSignature.getReferences();
        for (int i = 0; i < referenceArray.length; ++i) {
            Transformer[] transformerArray = referenceArray[i].getTransforms();
            if (transformerArray == null) continue;
            for (int j = 0; j < transformerArray.length; ++j) {
                for (int k = 0; k < Transformer.ENVELOPED_SIGNATURE_LIST.length; ++k) {
                    if (!transformerArray[j].getTransformAlgorithm().equals(Transformer.ENVELOPED_SIGNATURE_LIST[k])) continue;
                    return 2;
                }
            }
        }
        Element element = xMLSignature.getSignatureElement();
        if (element.getNextSibling() == null) {
            return 8;
        }
        return 4;
    }

    public static void write(String string, XMLSignature xMLSignature) throws XMLException {
        if (string == null) {
            throw new XMLException("Can't write signatures out: signedDocument is null");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ParserHandler.write(fileOutputStream, xMLSignature);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLException("Can't write the XMLSignatures out" + iOException.getMessage());
        }
    }

    public static void write(File file, XMLSignature xMLSignature) throws XMLException {
        if (file == null) {
            throw new XMLException("Can't write signatures out: signedDocument is null");
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ParserHandler.write(fileOutputStream, xMLSignature);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLException("Can't write the signatures out: " + iOException.getMessage());
        }
    }

    public static void write(OutputStream outputStream, XMLSignature xMLSignature) throws XMLException {
        if (outputStream == null) {
            throw new XMLException("Can't write signatures out: outputStream is null");
        }
        if (xMLSignature == null) {
            throw new XMLException("Can't write signatures out: XMLSignature object is null");
        }
        Object object = null;
        Element element = null;
        try {
            Object object2;
            int n = xMLSignature.getSignatureType() & 0xE;
            if (n == 2) {
                object2 = xMLSignature.getDocument();
                element = xMLSignature.getSignatureElement();
                if (element == null) {
                    element = ParserHandler.generateSignatureElement(xMLSignature, (Document)object2);
                    xMLSignature.setSignatureElement(element);
                }
                if (!xMLSignature.useTemplate || !xMLSignature.foundET) {
                    object2.getDocumentElement().appendChild(element);
                }
                object = object2;
            } else if (n == 8) {
                object = xMLSignature.getSignatureElement().getOwnerDocument();
            } else if (n == 4) {
                object2 = xMLSignature.getDocument();
                element = xMLSignature.getSignatureElement();
                if (element == null) {
                    element = ParserHandler.generateSignatureElement(xMLSignature, (Document)object2);
                    xMLSignature.setSignatureElement(element);
                }
                object = object2;
            } else {
                throw new XMLException("Unknown signature type");
            }
            object2 = new StringBuffer();
            ParserHandler.getStringValue((Node)object, (StringBuffer)object2);
            byte[] byArray = ((StringBuffer)object2).toString().getBytes(PRINTWRITER_ENCODING);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new XMLException("Can't write the signedDocument out: " + iOException.getMessage());
        }
    }

    public static Element generateSignatureElement(XMLSignature xMLSignature, Document document) throws XMLException {
        Element element = null;
        try {
            Object object;
            String string;
            if (xMLSignature.getSignatureMethod() == null) {
                throw new XMLException("Signature method not set");
            }
            String string2 = string = xMLSignature.getNamespacePrefix();
            if (string == null) {
                string = "";
                string2 = "";
            } else {
                string = string + ":";
                string2 = ":" + string2;
            }
            String string3 = xMLSignature.getXMLNamespace();
            element = document.createElementNS(xMLSignature.getXMLNamespace(), string + "Signature");
            element.setAttribute("xmlns" + string2, string3);
            if (xMLSignature.getSignatureID() != null) {
                element.setAttribute("Id", xMLSignature.getSignatureID());
            }
            element.appendChild(document.createTextNode("\n  "));
            Element element2 = document.createElementNS(xMLSignature.getXMLNamespace(), string + "SignedInfo");
            element.appendChild(element2);
            element2.appendChild(document.createTextNode("\n    "));
            if (xMLSignature.getCanonicalizationMethod() == null) {
                throw new XMLException("Canonicalization method not set");
            }
            Element element3 = document.createElementNS(xMLSignature.getXMLNamespace(), string + "CanonicalizationMethod");
            element3.setAttribute("Algorithm", xMLSignature.getCanonicalizationMethod());
            element2.appendChild(element3);
            element2.appendChild(document.createTextNode("\n    "));
            Element element4 = document.createElementNS(xMLSignature.getXMLNamespace(), string + "SignatureMethod");
            element4.setAttribute("Algorithm", xMLSignature.getSignatureMethod());
            for (int i = 0; i < XMLSignature.SUPPORTED_MAC_ALGORITHMS.length; ++i) {
                if (!xMLSignature.getSignatureMethod().equals(XMLSignature.SUPPORTED_MAC_ALGORITHMS[i])) continue;
                if (xMLSignature.getHMACOutputLen() == 0) break;
                Element element5 = document.createElementNS(xMLSignature.getXMLNamespace(), string + "HMACOutputLength");
                element5.appendChild(document.createTextNode(Integer.toString(xMLSignature.getHMACOutputLen(), 10)));
                element4.appendChild(element5);
                break;
            }
            element2.appendChild(element4);
            element2.appendChild(document.createTextNode("\n    "));
            if (xMLSignature.getReferences() == null) {
                throw new XMLException("Reference not set");
            }
            for (int i = 0; i < xMLSignature.getReferences().length; ++i) {
                Element element6 = xMLSignature.getReferences()[i].generateReferenceElement(xMLSignature, document);
                element2.appendChild(element6);
                element2.appendChild(i == xMLSignature.getReferences().length - 1 ? document.createTextNode("\n  ") : document.createTextNode("\n    "));
            }
            element.appendChild(document.createTextNode("\n  "));
            Element element7 = document.createElementNS(xMLSignature.getXMLNamespace(), string + "SignatureValue");
            element.appendChild(element7);
            if (xMLSignature.getSignatureValue() != null) {
                object = Base64Transformer.encodeBase64(xMLSignature.getSignatureValue(), 0, xMLSignature.getSignatureValue().length);
                element7.appendChild(document.createTextNode(new String((byte[])object)));
                element.appendChild(document.createTextNode("\n  "));
            }
            if ((object = ParserHandler.generateKeyInfo(xMLSignature, document)) != null) {
                element.appendChild((Node)object);
                element.appendChild(document.createTextNode("\n"));
            }
        }
        catch (Exception exception) {
            throw new XMLException("Can't create signature element: " + exception.getMessage());
        }
        return element;
    }

    public static Element generateKeyInfo(XMLSignature xMLSignature, Document document) throws XMLException {
        if (xMLSignature.getKeyInfos() != null) {
            String string = xMLSignature.getNamespacePrefix();
            string = string == null ? "" : string + ":";
            String string2 = xMLSignature.getXMLNamespace();
            Element element = document.createElementNS(string2, string + "KeyInfo");
            element.appendChild(document.createTextNode("\n    "));
            Element element2 = null;
            for (int i = 0; i < xMLSignature.getKeyInfos().length; ++i) {
                element2 = xMLSignature.getKeyInfos()[i].generateKeyInfo(document, string2, string);
                element.appendChild(element2);
                element.appendChild(i == xMLSignature.getKeyInfos().length - 1 ? document.createTextNode("\n  ") : document.createTextNode("\n    "));
            }
            return element;
        }
        return null;
    }

    public static byte[] nodeToByteArray(NodeList nodeList, boolean bl, boolean bl2, String string) throws XMLException {
        if (nodeList == null) {
            throw new XMLException("Can't convert node set to byte array: Node set is null");
        }
        if (bl) {
            if (nodeList.getLength() == 1) {
                return Canonicalizer.canonicalizeNodeset(nodeList.item(0), bl2);
            }
            return Canonicalizer.canonicalizeNodeset(nodeList, bl2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        ParserHandler.getStringValue(nodeList, stringBuffer);
        return stringBuffer.toString().getBytes();
    }

    public static byte[] nodeToByteArray(Node node, boolean bl, boolean bl2, String string) throws XMLException {
        if (node == null) {
            throw new XMLException("Can't convert node set to byte array: Node set is null");
        }
        if (bl) {
            return Canonicalizer.canonicalizeNodeset(node, bl2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        ParserHandler.getStringValue(node, stringBuffer);
        return stringBuffer.toString().getBytes();
    }

    public static Node byteArrayToNode(byte[] byArray, int n, int n2) throws XMLException {
        if (byArray == null) {
            throw new XMLException("Can't convert octet stream to Node: input is null");
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            InputSource inputSource = new InputSource(byteArrayInputStream);
            Document document = ParserHandler.parseXML(inputSource);
            byteArrayInputStream.close();
            return document;
        }
        catch (Exception exception) {
            throw new XMLException("Can't convert octet stream to Node, it is not a well-formatted XML document" + exception.getMessage());
        }
    }

    public static void getStringValue(Node node, StringBuffer stringBuffer) throws XMLException {
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                stringBuffer.append("<?xml version=\"1.0\" encoding=\"");
                stringBuffer.append(PRINTWRITER_ENCODING);
                stringBuffer.append("\"?>\n");
                if (DTD_LOCATION != null) {
                    stringBuffer.append("<!DOCTYPE Signature SYSTEM \"");
                    stringBuffer.append(DTD_LOCATION);
                    stringBuffer.append("\">\n");
                }
                ParserHandler.a(node.getChildNodes(), stringBuffer);
                break;
            }
            case 1: {
                stringBuffer.append('<');
                stringBuffer.append(node.getNodeName());
                Attr[] attrArray = ParserHandler.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    stringBuffer.append(' ');
                    stringBuffer.append(attr.getNodeName());
                    stringBuffer.append("=\"");
                    stringBuffer.append(ParserHandler.normalize(attr.getNodeValue(), true));
                    stringBuffer.append('\"');
                }
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                if (nodeList != null) {
                    n = nodeList.getLength();
                }
                if (n == 0) {
                    stringBuffer.append("/>");
                    break;
                }
                stringBuffer.append('>');
                for (int i = 0; i < n; ++i) {
                    ParserHandler.getStringValue(nodeList.item(i), stringBuffer);
                }
                stringBuffer.append("</");
                stringBuffer.append(node.getNodeName());
                stringBuffer.append('>');
                break;
            }
            case 2: {
                stringBuffer.append(' ');
                stringBuffer.append(node.getNodeName());
                stringBuffer.append("=\"");
                stringBuffer.append(ParserHandler.normalize(node.getNodeValue(), true));
                stringBuffer.append('\"');
                break;
            }
            case 5: {
                ParserHandler.a(node.getChildNodes(), stringBuffer);
                break;
            }
            case 4: {
                stringBuffer.append(ParserHandler.normalize(node.getNodeValue(), false));
                break;
            }
            case 3: {
                stringBuffer.append(ParserHandler.normalize(node.getNodeValue(), false));
                break;
            }
            case 7: {
                stringBuffer.append("<?");
                stringBuffer.append(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string);
                }
                stringBuffer.append("?>");
                break;
            }
            case 8: {
                stringBuffer.append("<!--");
                stringBuffer.append(ParserHandler.normalize(node.getNodeValue(), false));
                stringBuffer.append("-->");
                break;
            }
            case 10: {
                break;
            }
        }
    }

    public static void getStringValue(NodeList nodeList, StringBuffer stringBuffer) throws XMLException {
        if (nodeList == null) {
            throw new XMLException("Node set is null");
        }
        ParserHandler.a(nodeList, stringBuffer);
    }

    private static void a(NodeList nodeList, StringBuffer stringBuffer) throws XMLException {
        if (nodeList == null) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ParserHandler.getStringValue(nodeList.item(i), stringBuffer);
        }
    }

    protected static String normalize(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    continue block7;
                }
                default: {
                    if (bl) {
                        if (c == '\t') {
                            stringBuffer.append("&#x9;");
                            continue block7;
                        }
                        if (c == '\n') {
                            stringBuffer.append("&#xA;");
                            continue block7;
                        }
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected static Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    private static boolean a(Node node, Node node2) {
        if (node == node2) {
            return false;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i) != node2) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static NodeList a(NodeList nodeList) {
        int n;
        NodeListImpl nodeListImpl = new NodeListImpl();
        Node node = nodeList.item(0);
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (!ParserHandler.a(nodeList.item(n).getParentNode().getParentNode(), node.getParentNode().getParentNode())) continue;
            node = nodeList.item(n);
        }
        nodeListImpl.add(node);
        for (n = 0; n < nodeList.getLength(); ++n) {
            if (node == nodeList.item(n) || node.getParentNode().getParentNode() != nodeList.item(n).getParentNode().getParentNode()) continue;
            nodeListImpl.add(nodeList.item(n));
        }
        return nodeListImpl;
    }

    protected static String intToHex(int n, int n2) {
        long l = n;
        char[] cArray = null;
        cArray = new char[n2 * 2];
        for (int i = n2 - 1; i >= 0; --i) {
            int n3 = (int)(l >> 4 & 0xFL);
            if (n3 < 0) {
                n3 += 16;
            }
            byte by = (byte)(l & 0xFL);
            cArray[i * 2] = n3 < 10 ? (char)(48 + n3) : (char)(65 + n3 - 10);
            cArray[i * 2 + 1] = by < 10 ? (char)(48 + by) : (char)(65 + by - 10);
            l >>= 8;
        }
        return new String(cArray);
    }

    protected static String byteArrayToHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n + n2; ++i) {
            stringBuffer.append(ParserHandler.intToHex(byArray[i], 1));
        }
        return stringBuffer.toString();
    }

    protected static byte[] hexStringToByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = 0;
        while (n < string.length() - 1) {
            String string2 = n == string.length() - 2 ? string.substring(n) : string.substring(n, n + 2);
            byArray[n2] = (byte)Integer.parseInt(string2, 16);
            n += 2;
            ++n2;
        }
        return byArray;
    }

    protected static String byteArrayToIntString(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        return bigInteger.toString();
    }

    protected static byte[] intStringToByteArray(String string) {
        BigInteger bigInteger = new BigInteger(string);
        byte[] byArray = bigInteger.toByteArray();
        if (byArray == null) {
            return null;
        }
        int n = 0;
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        byte[] byArray2 = new byte[byArray.length - n];
        for (int i = 0; i < byArray2.length && n < byArray.length; ++i, ++n) {
            byArray2[i] = byArray[n];
        }
        return byArray2;
    }
}

