/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.jsafe.provider;

import com.rsa.crypto.AlgParamGenerator;
import com.rsa.crypto.AlgorithmParams;
import com.rsa.crypto.CryptoException;
import com.rsa.crypto.CryptoModule;
import com.rsa.crypto.NoSuchAlgorithmException;
import com.rsa.crypto.PQGParams;
import com.rsa.crypto.PublicKey;
import com.rsa.crypto.PublicKeyIsValidNotSupportedException;
import com.rsa.cryptoj.o.bj;
import com.rsa.cryptoj.o.ca;
import com.rsa.cryptoj.o.ce;
import com.rsa.cryptoj.o.cf;
import com.rsa.cryptoj.o.cj;
import com.rsa.cryptoj.o.cl;
import com.rsa.cryptoj.o.cx;
import com.rsa.cryptoj.o.fn;
import com.rsa.cryptoj.o.ka;
import com.rsa.cryptoj.o.kn;
import com.rsa.cryptoj.o.ko;
import com.rsa.jsafe.crypto.FIPS140Context;
import com.rsa.jsafe.provider.X942DHParameterSpec;
import com.rsa.jsafe.provider.b;
import com.rsa.jsafe.security.spec.DSADomainParameterGenerationSpec;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.List;

public final class Assurance {
    public static final String DIGEST_SHA1 = "SHA1";
    public static final String DIGEST_SHA224 = "SHA224";
    public static final String DIGEST_SHA256 = "SHA256";
    public static final String DIGEST_SHA384 = "SHA384";
    public static final String DIGEST_SHA512 = "SHA512";
    public static final int VERSION_FIPS186_2 = 2;
    public static final int VERSION_FIPS186_3 = 3;

    private Assurance() {
    }

    public static boolean isValidPublicKey(java.security.PublicKey publicKey) throws InvalidKeyException {
        return Assurance.isValidPublicKey(publicKey, null, null);
    }

    public static boolean isValidPublicKey(java.security.PublicKey publicKey, SecureRandom secureRandom, FIPS140Context fIPS140Context) throws InvalidKeyException {
        cf cf2 = fIPS140Context == null ? ce.a() : b.a(fIPS140Context);
        PublicKey publicKey2 = kn.a((java.security.PublicKey)publicKey, (String)publicKey.getAlgorithm(), (CryptoModule)cl.a((cf)cf2, Assurance.a()));
        if (publicKey2 == null) {
            publicKey2 = ((fn)publicKey).b();
        }
        try {
            return publicKey2.isValid(cx.a((SecureRandom)secureRandom, (cf)cf2));
        }
        catch (PublicKeyIsValidNotSupportedException publicKeyIsValidNotSupportedException) {
            return true;
        }
    }

    private static List<ca> a() {
        return ka.a;
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, null, null);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        return Assurance.a("DSA", (AlgorithmParameterSpec)dSADomainParameterGenerationSpec, string, secureRandom, fIPS140Context);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        if (dSADomainParameterGenerationSpec == null) {
            throw new InvalidParameterException("A DSADomainParameterGenerationSpec spec must be specified");
        }
        if (n == 2 && !DIGEST_SHA1.equals(string)) {
            return false;
        }
        return Assurance.a("DSA", (AlgorithmParameterSpec)dSADomainParameterGenerationSpec, string, secureRandom, fIPS140Context);
    }

    public static boolean verifyDSAParameters(DSADomainParameterGenerationSpec dSADomainParameterGenerationSpec, String string, int n) {
        return Assurance.verifyDSAParameters(dSADomainParameterGenerationSpec, string, n, null, null);
    }

    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        if (x942DHParameterSpec == null) {
            throw new InvalidParameterException("An X942DHParameter spec must be specified");
        }
        try {
            return Assurance.a("DH", x942DHParameterSpec, null, secureRandom, fIPS140Context);
        }
        catch (CryptoException cryptoException) {
            throw new InvalidParameterException(cryptoException.getMessage());
        }
    }

    public static boolean verifyX942DHParams(X942DHParameterSpec x942DHParameterSpec) {
        return Assurance.verifyX942DHParams(x942DHParameterSpec, null, null);
    }

    private static boolean a(String string, AlgorithmParameterSpec algorithmParameterSpec, String string2, SecureRandom secureRandom, FIPS140Context fIPS140Context) {
        cj cj2 = cl.a((cf)b.a(fIPS140Context), (ca)ca.a);
        try {
            AlgParamGenerator algParamGenerator = cj2.newAlgParamGenerator(string);
            PQGParams pQGParams = "DSA".equals(string) ? ko.a((DSAParameterSpec)((DSADomainParameterGenerationSpec)algorithmParameterSpec), (String)string2, (CryptoModule)cj2) : ko.a((X942DHParameterSpec)((X942DHParameterSpec)algorithmParameterSpec), (CryptoModule)cj2);
            algParamGenerator.initVerify((AlgorithmParams)pQGParams, cx.a((SecureRandom)secureRandom, (cf)b.a(fIPS140Context)));
            return algParamGenerator.verify();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (bj bj2) {
        }
        catch (CryptoException cryptoException) {
            return false;
        }
        return false;
    }
}

