/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.osgi;

import coldfusion.osgi.scanner.ModulesCodeScanner;
import coldfusion.osgi.servlet.ModulesServlet;
import coldfusion.server.felix.FelixConstants;
import coldfusion.server.felix.FelixUtil;
import coldfusion.util.RB;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import org.apache.log4j.PropertyConfigurator;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class OSGICli {
    private static String username = "";
    private static String pass = "";
    public static final String REPLICATE_REPOSITORY = "downloadrepo";
    public static final String UPDATE_REPOSITORY_PATH = "updaterepopath";
    private static String CF_MODULES = "cfpm>";

    public static void main(String[] args) {
        AnsiConsole.systemInstall();
        String clName = OSGICli.class.getClassLoader().getClass().getCanonicalName();
        if (clName != null && clName.equalsIgnoreCase("coldfusion.bootstrap.BootstrapClassLoader")) {
            OSGICli.printError("Unexpected behavior. Please see documentation for correct usage.");
            System.exit(-1);
        }
        OSGICli.setLib();
        if (args != null && args.length > 0) {
            OSGICli.nonInteractiveMode(args);
        } else {
            OSGICli.interactiveMode();
        }
        AnsiConsole.systemUninstall();
    }

    private static void nonInteractiveMode(String[] args) {
        int length = args.length;
        int i = 0;
        while (i < length && i < length) {
            String arg = args[i].toLowerCase();
            if (arg.equals("install")) {
                if (args[i + 1].equals("all")) {
                    OSGICli.handleInstallAllCommand(false);
                } else if (args[i + 1].equals("all-base")) {
                    OSGICli.handleInstallBaseAllCommand(false);
                } else {
                    OSGICli.handleInstallCommand(OSGICli.getBundleNames(args).toLowerCase());
                }
                i += length;
                break;
            }
            if (arg.equals("update")) {
                if (OSGICli.checkCommandLength(length, 2)) {
                    return;
                }
                if (i + 1 >= length) {
                    OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)arg));
                    break;
                }
                if (args[i + 1].equals("all")) {
                    OSGICli.handleUpdateAllCommand(false);
                } else if (args[i + 1].equals("packages")) {
                    OSGICli.handleUpdateCommand(false);
                } else {
                    OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmd", (Object)arg));
                    OSGICli.printUsage();
                    continue;
                }
                i += 2;
                break;
            }
            if (arg.equals("export")) {
                if (OSGICli.checkCommandLength(length, 2)) {
                    return;
                }
                if (i + 1 >= length) {
                    OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)arg));
                    break;
                }
                FelixUtil.handleExportCommand((String)args[i + 1]);
                i += 2;
                break;
            }
            if (arg.equals("import")) {
                if (OSGICli.checkCommandLength(length, 2)) {
                    return;
                }
                if (i + 1 >= length) {
                    OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)arg));
                    break;
                }
                OSGICli.handleImportCommand(args[i + 1]);
                i += 2;
                break;
            }
            if (arg.equals("uninstall")) {
                if (args[i + 1].equals("all")) {
                    OSGICli.handleUninstallallCommand();
                } else {
                    OSGICli.handleUninstallCommand(OSGICli.getBundleNames(args).toLowerCase());
                }
                i += length;
                break;
            }
            if (arg.equals("scan") || arg.equals("scanandinstall")) {
                if (OSGICli.checkCommandLength(length, 2)) {
                    return;
                }
                if (i + 1 >= length) {
                    OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidscancmd", (Object)arg));
                    break;
                }
                String[] params = new String[]{arg, args[i + 1]};
                String resp = OSGICli.handleScanCommand(arg, params);
                OSGICli.printResp(resp);
                i += 2;
                break;
            }
            if (arg.equals("list")) {
                if (OSGICli.checkCommandLength(length, 1)) {
                    return;
                }
                String resp = OSGICli.handleListCommand();
                ++i;
                OSGICli.printResp(resp);
                break;
            }
            if (arg.equals("listall")) {
                if (OSGICli.checkCommandLength(length, 1)) {
                    return;
                }
                String resp = OSGICli.handleListallCommand();
                ++i;
                OSGICli.printResp(resp);
                break;
            }
            if (arg.equals("info")) {
                if (OSGICli.checkCommandLength(length, 2)) {
                    return;
                }
                if (i + 1 >= length) {
                    OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)arg));
                    break;
                }
                String resp = OSGICli.handleInfoCommand(args[i + 1]);
                i += 2;
                OSGICli.printResp(resp);
                break;
            }
            if (arg.equals("help")) {
                if (OSGICli.checkCommandLength(length, 1)) {
                    return;
                }
                OSGICli.printUsage();
                ++i;
                break;
            }
            if (arg.equals(REPLICATE_REPOSITORY) || arg.equals(UPDATE_REPOSITORY_PATH)) {
                if (OSGICli.checkCommandLength(length, 2)) {
                    return;
                }
                if (i + 1 >= length) {
                    OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)arg));
                    break;
                }
                if (arg.equals(REPLICATE_REPOSITORY)) {
                    try {
                        OSGICli.replicateRepository(args[i + 1]);
                    }
                    catch (Exception e) {
                        OSGICli.printError(e.getMessage());
                    }
                } else if (arg.equals(UPDATE_REPOSITORY_PATH)) {
                    if (!OSGICli.isValidUrlFile(args[i + 1])) {
                        OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.repopathvalidation", (Object)arg));
                        break;
                    }
                    try {
                        OSGICli.setRepositoryPath(args[i + 1]);
                    }
                    catch (Exception e) {
                        OSGICli.printError(e.getMessage());
                    }
                    try {
                        if (ModulesServlet.isServerRunning()) {
                            OSGICli.printInfo(RB.getString(OSGICli.class, (String)"OSGICli.restartserver", (Object)arg));
                        }
                    }
                    catch (Exception e) {
                        OSGICli.printInfo(RB.getString(OSGICli.class, (String)"OSGICli.restartserver", (Object)arg));
                    }
                }
                i += 2;
                break;
            }
            if (arg.equals(FelixConstants.PURGECACHE_COMMAND)) {
                OSGICli.handlePurgeCache();
            } else {
                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmd2", (Object)arg));
            }
            ++i;
        }
    }

    private static boolean checkCommandLength(int length, int i) {
        if (length > i) {
            OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.noninteractivechaining"));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String handleImportCommand(String importPath) {
        if (!new File(importPath).exists()) {
            System.out.println(RB.getString(OSGICli.class, (String)"OSGICli.invalidfile", (Object)importPath));
            return null;
        }
        FileReader bundlesFr = null;
        OutputStreamWriter fw = null;
        try {
            bundlesFr = new FileReader(importPath);
            Properties propsImport = new Properties();
            propsImport.load(bundlesFr);
            if (!propsImport.containsKey("packages")) {
                OSGICli.printError(RB.getString(ModulesServlet.class, (String)"ModulesServlet.invalidcontent", (Object)"packages=pdf,htmltopdf"));
                String string = null;
                return string;
            }
            String bundlesImport = propsImport.getProperty("packages", "");
            String serverHotfixUpdateLevelImport = propsImport.getProperty("server_hotfix_updatelevel", "0");
            String currentServerBundlesFilePath = FelixUtil.libFolder + File.separatorChar + "installedBundles.txt";
            FileReader bundlesServer = new FileReader(currentServerBundlesFilePath);
            Properties propsServer = new Properties();
            propsServer.load(bundlesServer);
            propsServer.setProperty("server_hotfix_updatelevel", serverHotfixUpdateLevelImport);
            fw = new FileWriter(currentServerBundlesFilePath);
            propsServer.store(fw, "");
            boolean val = OSGICli.validateBundles(bundlesImport);
            if (!val) {
                String string = null;
                return string;
            }
            String string = ModulesServlet.handleInstallCommand((String)bundlesImport);
            return string;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (bundlesFr != null) {
                try {
                    bundlesFr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String handleInstallCommand(String bundles) {
        boolean val = OSGICli.validateBundles(bundles);
        if (!val) {
            return null;
        }
        return ModulesServlet.handleInstallCommand((String)bundles);
    }

    private static boolean validateBundles(String bundles) {
        bundles = bundles.toLowerCase();
        List cfbundleNamesVersions = FelixUtil.listModuleNamesVersions();
        List cfbundleNames = FelixUtil.listModuleNames();
        ArrayList<String> list = new ArrayList<String>();
        for (String bun : bundles.split(",")) {
            if (bun.trim().equals("")) {
                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.emptybundle"));
                return false;
            }
            if (list.contains(bun)) {
                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.multibundle", (Object)bun));
                return false;
            }
            list.add(bun);
            String[] split = bun.split(":");
            String name = split[0];
            String cversion = "";
            if (split.length == 2) {
                cversion = split[1];
            }
            String bunNameVersion = name + "-" + cversion;
            if (name.equals("felixclassloader") || (cversion.length() <= 0 || cfbundleNamesVersions.contains(bunNameVersion)) && (cversion.length() != 0 || cfbundleNames.contains(name))) continue;
            OSGICli.printError(RB.getString(ModulesServlet.class, (String)"ModulesServlet.modulenotfound", (Object)bun));
            return false;
        }
        return true;
    }

    private static void printResp(String resp) {
        if (null != resp) {
            FelixUtil.auditLog((String)resp);
            if (resp.toLowerCase().contains("error")) {
                OSGICli.printError(resp);
            } else {
                OSGICli.printInfo(resp);
            }
        }
    }

    private static void interactiveMode() {
        Scanner scan = new Scanner(System.in);
        try {
            OSGICli.takeCommands(scan);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private static void printCfModule() {
        System.out.print(Ansi.ansi((int)20).fgBrightCyan().bold().a(CF_MODULES).reset());
    }

    public static void printError(String err) {
        System.out.print(Ansi.ansi().fgBrightRed().bold().a(err).newline().reset());
    }

    private static void printWarning(String err) {
        System.out.print(Ansi.ansi().fgBrightYellow().bold().a(err).newline().reset());
    }

    public static void printInfo(String info) {
        System.out.print(Ansi.ansi((int)10).fgBrightGreen().a(info).newline().reset());
    }

    private static void printExit(String info) {
        System.out.print(Ansi.ansi((int)10).fgDefault().a(info).newline().reset());
    }

    private static void printHelpHeading(String info) {
        System.out.print(Ansi.ansi((int)40).fgBrightYellow().a(info).newline().reset());
    }

    private static void printWhite(String info) {
        System.out.print(Ansi.ansi((int)20).fg(Ansi.Color.WHITE).a(info).newline().reset());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void takeCommands(Scanner scan) {
        while (true) {
            String resp;
            block50: {
                String buns;
                String cmd;
                String[] splits;
                block56: {
                    block55: {
                        block54: {
                            block53: {
                                block52: {
                                    block51: {
                                        OSGICli.printCfModule();
                                        String command = null;
                                        if (scan.hasNextLine()) {
                                            command = scan.nextLine();
                                        }
                                        if (command == null) {
                                            OSGICli.sayBye();
                                            return;
                                        }
                                        try {
                                            FelixUtil.loadBundlesDependency((String)FelixUtil.libFolder, (boolean)false, (boolean)true);
                                        }
                                        catch (Exception e) {
                                            OSGICli.printError(e.getMessage());
                                            continue;
                                        }
                                        command = command.trim();
                                        if (command.length() == 0) continue;
                                        splits = command.split(" ");
                                        cmd = splits[0].toLowerCase();
                                        Object data = "";
                                        String bun = "";
                                        resp = "";
                                        if (splits.length == 1) {
                                            if (cmd.equals("quit") || cmd.equals("q")) {
                                                OSGICli.sayBye();
                                                return;
                                            }
                                            if (cmd.equals("help")) {
                                                OSGICli.printUsage();
                                                continue;
                                            }
                                            if (cmd.equals("cls") || cmd.equals("clear")) {
                                                OSGICli.clearScreen();
                                                continue;
                                            }
                                            if (cmd.equals(REPLICATE_REPOSITORY) && splits.length != 2) {
                                                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)cmd));
                                                OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage") + "\tdownloadrepo DOWNLOAD_PATH \t");
                                                continue;
                                            }
                                            if (!(cmd.equals("list") || cmd.equals("listall") || cmd.equals(FelixConstants.PURGECACHE_COMMAND))) {
                                                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmd", (Object)cmd));
                                                OSGICli.printUsage();
                                                continue;
                                            }
                                            data = "3:STR:" + cmd.length() + ":" + cmd + "STR:" + username.length() + ":" + username + "STR:" + pass.length() + ":" + pass;
                                        } else if (cmd.equals("info")) {
                                            if (splits.length != 2) {
                                                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidinfocmd"));
                                                continue;
                                            }
                                            bun = splits[1];
                                            data = "4:STR:" + cmd.length() + ":" + cmd + "STR:" + bun.length() + ":" + bun + "STR:" + username.length() + ":" + username + "STR:" + pass.length() + ":" + pass;
                                        } else if ((cmd.equals("list") || cmd.equals("listall")) && splits.length > 1) {
                                            OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidlistcmd", (Object)cmd));
                                            continue;
                                        }
                                        OSGICli.setLib();
                                        if (!cmd.equals("list")) break block51;
                                        resp = OSGICli.handleListCommand();
                                        break block50;
                                    }
                                    if (!cmd.equals("listall")) break block52;
                                    resp = OSGICli.handleListallCommand();
                                    break block50;
                                }
                                if (!cmd.equals("info")) break block53;
                                resp = OSGICli.handleInfoCommand(splits[1]);
                                break block50;
                            }
                            if (!cmd.equals("scan") && !cmd.equals("scanandinstall")) break block54;
                            resp = OSGICli.handleScanCommand(cmd, splits);
                            if (null == resp) {
                                continue;
                            }
                            break block50;
                        }
                        if (cmd.equals(REPLICATE_REPOSITORY)) {
                            if (splits.length != 2) {
                                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)cmd));
                                OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage") + "\tdownloadrepo DOWNLOAD_PATH \t");
                                continue;
                            }
                            try {
                                OSGICli.replicateRepository(splits[1]);
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                            }
                            continue;
                        }
                        if (cmd.equals(UPDATE_REPOSITORY_PATH)) {
                            if (splits.length != 2) {
                                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)cmd));
                                OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage") + "\tupdaterepopath REPO_PATH/URL \t");
                                continue;
                            }
                            if (!OSGICli.isValidUrlFile(splits[1])) {
                                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.repopathvalidation"));
                                continue;
                            }
                            try {
                                OSGICli.setRepositoryPath(splits[1]);
                            }
                            catch (Exception e) {
                                OSGICli.printError(e.getMessage());
                            }
                            try {
                                if (!ModulesServlet.isServerRunning()) continue;
                                OSGICli.printInfo(RB.getString(OSGICli.class, (String)"OSGICli.restartserver"));
                            }
                            catch (Exception e) {
                                OSGICli.printInfo(RB.getString(OSGICli.class, (String)"OSGICli.restartserver"));
                            }
                            continue;
                        }
                        if (cmd.equals("export")) {
                            if (splits.length != 2) {
                                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)cmd));
                                OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage") + "\texport EXPORT_FILEPATH \t");
                                continue;
                            }
                            try {
                                FelixUtil.handleExportCommand((String)splits[1]);
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                            }
                            continue;
                        }
                        if (cmd.equals("import")) {
                            if (splits.length != 2) {
                                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmdparams", (Object)cmd));
                                OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage") + "\timport IMPORT_FILEPATH \t");
                                continue;
                            }
                            try {
                                OSGICli.handleImportCommand(splits[1]);
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                            }
                            continue;
                        }
                        if (!cmd.equals("install")) break block55;
                        buns = OSGICli.getBundleNames(splits).toLowerCase();
                        if (buns.equals("all")) {
                            OSGICli.handleInstallAllCommand(false);
                            break block50;
                        } else if (buns.equals("all-base")) {
                            OSGICli.handleInstallBaseAllCommand(false);
                            break block50;
                        } else {
                            resp = OSGICli.handleInstallCommand(OSGICli.getBundleNames(splits).toLowerCase());
                        }
                        break block50;
                    }
                    if (!cmd.equals("update")) break block56;
                    buns = OSGICli.getBundleNames(splits).toLowerCase();
                    if (buns.equals("all")) {
                        OSGICli.handleUpdateAllCommand(false);
                        break block50;
                    } else if (buns.equals("packages")) {
                        OSGICli.handleUpdateCommand(false);
                        break block50;
                    } else {
                        OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmd", (Object)cmd));
                        OSGICli.printUsage();
                        continue;
                    }
                }
                if (cmd.equals("uninstall")) {
                    buns = OSGICli.getBundleNames(splits).toLowerCase();
                    if (buns.equals("all")) {
                        OSGICli.handleUninstallallCommand();
                    } else {
                        resp = OSGICli.handleUninstallCommand(OSGICli.getBundleNames(splits).toLowerCase());
                    }
                } else if (cmd.equals(FelixConstants.PURGECACHE_COMMAND)) {
                    OSGICli.handlePurgeCache();
                } else {
                    OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidcmd", (Object)cmd));
                    OSGICli.printUsage();
                    continue;
                }
            }
            OSGICli.printResp(resp);
        }
    }

    private static void handlePurgeCache() {
        try {
            if (ModulesServlet.isServerRunning()) {
                OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.serverrunningpurge"));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String home = System.getenv().get("CFUSION_HOME");
        if (null == home) {
            home = System.getProperty("CFUSION_HOME");
        }
        String cache = home + File.separator + "bin" + File.separator + "felix-cache";
        OSGICli.deleteFolder(new File(cache));
        OSGICli.printInfo(RB.getString(OSGICli.class, (String)"OSGICli.purgesuccess"));
    }

    static void deleteFolder(File file) {
        if (!file.exists()) {
            OSGICli.printError("File" + file.getAbsolutePath() + " does not exist");
            return;
        }
        for (File subFile : file.listFiles()) {
            if (subFile.isDirectory()) {
                OSGICli.deleteFolder(subFile);
                continue;
            }
            subFile.delete();
        }
        file.delete();
    }

    private static String handleInfoCommand(String bun) {
        Object resp = "";
        try {
            resp = ModulesServlet.findBundle((String)bun);
        }
        catch (Exception e) {
            resp = "Error:" + e.getMessage();
        }
        resp = OSGICli.getCommandResponse((String)resp, "info");
        return resp;
    }

    private static String handleListCommand() {
        return OSGICli.getCommandResponse(null, "list");
    }

    private static String handleListallCommand() {
        String resp = ModulesServlet.listAllBundlesByName();
        return OSGICli.getCommandResponse(resp, "listall");
    }

    private static void handleUninstallallCommand() {
        ModulesServlet.handleUninstallallCommand(null);
    }

    public static int handleInstallAllCommand(boolean async) {
        return ModulesServlet.handleInstallAllCommand((boolean)async);
    }

    public static int handleInstallBaseAllCommand(boolean async) {
        return ModulesServlet.handleInstallBaseAllCommand((boolean)async);
    }

    public static int handleUpdateAllCommand(boolean async) {
        return ModulesServlet.handleUpdateAllCommand((boolean)async);
    }

    public static int handleUpdateCommand(boolean async) {
        return ModulesServlet.handleUpdateCommand((boolean)async);
    }

    private static String getBundleNames(String[] splits) {
        Object buns = "";
        int c = 0;
        for (String b : splits) {
            if (c++ == 0) continue;
            buns = (String)buns + b;
        }
        return buns;
    }

    private static String handleUninstallCommand(String bun) {
        boolean val = OSGICli.validateBundles(bun);
        if (!val) {
            return null;
        }
        return ModulesServlet.handleUninstallCommand((String)bun);
    }

    private static String handleScanCommand(String cmd, String[] splits) {
        if (splits.length != 2) {
            OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.invalidscancmd", (Object)cmd));
            return null;
        }
        String path = splits[1];
        if (!new File(path = path.replace("\\", "/")).exists()) {
            OSGICli.printError("CODEBASEPATH " + path + " not found");
            return null;
        }
        ModulesCodeScanner scanner = new ModulesCodeScanner(FelixUtil.libFolder);
        Set modules = scanner.scan(path);
        Object resp = "";
        for (String str : modules) {
            resp = (String)resp + str + ",";
        }
        if (((String)resp).endsWith(",")) {
            resp = ((String)resp).substring(0, ((String)resp).length() - 1);
        }
        if (cmd.equals("scanandinstall")) {
            OSGICli.printInfo(RB.getString(ModulesServlet.class, (String)"ModulesServlet.scaninfo1", (Object)resp));
            OSGICli.handleInstallCommand((String)resp);
            System.out.println("\n");
            resp = RB.getString(ModulesServlet.class, (String)"ModulesServlet.scaninfo2");
        } else {
            resp = modules.toString();
        }
        return resp;
    }

    private static void setLib() {
        String home = System.getenv().get("CFUSION_HOME");
        if (null == home) {
            home = System.getProperty("CFUSION_HOME");
        }
        String lib = home + File.separator + "lib";
        FelixUtil.libFolder = lib;
        FelixUtil.invokedFromClient = true;
        try {
            OSGICli.checkWriteStatus();
        }
        catch (Throwable e) {
            OSGICli.printError(RB.getString(OSGICli.class, (String)"OSGICli.writeerror"));
            return;
        }
        try {
            PropertyConfigurator.configure((String)(lib + "/cfpmlog4j.properties"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkWriteStatus() throws Throwable {
        String file = FelixUtil.libFolder + File.separator + "dummy.txt";
        Properties prop = new Properties();
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        try (FileOutputStream fos = new FileOutputStream(f);){
            prop.store(fos, "");
        }
        finally {
            f.delete();
        }
    }

    private static void sayBye() {
        OSGICli.printExit(RB.getString(OSGICli.class, (String)"OSGICli.bye"));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static String getCommandResponse(String resp, String cmd) {
        if (cmd.equals("list") || cmd.equals("listall")) {
            try {
                OSGICli.printListCommandResponse(resp, cmd);
                resp = null;
            }
            catch (Throwable t) {
                resp = t.getMessage();
                return resp;
            }
        } else if (cmd.equals("info")) {
            if (resp.toLowerCase().contains("error:")) {
                return resp;
            }
            OSGICli.printInfoCommandResponse(resp);
            resp = null;
        }
        return resp;
    }

    private static void printListCommandResponse(String resp, String cmd) {
        block9: {
            JsonObject jobj;
            int i;
            HashMap<String, String> installedBundles;
            JsonArray alluniquebundles;
            block8: {
                JsonArray bundlesinstalled = new JsonArray();
                alluniquebundles = new JsonArray();
                installedBundles = new HashMap<String, String>();
                JsonArray allBundlesObj = new JsonArray(ModulesServlet.listBundles());
                for (i = 0; i < allBundlesObj.length(); ++i) {
                    JsonObject j = allBundlesObj.getJsonObject(i);
                    if (!j.getBoolean("installed")) continue;
                    bundlesinstalled.put((Object)j);
                    installedBundles.put(j.getString("name"), j.getString("version"));
                }
                if (!cmd.equals("list")) break block8;
                if (bundlesinstalled.length() == 0) {
                    OSGICli.printInfo("No package installed.");
                }
                for (i = 0; i < bundlesinstalled.length(); ++i) {
                    jobj = bundlesinstalled.getJsonObject(i);
                    String output = jobj.getString("name") + ", version : " + jobj.getString("version");
                    OSGICli.printInfo(output);
                }
                break block9;
            }
            if (!cmd.equals("listall")) break block9;
            alluniquebundles = new JsonArray(resp);
            if (alluniquebundles.length() == 0) {
                OSGICli.printInfo("No package installed.");
            }
            for (i = 0; i < alluniquebundles.length(); ++i) {
                jobj = alluniquebundles.getJsonObject(i);
                if (ModulesServlet.lambdaMode && jobj.has("awsserverless") && !jobj.getBoolean("awsserverless")) continue;
                String bundleName = jobj.getString("name");
                JsonArray versions = jobj.getJsonArray("versions");
                if (installedBundles.containsKey(bundleName)) {
                    String installedVersion = (String)installedBundles.get(bundleName);
                    String bundleInstalledStr = bundleName + ", versions : [" + installedVersion;
                    Object versionsStr = ",";
                    for (int y = 0; y < versions.length(); ++y) {
                        String ver = versions.getString(y);
                        if (ver.equals(installedVersion)) continue;
                        versionsStr = (String)versionsStr + ver + ",";
                    }
                    versionsStr = OSGICli.trimComma((String)versionsStr);
                    System.out.println(Ansi.ansi((int)10).fgBrightGreen().a(bundleInstalledStr).fgBrightYellow().bold().a((String)versionsStr).fgBrightGreen().a("]").reset());
                    continue;
                }
                Object versionsStr = "";
                for (int y = 0; y < versions.length(); ++y) {
                    String ver = versions.getString(y);
                    if (ver.contentEquals("UNINSTALLED")) continue;
                    versionsStr = (String)versionsStr + ver + ",";
                }
                versionsStr = OSGICli.trimComma((String)versionsStr);
                String output = jobj.getString("name") + ", versions : [" + (String)versionsStr + "]";
                OSGICli.printWarning(output);
            }
        }
    }

    private static String trimComma(String str) {
        if (str != null && str.endsWith(",")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private static void printInfoCommandResponse(String resp) {
        JsonObject obj = new JsonObject(resp);
        Object output = "";
        output = (String)output + "Package name :  " + obj.getString("name") + "\n";
        boolean isIntalled = obj.getBoolean("installed");
        if (obj.getBoolean("installed")) {
            output = (String)output + "Installed version:  " + obj.getString("version") + "\n";
        }
        if (obj.has("description")) {
            output = (String)output + "Description:  " + obj.getString("description") + "\n";
        }
        if (obj.has("category")) {
            output = (String)output + "Category:  " + obj.getString("category") + "\n";
        }
        JsonArray dependencies = obj.getJsonArray("dependencies");
        Object jars = "";
        Object cf = "";
        for (int i = 0; i < dependencies.length(); ++i) {
            JsonObject jobj = dependencies.getJsonObject(i);
            String str = jobj.getString("name") + "-" + jobj.getString("version");
            String type = jobj.getString("type");
            if (type.equals("cfdependency")) {
                cf = (String)cf + str + ",";
                continue;
            }
            jars = (String)jars + str + ",";
        }
        cf = OSGICli.trimComma((String)cf);
        jars = OSGICli.trimComma((String)jars);
        if (((String)cf).length() > 0) {
            output = (String)output + "Required ColdFusion Package(s): " + (String)cf + "\n";
        }
        if (((String)jars).length() > 0) {
            output = (String)output + "Required Jar(s): " + (String)jars + "\n";
        }
        output = (String)output + RB.getString(OSGICli.class, (String)"OSGICli.info1");
        if (isIntalled) {
            OSGICli.printInfo((String)output);
        } else {
            OSGICli.printWarning((String)output);
        }
    }

    private static void printUsage() {
        OSGICli.printHelpHeading("\ninstall PACKAGENAME[:VERSION]");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage1"));
        OSGICli.printHelpHeading("\ninstall all");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage10"));
        OSGICli.printHelpHeading("\nupdate all");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usageupdateall"));
        OSGICli.printHelpHeading("\nupdate packages");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usageupdatepackages"));
        OSGICli.printHelpHeading("\nuninstall all");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage12"));
        OSGICli.printHelpHeading("\nuninstall PACKAGENAME");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage2"));
        OSGICli.printHelpHeading("\nlist ");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage3"));
        OSGICli.printHelpHeading("\nlistall ");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage4"));
        OSGICli.printHelpHeading("\ninfo PACKAGENAME");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage5"));
        OSGICli.printHelpHeading("\nhelp ");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage6"));
        OSGICli.printHelpHeading("\nscan CODEBASEPATH ");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage7"));
        OSGICli.printHelpHeading("\nscanandinstall CODEBASEPATH ");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage8"));
        OSGICli.printHelpHeading("\ndownloadrepo DOWNLOAD_PATH \t");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage9"));
        OSGICli.printHelpHeading("\nupdaterepopath REPOSITORY_PATH/URL \t");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage18"));
        OSGICli.printHelpHeading("\nq or quit\t");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage13"));
        OSGICli.printHelpHeading("\ncls or clear\t");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage14"));
        OSGICli.printHelpHeading("\n" + FelixConstants.PURGECACHE_COMMAND + "\t");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage15"));
        OSGICli.printHelpHeading("\nexport EXPORT_FILEPATH");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage16"));
        OSGICli.printHelpHeading("\nimport IMPORT_FILEPATH");
        OSGICli.printWhite(RB.getString(OSGICli.class, (String)"OSGICli.usage17"));
    }

    private static void replicateRepository(String downloadPath) throws Exception {
        FelixUtil.replicateRepository((String)downloadPath);
    }

    private static void setRepositoryPath(String repositoryPath) throws Exception {
        FelixUtil.setRepositoryPath((String)repositoryPath);
    }

    public static boolean isValidUrlFile(String urlOrFile) {
        boolean isValidUrl = false;
        boolean isValidFile = false;
        try {
            new URL(urlOrFile).toURI();
            isValidUrl = true;
        }
        catch (URISyntaxException exception) {
            isValidUrl = false;
        }
        catch (MalformedURLException exception) {
            isValidUrl = false;
        }
        if (!isValidUrl) {
            try {
                Paths.get(urlOrFile, new String[0]);
                if (urlOrFile.endsWith(".json")) {
                    isValidFile = true;
                }
            }
            catch (InvalidPathException ex) {
                isValidFile = false;
            }
        }
        return isValidUrl || isValidFile;
    }

    private static void clearScreen() {
        try {
            String os = System.getProperty("os.name");
            if (os.contains("Windows")) {
                new ProcessBuilder("cmd", "/c", "cls").inheritIO().start().waitFor();
            } else {
                System.out.print("\u001b[H\u001b[2J");
                System.out.flush();
                Runtime.getRuntime().exec("clear");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

