/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URI;
import org.apache.webdav.lib.BaseProperty;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.ResponseEntity;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.PropPatchMethod;
import org.apache.webdav.lib.methods.SearchMethod;

public class Test {
    public static void main1(String[] args) {
        String localTime = "02/23/2006 1:30 PM";
        String exchangeDate = Test.localToExchangeDate(localTime);
        System.out.println(localTime + " = GMT - " + exchangeDate);
        System.out.println(exchangeDate + " = Local - " + Test.exchangeToLocalDate(exchangeDate));
    }

    public static void main(String[] args) {
        try {
            System.out.println("Opening WebDAV connection to the Exchange Server");
            Vector<PropertyName> vec = new Vector<PropertyName>();
            PropertyName propName = new PropertyName("DAV:", "parentname");
            vec.add(propName);
            vec.add(new PropertyName("DAV:", "prop"));
            String hostName = "10.192.16.33";
            String userName = "user1";
            String userPass = "123@user";
            String mailBoxName = "user2";
            HttpURL httpUrl = new HttpURL("http://" + hostName + "/exchange/" + mailBoxName);
            System.out.println("http://" + hostName + "/exchange/" + mailBoxName);
            httpUrl.setUserinfo(userName, userPass);
            System.out.println("HttpUrl = " + httpUrl.getPathQuery());
            WebdavResource wdr = new WebdavResource(httpUrl);
            wdr.setDebug(1);
            String query = Test.createExchangeSQL(hostName, userName);
            Test.executeExchangeQuery(wdr, query, "exchange/" + mailBoxName + "/Calendar", httpUrl);
            wdr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createCalendarEvent(WebdavResource wdr, String path) throws Exception {
        PropPatchMethod patchMethod = new PropPatchMethod(path + "/testmeeting.eml");
        String strMtgRequest = Test.createAptString();
        patchMethod.setRequestBody(strMtgRequest);
        HttpClient client = wdr.getSessionInstance(wdr.getHttpURL());
        HostConfiguration hostConfig = client.getHostConfiguration();
        hostConfig.setHost((URI)wdr.getHttpURL());
        hostConfig.setProxy("localhost", 8080);
        int code = client.executeMethod((HttpMethod)patchMethod);
        System.out.println("PatchMethod Code = " + code);
    }

    public static void executeExchangeQuery(WebdavResource wdr, String query, String path, HttpURL url) throws Exception {
        SearchMethod method = new SearchMethod(path, query);
        method.setRequestHeader(new Header("Depth", "0"));
        method.setRequestHeader(new Header("Translate", "f"));
        method.setRequestHeader(new Header("Range", "rows=0-9"));
        HttpClient client = wdr.getSessionInstance(url);
        HostConfiguration hostConfig = client.getHostConfiguration();
        hostConfig.setHost((URI)url);
        System.out.println("url = " + url.getHost());
        hostConfig.setProxy("localhost", 8080);
        int code = client.executeMethod((HttpMethod)method);
        Enumeration enm = method.getResponses();
        while (enm.hasMoreElements()) {
            Object obj = enm.nextElement();
            ResponseEntity entity = (ResponseEntity)obj;
            Enumeration enm1 = entity.getProperties();
            while (enm1.hasMoreElements()) {
                BaseProperty prop = (BaseProperty)enm1.nextElement();
                System.out.println("\t" + prop.getName() + " = " + prop.getPropertyAsString());
            }
            System.out.println("------------------------------------------------------");
        }
        System.out.println("Response code = " + code);
        String strResponse = method.getResponseBodyAsString();
        System.out.println(" Response from query execution ... \n" + strResponse);
    }

    public static String createExchangeSQL(String hostName, String userName) {
        try {
            String tmpStr;
            File file = new File("C:/users/rkulkarni/temp-projects/CFExchange/src/webdav/test/query.sql");
            FileReader reader = new FileReader(file);
            BufferedReader bufReader = new BufferedReader(reader);
            String sql = "";
            while ((tmpStr = bufReader.readLine()) != null) {
                sql = sql + tmpStr + "\n";
            }
            return sql;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String createAptString() {
        try {
            String tmpStr;
            File file = new File("C:/users/rkulkarni/temp-projects/CFExchange/src/webdav/test/createApt.txt");
            FileReader reader = new FileReader(file);
            BufferedReader bufReader = new BufferedReader(reader);
            String txt = "";
            while ((tmpStr = bufReader.readLine()) != null) {
                txt = txt + tmpStr + "\n";
            }
            return txt;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String createExchangeSQL1(String hostName, String userName) {
        StringBuffer buf = new StringBuffer();
        String localDate = "02/22/2006 12:00 PM";
        String gmtDate = Test.localToExchangeDate(localDate);
        buf.append("select \"urn:schemas:mailheader:to\" from \"http://" + hostName + "/exchange/" + userName + "/Calendar\"");
        buf.append(" where \"urn:schemas:mailheader:from\" LIKE '%rbhushan@adobe.com%' ");
        System.out.println("Query -> " + buf.toString());
        String query = "<?xml version=\"1.0\"?><g:searchrequest xmlns:g=\"DAV:\"><g:sql>" + buf.toString() + "</g:sql>" + "</g:searchrequest>";
        return query;
    }

    public static String localToExchangeDate(String localDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy h:m aaa");
        SimpleDateFormat exchangeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date aDate = dateFormat.parse(localDate);
            Calendar here = Calendar.getInstance();
            int gmtoffset = here.get(16) + here.get(15);
            Date gmtDate = new Date(aDate.getTime() - (long)gmtoffset);
            String gmtStrDate = exchangeDateFormat.format(gmtDate);
            int i1 = gmtStrDate.indexOf(32);
            if (i1 < 0) {
                return "";
            }
            String datePart = gmtStrDate.substring(0, i1);
            String timePart = gmtStrDate.substring(i1 + 1);
            return datePart + "T" + timePart + ".000Z";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Date exchangeToLocalDate(String exchangeDate) {
        int i1 = exchangeDate.indexOf(84);
        int i2 = exchangeDate.lastIndexOf(46);
        int n = i2 = i1 < 0 ? exchangeDate.length() : i2;
        if (i1 < 0) {
            return null;
        }
        String datePart = exchangeDate.substring(0, i1);
        String timePart = exchangeDate.substring(i1 + 1, i2);
        try {
            String exchangeDateStr = datePart + " " + timePart;
            SimpleDateFormat exchangeDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date dtExchange = exchangeDateFormat.parse(exchangeDateStr);
            Calendar here = Calendar.getInstance();
            int gmtoffset = here.get(16) + here.get(15);
            return new Date(dtExchange.getTime() + (long)gmtoffset);
        }
        catch (Exception e) {
            return null;
        }
    }
}

