/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.CertJVersion;
import com.rsa.certj.CompatibilityType;
import com.rsa.certj.DatabaseService;
import com.rsa.certj.FIPS140Mode;
import com.rsa.certj.FIPS140Role;
import com.rsa.certj.InvalidParameterException;
import com.rsa.certj.InvalidUseException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Provider;
import com.rsa.certj.ProviderImplementation;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.Service;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.GeneralSubtrees;
import com.rsa.certj.core.config.CertJConfiguration;
import com.rsa.certj.internal.CertJContext;
import com.rsa.certj.internal.EVDelegator;
import com.rsa.certj.internal.SuiteBDelegator;
import com.rsa.certj.pkcs12.PKCS12;
import com.rsa.certj.pkcs12.PKCS12Exception;
import com.rsa.certj.provider.random.DefaultRandom;
import com.rsa.certj.spi.path.CertPathCtx;
import com.rsa.certj.spi.path.CertPathException;
import com.rsa.certj.spi.path.CertPathInterface;
import com.rsa.certj.spi.path.CertPathResult;
import com.rsa.certj.spi.path.PolicyInformation;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.certj.spi.random.RandomInterface;
import com.rsa.certj.spi.revocation.CertRevocationInfo;
import com.rsa.certj.spi.revocation.CertStatusException;
import com.rsa.certj.spi.revocation.CertStatusInterface;
import com.rsa.jsafe.CryptoJ;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Session;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertJ {
    public static final int SPT_RANDOM = 0;
    public static final int SPT_DATABASE = 1;
    public static final int SPT_CERT_STATUS = 2;
    public static final int SPT_CERT_PATH = 3;
    public static final int SPT_PKI = 4;
    private static final int SPT_FIRST = 0;
    private static final int SPT_LAST = 4;
    public static final int SERVICE_ORDER_FIRST = 0;
    public static final int SERVICE_ORDER_LAST = 1;
    public static final String CERT_J_VERSION = CertJVersion.getVersionString();
    public static final int COMPAT_STRICT = 0;
    public static final int COMPAT_BUS_CAT_ABSENT = 1;
    public static final int COMPAT_EXTRA_KEY_USAGE_BIT = 2;
    public static final int COMPAT_NON_CRITICAL_KEY_USAGE = 4;
    public static final int COMPAT_WEAK_RSA_KEY_SIZE = 8;
    public static final int COMPAT_CERT_POLICY_ABSENT = 16;
    private static volatile String defaultDevice = CertJ.getDefaultDeviceStringValue();
    private static final String PARAMETERS_SHOULD_NOT_BE_NULL = "CertJ.isSuiteBCompliant: parameters should not be null.";
    private final Vector<Object>[] services = new Vector[5];
    private volatile String device;
    private volatile JSAFE_Session[] pkcs11Sessions;
    final CertJContext context;
    private static Vector<CompatibilityType> compatibilityTypeVector = new Vector(1);
    public static final int NOT_INITIALIZED = 0;
    public static final int UNDER_SELF_TEST = 1;
    public static final int OPERATIONAL = 2;
    public static final int FAILED = 3;
    public static final int FIPS140_MODE = 0;
    public static final int FIPS140_ECC_MODE = 0;
    public static final int FIPS140_SSL_MODE = 2;
    public static final int FIPS140_SSL_ECC_MODE = 2;
    public static final int NON_FIPS140_MODE = 1;
    public static final int CRYPTO_OFFICER_ROLE = 10;
    public static final int USER_ROLE = 11;

    private static String getDefaultDeviceStringValue() {
        if (CryptoJ.isNativeAvailable((String)"SHA1")) {
            return "Native/Java";
        }
        return "Java";
    }

    public void setPKCS11Sessions(JSAFE_Session[] sessionArray) throws InvalidParameterException {
        if (sessionArray == null) {
            throw new InvalidParameterException("PKCS11 Session Array cannot be null");
        }
        this.pkcs11Sessions = (JSAFE_Session[])sessionArray.clone();
    }

    public JSAFE_Session[] getPKCS11Sessions() {
        if (this.pkcs11Sessions != null) {
            return (JSAFE_Session[])this.pkcs11Sessions.clone();
        }
        return null;
    }

    public static String getDefaultDevice() {
        return defaultDevice;
    }

    public static void setDefaultDevice(String device) throws InvalidParameterException {
        if (device == null) {
            throw new InvalidParameterException("A device string must be provided.");
        }
        defaultDevice = device;
    }

    public CertJ() throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(), (Provider[])null);
    }

    public CertJ(FIPS140Mode mode) throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(mode), (Provider[])null);
    }

    public CertJ(FIPS140Mode mode, FIPS140Role role) throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(mode, role), (Provider[])null);
    }

    public CertJ(FIPS140Mode mode, FIPS140Role role, byte[] pin) throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(mode, role, pin, null), (Provider[])null);
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("A valid pin must be provided.");
        }
    }

    public CertJ(FIPS140Mode mode, FIPS140Role role, byte[] pin, File moduleConfigFile) throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(mode, role, pin, moduleConfigFile), (Provider[])null);
        if (pin == null || pin.length == 0 || moduleConfigFile == null) {
            throw new IllegalArgumentException("A valid pin and configuration file must be provided.");
        }
    }

    public CertJ(Provider[] providers) throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(), providers);
    }

    public CertJ(Provider[] providers, FIPS140Mode mode) throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(mode), providers);
    }

    public CertJ(Provider[] providers, FIPS140Mode mode, FIPS140Role role) throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(mode, role), providers);
    }

    public CertJ(Provider[] providers, FIPS140Mode mode, FIPS140Role role, byte[] pin) throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(mode, role, pin, null), providers);
        if (pin == null || pin.length == 0) {
            throw new IllegalArgumentException("A valid pin must be provided.");
        }
    }

    public CertJ(Provider[] providers, FIPS140Mode mode, FIPS140Role role, byte[] pin, File moduleConfigFile) throws ProviderManagementException, InvalidUseException {
        this(CertJContext.getCertJContext(mode, role, pin, moduleConfigFile), providers);
        if (pin == null || pin.length == 0 || moduleConfigFile == null) {
            throw new IllegalArgumentException("A valid pin and configuration file must be provided.");
        }
    }

    private CertJ(CertJContext context, Provider[] providers) throws ProviderManagementException, InvalidUseException {
        int i;
        this.context = context;
        CertJ.isFIPS140Compliant();
        this.device = defaultDevice;
        for (i = 0; i <= 4; ++i) {
            this.services[i] = new Vector();
        }
        try {
            if (providers != null) {
                for (i = 0; i < providers.length; ++i) {
                    this.registerService(providers[i], 1);
                }
            }
            if (this.services[0].isEmpty()) {
                this.registerService(new DefaultRandom("Default Random"), 1);
            }
        }
        catch (InvalidParameterException e) {
            this.unregisterAll();
            throw new ProviderManagementException("CertJ.CertJ: ", e);
        }
        catch (ProviderManagementException e) {
            this.unregisterAll();
            throw e;
        }
    }

    public void unregisterAll() {
        for (int type = 0; type <= 4; ++type) {
            Vector<Object> providerList = this.services[type];
            for (Object providerImpl : providerList) {
                ProviderImplementation implementor = (ProviderImplementation)providerImpl;
                implementor.unregister();
            }
            providerList.removeAllElements();
        }
    }

    public void registerService(Provider provider) throws InvalidParameterException, ProviderManagementException {
        this.registerService(provider, 1);
    }

    public void registerService(Provider provider, int order) throws InvalidParameterException, ProviderManagementException {
        if (provider == null) {
            throw new InvalidParameterException("CertJ.registerService: provider can not be null.");
        }
        if (order != 1 && order != 0) {
            throw new InvalidParameterException("CertJ.registerService: order should be either SERVICE_ORDER_LAST or SERVICE_ORDER_FIRST.");
        }
        if (provider.getName() == null) {
            throw new ProviderManagementException("CertJ.registerService: provider has to have a name.");
        }
        int type = provider.getType();
        if (type < 0 || type > 4) {
            throw new ProviderManagementException("CertJ.registerService: service type(" + type + ") of the provider is not between " + 0 + " and " + 4 + ".");
        }
        if (type == 0) {
            if (this.services[0] != null && !this.services[0].isEmpty()) {
                throw new ProviderManagementException("CertJ.registerService: a random service is already registered. Do unregister it first.");
            }
        } else {
            Service existingService = null;
            try {
                existingService = this.bindService(provider.getType(), provider.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (existingService != null) {
                this.unbindService(existingService);
                throw new ProviderManagementException("CertJ.registerService: " + CertJ.serviceTypeToString(provider.getType()) + " service named " + provider.getName() + " is already registered.");
            }
        }
        ProviderImplementation implementor = provider.instantiate(this);
        Vector<Object> providerList = this.services[type];
        if (order == 0) {
            providerList.insertElementAt(implementor, 0);
        } else if (order == 1) {
            providerList.addElement(implementor);
        }
    }

    public void unregisterService(int type, String name) throws InvalidParameterException {
        if (type < 0 || type > 4) {
            throw new InvalidParameterException("CertJ.unregisterService: type (" + type + ") is not between SPT_FIRST and SPT_LAST.");
        }
        if (name == null) {
            throw new InvalidParameterException("CertJ.unregisterService: name should not be null.");
        }
        Vector<Object> providerList = this.services[type];
        for (Object providerImpl : providerList) {
            ProviderImplementation implementor = (ProviderImplementation)providerImpl;
            if (!implementor.getName().equals(name)) continue;
            implementor.unregister();
            providerList.remove(implementor);
            break;
        }
    }

    public void addProvider(Provider provider) throws InvalidParameterException, ProviderManagementException {
        this.registerService(provider);
    }

    public void addProvider(Provider provider, int order) throws InvalidParameterException, ProviderManagementException {
        this.registerService(provider, order);
    }

    public void removeProvider(int type, String name) throws InvalidParameterException {
        this.unregisterService(type, name);
    }

    public Service bindService(int type, String name) throws InvalidParameterException, ProviderManagementException {
        String[] names = new String[1];
        if (name == null) {
            if (type < 0 || type > 4) {
                throw new InvalidParameterException("CertJ.bindService: type (" + type + ") is not between SPT_FIRST and SPT_LAST.");
            }
            Vector<Object> providerList = this.services[type];
            if (providerList.isEmpty()) {
                throw new ProviderManagementException("CertJ.bindService: no provider is registered for type" + CertJ.serviceTypeToString(type));
            }
            names[0] = ((ProviderImplementation)providerList.elementAt(0)).getName();
        } else {
            names[0] = name;
        }
        return this.bindServices(type, names);
    }

    public Service bindServices(int type, String[] names) throws InvalidParameterException, ProviderManagementException {
        if (type < 0 || type > 4) {
            throw new InvalidParameterException("CertJ.bindServices: type (" + type + ") is not between SPT_FIRST and SPT_LAST.");
        }
        if (names == null) {
            return this.bindServices(type);
        }
        Vector<Object> providerList = this.services[type];
        Service service = Service.getInstance(this, type);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            boolean found = false;
            for (Object providerImpl : providerList) {
                ProviderImplementation implementor = (ProviderImplementation)providerImpl;
                if (!name.equals(implementor.getName())) continue;
                service.addProvider(implementor);
                found = true;
                break;
            }
            if (found) continue;
            throw new ProviderManagementException("CertJ.bindServices: provider of type: " + CertJ.serviceTypeToString(type) + " with name: " + names[i] + " not found.");
        }
        return service;
    }

    public Service bindServices(int type) throws InvalidParameterException, ProviderManagementException {
        if (type < 0 || type > 4) {
            throw new InvalidParameterException("CertJ.bindServices: type (" + type + ") is not between SPT_FIRST and SPT_LAST.");
        }
        Service service = Service.getInstance(this, type);
        Vector<Object> providerList = this.services[type];
        if (providerList.isEmpty()) {
            throw new ProviderManagementException("CertJ.bindServices: no provider is registered for type: " + CertJ.serviceTypeToString(type));
        }
        for (Object providerImpl : providerList) {
            service.addProvider((ProviderImplementation)providerImpl);
        }
        return service;
    }

    public void unbindService(Service service) {
        if (service != null) {
            service.unbind();
        }
    }

    public String[] listAllProviders() {
        ArrayList<String> list = new ArrayList<String>();
        for (int type = 0; type <= 4; ++type) {
            Vector<Object> providerList = this.services[type];
            for (Object providerImpl : providerList) {
                list.add(providerImpl.toString());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public String[] listProviderNames(int providerType) {
        Vector<Object> providerList = this.services[providerType];
        ArrayList<String> list = new ArrayList<String>();
        for (Object providerImpl : providerList) {
            list.add(((ProviderImplementation)providerImpl).getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean isProviderRegistered(Provider provider, int providerType) {
        boolean found = false;
        String providerClass = provider.getClass().getName();
        Vector<Object> providerList = this.services[providerType];
        for (Object providerImpl : providerList) {
            String registeredProviders = providerImpl.getClass().getName();
            if (!(registeredProviders = registeredProviders.substring(0, registeredProviders.indexOf("$"))).equals(providerClass)) continue;
            found = true;
            break;
        }
        return found;
    }

    public JSAFE_SecureRandom getRandomObject() throws NoServiceException, RandomException {
        if (this.services[0].isEmpty()) {
            throw new NoServiceException("CertJ.getRandomObject: no random service is registered.");
        }
        RandomInterface provider = (RandomInterface)this.services[0].elementAt(0);
        try {
            return provider.getRandomObject();
        }
        catch (NotSupportedException e) {
            throw new NoServiceException("CertJ.getRandomObject: ", e);
        }
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) throws InvalidParameterException {
        if (device == null) {
            throw new InvalidParameterException("A device string must be provided.");
        }
        this.device = device;
    }

    public boolean verifyCertPath(CertPathCtx pathCtx, Object startObject) throws InvalidParameterException, NoServiceException, CertPathException {
        return this.buildCertPath(pathCtx, startObject, null, null, null, null);
    }

    public boolean buildCertPath(CertPathCtx pathCtx, Object startObject, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList) throws InvalidParameterException, NoServiceException, CertPathException {
        if (pathCtx == null) {
            throw new InvalidParameterException("CertJ.buildCertPath: pathCtx should not be null.");
        }
        if (!(startObject instanceof Certificate) && !(startObject instanceof CRL)) {
            throw new InvalidParameterException("CertJ.buildCertPath: startObject should be either Certificate or CRL.");
        }
        Vector<Object> providerList = this.services[3];
        for (Object providerImpl : providerList) {
            try {
                return ((CertPathInterface)providerImpl).buildCertPath(pathCtx, startObject, certPath, crlList, crlCerts, policyInfoList);
            }
            catch (NotSupportedException e) {
            }
        }
        throw new NoServiceException("CertJ.buildCertPath: no provider is found to handle this method.");
    }

    public CertPathResult buildCertPath(CertPathCtx pathCtx, Object startObject, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts) throws InvalidParameterException, NoServiceException, CertPathException {
        if (pathCtx == null) {
            throw new InvalidParameterException("CertJ.buildCertPath: pathCtx should not be null.");
        }
        if (!(startObject instanceof Certificate) && !(startObject instanceof CRL)) {
            throw new InvalidParameterException("CertJ.buildCertPath: startObject should be either Certificate or CRL.");
        }
        Vector<Object> providerList = this.services[3];
        for (Object certPathImpl : providerList) {
            try {
                return ((CertPathInterface)certPathImpl).buildCertPath(pathCtx, startObject, certPath, crlList, crlCerts);
            }
            catch (NotSupportedException e) {
            }
        }
        throw new NoServiceException("CertJ.buildCertPath: no provider is found to handle this method.");
    }

    public boolean buildCertPath(CertPathCtx pathCtx, Object startObject, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, Vector<PolicyInformation> policyInfoList, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees) throws InvalidParameterException, NoServiceException, CertPathException {
        if (pathCtx == null) {
            throw new InvalidParameterException("CertJ.buildCertPath: pathCtx should not be null.");
        }
        if (!(startObject instanceof Certificate) && !(startObject instanceof CRL)) {
            throw new InvalidParameterException("CertJ.buildCertPath: startObject should be either Certificate or CRL.");
        }
        Vector<Object> providerList = this.services[3];
        for (Object certPathImpl : providerList) {
            try {
                CertPathResult result = ((CertPathInterface)certPathImpl).buildCertPath(pathCtx, startObject, certPath, crlList, crlCerts, initialPermittedSubtrees, initialExcludedSubtrees);
                Vector<PolicyInformation> validPolicies = result.getValidPolicies();
                if (validPolicies != null) {
                    policyInfoList.addAll(validPolicies);
                }
                return result.getValidationResult();
            }
            catch (NotSupportedException e) {
            }
        }
        throw new NoServiceException("CertJ.buildCertPath: no provider is found to handle this method.");
    }

    public CertPathResult buildCertPath(CertPathCtx pathCtx, Object startObject, Vector<Certificate> certPath, Vector<CRL> crlList, Vector<Certificate> crlCerts, GeneralSubtrees initialPermittedSubtrees, GeneralNames initialExcludedSubtrees) throws InvalidParameterException, NoServiceException, CertPathException {
        if (pathCtx == null) {
            throw new InvalidParameterException("CertJ.buildCertPath: pathCtx should not be null.");
        }
        if (!(startObject instanceof Certificate) && !(startObject instanceof CRL)) {
            throw new InvalidParameterException("CertJ.buildCertPath: startObject should be either Certificate or CRL.");
        }
        Vector<Object> providerList = this.services[3];
        for (Object certPathImpl : providerList) {
            try {
                return ((CertPathInterface)certPathImpl).buildCertPath(pathCtx, startObject, certPath, crlList, crlCerts, initialPermittedSubtrees, initialExcludedSubtrees);
            }
            catch (NotSupportedException e) {
            }
        }
        throw new NoServiceException("CertJ.buildCertPath: no provider is found to handle this method.");
    }

    public void getNextCertInPath(CertPathCtx pathCtx, Object baseObject, Vector<Certificate> certList) throws InvalidParameterException, NoServiceException, CertPathException {
        if (pathCtx == null) {
            throw new InvalidParameterException("CertJ.getNextCertInPath: pathCtx should not be null.");
        }
        if (!(baseObject instanceof Certificate) && !(baseObject instanceof CRL)) {
            throw new InvalidParameterException("CertJ.getNextCertInPath: baseObject should be either Certificate or CRL.");
        }
        Vector<Object> providerList = this.services[3];
        for (Object certPathImpl : providerList) {
            try {
                ((CertPathInterface)certPathImpl).getNextCertInPath(pathCtx, baseObject, certList);
                return;
            }
            catch (NotSupportedException e) {
            }
        }
        throw new NoServiceException("CertJ.getNextCertInPath: no provider is found to handle this method.");
    }

    public boolean validateCertificate(CertPathCtx pathCtx, Certificate cert, JSAFE_PublicKey validationKey) throws InvalidParameterException, NoServiceException, CertPathException {
        if (pathCtx == null) {
            throw new InvalidParameterException("CertJ.validateCertificate: pathCtx should not be null.");
        }
        if (cert == null) {
            throw new InvalidParameterException("CertJ.validateCertificate: cert should not be null.");
        }
        if (validationKey == null) {
            throw new InvalidParameterException("CertJ.validateCertificate: validationKey should not be null.");
        }
        Vector<Object> providerList = this.services[3];
        for (int i = 0; i < providerList.size(); ++i) {
            try {
                return ((CertPathInterface)providerList.elementAt(i)).validateCertificate(pathCtx, cert, validationKey);
            }
            catch (NotSupportedException e) {
                continue;
            }
        }
        throw new NoServiceException("CertJ.validateCertificate: no provider is found to handle this method.");
    }

    public CertRevocationInfo checkCertRevocation(CertPathCtx pathCtx, Certificate cert) throws InvalidParameterException, NoServiceException, CertStatusException {
        if (pathCtx == null) {
            throw new InvalidParameterException("CertJ.checkCertRevocation: pathCtx should not be null.");
        }
        if (cert == null) {
            throw new InvalidParameterException("CertJ.checkCertRevocation: cert should not be null.");
        }
        Vector<Object> providerList = this.services[2];
        CertRevocationInfo aUnknownStatusInfo = null;
        for (int i = 0; i < providerList.size(); ++i) {
            try {
                CertRevocationInfo info = ((CertStatusInterface)providerList.elementAt(i)).checkCertRevocation(pathCtx, cert);
                if (info.getStatus() == 2) {
                    if (aUnknownStatusInfo == null) {
                        aUnknownStatusInfo = info;
                    }
                    continue;
                }
                return info;
            }
            catch (NotSupportedException e) {
                // empty catch block
            }
        }
        if (aUnknownStatusInfo != null) {
            return aUnknownStatusInfo;
        }
        throw new NoServiceException("CertJ.checkCertRevocation: no provider is found to handle this method or no registered provider can determine the revocation status of the given certificate.");
    }

    public void importPKCS12(String pkcs12File, char[] password, DatabaseService database) throws PKCS12Exception {
        new PKCS12(this, database, password, pkcs12File);
    }

    public void importPKCS12(File pkcs12File, char[] password, DatabaseService database) throws PKCS12Exception {
        new PKCS12(this, database, password, pkcs12File);
    }

    public static String serviceTypeToString(int type) {
        switch (type) {
            case 0: {
                return "SPT_RANDOM";
            }
            case 1: {
                return "SPT_DATABASE";
            }
            case 2: {
                return "SPT_CERT_STATUS";
            }
            case 3: {
                return "SPT_CERT_PATH";
            }
            case 4: {
                return "SPT_PKI";
            }
        }
        return "Unknown service type: " + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCompatibilityType(CompatibilityType property) {
        Vector<CompatibilityType> vector = compatibilityTypeVector;
        synchronized (vector) {
            if (!compatibilityTypeVector.contains(property)) {
                compatibilityTypeVector.addElement(property);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCompatibilityType(CompatibilityType property) {
        Vector<CompatibilityType> vector = compatibilityTypeVector;
        synchronized (vector) {
            compatibilityTypeVector.removeElement(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompatibilityTypeSet(CompatibilityType type) {
        boolean isSet;
        Vector<CompatibilityType> vector = compatibilityTypeVector;
        synchronized (vector) {
            isSet = compatibilityTypeVector.contains(type);
        }
        return isSet;
    }

    public static boolean isFIPS140Compliant() {
        return CertJConfiguration.isFIPSCompliant();
    }

    public static boolean isNotFIPS140Compliant() throws InvalidUseException {
        return !CertJ.isFIPS140Compliant();
    }

    public static int getState() {
        return CryptoJ.getState();
    }

    public static int getMode() {
        return CryptoJ.getMode();
    }

    public static void setMode(int newMode) throws InvalidUseException {
        try {
            CryptoJ.setMode((int)newMode);
        }
        catch (JSAFE_InvalidUseException ex) {
            throw new InvalidUseException((Exception)((Object)ex));
        }
    }

    public static int getRole() {
        return CryptoJ.getRole();
    }

    public static void setRole(int newRole) throws InvalidUseException {
        try {
            CryptoJ.setRole((int)newRole);
        }
        catch (JSAFE_InvalidUseException ex) {
            throw new InvalidUseException((Exception)((Object)ex));
        }
    }

    public static boolean selfTestPassed() {
        return CryptoJ.selfTestPassed();
    }

    public static synchronized boolean runSelfTests() throws InvalidUseException {
        try {
            return CryptoJ.runSelfTests();
        }
        catch (JSAFE_InvalidUseException ex) {
            throw new InvalidUseException((Exception)((Object)ex));
        }
    }

    public FIPS140Mode getFIPS140Mode() {
        if (this.context.fips140 == null) {
            return FIPS140Mode.NON_FIPS140_MODE;
        }
        return FIPS140Mode.lookup(this.context.fips140.getModeValue());
    }

    public FIPS140Role getFIPS140Role() {
        if (this.context.fips140 == null) {
            return FIPS140Role.USER_ROLE;
        }
        return FIPS140Role.lookup(this.context.fips140.getRoleValue());
    }

    public boolean isSuiteBCompliant(X509CRL crl) throws InvalidParameterException, CertStatusException {
        if (crl == null) {
            throw new InvalidParameterException(PARAMETERS_SHOULD_NOT_BE_NULL);
        }
        return SuiteBDelegator.checkSuiteBCompliance(crl);
    }

    public boolean isSuiteBCompliant(X509Certificate cert) throws InvalidParameterException, CertPathException {
        return this.isSuiteBCompliant(cert, null);
    }

    public boolean isSuiteBCompliant(X509Certificate cert, JSAFE_PublicKey signingPubKey) throws InvalidParameterException, CertPathException {
        if (cert == null) {
            throw new InvalidParameterException(PARAMETERS_SHOULD_NOT_BE_NULL);
        }
        return SuiteBDelegator.checkSuiteBCompliance(cert, signingPubKey, this.context);
    }

    public boolean isEVCompliant(X509Certificate[] certs, List<String> trustedEVPolicyOIDs) throws InvalidParameterException, CertPathException {
        return this.isEVCompliant(certs, trustedEVPolicyOIDs, CertJ.getDefaultCompatibilityMask());
    }

    public boolean isEVCompliant(X509Certificate[] certs, List<String> trustedEVPolicyOIDs, int compatibilityMask) throws InvalidParameterException, CertPathException {
        if (certs == null || trustedEVPolicyOIDs == null) {
            throw new InvalidParameterException("CertJ.isEVCompliant: parameters should not be null.");
        }
        return EVDelegator.checkEVCompliance(certs, trustedEVPolicyOIDs, compatibilityMask, this.context);
    }

    public static int getDefaultCompatibilityMask() {
        return EVDelegator.getDefaultCompatibilityMask();
    }
}

