/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.cert.extensions.GeneralNames;
import com.rsa.certj.cert.extensions.IssuerAltName;
import com.rsa.certj.cert.extensions.X509V3Extension;
import com.rsa.jsafe.cert.ObjectID;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CertJUtils {
    private CertJUtils() {
    }

    public static void mergeLists(Vector dest, Vector<?> source) {
        if (dest == null || source == null) {
            return;
        }
        for (int i = 0; i < source.size(); ++i) {
            Object element = source.elementAt(i);
            if (dest.contains(element)) continue;
            dest.addElement(element);
        }
    }

    public static void subtractLists(Vector<?> dest, Vector<?> source) {
        if (dest == null || source == null) {
            return;
        }
        for (Object element : source) {
            if (!dest.contains(element)) continue;
            dest.removeElement(element);
        }
    }

    public static void intersectLists(Vector dest, Vector source) {
        if (dest == null || source == null) {
            return;
        }
        int count = dest.size();
        while (count > 0) {
            if (source.contains(dest.elementAt(--count))) continue;
            dest.removeElementAt(count);
        }
    }

    public static void uniteLists(Vector dest, Vector source) {
        if (dest == null || source == null) {
            return;
        }
        for (int i = 0; i < source.size(); ++i) {
            Object element = source.elementAt(i);
            if (dest.contains(element)) continue;
            dest.addElement(element);
        }
    }

    public static boolean byteArraysEqual(byte[] array1, byte[] array2) {
        return Arrays.equals(array1, array2);
    }

    public static boolean byteArraysEqual(byte[] array1, int offset1, int len1, byte[] array2) {
        return CertJUtils.byteArraysEqual(array1, offset1, len1, array2, 0, array2.length);
    }

    public static boolean byteArraysEqual(byte[] array1, int offset1, int len1, byte[] array2, int offset2, int len2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (len1 != len2) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (array1[offset1 + i] == array2[offset2 + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean containsByteArray(Vector<byte[]> list, byte[] byteArray) {
        for (byte[] element : list) {
            if (!CertJUtils.byteArraysEqual(element, byteArray)) continue;
            return true;
        }
        return false;
    }

    public static void intersectByteArrayLists(Vector dest, Vector source) {
        if (dest == null || source == null) {
            return;
        }
        int count = dest.size();
        while (count > 0) {
            if (CertJUtils.containsByteArray(source, (byte[])dest.elementAt(--count))) continue;
            dest.removeElementAt(count);
        }
    }

    public static void uniteByteArrayLists(Vector dest, Vector source) {
        if (dest == null || source == null) {
            return;
        }
        for (int i = 0; i < source.size(); ++i) {
            byte[] element = (byte[])source.elementAt(i);
            if (CertJUtils.containsByteArray(dest, element)) continue;
            dest.addElement(element);
        }
    }

    public static boolean sequencesEqual(Vector<Certificate> seq1, Vector<Certificate> seq2) {
        int len2;
        int len1 = seq1.size();
        if (len1 != (len2 = seq2.size())) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (seq1.elementAt(i).equals(seq2.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean setsEqual(Vector set1, Vector set2) {
        int len2;
        int len1 = set1.size();
        if (len1 != (len2 = set2.size())) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (set1.contains(set2.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsExtension(X509V3Extension extension, X509V3Extensions extensions) {
        int type = extension.getExtensionType();
        X509V3Extension foundExt = null;
        try {
            foundExt = extensions.getExtensionByType(type);
        }
        catch (CertificateException e) {
            return false;
        }
        if (foundExt == null) {
            return false;
        }
        switch (type) {
            case 18: {
                GeneralNames names = ((IssuerAltName)extension).getGeneralNames();
                GeneralNames foundNames = ((IssuerAltName)foundExt).getGeneralNames();
                try {
                    for (int i = 0; i < names.getNameCount(); ++i) {
                        if (!foundNames.contains(names.getGeneralName(i))) continue;
                        return true;
                    }
                }
                catch (NameException e) {
                    return false;
                }
                return false;
            }
        }
        byte[] derEncodingOfRule = new byte[extension.getDERLen(0)];
        byte[] derEncodingOfFound = new byte[foundExt.getDERLen(0)];
        if (derEncodingOfRule.length != derEncodingOfFound.length) {
            return false;
        }
        extension.getDEREncoding(derEncodingOfRule, 0, 0);
        foundExt.getDEREncoding(derEncodingOfFound, 0, 0);
        for (int i = 0; i < derEncodingOfRule.length; ++i) {
            if (derEncodingOfRule[i] == derEncodingOfFound[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compareExtensions(X509V3Extensions rule, X509V3Extensions extensions) {
        if (rule == null) {
            return true;
        }
        if (extensions == null) {
            return false;
        }
        try {
            for (int ruleIndex = 0; ruleIndex < rule.getExtensionCount(); ++ruleIndex) {
                if (CertJUtils.containsExtension(rule.getExtensionByIndex(ruleIndex), extensions)) continue;
                return false;
            }
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    public static int bytesToHashCode(byte[] bytes) {
        return CertJUtils.bytesToHashCode(bytes, 0, bytes.length);
    }

    public static int bytesToHashCode(byte[] bytes, int offset, int length) {
        int result = 0;
        int bytesSum = 0;
        int endIndex = offset + length;
        int shiftCount = 0;
        for (int i = offset; i < endIndex; ++i) {
            int shiftedByte = (bytes[i] & 0xFF) << shiftCount;
            bytesSum += bytes[i];
            result ^= shiftedByte;
            if (shiftCount == 24) {
                shiftCount = 0;
                continue;
            }
            shiftCount += 8;
        }
        result ^= length;
        return result ^= bytesSum;
    }

    public static String objectArrayToString(Object[] objectArray, String separator) {
        if (objectArray == null) {
            return "";
        }
        String theSeparator = separator == null ? ", " : separator;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            Object nextObject = objectArray[i];
            result.append(theSeparator);
            if (nextObject == null) continue;
            result.append(nextObject.toString());
        }
        if (objectArray.length > 0) {
            result.delete(0, theSeparator.length());
        }
        return result.toString();
    }

    public static byte[] oidStringToBytes(String oid) throws IllegalArgumentException {
        return new ObjectID(oid).getEncoded();
    }

    public static char[] byteArrayToCharArray(byte[] in) {
        char[] buffer = new char[in.length];
        for (int i = 0; i < in.length; ++i) {
            buffer[i] = (char)(in[i] & 0xFF);
        }
        return buffer;
    }
}

