/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj;

import com.rsa.certj.CertJ;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.NotSupportedException;
import com.rsa.certj.Service;
import com.rsa.certj.cert.CRL;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X509CRL;
import com.rsa.certj.cert.X509V3Extensions;
import com.rsa.certj.spi.db.DatabaseException;
import com.rsa.certj.spi.db.DatabaseInterface;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseService
extends Service {
    private int currentCertIterator = -1;
    private int currentCrlIterator = -1;

    public DatabaseService(CertJ certJ) {
        super(certJ);
    }

    public void insertCertificate(Certificate cert) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).insertCertificate(cert);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.insertCertificate: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
    }

    public void insertCertificates(Certificate[] certs) throws NoServiceException, DatabaseException {
        if (certs == null) {
            throw new DatabaseException("DatabaseService.insertCertificates: certs should not be null.");
        }
        for (int i = 0; i < certs.length; ++i) {
            this.insertCertificate(certs[i]);
        }
    }

    public void insertCRL(CRL crl) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).insertCRL(crl);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.insertCRL: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
    }

    public void insertCRLs(CRL[] crls) throws NoServiceException, DatabaseException {
        if (crls == null) {
            throw new DatabaseException("DatabaseService.insertCRLs: crls should not be null.");
        }
        for (int i = 0; i < crls.length; ++i) {
            this.insertCRL(crls[i]);
        }
    }

    public void insertPrivateKeyByCertificate(Certificate cert, JSAFE_PrivateKey privateKey) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).insertPrivateKeyByCertificate(cert, privateKey);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.insertPrivateKeyByCertificate: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
    }

    public void insertPrivateKeyByPublicKey(JSAFE_PublicKey publicKey, JSAFE_PrivateKey privateKey) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).insertPrivateKeyByPublicKey(publicKey, privateKey);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.insertPrivateKeyByPublicKey: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
    }

    public int selectCertificateByIssuerAndSerialNumber(X500Name issuerName, byte[] serialNumber, Vector<Certificate> certList) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        if (certList == null) {
            throw new DatabaseException("DatabaseService.selectCertificateByIssuerAndSerialNumber: certList should not be null.");
        }
        int count = certList.size();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                int found = ((DatabaseInterface)((Object)this.getProviderAt(i))).selectCertificateByIssuerAndSerialNumber(issuerName, serialNumber, certList);
                noHandler = false;
                if (found <= 0) continue;
                return certList.size() - count;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.selectCertificateByIssuerAndSerialNumber: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
        return 0;
    }

    public int selectCertificateBySubject(X500Name subjectName, Vector<Certificate> certList) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        if (certList == null) {
            throw new DatabaseException("DatabaseService.selectCertificateBySubject: certList should not be null.");
        }
        int count = certList.size();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).selectCertificateBySubject(subjectName, certList);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.selectCertificateBySubject: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
        return certList.size() - count;
    }

    public int selectCertificateByExtensions(X500Name baseName, X509V3Extensions extensions, Vector<Certificate> certList) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        if (certList == null) {
            throw new DatabaseException("DatabaseService.selectCertificateByExtensions: certList should not be null.");
        }
        int count = certList.size();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).selectCertificateByExtensions(baseName, extensions, certList);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.selectCertificateByExtensions: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
        return certList.size() - count;
    }

    public Certificate firstCertificate() throws NoServiceException, DatabaseException {
        this.setupCertificateIterator();
        return this.nextCertificate();
    }

    public Certificate nextCertificate() throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        if (!this.isCertificateIteratorSetup()) {
            throw new DatabaseException("DatabaseService.nextCertificate: No certificate iterator has been set!");
        }
        int providerCount = this.getProviderCount();
        Certificate result = null;
        while (this.currentCertIterator < providerCount) {
            try {
                result = ((DatabaseInterface)((Object)this.getProviderAt(this.currentCertIterator))).nextCertificate();
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
            if (result != null) {
                return result;
            }
            ++this.currentCertIterator;
        }
        return null;
    }

    public boolean hasMoreCertificates() throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        if (this.currentCertIterator < 0) {
            this.setupCertificateIterator();
        }
        int providerCount = this.getProviderCount();
        while (this.currentCertIterator < providerCount) {
            try {
                if (((DatabaseInterface)((Object)this.getProviderAt(this.currentCertIterator))).hasMoreCertificates()) {
                    return true;
                }
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
            ++this.currentCertIterator;
        }
        return false;
    }

    public int selectCRLByIssuerAndTime(X500Name issuerName, Date time, Vector<CRL> crlList) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        if (crlList == null) {
            throw new DatabaseException("DatabaseService.selectCRLByIssuerAndTime: crlList should not be null.");
        }
        Vector<CRL> list = new Vector<CRL>();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).selectCRLByIssuerAndTime(issuerName, time, list);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.selectCRLByIssuerAndTime: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
        Date bestTime = new Date(0L);
        X509CRL bestCrl = null;
        for (CRL crl : list) {
            X509CRL x509crl = (X509CRL)crl;
            Date thisUpdate = x509crl.getThisUpdate();
            if (!thisUpdate.after(bestTime)) continue;
            bestTime = thisUpdate;
            bestCrl = x509crl;
        }
        if (bestCrl == null) {
            return 0;
        }
        if (!crlList.contains(bestCrl)) {
            crlList.addElement(bestCrl);
        }
        return 1;
    }

    public CRL firstCRL() throws NoServiceException, DatabaseException {
        this.setupCRLIterator();
        return this.nextCRL();
    }

    public CRL nextCRL() throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        if (!this.isCRLIteratorSetup()) {
            throw new DatabaseException("DatabaseService.nextCRL: No CRL iterator has been set up.");
        }
        int providerCount = this.getProviderCount();
        CRL result = null;
        while (this.currentCrlIterator < providerCount) {
            try {
                result = ((DatabaseInterface)((Object)this.getProviderAt(this.currentCrlIterator))).nextCRL();
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
            if (result != null) {
                return result;
            }
            ++this.currentCrlIterator;
        }
        return null;
    }

    public boolean hasMoreCRLs() throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        if (this.currentCrlIterator < 0) {
            this.setupCRLIterator();
        }
        int providerCount = this.getProviderCount();
        while (this.currentCrlIterator < providerCount) {
            try {
                if (((DatabaseInterface)((Object)this.getProviderAt(this.currentCrlIterator))).hasMoreCRLs()) {
                    return true;
                }
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
            ++this.currentCrlIterator;
        }
        return false;
    }

    public JSAFE_PrivateKey selectPrivateKeyByCertificate(Certificate cert) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                JSAFE_PrivateKey key = ((DatabaseInterface)((Object)this.getProviderAt(i))).selectPrivateKeyByCertificate(cert);
                noHandler = false;
                if (key == null) continue;
                return key;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.selectPrivateKeyByCertificate: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
        return null;
    }

    public JSAFE_PrivateKey selectPrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                JSAFE_PrivateKey key = ((DatabaseInterface)((Object)this.getProviderAt(i))).selectPrivateKeyByPublicKey(publicKey);
                noHandler = false;
                if (key == null) continue;
                return key;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.selectPrivateKeyByPublicKey: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
        return null;
    }

    public JSAFE_PrivateKey firstPrivateKey() throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                JSAFE_PrivateKey key = ((DatabaseInterface)((Object)this.getProviderAt(i))).firstPrivateKey();
                noHandler = false;
                if (key == null) continue;
                return key;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.firstPrivateKey: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
        return null;
    }

    public JSAFE_PrivateKey nextPrivateKey() throws NoServiceException, DatabaseException {
        JSAFE_PrivateKey key;
        this.checkForEmptyService();
        int theIndex = this.findCurrentPrivateKeyIterator();
        if (theIndex < 0) {
            throw new DatabaseException("DatabaseService.nextPrivateKey: no iterator is set up. Call firstPrivateKey first.");
        }
        try {
            key = ((DatabaseInterface)((Object)this.getProviderAt(theIndex))).nextPrivateKey();
        }
        catch (NotSupportedException e) {
            throw new DatabaseException("DatabaseService.nextPrivateKey: ", e);
        }
        if (key != null) {
            return key;
        }
        for (int j = theIndex + 1; j < this.getProviderCount(); ++j) {
            try {
                key = ((DatabaseInterface)((Object)this.getProviderAt(j))).firstPrivateKey();
                if (key == null) continue;
                return key;
            }
            catch (NotSupportedException e) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean hasMorePrivateKeys() throws NoServiceException, DatabaseException {
        boolean exists;
        this.checkForEmptyService();
        int theIndex = this.findCurrentPrivateKeyIterator();
        if (theIndex < 0) {
            throw new DatabaseException("DatabaseService.hasMorePrivateKeys: no iterator is set up.");
        }
        try {
            exists = ((DatabaseInterface)((Object)this.getProviderAt(theIndex))).hasMorePrivateKeys();
        }
        catch (NotSupportedException e) {
            throw new NoServiceException("DatabaseService.hasMorePrivateKeys: a provider is not found to handle this method.");
        }
        if (exists) {
            return true;
        }
        for (int j = theIndex + 1; j < this.getProviderCount(); ++j) {
            DatabaseInterface db = (DatabaseInterface)((Object)this.getProviderAt(j));
            try {
                db.setupPrivateKeyIterator();
            }
            catch (NotSupportedException e) {
                continue;
            }
            catch (DatabaseException e) {
                throw new NoServiceException("DatabaseService.hasMorePrivateKeys: unable to setup an iterator for a provider.", e);
            }
            try {
                if (db.hasMorePrivateKeys()) {
                    return true;
                }
                db.nextPrivateKey();
                continue;
            }
            catch (NotSupportedException e) {
                throw new DatabaseException("DatabaseService.hasMorePrivateKeys: ", e);
            }
        }
        return false;
    }

    public void deleteCertificate(X500Name issuerName, byte[] serialNumber) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).deleteCertificate(issuerName, serialNumber);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.deleteCertificate: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
    }

    public void deleteCRL(X500Name issuerName, Date lastUpdate) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).deleteCRL(issuerName, lastUpdate);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.deleteCRL: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
    }

    public void deletePrivateKeyByCertificate(Certificate cert) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).deletePrivateKeyByCertificate(cert);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.deletePrivateKeyByCertificate: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
    }

    public void deletePrivateKeyByPublicKey(JSAFE_PublicKey publicKey) throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noHandler = true;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).deletePrivateKeyByPublicKey(publicKey);
                noHandler = false;
                continue;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.deletePrivateKeyByPublicKey: no provider is found to handle this method(" + errorString.substring(1) + ").");
        }
    }

    public void setupCertificateIterator() throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noService = true;
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).setupCertificateIterator();
            }
            catch (NotSupportedException e) {
                continue;
            }
            if (!noService) continue;
            this.currentCertIterator = i;
            noService = false;
        }
        if (noService) {
            throw new NoServiceException("DatabaseService.setupCertificateIterator: no provider is found to handle this method.");
        }
    }

    public void setupCRLIterator() throws NoServiceException, DatabaseException {
        this.checkForEmptyService();
        boolean noService = true;
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                ((DatabaseInterface)((Object)this.getProviderAt(i))).setupCRLIterator();
            }
            catch (NotSupportedException e) {
                continue;
            }
            if (!noService) continue;
            this.currentCrlIterator = i;
            noService = false;
        }
        if (noService) {
            throw new NoServiceException("DatabaseService.setupCRLIterator: no provider is found to handle this method.");
        }
    }

    private boolean isCertificateIteratorSetup() {
        return this.currentCertIterator >= 0;
    }

    private boolean isCRLIteratorSetup() {
        return this.currentCrlIterator >= 0;
    }

    private int findCurrentPrivateKeyIterator() throws NoServiceException, DatabaseException {
        boolean noHandler = true;
        int theIndex = -1;
        String errorString = "";
        for (int i = 0; i < this.getProviderCount(); ++i) {
            try {
                boolean setup = ((DatabaseInterface)((Object)this.getProviderAt(i))).isPrivateKeyIteratorSetup();
                noHandler = false;
                if (!setup) continue;
                theIndex = i;
                break;
            }
            catch (NotSupportedException e) {
                errorString = errorString + "/" + e.getMessage();
            }
        }
        if (noHandler) {
            throw new NoServiceException("DatabaseService.findCurrentPrivateKeyIterator: no provider is found to handle isPrivateKeyIteratorSetup method(" + errorString.substring(1) + ").");
        }
        return theIndex;
    }

    private void checkForEmptyService() throws NoServiceException {
        if (this.getProviderCount() == 0) {
            throw new NoServiceException("DatabaseService.checkForEmptyService: no Database provider is bound to this service. Use CertJ.registerService followed by CertJ.bindService or CertJ.bindServices to obtain a non-empty DatabaseService object.");
        }
    }
}

