/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OIDList;
import com.rsa.certj.CertJ;
import com.rsa.certj.cert.Certificate;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.internal.JSAFEFactory;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_PrivateKey;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_Signature;
import java.io.Serializable;
import java.security.SecureRandom;

public abstract class CRL
implements Cloneable,
Serializable {
    public static final int RSA_WITH_SHA1_PKCS = 0;
    public static final int RSA_WITH_SHA1_ISO_OIW = 1;
    public static final int DSA_WITH_SHA1_X930 = 2;
    public static final int DSA_WITH_SHA1_X957 = 3;
    protected byte[] signatureAlgorithmBER;
    protected int signatureAlgorithmFormat = -1;
    protected byte[] signature;
    protected String theDevice;
    protected String[] theDeviceList;
    private CertJ theCertJ;

    public final void setCertJ(CertJ certJContext) {
        this.theCertJ = certJContext;
    }

    public final CertJ getCertJ() {
        return this.theCertJ;
    }

    public String getSignatureAlgorithm() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return OIDList.getTrans((byte[])this.signatureAlgorithmBER, (int)0, (int)this.signatureAlgorithmBER.length, (int)1);
    }

    public byte[] getSignatureAlgorithmDER() throws CertificateException {
        if (this.signatureAlgorithmBER == null) {
            throw new CertificateException("Object not set with signature algorithm.");
        }
        return (byte[])this.signatureAlgorithmBER.clone();
    }

    public abstract byte[] getSignature() throws CertificateException;

    public String getDevice() throws CertificateException {
        if (this.theDevice == null) {
            throw new CertificateException("Object not set with a device.");
        }
        return this.theDevice;
    }

    public String[] getDeviceList() throws CertificateException {
        if (this.theDeviceList == null) {
            throw new CertificateException("Object not set with a device.");
        }
        String[] returnValue = new String[this.theDeviceList.length];
        System.arraycopy(this.theDeviceList, 0, returnValue, 0, this.theDeviceList.length);
        return returnValue;
    }

    public void setSignatureStandard(int standardFlag) {
        this.signatureAlgorithmFormat = standardFlag;
    }

    public int getSignatureStandard() {
        return this.signatureAlgorithmFormat;
    }

    public String getSignatureFormat() {
        switch (this.signatureAlgorithmFormat) {
            case 0: {
                return "RSAWithSHA1PKCS";
            }
            case 1: {
                return "RSAWithSHA1ISO_OIW";
            }
            case 2: {
                return "DSAWithSHA1X930";
            }
            case 3: {
                return "DSAWithSHA1X957";
            }
        }
        return null;
    }

    public abstract void signCRL(String var1, String var2, JSAFE_PrivateKey var3, SecureRandom var4) throws CertificateException;

    public void signCRL(byte[] signatureAlgorithmBER, int offset, String device, JSAFE_PrivateKey signingKey, SecureRandom random) throws CertificateException {
        if (signatureAlgorithmBER == null || device == null || signingKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            int len = ASN1Lengths.determineLengthLen((byte[])signatureAlgorithmBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])signatureAlgorithmBER, (int)(offset + 1));
            String transformation = OIDList.getTrans((byte[])signatureAlgorithmBER, (int)offset, (int)len, (int)1);
            this.signCRL(transformation, device, signingKey, random);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot sign cert:", (Exception)((Object)asnException));
        }
    }

    public abstract boolean verifyCRLSignature(String var1, JSAFE_PublicKey var2, SecureRandom var3) throws CertificateException;

    public boolean verifyCRLSignature(String device, byte[] verifyingKeyBER, int offset, SecureRandom random) throws CertificateException {
        if (device == null || verifyingKeyBER == null) {
            throw new CertificateException("Specified values are null.");
        }
        try {
            JSAFE_PublicKey verifyingKey = JSAFEFactory.getPublicKey(verifyingKeyBER, offset, device, this.theCertJ);
            return this.verifyCRLSignature(device, verifyingKey, random);
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Cannot verify: ", (Exception)((Object)jsafeException));
        }
    }

    public boolean verifyCRLSignature(String device, Certificate signerCert, SecureRandom random) throws CertificateException {
        if (device == null || signerCert == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_PublicKey verifyingKey = signerCert.getSubjectPublicKey(device);
        return this.verifyCRLSignature(device, verifyingKey, random);
    }

    protected byte[] performSignature(String transformation, String device, JSAFE_PrivateKey signingKey, SecureRandom random, byte[] dataToSign, int offset, int len) throws CertificateException {
        if (transformation == null || device == null || signingKey == null || dataToSign == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature signer = null;
        try {
            signer = JSAFEFactory.getSignature(transformation, device, this.theCertJ);
            if (this.theCertJ == null) {
                signer.signInit(signingKey, random);
            } else {
                signer.signInit(signingKey, null, random, this.theCertJ.getPKCS11Sessions());
            }
            signer.signUpdate(dataToSign, offset, len);
            byte[] byArray = signer.signFinal();
            return byArray;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Could not sign the CRL: ", (Exception)((Object)jsafeException));
        }
        finally {
            if (signer != null) {
                signer.clearSensitiveData();
            }
        }
    }

    protected boolean performSignatureVerification(String device, JSAFE_PublicKey verifyingKey, SecureRandom random, byte[] dataToVerify, int dataOffset, int dataLen, byte[] signatureData, int sigOffset, int sigLen) throws CertificateException {
        if (device == null || verifyingKey == null || dataToVerify == null || signatureData == null) {
            throw new CertificateException("Specified values are null.");
        }
        JSAFE_Signature verifier = null;
        try {
            verifier = JSAFEFactory.getSignature(this.signatureAlgorithmBER, 0, device, this.theCertJ);
            if (this.theCertJ == null) {
                verifier.verifyInit(verifyingKey, random);
            } else {
                verifier.verifyInit(verifyingKey, null, random, this.theCertJ.getPKCS11Sessions());
            }
            verifier.verifyUpdate(dataToVerify, dataOffset, dataLen);
            boolean bl = verifier.verifyFinal(signatureData, sigOffset, sigLen);
            return bl;
        }
        catch (JSAFE_Exception jsafeException) {
            throw new CertificateException("Could not verify the CRL signature: ", (Exception)((Object)jsafeException));
        }
        finally {
            if (verifier != null) {
                verifier.clearSensitiveData();
            }
        }
    }

    protected void clearSignature() {
        this.signature = null;
        this.theDevice = null;
        this.theDeviceList = null;
    }

    protected void clearComponents() {
        this.clearSignature();
        this.signatureAlgorithmBER = null;
    }
}

