/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.certj.cert.AttributeValueAssertion;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.RDN;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.extensions.BuiltInDomainDefinedAttributes;
import com.rsa.certj.cert.extensions.BuiltInStandardAttributes;
import com.rsa.certj.cert.extensions.EDIPartyName;
import com.rsa.certj.cert.extensions.ExtendedNetworkAddress;
import com.rsa.certj.cert.extensions.ExtensionAttribute;
import com.rsa.certj.cert.extensions.ExtensionAttributes;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.cert.extensions.ORAddress;
import com.rsa.certj.cert.extensions.ORName;
import com.rsa.certj.cert.extensions.OtherName;
import com.rsa.certj.cert.extensions.PDSParameter;
import com.rsa.certj.cert.extensions.PersonalName;
import com.rsa.certj.cert.extensions.UnformattedPostalAddress;
import java.util.ArrayList;
import java.util.Arrays;

public final class NameMatcher {
    public static final int CMP_DIFFERENT = 0;
    public static final int CMP_SAME = 1;
    public static final int CMP_SMALLER = 2;
    public static final int CMP_LARGER = 3;

    private NameMatcher() {
    }

    public static boolean isNameIncluded(String name1, String name2) {
        return name2.toLowerCase().endsWith(name1.toLowerCase());
    }

    public static boolean matchDefinedAttributeLists(BuiltInDomainDefinedAttributes attrs1, BuiltInDomainDefinedAttributes attrs2) {
        if (attrs1 == null || attrs2 == null) {
            return false;
        }
        if (attrs1.getAttributeCount() > attrs2.getAttributeCount()) {
            return false;
        }
        try {
            for (int i = 0; i < attrs1.getAttributeCount(); ++i) {
                if (Arrays.equals(attrs1.getAttribute(i), attrs2.getAttribute(i))) continue;
                return false;
            }
        }
        catch (NameException e) {
            return false;
        }
        return true;
    }

    public static boolean matchDirectoryNames(X500Name name1, X500Name name2) {
        int count2;
        if (name1 == null || name2 == null) {
            return false;
        }
        int count1 = name1.getRDNCount();
        if (count1 < (count2 = name2.getRDNCount())) {
            return false;
        }
        try {
            for (int i = 0; i < count2; ++i) {
                if (NameMatcher.matchNameAttributeSets(name1.getRDN(i), name2.getRDN(i))) continue;
                return false;
            }
        }
        catch (NameException e) {
            return false;
        }
        return true;
    }

    public static boolean matchDnsNames(String name1, String name2) {
        if (name1 == null || name2 == null) {
            return false;
        }
        if (NameMatcher.isNameIncluded(name2, name1)) {
            if (name1.length() == name2.length()) {
                return true;
            }
            if (name1.charAt(name1.length() - 1 - name2.length()) == '.') {
                return true;
            }
        }
        return false;
    }

    public static boolean matchEdiPartyNames(EDIPartyName name1, EDIPartyName name2) {
        return name1 != null && name2 != null && name1.equals(name2);
    }

    public static boolean matchExtensionAttributeLists(ExtensionAttributes attrs1, ExtensionAttributes attrs2) {
        if (attrs1 == null || attrs2 == null) {
            return false;
        }
        int count1 = attrs1.getAttributeCount();
        int count2 = attrs2.getAttributeCount();
        if (count1 == 0) {
            return true;
        }
        if (count1 > count2) {
            return false;
        }
        try {
            for (int i = 0; i < count1; ++i) {
                boolean found = false;
                for (int j = 0; j < count2; ++j) {
                    if (!NameMatcher.matchExtensionAttributes(attrs1.getAttribute(i), attrs2.getAttribute(j))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        catch (NameException e) {
            return false;
        }
        return true;
    }

    public static boolean matchExtensionAttributes(ExtensionAttribute attr1, ExtensionAttribute attr2) {
        int type2;
        if (attr1 == null || attr2 == null) {
            return false;
        }
        int type1 = attr1.getAttributeType();
        if (type1 != (type2 = attr2.getAttributeType())) {
            return false;
        }
        switch (type1) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                String value1 = (String)attr1.getAttribute();
                String value2 = (String)attr2.getAttribute();
                if (value1 == null) {
                    return value2 == null;
                }
                return value1.equals(value2);
            }
            case 8: 
            case 9: {
                return NameMatcher.matchOrNames((ORName)attr1.getAttribute(), (ORName)attr2.getAttribute());
            }
            case 4: {
                return NameMatcher.matchPersonalNames((PersonalName)attr1.getAttribute(), (PersonalName)attr2.getAttribute());
            }
            case 5: {
                return NameMatcher.matchOrgUnitNameLists((String[])attr1.getAttribute(), (String[])attr2.getAttribute());
            }
            case 6: {
                return NameMatcher.matchDefinedAttributeLists((BuiltInDomainDefinedAttributes)attr1.getAttribute(), (BuiltInDomainDefinedAttributes)attr2.getAttribute());
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                PDSParameter param1 = (PDSParameter)attr1.getAttribute();
                PDSParameter param2 = (PDSParameter)attr2.getAttribute();
                if (param1 == null) {
                    return param2 == null;
                }
                return param1.equals(param2);
            }
            case 16: {
                UnformattedPostalAddress postalAddr1 = (UnformattedPostalAddress)attr1.getAttribute();
                UnformattedPostalAddress postalAddr2 = (UnformattedPostalAddress)attr2.getAttribute();
                if (postalAddr1 == null) {
                    return postalAddr2 == null;
                }
                return postalAddr1.equals(postalAddr2);
            }
            case 22: {
                ExtendedNetworkAddress networkAddr1 = (ExtendedNetworkAddress)attr1.getAttribute();
                ExtendedNetworkAddress networkAddr2 = (ExtendedNetworkAddress)attr2.getAttribute();
                if (networkAddr1 == null) {
                    return networkAddr2 == null;
                }
                return networkAddr1.equals(networkAddr2);
            }
            case 23: {
                return attr1.getAttribute().equals(attr2.getAttribute());
            }
        }
        return false;
    }

    public static boolean matchGeneralNames(GeneralName name1, GeneralName name2, int type) {
        if (name1.getGeneralNameType() != type || name2.getGeneralNameType() != type) {
            return false;
        }
        switch (type) {
            case 1: {
                return NameMatcher.matchOtherNames((OtherName)name1.getGeneralName(), (OtherName)name2.getGeneralName());
            }
            case 2: {
                return NameMatcher.matchRfc822Names((String)name1.getGeneralName(), (String)name2.getGeneralName());
            }
            case 3: {
                return NameMatcher.matchDnsNames((String)name1.getGeneralName(), (String)name2.getGeneralName());
            }
            case 4: {
                return NameMatcher.matchX400Addresses((ORAddress)name1.getGeneralName(), (ORAddress)name2.getGeneralName());
            }
            case 5: {
                return NameMatcher.matchDirectoryNames((X500Name)name1.getGeneralName(), (X500Name)name2.getGeneralName());
            }
            case 6: {
                return NameMatcher.matchEdiPartyNames((EDIPartyName)name1.getGeneralName(), (EDIPartyName)name2.getGeneralName());
            }
            case 7: {
                return NameMatcher.matchResourceLocators((String)name1.getGeneralName(), (String)name2.getGeneralName());
            }
            case 8: {
                return NameMatcher.matchIpAddresses((byte[])name1.getGeneralName(), (byte[])name2.getGeneralName());
            }
            case 9: {
                return NameMatcher.matchRegisteredIds((String)name1.getGeneralName(), (String)name2.getGeneralName());
            }
        }
        return false;
    }

    public static boolean matchIpAddresses(byte[] addr1, byte[] addr2) {
        int maskLen2;
        int i;
        int maskLen1;
        if (addr1 == null || addr2 == null) {
            return false;
        }
        int maskSize = 16;
        int length4 = 4;
        int length8 = 8;
        int length16 = 16;
        int length32 = 32;
        int allBitsRaised = -1;
        int len1 = addr1.length;
        int len2 = addr2.length;
        byte[] mask1 = new byte[16];
        byte[] mask2 = new byte[16];
        switch (len1) {
            case 4: 
            case 16: {
                maskLen1 = len1;
                for (i = 0; i < maskLen1; ++i) {
                    mask1[i] = 0;
                }
                break;
            }
            case 8: 
            case 32: {
                maskLen1 = len1 / 2;
                for (i = 0; i < maskLen1; ++i) {
                    mask1[i] = ~addr1[i + maskLen1];
                }
                break;
            }
            default: {
                return false;
            }
        }
        switch (len2) {
            case 4: 
            case 16: {
                maskLen2 = len2;
                for (i = 0; i < maskLen2; ++i) {
                    mask2[i] = -1;
                }
                break;
            }
            case 8: 
            case 32: {
                maskLen2 = len2 / 2;
                System.arraycopy(addr2, maskLen2, mask2, 0, maskLen2);
                break;
            }
            default: {
                return false;
            }
        }
        if (maskLen1 != maskLen2) {
            return false;
        }
        for (i = 0; i < maskLen1; ++i) {
            if ((mask2[i] & addr1[i]) == addr2[i] && (mask2[i] & (addr1[i] | mask1[i])) == addr2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean matchNameAttributes(AttributeValueAssertion ava1, AttributeValueAssertion ava2) {
        String string2;
        String string1;
        if (ava1 == null || ava2 == null) {
            return false;
        }
        if (ava1.getAttributeType() != ava2.getAttributeType()) {
            return false;
        }
        try {
            string1 = ava1.getStringAttribute();
            string2 = ava2.getStringAttribute();
        }
        catch (NameException e) {
            return false;
        }
        if (ava1.getAttributeType() == 7) {
            return NameMatcher.matchRfc822Names(string1, string2);
        }
        if (ava1.getAttributeType() == 19) {
            return string1.equalsIgnoreCase(string2);
        }
        switch (ava1.getValueType()) {
            case 4864: {
                return NameMatcher.printableStringsEqual(string1, string2);
            }
            case 3072: 
            case 5120: 
            case 7168: 
            case 7680: {
                return string1.equals(string2);
            }
        }
        return false;
    }

    public static boolean matchNameAttributeSets(RDN set1, RDN set2) {
        int count2;
        if (set1 == null || set2 == null) {
            return false;
        }
        int count1 = set1.getAttributeCount();
        if (count1 > (count2 = set2.getAttributeCount())) {
            return false;
        }
        ArrayList<AttributeValueAssertion> intersection = new ArrayList<AttributeValueAssertion>();
        try {
            block2: for (int i = 0; i < count2; ++i) {
                AttributeValueAssertion ava2 = set2.getAttributeByIndex(i);
                for (int j = 0; j < count1; ++j) {
                    AttributeValueAssertion ava1 = set1.getAttributeByIndex(j);
                    if (!NameMatcher.matchNameAttributes(ava1, ava2)) continue;
                    intersection.add(ava2);
                    continue block2;
                }
            }
        }
        catch (NameException e) {
            return false;
        }
        return count1 == intersection.size();
    }

    public static boolean matchOrgUnitNameLists(String[] names1, String[] names2) {
        if (names1 == null || names2 == null) {
            return false;
        }
        if (names1.length > names2.length) {
            return false;
        }
        for (int i = 0; i < names1.length; ++i) {
            if (names1[i].equals(names2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matchOrNames(ORName name1, ORName name2) {
        if (name1 == null || name2 == null) {
            return false;
        }
        return name1.equals(name2);
    }

    public static boolean matchOtherNames(OtherName name1, OtherName name2) {
        if (name1 == null || name2 == null) {
            return false;
        }
        return name1.equals(name2);
    }

    public static boolean matchPersonalNames(PersonalName name1, PersonalName name2) {
        if (name1 == null || name2 == null) {
            return false;
        }
        return name1.equals(name2);
    }

    public static boolean matchRegisteredIds(String id1, String id2) {
        if (id1 == null || id2 == null) {
            return false;
        }
        return id1.equals(id2);
    }

    public static boolean matchResourceLocators(String url1, String url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        String host1 = NameMatcher.extractHostName(url1);
        String host2 = NameMatcher.extractHostName(url2);
        if (host1 == null || host2 == null) {
            return false;
        }
        if (NameMatcher.isNameIncluded(host2, host1)) {
            if (host1.length() == host2.length()) {
                return true;
            }
            if (host2.length() > 0 && host2.charAt(0) == '.') {
                return true;
            }
        }
        return false;
    }

    public static boolean matchRfc822Names(String name1, String name2) {
        if (name1 == null || name2 == null) {
            return false;
        }
        if (NameMatcher.isNameIncluded(name2, name1)) {
            if (name1.length() == name2.length()) {
                return true;
            }
            if (name2.length() > 0 && name2.charAt(0) == '.') {
                return true;
            }
            if (name1.charAt(name1.length() - 1 - name2.length()) == '@') {
                return true;
            }
        }
        return false;
    }

    public static boolean matchStandardAttributeLists(BuiltInStandardAttributes attrs1, BuiltInStandardAttributes attrs2) {
        if (attrs1 == null || attrs2 == null) {
            return false;
        }
        if (!(attrs1.getCountryName() == null && attrs1.getCountryName() == null || NameMatcher.matchOrNames(attrs1.getCountryName(), attrs2.getCountryName()))) {
            return false;
        }
        if (!(attrs1.getAdminDomainName() == null && attrs1.getAdminDomainName() == null || NameMatcher.matchOrNames(attrs1.getAdminDomainName(), attrs2.getAdminDomainName()))) {
            return false;
        }
        if (attrs1.getNetworkAddress() != null && !attrs1.getNetworkAddress().equals(attrs2.getNetworkAddress())) {
            return false;
        }
        if (attrs1.getTerminalIdentifier() != null && !attrs1.getTerminalIdentifier().equals(attrs2.getTerminalIdentifier())) {
            return false;
        }
        if (!(attrs1.getPrivateDomainName() == null && attrs1.getPrivateDomainName() == null || NameMatcher.matchOrNames(attrs1.getPrivateDomainName(), attrs2.getPrivateDomainName()))) {
            return false;
        }
        if (attrs1.getOrganizationName() != null && !attrs1.getOrganizationName().equals(attrs2.getOrganizationName())) {
            return false;
        }
        if (attrs1.getNumericUserIdentifier() != null && !attrs1.getNumericUserIdentifier().equals(attrs2.getNumericUserIdentifier())) {
            return false;
        }
        if (!(attrs1.getPersonalName() == null && attrs1.getPersonalName() == null || NameMatcher.matchPersonalNames(attrs1.getPersonalName(), attrs2.getPersonalName()))) {
            return false;
        }
        return attrs1.getOrganizationalUnitNames() == null || Arrays.equals(attrs1.getOrganizationalUnitNames(), attrs2.getOrganizationalUnitNames());
    }

    public static boolean matchUnformattedPostalAddrs(UnformattedPostalAddress addr1, UnformattedPostalAddress addr2) {
        if (addr1 == null || addr2 == null) {
            return false;
        }
        String[] printableAddress1 = addr1.getPrintableAddress();
        String[] printableAddress2 = addr2.getPrintableAddress();
        if (printableAddress1 == null) {
            if (printableAddress2 != null) {
                return false;
            }
        } else {
            if (printableAddress1.length > printableAddress2.length) {
                return false;
            }
            for (int i = 0; i < printableAddress1.length; ++i) {
                if (printableAddress1[i] == printableAddress2[i] || printableAddress1[i] != null && printableAddress1[i].equals(printableAddress2[i])) continue;
                return false;
            }
        }
        String teletex1 = addr1.getTeletexString();
        String teletex2 = addr2.getTeletexString();
        if (teletex1 == null) {
            return teletex2 == null;
        }
        return teletex1.equals(teletex2);
    }

    public static boolean matchX400Addresses(ORAddress addr1, ORAddress addr2) {
        if (addr1 == null || addr2 == null) {
            return false;
        }
        BuiltInDomainDefinedAttributes definedAttr1 = addr1.getBuiltInDomainDefinedAttributes();
        BuiltInDomainDefinedAttributes definedAttr2 = addr2.getBuiltInDomainDefinedAttributes();
        BuiltInStandardAttributes standardAttr1 = addr1.getBuiltInStandardAttributes();
        BuiltInStandardAttributes standardAttr2 = addr2.getBuiltInStandardAttributes();
        ExtensionAttributes extensionAttr1 = addr1.getExtensionAttributes();
        ExtensionAttributes extensionAttr2 = addr2.getExtensionAttributes();
        if (!(standardAttr1 == null && standardAttr2 == null || NameMatcher.matchStandardAttributeLists(standardAttr1, standardAttr2))) {
            return false;
        }
        if (definedAttr1 != null || definedAttr2 != null) {
            if (definedAttr1 == null || definedAttr2 == null) {
                return false;
            }
            if (!NameMatcher.matchDefinedAttributeLists(definedAttr1, definedAttr2)) {
                return false;
            }
        }
        if (extensionAttr1 != null || extensionAttr2 != null) {
            if (extensionAttr1 == null || extensionAttr2 == null) {
                return false;
            }
            if (!NameMatcher.matchExtensionAttributeLists(extensionAttr1, extensionAttr2)) {
                return false;
            }
        }
        return true;
    }

    public static int compareAltNames(GeneralName name1, GeneralName name2) {
        boolean match2;
        boolean match1;
        if (name1 == null || name2 == null) {
            return 0;
        }
        switch (name1.getGeneralNameType()) {
            case 1: {
                OtherName otherName1 = (OtherName)name1.getGeneralName();
                OtherName otherName2 = (OtherName)name2.getGeneralName();
                match1 = NameMatcher.matchOtherNames(otherName1, otherName2);
                match2 = NameMatcher.matchOtherNames(otherName2, otherName1);
                break;
            }
            case 2: {
                String rfc822Name1 = (String)name1.getGeneralName();
                String rfc822Name2 = (String)name2.getGeneralName();
                match1 = NameMatcher.matchRfc822Names(rfc822Name1, rfc822Name2);
                match2 = NameMatcher.matchRfc822Names(rfc822Name2, rfc822Name1);
                break;
            }
            case 3: {
                String dnsName1 = (String)name1.getGeneralName();
                String dnsName2 = (String)name2.getGeneralName();
                match1 = NameMatcher.matchDnsNames(dnsName1, dnsName2);
                match2 = NameMatcher.matchDnsNames(dnsName2, dnsName1);
                break;
            }
            case 4: {
                ORAddress orAddress1 = (ORAddress)name1.getGeneralName();
                ORAddress orAddress2 = (ORAddress)name2.getGeneralName();
                match1 = NameMatcher.matchX400Addresses(orAddress1, orAddress2);
                match2 = NameMatcher.matchX400Addresses(orAddress2, orAddress1);
                break;
            }
            case 5: {
                X500Name x500Name1 = (X500Name)name1.getGeneralName();
                X500Name x500Name2 = (X500Name)name2.getGeneralName();
                match1 = NameMatcher.matchDirectoryNames(x500Name1, x500Name2);
                match2 = NameMatcher.matchDirectoryNames(x500Name2, x500Name1);
                break;
            }
            case 6: {
                EDIPartyName ediPartyName1 = (EDIPartyName)name1.getGeneralName();
                EDIPartyName ediPartyName2 = (EDIPartyName)name2.getGeneralName();
                match1 = NameMatcher.matchEdiPartyNames(ediPartyName1, ediPartyName2);
                match2 = NameMatcher.matchEdiPartyNames(ediPartyName2, ediPartyName1);
                break;
            }
            case 7: {
                String urlName1 = (String)name1.getGeneralName();
                String urlName2 = (String)name2.getGeneralName();
                match1 = NameMatcher.matchResourceLocators(urlName1, urlName2);
                match2 = NameMatcher.matchResourceLocators(urlName2, urlName1);
                break;
            }
            case 8: {
                byte[] ipAddress1 = (byte[])name1.getGeneralName();
                byte[] ipAddress2 = (byte[])name2.getGeneralName();
                match1 = NameMatcher.matchIpAddresses(ipAddress1, ipAddress2);
                match2 = NameMatcher.matchIpAddresses(ipAddress2, ipAddress1);
                break;
            }
            case 9: {
                byte[] registeredName1 = (byte[])name1.getGeneralName();
                byte[] registeredName2 = (byte[])name2.getGeneralName();
                match1 = match2 = Arrays.equals(registeredName1, registeredName2);
                break;
            }
            default: {
                match1 = match2 = name1.equals(name2);
            }
        }
        if (match1 && match2) {
            return 1;
        }
        if (match1) {
            return 2;
        }
        if (match2) {
            return 3;
        }
        return 0;
    }

    public static String compressWhiteSpaces(String string) {
        String whiteSpaces = " \t\n\f\r";
        StringBuffer buffer = new StringBuffer();
        boolean isPreviousWhitespace = false;
        for (int i = 0; i < string.length(); ++i) {
            char nextChar = string.charAt(i);
            if (" \t\n\f\r".indexOf(nextChar) >= 0) {
                if (isPreviousWhitespace) continue;
                buffer.append(" ");
                isPreviousWhitespace = true;
                continue;
            }
            buffer.append(nextChar);
            isPreviousWhitespace = false;
        }
        return buffer.toString().trim();
    }

    private static boolean printableStringsEqual(String string1, String string2) {
        return NameMatcher.convertToCanonicalString(string1).equals(NameMatcher.convertToCanonicalString(string2));
    }

    private static String extractHostName(String uri) {
        if (uri == null) {
            return null;
        }
        String protocolSeparator = "://";
        int startIndex = uri.indexOf("://");
        startIndex = startIndex < 0 ? 0 : (startIndex += "://".length());
        int endIndexCandidate1 = uri.indexOf(58, startIndex);
        int endIndexCandidate2 = uri.indexOf(47, startIndex);
        int endIndex = endIndexCandidate1 < 0 && endIndexCandidate2 < 0 ? uri.length() : (endIndexCandidate1 < 0 ? endIndexCandidate2 : (endIndexCandidate2 < 0 ? endIndexCandidate1 : Math.min(endIndexCandidate1, endIndexCandidate2)));
        return uri.substring(startIndex, endIndex);
    }

    private static String convertToCanonicalString(String string) {
        String result = string;
        if (result.startsWith("\\ ")) {
            result = result.substring(2);
        }
        if (result.endsWith("\\ ")) {
            result = result.substring(0, result.length() - 2);
        }
        return NameMatcher.compressWhiteSpaces(result).toUpperCase();
    }
}

