/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CertRequest;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.X500Name;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.core.config.CertJConfiguration;
import com.rsa.certj.internal.CertificateUtil;
import com.rsa.jsafe.JSAFE_PrivateKey;
import java.security.SecureRandom;
import java.util.Arrays;

public class PKCS10CertRequest
extends CertRequest {
    public static final int PKCS10_VERSION_1 = 0;
    private byte[] requestInfo;
    private byte[] requestInfoDER;
    private int requestInfoDERLen;
    private int theVersion = 0;
    private X500Name subjectName;
    private X501Attributes theAttributes;
    private ASN1Template asn1Template;
    protected int special;
    private ASN1Template asn1TemplateInfo;
    protected int infoSpecial;

    public PKCS10CertRequest() {
    }

    public PKCS10CertRequest(CertJ certJContext) {
        this.setCertJ(certJContext);
    }

    public PKCS10CertRequest(byte[] pkcs10CertRequestBER, int offset, int special) throws CertificateException {
        this(pkcs10CertRequestBER, offset, special, null);
    }

    public PKCS10CertRequest(byte[] pkcs10CertRequestBER, int offset, int special, CertJ certJContext) throws CertificateException {
        if (pkcs10CertRequestBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.setCertRequestBER(pkcs10CertRequestBER, offset, special);
        this.setCertJ(certJContext);
    }

    public static int getNextBEROffset(byte[] pkcs10CertRequestBER, int offset) throws CertificateException {
        if (pkcs10CertRequestBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        try {
            return offset + 1 + ASN1Lengths.determineLengthLen((byte[])pkcs10CertRequestBER, (int)(offset + 1)) + ASN1Lengths.determineLength((byte[])pkcs10CertRequestBER, (int)(offset + 1));
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not read the BER encoding.");
        }
    }

    private void setCertRequestBER(byte[] pkcs10CertRequestBER, int offset, int special) throws CertificateException {
        if (pkcs10CertRequestBER == null) {
            throw new CertificateException("Encoding is null");
        }
        this.clearComponents();
        ASN1Container[] asn1Def = PKCS10CertRequest.decodeRequest(pkcs10CertRequestBER, offset, special);
        this.requestInfo = new byte[asn1Def[1].dataLen];
        System.arraycopy(asn1Def[1].data, asn1Def[1].dataOffset, this.requestInfo, 0, asn1Def[1].dataLen);
        this.setCertRequestInfo(asn1Def[1].data, asn1Def[1].dataOffset, 0);
        this.signatureAlgorithmBER = new byte[asn1Def[2].dataLen];
        System.arraycopy(asn1Def[2].data, asn1Def[2].dataOffset, this.signatureAlgorithmBER, 0, asn1Def[2].dataLen);
        this.signature = new byte[asn1Def[3].dataLen];
        System.arraycopy(asn1Def[3].data, asn1Def[3].dataOffset, this.signature, 0, asn1Def[3].dataLen);
    }

    protected static ASN1Container[] decodeRequest(byte[] requestBER, int offset, int special) throws CertificateException {
        if (requestBER == null) {
            throw new CertificateException("Encoding is null.");
        }
        SequenceContainer aSeq = new SequenceContainer(special);
        EndContainer anEnd = new EndContainer();
        EncodedContainer info = new EncodedContainer(12288);
        EncodedContainer algID = new EncodedContainer(12288);
        EncodedContainer sig = new EncodedContainer(768);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, info, algID, sig, anEnd};
        try {
            ASN1.berDecode((byte[])requestBER, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not BER decode the request.");
        }
        return asn1Def;
    }

    public int getDERLen(int special) {
        return this.encodeInit(special);
    }

    private int encodeInit(int special) {
        this.special = special;
        if (!this.signedByUs) {
            return 0;
        }
        if (this.requestInfoDER == null) {
            this.requestInfoDERLen = this.getCertRequestInfoDERLen(special);
        }
        if (this.requestInfoDERLen == 0) {
            return 0;
        }
        if (this.signature == null || this.signatureAlgorithmBER == null) {
            return 0;
        }
        try {
            SequenceContainer aSeq = new SequenceContainer(special, true, 0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer info = new EncodedContainer(12288, true, 0, null, 0, this.requestInfoDERLen);
            EncodedContainer algID = new EncodedContainer(12288, true, 0, null, 0, this.signatureAlgorithmBER.length);
            EncodedContainer sig = new EncodedContainer(768, true, 0, null, 0, this.signature.length);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, info, algID, sig, anEnd};
            this.asn1Template = new ASN1Template(asn1Def);
            return this.asn1Template.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int getDEREncoding(byte[] encoding, int offset, int special) throws CertificateException {
        if (encoding == null) {
            throw new CertificateException("Specified array is null.");
        }
        if (!this.signedByUs) {
            throw new CertificateException("Could not encode, missing data.");
        }
        int totalLen = 0;
        try {
            if (this.asn1Template == null || special != this.special) {
                this.encodeInit(special);
            }
            totalLen += this.asn1Template.derEncode(encoding, offset);
            this.asn1Template = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1Template = null;
            throw new CertificateException("Could not encode: ", (Exception)((Object)asnException));
        }
        if (this.requestInfoDER != null && this.requestInfoDERLen != 0 && this.infoSpecial == 0) {
            System.arraycopy(this.requestInfoDER, 0, encoding, offset + totalLen, this.requestInfoDERLen);
            totalLen += this.requestInfoDERLen;
        } else {
            int infoLen = this.getCertRequestInfoDEREncoding(encoding, offset + totalLen, 0);
            if (infoLen == 0) {
                throw new CertificateException("Could not encode, missing data.");
            }
            totalLen += infoLen;
        }
        System.arraycopy(this.signatureAlgorithmBER, 0, encoding, offset + totalLen, this.signatureAlgorithmBER.length);
        System.arraycopy(this.signature, 0, encoding, offset + (totalLen += this.signatureAlgorithmBER.length), this.signature.length);
        return totalLen + this.signature.length;
    }

    public void setCertRequestInfo(byte[] pkcs10CertRequestInfo, int offset, int special) throws CertificateException {
        if (pkcs10CertRequestInfo == null) {
            throw new CertificateException("Encoding is null.");
        }
        this.clearSignature();
        this.clearTemplate();
        SequenceContainer aSeq = new SequenceContainer(special);
        EndContainer anEnd = new EndContainer();
        IntegerContainer vers = new IntegerContainer(0);
        EncodedContainer name = new EncodedContainer(12288);
        EncodedContainer key = new EncodedContainer(12288);
        EncodedContainer attrib = new EncodedContainer(8401152);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, vers, name, key, attrib, anEnd};
        try {
            ASN1.berDecode((byte[])pkcs10CertRequestInfo, (int)offset, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Could not BER decode the request info.");
        }
        this.checkVersionNumber(-1, vers.data, vers.dataOffset, vers.dataLen);
        try {
            this.subjectName = new X500Name(name.data, name.dataOffset, 0);
        }
        catch (NameException nameException) {
            throw new CertificateException("Could not read the SubjectName: ", nameException);
        }
        this.setSubjectPublicKey(key.data, key.dataOffset);
        try {
            this.theAttributes = new X501Attributes(attrib.data, attrib.dataOffset, 0x800000);
        }
        catch (AttributeException attribException) {
            throw new CertificateException("Could not read the Attributes: ", attribException);
        }
    }

    protected void checkVersionNumber(int versionInt, byte[] version, int offset, int len) throws CertificateException {
        if (versionInt == -1) {
            if (version == null || len > 4) {
                throw new CertificateException("Invalid PKCS #10 Cert Request version.");
            }
            versionInt = 0;
            for (int index = offset; index < offset + len; ++index) {
                versionInt = versionInt << 8 | version[offset] & 0xFF;
            }
        }
        if (versionInt != 0) {
            throw new CertificateException("Invalid PKCS #10 Cert Request version.");
        }
    }

    public int getCertRequestInfoDERLen(int special) {
        return this.infoEncodeInit(special);
    }

    private int infoEncodeInit(int special) {
        this.infoSpecial = special;
        if (this.subjectPublicKeyInfo == null || this.subjectName == null) {
            return 0;
        }
        int nameLen = this.subjectName.getDERLen(0);
        int attributesLen = 2;
        if (this.theAttributes != null) {
            attributesLen = this.theAttributes.getDERLen(0x800000);
        }
        try {
            SequenceContainer aSeq = new SequenceContainer(special, true, 0);
            EndContainer anEnd = new EndContainer();
            IntegerContainer vers = new IntegerContainer(0, true, 0, this.theVersion);
            EncodedContainer name = new EncodedContainer(12288, true, 0, null, 0, nameLen);
            EncodedContainer pubKey = new EncodedContainer(12288, true, 0, null, 0, this.subjectPublicKeyInfo.length);
            EncodedContainer attrib = new EncodedContainer(8401152, true, 0, null, 0, attributesLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, vers, name, pubKey, attrib, anEnd};
            this.asn1TemplateInfo = new ASN1Template(asn1Def);
            return this.asn1TemplateInfo.derEncodeInit();
        }
        catch (ASN_Exception asnException) {
            return 0;
        }
    }

    public int getCertRequestInfoDEREncoding(byte[] encoding, int offset, int special) throws CertificateException {
        if (encoding == null) {
            throw new CertificateException("Specified array is null.");
        }
        if ((this.asn1TemplateInfo == null || special != this.infoSpecial) && this.infoEncodeInit(special) == 0) {
            throw new CertificateException("Could not encode, missing data.");
        }
        int totalLen = 0;
        try {
            totalLen += this.asn1TemplateInfo.derEncode(encoding, offset);
            this.asn1TemplateInfo = null;
        }
        catch (ASN_Exception asnException) {
            this.asn1TemplateInfo = null;
            throw new CertificateException("Could not encode Cert Request: ", (Exception)((Object)asnException));
        }
        try {
            totalLen += this.subjectName.getDEREncoding(encoding, offset + totalLen, 0);
        }
        catch (NameException nameException) {
            throw new CertificateException("Cannot build Cert Request Info: ", nameException);
        }
        System.arraycopy(this.subjectPublicKeyInfo, 0, encoding, offset + totalLen, this.subjectPublicKeyInfo.length);
        totalLen += this.subjectPublicKeyInfo.length;
        if (this.theAttributes == null) {
            encoding[offset += totalLen] = -96;
            encoding[offset + 1] = 0;
            totalLen += 2;
        } else {
            try {
                totalLen += this.theAttributes.getDEREncoding(encoding, offset + totalLen, 0x800000);
            }
            catch (AttributeException attribException) {
                throw new CertificateException("Could not encode CertRequest: ", attribException);
            }
        }
        return totalLen;
    }

    public byte[] getSignature() throws CertificateException {
        if (this.signature == null) {
            throw new CertificateException("Object not signed.");
        }
        BitStringContainer sig = new BitStringContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{sig};
        try {
            ASN1.berDecode((byte[])this.signature, (int)0, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new CertificateException("Cannot extract the signature.");
        }
        byte[] returnValue = new byte[sig.dataLen];
        System.arraycopy(sig.data, sig.dataOffset, returnValue, 0, sig.dataLen);
        return returnValue;
    }

    public void setVersion(int version) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        this.checkVersionNumber(version, null, 0, 0);
    }

    public int getVersion() {
        return this.theVersion;
    }

    public void setSubjectName(X500Name subjName) throws CertificateException {
        this.setSubjectName(subjName, CertJConfiguration.isAutoGenSerialNumEnabled());
    }

    public void setSubjectName(X500Name subjName, boolean autoGenerateSerialNumber) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        if (subjName == null) {
            throw new CertificateException("Cannot set the cert with the given subjectName.");
        }
        try {
            this.subjectName = (X500Name)subjName.clone();
            if (autoGenerateSerialNumber) {
                CertificateUtil.checkSerialNumber(this.subjectName);
            }
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CertificateException("Cannot set the cert with the given subjectName.");
        }
    }

    public X500Name getSubjectName() {
        if (this.subjectName == null) {
            return null;
        }
        try {
            return (X500Name)this.subjectName.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    public void addAttribute(X501Attribute attribute) {
        if (attribute != null) {
            if (this.theAttributes == null) {
                this.theAttributes = new X501Attributes();
            }
            this.theAttributes.addAttribute(attribute);
        }
    }

    public void setAttributes(X501Attributes attributes) throws CertificateException {
        this.clearSignature();
        this.clearTemplate();
        try {
            this.theAttributes = attributes != null ? (X501Attributes)attributes.clone() : null;
        }
        catch (CloneNotSupportedException cloneException) {
            throw new CertificateException("Could not set the request object with the given attributes.");
        }
    }

    public X501Attributes getAttributes() {
        if (this.theAttributes == null) {
            return null;
        }
        try {
            return (X501Attributes)this.theAttributes.clone();
        }
        catch (CloneNotSupportedException cloneException) {
            return null;
        }
    }

    public void signCertRequest(String transformation, String device, JSAFE_PrivateKey signingKey, SecureRandom random) throws CertificateException {
        if (transformation == null || device == null || signingKey == null) {
            throw new CertificateException("Specified values are null.");
        }
        this.clearSignature();
        if (this.requestInfoDER == null) {
            this.requestInfoDERLen = this.getCertRequestInfoDERLen(0);
            this.requestInfoDER = new byte[this.requestInfoDERLen];
            this.requestInfoDERLen = this.getCertRequestInfoDEREncoding(this.requestInfoDER, 0, 0);
        }
        byte[] sigData = this.performSignature(transformation, device, signingKey, random, this.requestInfoDER, 0, this.requestInfoDERLen);
        try {
            BitStringContainer sig = new BitStringContainer(0, true, 0, sigData, 0, sigData.length, sigData.length * 8, false);
            ASN1Container[] asn1Def = new ASN1Container[]{sig};
            this.signature = ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            this.clearSignature();
            throw new CertificateException("Cannot sign the cert as presently set.");
        }
    }

    public boolean verifyCertRequestSignature(String device, SecureRandom random) throws CertificateException {
        if (device == null) {
            throw new CertificateException("Specified values are null.");
        }
        if (this.requestInfo == null) {
            if (this.requestInfoDER != null) {
                this.requestInfo = new byte[this.requestInfoDERLen];
                System.arraycopy(this.requestInfoDER, 0, this.requestInfo, 0, this.requestInfoDERLen);
            } else {
                throw new CertificateException("Cannot verify the signature, not all components are set.");
            }
        }
        if (this.signature == null || this.signatureAlgorithmBER == null) {
            throw new CertificateException("Cannot verify the signature, not all components are set.");
        }
        byte[] sigData = this.getSignature();
        return this.performSignatureVerification(device, random, this.requestInfo, 0, this.requestInfo.length, sigData, 0, sigData.length);
    }

    protected void clearTemplate() {
        this.asn1Template = null;
        this.asn1TemplateInfo = null;
        this.requestInfoDER = null;
        this.requestInfoDERLen = 0;
    }

    protected void clearComponents() {
        super.clearComponents();
        this.clearTemplate();
        this.requestInfo = null;
        this.theVersion = 0;
        this.subjectName = null;
        this.theAttributes = null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PKCS10CertRequest)) {
            return false;
        }
        int len = this.getDERLen(0);
        if (len == 0) {
            return false;
        }
        byte[] enc = new byte[len];
        try {
            this.getDEREncoding(enc, 0, 0);
        }
        catch (CertificateException e) {
            return false;
        }
        PKCS10CertRequest otherExt = (PKCS10CertRequest)other;
        int otherLen = otherExt.getDERLen(0);
        if (otherLen == 0) {
            return false;
        }
        byte[] otherEnc = new byte[len];
        try {
            otherExt.getDEREncoding(otherEnc, 0, 0);
        }
        catch (CertificateException e) {
            return false;
        }
        return CertJUtils.byteArraysEqual(enc, otherEnc);
    }

    public int hashCode() {
        int len = this.getDERLen(0);
        if (len == 0) {
            return 0;
        }
        byte[] enc = new byte[len];
        try {
            this.getDEREncoding(enc, 0, 0);
        }
        catch (CertificateException e) {
            return 0;
        }
        return Arrays.hashCode(enc);
    }
}

